package ONVIF::Analytics::Types::ObjectTree;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Rename_of :ATTR(:get<Rename>);
my %Split_of :ATTR(:get<Split>);
my %Merge_of :ATTR(:get<Merge>);
my %Delete_of :ATTR(:get<Delete>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Rename
        Split
        Merge
        Delete
        Extension

    ) ],
    {
        'Rename' => \%Rename_of,
        'Split' => \%Split_of,
        'Merge' => \%Merge_of,
        'Delete' => \%Delete_of,
        'Extension' => \%Extension_of,
    },
    {
        'Rename' => 'ONVIF::Analytics::Types::Rename',
        'Split' => 'ONVIF::Analytics::Types::Split',
        'Merge' => 'ONVIF::Analytics::Types::Merge',
        'Delete' => 'ONVIF::Analytics::Types::ObjectId',
        'Extension' => 'ONVIF::Analytics::Types::ObjectTreeExtension',
    },
    {

        'Rename' => 'Rename',
        'Split' => 'Split',
        'Merge' => 'Merge',
        'Delete' => 'Delete',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::ObjectTree

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ObjectTree from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Rename


=item * Split


=item * Merge


=item * Delete


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::ObjectTree
   Rename =>  { # ONVIF::Analytics::Types::Rename
     from => ,
     to => ,
   },
   Split =>  { # ONVIF::Analytics::Types::Split
     from => ,
     to => ,
   },
   Merge =>  { # ONVIF::Analytics::Types::Merge
     from => ,
     to => ,
   },
   Delete => ,
   Extension =>  { # ONVIF::Analytics::Types::ObjectTreeExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

