/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.navigation;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.java3d.navigation.CollisionListener;
import org.j3d.renderer.java3d.navigation.FrameUpdateListener;
import org.j3d.renderer.java3d.util.J3DIntersectionUtils;
import org.j3d.ui.navigation.HeightDataSource;
import org.j3d.util.MatrixUtils;
import org.j3d.util.UserSupplementData;

public class NavigationProcessor {
    public static final int AVATAR_POINT = 1;
    public static final int AVATAR_CYLINDER = 2;
    public static final int AVATAR_SHOULDERS = 3;
    private static final float DEFAULT_AVATAR_HEIGHT = 1.8f;
    private static final float DEFAULT_AVATAR_SIZE = 0.25f;
    private static final float DEFAULT_STEP_HEIGHT = 0.4f;
    private static final float DEFAULT_ORBIT_TIME = 5.0f;
    private static final double ZEROEPS = 1.0E-6;
    private static final Vector3d Y_DOWN = new Vector3d(0.0, -1.0, 0.0);
    private static final Vector3d Y_UP = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d COLLISION_DIRECTION = new Vector3d(0.0, 0.0, -1.0);
    private J3DIntersectionUtils terrainIntersect = new J3DIntersectionUtils();
    private J3DIntersectionUtils collideIntersect = new J3DIntersectionUtils();
    private View view;
    private TransformGroup viewTg = new TransformGroup();
    private Transform3D viewTx = new Transform3D();
    private SceneGraphPath viewPath;
    private CollisionListener collisionListener;
    private int navigationState = 0;
    private boolean movementInProgress = false;
    private float speed;
    private float scaledSpeed;
    private BranchGroup terrain;
    private BranchGroup collidables;
    private PickRay terrainPicker;
    private PickShape collisionPicker;
    private Vector3d downVector;
    private Vector3d collisionVector;
    private Vector3d movementDirection;
    private Vector3d lookDirection;
    private Vector3d lastLookDirection;
    private FrameUpdateListener updateListener;
    private float avatarHeight;
    private float avatarSize;
    private float avatarStep;
    private float lastTerrainHeight;
    private Vector3d locationVector;
    private Point3d locationPoint;
    private Point3d locationEndPoint;
    private Point3d kneePoint;
    private Point3d wkPoint;
    private Vector3d diffVec;
    private Point3d intersectionPoint;
    private Point3d centerOfRotation;
    private float orbitTime;
    private double lastAngle;
    private double rotationRadius;
    private Vector3d dragTranslationAmt;
    private Vector3d oneFrameTranslation;
    private Transform3D oneFrameRotation;
    private Vector3d viewTranslation;
    private Transform3D worldEyeTransform = new Transform3D();
    private double inputRotationY;
    private double inputRotationX;
    private boolean allowCollisions;
    private boolean allowTerrainFollowing;
    private double angle;
    private FrameTimerBehavior frameTimer;
    private long startFrameDurationCalc;
    private long frameDuration;
    private SceneGraphPath collidedObject;
    private int avatarRep;
    private Matrix4d lookatTmp;
    private MatrixUtils matUtils;

    public NavigationProcessor() {
        this.downVector = new Vector3d();
        this.terrainPicker = new PickRay();
        this.movementDirection = new Vector3d();
        this.lookDirection = new Vector3d();
        this.lastLookDirection = new Vector3d();
        this.lastLookDirection.x = 0.0;
        this.lastLookDirection.y = 0.0;
        this.lastLookDirection.z = 0.0;
        this.centerOfRotation = new Point3d();
        this.collisionVector = new Vector3d();
        this.intersectionPoint = new Point3d();
        this.wkPoint = new Point3d();
        this.diffVec = new Vector3d();
        this.avatarRep = 1;
        if (this.avatarRep == 1) {
            this.collisionPicker = new PickSegment();
        } else if (this.avatarRep == 2) {
            this.collisionPicker = new PickCylinderSegment();
        } else if (this.avatarRep == 3) {
            this.collisionPicker = new PickCylinderSegment();
        }
        this.locationVector = new Vector3d();
        this.locationPoint = new Point3d();
        this.locationEndPoint = new Point3d();
        this.kneePoint = new Point3d();
        this.dragTranslationAmt = new Vector3d();
        this.oneFrameTranslation = new Vector3d();
        this.oneFrameRotation = new Transform3D();
        this.viewTranslation = new Vector3d();
        this.inputRotationY = 0.0;
        this.inputRotationX = 0.0;
        this.allowCollisions = false;
        this.allowTerrainFollowing = false;
        this.orbitTime = 5.0f;
        this.avatarHeight = 1.8f;
        this.avatarSize = 0.25f;
        this.avatarStep = 0.4f;
        this.lastTerrainHeight = 0.0f;
        this.speed = 0.0f;
        this.centerOfRotation = new Point3d(0.0, 0.0, 0.0);
        this.lookatTmp = new Matrix4d();
        this.matUtils = new MatrixUtils();
    }

    public Behavior getTimerBehavior() {
        if (this.frameTimer == null) {
            BoundingSphere boundingSphere = new BoundingSphere();
            boundingSphere.setRadius(Double.POSITIVE_INFINITY);
            this.frameTimer = new FrameTimerBehavior();
            this.frameTimer.setSchedulingBounds((Bounds)boundingSphere);
            this.frameTimer.setEnable(false);
        }
        return this.frameTimer;
    }

    public void setCenterOfRotation(float[] fArray, float[] fArray2) {
        this.centerOfRotation.x = fArray[0];
        this.centerOfRotation.y = fArray[1];
        this.centerOfRotation.z = fArray[2];
        if (this.navigationState == 5 || this.navigationState == 6) {
            if (fArray2 == null) {
                this.viewTg.getTransform(this.viewTx);
                this.viewTx.get(this.viewTranslation);
                this.locationPoint.set(this.viewTranslation);
            } else {
                this.locationPoint.x = fArray2[0];
                this.locationPoint.y = fArray2[1];
                this.locationPoint.z = fArray2[2];
            }
            double d = this.locationPoint.x - this.centerOfRotation.x;
            double d2 = this.locationPoint.z - this.centerOfRotation.z;
            this.rotationRadius = Math.sqrt(d * d + d2 * d2);
            this.lastAngle = Math.atan2(d2, d);
            this.matUtils.lookAt(this.locationPoint, this.centerOfRotation, Y_UP, this.lookatTmp);
            this.viewTx.set(this.lookatTmp);
            this.viewTx.invert();
            this.viewTg.setTransform(this.viewTx);
        }
    }

    public void setViewInfo(View view, TransformGroup transformGroup) {
        this.setViewInfo(view, transformGroup, null);
    }

    public void setViewInfo(View view, TransformGroup transformGroup, SceneGraphPath sceneGraphPath) {
        if (view != null && transformGroup == null || view == null && transformGroup != null) {
            throw new IllegalArgumentException("View or TG is null when the other isn't");
        }
        this.view = view;
        this.viewTg = transformGroup;
        this.viewPath = sceneGraphPath;
        if (transformGroup == null) {
            return;
        }
        this.viewTg.getTransform(this.viewTx);
        if (transformGroup.isLive()) {
            if (!this.viewTg.getCapability(11)) {
                throw new IllegalStateException("Live scenegraph and cannot read the VWorld transform");
            }
        } else {
            transformGroup.setCapability(11);
        }
    }

    public void setViewPath(SceneGraphPath sceneGraphPath) {
        this.viewPath = sceneGraphPath;
    }

    public void setWorldInfo(BranchGroup branchGroup, BranchGroup branchGroup2) {
        this.terrain = branchGroup;
        this.collidables = branchGroup2;
    }

    public void setAvatarInfo(float f, float f2, float f3) {
        this.avatarHeight = f;
        this.avatarSize = f2;
        this.avatarStep = f3;
    }

    public void setNavigationSpeed(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative speed value");
        }
        this.speed = f;
    }

    public void setOrbitTime(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Orbit time <= 0");
        }
        this.orbitTime = f;
    }

    public void setNavigationState(int n) {
        this.navigationState = n;
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        this.collisionListener = collisionListener;
    }

    public int getNavigationState() {
        return this.navigationState;
    }

    public void processNextFrame() {
        this.frameDuration = System.currentTimeMillis() - this.startFrameDurationCalc;
        if (this.frameDuration == 0L) {
            this.frameDuration = 1L;
        }
        this.processClockTick();
    }

    public void startMove() {
        if (this.movementInProgress || this.viewTg == null || this.navigationState == 0 || this.navigationState == 6) {
            return;
        }
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.viewTranslation);
        this.inputRotationY = 0.0;
        this.inputRotationX = 0.0;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0);
        this.startFrameDurationCalc = System.currentTimeMillis();
        if (this.frameTimer != null) {
            this.frameTimer.setEnable(true);
        }
        switch (this.navigationState) {
            case 4: {
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = false;
                break;
            }
            case 3: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 2: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 1: {
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = this.terrain != null;
                break;
            }
            case 5: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 0: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
            }
        }
        if (this.navigationState == 1 && this.allowTerrainFollowing) {
            this.setInitialTerrainHeight();
        }
        if (this.navigationState == 5) {
            double d = this.viewTranslation.x - this.centerOfRotation.x;
            double d2 = this.viewTranslation.z - this.centerOfRotation.z;
            this.rotationRadius = Math.sqrt(d * d + d2 * d2);
            this.lastAngle = Math.atan2(d2, d);
            this.locationPoint.set(this.viewTranslation);
            this.matUtils.lookAt(this.locationPoint, this.centerOfRotation, Y_UP, this.lookatTmp);
            this.viewTx.set(this.lookatTmp);
            this.viewTx.invert();
            this.viewTg.setTransform(this.viewTx);
        }
    }

    public void stopMove() {
        this.movementInProgress = false;
        this.allowCollisions = false;
        this.allowTerrainFollowing = false;
        if (this.frameTimer != null) {
            this.frameTimer.setEnable(false);
        }
        this.viewTx.normalize();
        this.inputRotationY = 0.0;
        this.inputRotationX = 0.0;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0);
        this.viewTg.getTransform(this.viewTx);
    }

    public void move(float[] fArray, float f) {
        if (this.viewTg == null) {
            return;
        }
        if (this.speed == 0.0f) {
            f = 0.0f;
        }
        this.scaledSpeed = this.speed * f;
        switch (this.navigationState) {
            case 4: {
                this.dragTranslationAmt.set(0.0, 0.0, fArray[2] * this.scaledSpeed);
                this.inputRotationY = fArray[0] * f;
                this.inputRotationX = fArray[1] * this.scaledSpeed;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = false;
                break;
            }
            case 3: {
                this.dragTranslationAmt.set(fArray[0] * this.scaledSpeed, fArray[1] * this.scaledSpeed, fArray[2] * this.scaledSpeed);
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 2: {
                this.inputRotationX = fArray[1] * f;
                this.inputRotationY = fArray[0] * f;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 1: {
                this.dragTranslationAmt.set(0.0, 0.0, fArray[2] * this.scaledSpeed);
                this.inputRotationY = fArray[0] * f;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = this.terrain != null;
                break;
            }
            case 5: {
                this.dragTranslationAmt.set(0.0, 0.0, fArray[2] * this.scaledSpeed);
                this.inputRotationY = fArray[0] * f;
                this.inputRotationX = fArray[1] * f;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 0: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
            }
        }
    }

    public void orient(float[] fArray) {
        this.lookDirection.x = fArray[0];
        this.lookDirection.y = fArray[1];
        this.lookDirection.z = fArray[2];
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.viewTranslation);
        this.inputRotationY = 0.0;
        this.inputRotationX = 0.0;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0);
        this.frameDuration = 0L;
        this.processClockTick();
    }

    public void getPosition(Vector3d vector3d) {
        if (this.viewPath != null) {
            this.viewTg.getLocalToVworld(this.viewPath, this.worldEyeTransform);
        } else {
            this.viewTg.getLocalToVworld(this.worldEyeTransform);
        }
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        vector3d.x = this.locationVector.x;
        vector3d.y = this.locationVector.y;
        vector3d.z = this.locationVector.z;
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.updateListener = frameUpdateListener;
    }

    private void processClockTick() {
        if (this.navigationState == 5) {
            this.processExamineMotion();
        } else {
            if (this.navigationState == 6) {
                return;
            }
            this.processDefaultMotion();
        }
    }

    private void processExamineMotion() {
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl = false;
        double d5 = this.lastAngle;
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.locationVector);
        if (this.dragTranslationAmt.z != 0.0) {
            d4 = 5.0E-4 * (double)this.frameDuration;
            d3 = this.locationVector.x - this.centerOfRotation.x;
            d2 = this.locationVector.z - this.centerOfRotation.z;
            d = this.dragTranslationAmt.z * (double)this.scaledSpeed;
            this.rotationRadius = Math.sqrt(d3 * d3 + d2 * d2) + d;
            bl = true;
        }
        if (this.inputRotationY != 0.0) {
            d4 = this.inputRotationY * (double)this.scaledSpeed;
            d = d4 * Math.PI * 2.0 * (double)this.frameDuration / (double)(this.orbitTime * 1000.0f);
            if ((d5 += d) > Math.PI * 2) {
                d5 -= Math.PI * 2;
            }
            this.lastAngle = d5;
            bl = true;
        }
        if (bl) {
            d3 = this.rotationRadius * Math.cos(d5);
            d2 = this.rotationRadius * Math.sin(d5);
            this.locationPoint.x = this.centerOfRotation.x + d3;
            this.locationPoint.y = this.locationVector.y;
            this.locationPoint.z = this.centerOfRotation.z + d2;
            this.matUtils.lookAt(this.locationPoint, this.centerOfRotation, Y_UP, this.lookatTmp);
            this.viewTx.set(this.lookatTmp);
            this.viewTx.invert();
            this.viewTg.setTransform(this.viewTx);
        }
        this.startFrameDurationCalc = System.currentTimeMillis();
        if (this.updateListener != null) {
            try {
                this.updateListener.viewerPositionUpdated(this.viewTx);
            }
            catch (Exception exception) {
                System.out.println("Error sending frame update message");
                exception.printStackTrace();
            }
        }
    }

    private void processDefaultMotion() {
        double d = 0.005 * (double)this.frameDuration;
        this.viewTg.getTransform(this.viewTx);
        if (this.lastLookDirection.x != 0.0 || this.lastLookDirection.y != 0.0 || this.lastLookDirection.z != 0.0) {
            this.oneFrameRotation.setEuler(this.lastLookDirection);
            this.viewTx.mul(this.oneFrameRotation);
        }
        this.oneFrameRotation.rotX(this.inputRotationX * d);
        this.viewTx.mul(this.oneFrameRotation);
        this.oneFrameRotation.rotY(this.inputRotationY * d);
        this.viewTx.mul(this.oneFrameRotation);
        this.oneFrameTranslation.set(this.dragTranslationAmt);
        this.oneFrameTranslation.scale(d);
        this.viewTx.transform(this.oneFrameTranslation);
        boolean bl = false;
        if (this.allowCollisions) {
            boolean bl2 = bl = !this.checkCollisions();
        }
        if (this.allowTerrainFollowing && !bl) {
            boolean bl3 = bl = !this.checkTerrainFollowing();
        }
        if (bl) {
            if (this.collisionListener != null) {
                this.collisionListener.avatarCollision(this.collidedObject);
            }
            this.collidedObject = null;
            this.oneFrameTranslation.z = 0.0;
            this.oneFrameTranslation.x = 0.0;
            this.oneFrameTranslation.y = 0.0;
        }
        this.viewTranslation.add(this.oneFrameTranslation);
        this.viewTx.setTranslation(this.viewTranslation);
        if (this.lookDirection.x != 0.0 || this.lookDirection.y != 0.0 || this.lookDirection.z != 0.0) {
            this.oneFrameRotation.setEuler(this.lookDirection);
            this.lastLookDirection.x = -this.lookDirection.x;
            this.lastLookDirection.y = -this.lookDirection.y;
            this.lastLookDirection.z = -this.lookDirection.z;
            this.viewTx.mul(this.oneFrameRotation);
        }
        try {
            this.viewTg.setTransform(this.viewTx);
        }
        catch (Exception exception) {
            this.viewTx.rotX(0.0);
            this.viewTg.setTransform(this.viewTx);
        }
        this.startFrameDurationCalc = System.currentTimeMillis();
        if (this.updateListener != null) {
            try {
                this.updateListener.viewerPositionUpdated(this.viewTx);
            }
            catch (Exception exception) {
                System.out.println("Error sending frame update message");
                exception.printStackTrace();
            }
        }
    }

    private boolean checkTerrainFollowing() {
        boolean bl = true;
        if (this.viewPath != null) {
            this.viewTg.getLocalToVworld(this.viewPath, this.worldEyeTransform);
        } else {
            this.viewTg.getLocalToVworld(this.worldEyeTransform);
        }
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.add(this.locationVector, this.oneFrameTranslation);
        this.terrainPicker.set(this.locationPoint, this.downVector);
        SceneGraphPath[] sceneGraphPathArray = this.terrain.pickAllSorted((PickShape)this.terrainPicker);
        if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) {
            return bl;
        }
        double d = -1.0;
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            Object object;
            Node node;
            Node node2 = sceneGraphPathArray[i].getObject();
            Object object2 = node2.getUserData();
            if (object2 instanceof UserSupplementData && !((UserSupplementData)object2).isTerrain) continue;
            int n = sceneGraphPathArray[i].nodeCount();
            boolean bl2 = false;
            for (int j = 0; j < n && !bl2; ++j) {
                node = sceneGraphPathArray[i].getNode(j);
                object2 = node.getUserData();
                if (!(object2 instanceof UserSupplementData)) continue;
                bl2 = !((UserSupplementData)object2).isTerrain;
            }
            if (bl2) continue;
            Transform3D transform3D = sceneGraphPathArray[i].getTransform();
            transform3D.get(this.locationVector);
            node = (Shape3D)sceneGraphPathArray[i].getObject();
            object2 = node.getUserData();
            HeightDataSource heightDataSource = null;
            GeometryData geometryData = null;
            if (object2 instanceof UserSupplementData) {
                object = (UserSupplementData)object2;
                if (((UserSupplementData)object).geometryData instanceof HeightDataSource) {
                    heightDataSource = (HeightDataSource)((UserSupplementData)object).geometryData;
                } else if (((UserSupplementData)object).geometryData instanceof GeometryData) {
                    geometryData = (GeometryData)((UserSupplementData)object).geometryData;
                }
            } else if (object2 instanceof HeightDataSource) {
                heightDataSource = (HeightDataSource)object2;
            } else if (object2 instanceof GeometryData) {
                geometryData = (GeometryData)object2;
            }
            if (heightDataSource != null) {
                this.intersectionPoint.x = this.locationVector.x;
                this.intersectionPoint.y = this.locationVector.y;
                this.intersectionPoint.z = heightDataSource.getHeight((float)this.locationVector.x, (float)this.locationVector.y);
                continue;
            }
            if (geometryData != null) {
                if (!this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false)) continue;
                this.diffVec.sub(this.locationPoint, this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.intersectionPoint.set(this.wkPoint);
                this.collidedObject = sceneGraphPathArray[i];
                continue;
            }
            object = node.getAllGeometries();
            while (object.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)object.nextElement();
                if (geometryArray == null) continue;
                object2 = geometryArray.getUserData();
                geometryData = null;
                if (object2 instanceof UserSupplementData) {
                    UserSupplementData userSupplementData = (UserSupplementData)object2;
                    if (userSupplementData.geometryData instanceof HeightDataSource) {
                        heightDataSource = (HeightDataSource)userSupplementData.geometryData;
                    } else if (userSupplementData.geometryData instanceof GeometryData) {
                        geometryData = (GeometryData)userSupplementData.geometryData;
                    }
                } else if (object2 instanceof HeightDataSource) {
                    heightDataSource = (HeightDataSource)object2;
                } else if (object2 instanceof GeometryData) {
                    geometryData = (GeometryData)object2;
                }
                boolean bl3 = false;
                bl3 = geometryData != null ? this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false) : this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryArray, transform3D, this.wkPoint, false);
                if (!bl3) continue;
                this.diffVec.sub(this.locationPoint, this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.intersectionPoint.set(this.wkPoint);
                this.collidedObject = sceneGraphPathArray[i];
            }
        }
        if (d == -1.0) {
            return true;
        }
        double d2 = this.intersectionPoint.y - (double)this.lastTerrainHeight;
        double d3 = this.locationPoint.y - this.intersectionPoint.y;
        if (!this.floatEq(d3 - (double)this.avatarHeight, 0.0)) {
            if (this.floatEq(d2, 0.0)) {
                this.oneFrameTranslation.y = (double)this.avatarHeight - d3;
                bl = true;
            } else if (d2 < (double)this.avatarStep) {
                this.oneFrameTranslation.y = d2;
                bl = true;
            } else {
                bl = false;
                return bl;
            }
        }
        this.lastTerrainHeight = (float)this.intersectionPoint.y;
        return bl;
    }

    private boolean checkCollisions() {
        boolean bl = true;
        if (this.viewPath != null) {
            this.viewTg.getLocalToVworld(this.viewPath, this.worldEyeTransform);
        } else {
            this.viewTg.getLocalToVworld(this.worldEyeTransform);
        }
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.locationPoint.set(this.locationVector);
        this.collisionVector.x = this.oneFrameTranslation.x;
        this.collisionVector.y = this.oneFrameTranslation.y;
        this.collisionVector.z = this.oneFrameTranslation.z;
        if (this.collisionVector.length() > 0.0) {
            this.collisionVector.normalize();
        }
        this.collisionVector.scale(this.avatarSize);
        this.locationEndPoint.add(this.locationVector, this.collisionVector);
        this.locationEndPoint.add(this.oneFrameTranslation);
        switch (this.avatarRep) {
            case 1: {
                ((PickSegment)this.collisionPicker).set(this.locationPoint, this.locationEndPoint);
                break;
            }
            case 2: {
                this.kneePoint.x = this.locationEndPoint.x;
                this.kneePoint.y = this.locationEndPoint.y - (double)this.avatarHeight + (double)this.avatarStep;
                this.kneePoint.z = this.locationEndPoint.z;
                ((PickCylinderSegment)this.collisionPicker).set(this.locationEndPoint, this.kneePoint, (double)this.avatarSize);
                break;
            }
            case 3: {
                double d = this.locationPoint.x;
                this.locationPoint.x -= (double)this.avatarSize;
                this.kneePoint.x = d + (double)this.avatarSize;
                this.kneePoint.y = this.locationEndPoint.y - (double)(this.avatarSize / 2.0f);
                this.kneePoint.z = this.locationEndPoint.z;
                ((PickCylinderSegment)this.collisionPicker).set(this.locationEndPoint, this.kneePoint, (double)this.avatarSize);
            }
        }
        SceneGraphPath[] sceneGraphPathArray = this.collidables.pickAllSorted(this.collisionPicker);
        if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) {
            return true;
        }
        boolean bl2 = false;
        float f = (float)this.collisionVector.length();
        for (int i = 0; i < sceneGraphPathArray.length && !bl2; ++i) {
            Node node;
            Node node2 = sceneGraphPathArray[i].getObject();
            Object object = node2.getUserData();
            if (object instanceof UserSupplementData && !((UserSupplementData)object).collidable) continue;
            int n = sceneGraphPathArray[i].nodeCount();
            boolean bl3 = false;
            for (int j = 0; j < n && !bl3; ++j) {
                node = sceneGraphPathArray[i].getNode(j);
                object = node.getUserData();
                if (!(object instanceof UserSupplementData)) continue;
                bl3 = !((UserSupplementData)object).collidable;
            }
            if (bl3) continue;
            Transform3D transform3D = sceneGraphPathArray[i].getTransform();
            node = (Shape3D)sceneGraphPathArray[i].getObject();
            Enumeration enumeration = node.getAllGeometries();
            GeometryData geometryData = null;
            while (enumeration.hasMoreElements() && !bl2) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                if (geometryArray == null) continue;
                object = geometryArray.getUserData();
                geometryData = null;
                if (object instanceof UserSupplementData) {
                    UserSupplementData userSupplementData = (UserSupplementData)object;
                    if (userSupplementData.geometryData instanceof GeometryData) {
                        geometryData = (GeometryData)userSupplementData.geometryData;
                    }
                } else if (object instanceof GeometryData) {
                    geometryData = (GeometryData)object;
                }
                if (geometryData != null) {
                    bl2 = this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, geometryData, transform3D, this.wkPoint, true);
                    if (bl2) {
                        System.out.println("head collided:  dir: " + this.collisionVector + " cpnt: " + this.wkPoint);
                    }
                    if (!bl2 && this.avatarRep == 2 && (bl2 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, geometryData, transform3D, this.wkPoint, true))) {
                        System.out.println("knee collided");
                    }
                    if (bl2 || this.avatarRep != 3 || !(bl2 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, geometryData, transform3D, this.wkPoint, true))) continue;
                    System.out.println("right shoulder collided");
                    continue;
                }
                bl2 = this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, geometryArray, transform3D, this.wkPoint, true);
                if (bl2) {
                    System.out.println("head collided");
                }
                if (!bl2 && this.avatarRep == 2 && (bl2 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, geometryArray, transform3D, this.wkPoint, true))) {
                    System.out.println("knee collided");
                }
                if (bl2 || this.avatarRep != 3 || !(bl2 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, geometryArray, transform3D, this.wkPoint, true))) continue;
                System.out.println("right shoulder collided");
            }
            boolean bl4 = bl = !bl2;
            if (!bl2) continue;
            this.collidedObject = sceneGraphPathArray[i];
        }
        return bl;
    }

    private void setInitialTerrainHeight() {
        if (this.terrain == null) {
            return;
        }
        if (this.viewPath != null) {
            this.viewTg.getLocalToVworld(this.viewPath, this.worldEyeTransform);
        } else {
            this.viewTg.getLocalToVworld(this.worldEyeTransform);
        }
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.set(this.locationVector);
        this.terrainPicker.set(this.locationPoint, this.downVector);
        SceneGraphPath[] sceneGraphPathArray = this.terrain.pickAllSorted((PickShape)this.terrainPicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        double d = -1.0;
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            Object object;
            Node node;
            Node node2 = sceneGraphPathArray[i].getObject();
            Object object2 = node2.getUserData();
            if (object2 instanceof UserSupplementData && !((UserSupplementData)object2).isTerrain) continue;
            int n = sceneGraphPathArray[i].nodeCount();
            boolean bl = false;
            for (int j = 0; j < n && !bl; ++j) {
                node = sceneGraphPathArray[i].getNode(j);
                object2 = node.getUserData();
                if (!(object2 instanceof UserSupplementData)) continue;
                bl = !((UserSupplementData)object2).isTerrain;
            }
            if (bl) continue;
            Transform3D transform3D = sceneGraphPathArray[i].getTransform();
            transform3D.get(this.locationVector);
            node = (Shape3D)sceneGraphPathArray[i].getObject();
            object2 = node.getUserData();
            HeightDataSource heightDataSource = null;
            GeometryData geometryData = null;
            if (object2 instanceof UserSupplementData) {
                object = (UserSupplementData)object2;
                if (((UserSupplementData)object).geometryData instanceof HeightDataSource) {
                    heightDataSource = (HeightDataSource)((UserSupplementData)object).geometryData;
                } else if (((UserSupplementData)object).geometryData instanceof GeometryData) {
                    geometryData = (GeometryData)((UserSupplementData)object).geometryData;
                }
            } else if (object2 instanceof HeightDataSource) {
                heightDataSource = (HeightDataSource)object2;
            } else if (object2 instanceof GeometryData) {
                geometryData = (GeometryData)object2;
            }
            if (heightDataSource != null) {
                this.intersectionPoint.x = this.locationVector.x;
                this.intersectionPoint.y = this.locationVector.y;
                this.intersectionPoint.z = heightDataSource.getHeight((float)this.locationVector.x, (float)this.locationVector.y);
                continue;
            }
            if (geometryData != null) {
                if (!this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false)) continue;
                this.diffVec.sub(this.locationPoint, this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.intersectionPoint.set(this.wkPoint);
                continue;
            }
            object = node.getAllGeometries();
            while (object.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)object.nextElement();
                if (geometryArray == null) continue;
                object2 = geometryArray.getUserData();
                geometryData = null;
                if (object2 instanceof UserSupplementData) {
                    UserSupplementData userSupplementData = (UserSupplementData)object2;
                    if (userSupplementData.geometryData instanceof HeightDataSource) {
                        heightDataSource = (HeightDataSource)userSupplementData.geometryData;
                    } else if (userSupplementData.geometryData instanceof GeometryData) {
                        geometryData = (GeometryData)userSupplementData.geometryData;
                    }
                } else if (object2 instanceof HeightDataSource) {
                    heightDataSource = (HeightDataSource)object2;
                } else if (object2 instanceof GeometryData) {
                    geometryData = (GeometryData)object2;
                }
                boolean bl2 = false;
                bl2 = geometryData != null ? this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false) : this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryArray, transform3D, this.wkPoint, false);
                if (!bl2) continue;
                this.diffVec.sub(this.locationPoint, this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.intersectionPoint.set(this.wkPoint);
            }
        }
        if (d != -1.0) {
            this.lastTerrainHeight = (float)this.intersectionPoint.y;
        }
    }

    private boolean floatEq(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        return d3 < 1.0E-6;
    }

    private class FrameTimerBehavior
    extends Behavior {
        private WakeupCondition fpsCriterion = new WakeupOnElapsedFrames(0, false);

        public void initialize() {
            this.wakeupOn(this.fpsCriterion);
        }

        public void processStimulus(Enumeration enumeration) {
            NavigationProcessor.this.frameDuration = System.currentTimeMillis() - NavigationProcessor.this.startFrameDurationCalc;
            if (!this.getEnable()) {
                NavigationProcessor.this.startFrameDurationCalc = System.currentTimeMillis();
                this.wakeupOn(this.fpsCriterion);
                return;
            }
            NavigationProcessor.this.processClockTick();
            this.wakeupOn(this.fpsCriterion);
        }
    }
}

