/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensolaris.os.dtrace.Record;
import org.opensolaris.os.dtrace.ScalarRecord;
import org.opensolaris.os.dtrace.ValueRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrintfRecord
implements Record,
Serializable,
Comparable<PrintfRecord> {
    static final long serialVersionUID = 727237355963977675L;
    private List<ValueRecord> records;
    private String formattedString;

    PrintfRecord() {
        this.records = new ArrayList<ValueRecord>();
    }

    public PrintfRecord(List<ValueRecord> v, String s) {
        this.formattedString = s;
        this.records = new ArrayList<ValueRecord>(v.size());
        this.records.addAll(v);
        this.validate();
    }

    private final void validate() {
        if (this.formattedString == null) {
            throw new NullPointerException("formatted string is null");
        }
        if (this.records == null) {
            throw new NullPointerException("list of format args is null");
        }
        for (ValueRecord r : this.records) {
            if (r != null) continue;
            throw new NullPointerException("format arg is null");
        }
    }

    void addUnformattedElement(ScalarRecord rec) {
        this.records.add(rec);
    }

    public String getFormattedString() {
        return this.formattedString;
    }

    void setFormattedString(String s) {
        if (s == null) {
            throw new NullPointerException("formatted string is null");
        }
        this.formattedString = s;
    }

    public List<ValueRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public int getRecordCount() {
        return this.records.size();
    }

    public ValueRecord getRecord(int i) {
        return this.records.get(i);
    }

    public boolean equals(Object o) {
        if (o instanceof PrintfRecord) {
            PrintfRecord r = (PrintfRecord)o;
            return ((Object)this.records).equals(r.records) && this.formattedString.equals(r.formattedString);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + ((Object)this.records).hashCode();
        hash = 37 * hash + this.formattedString.hashCode();
        return hash;
    }

    @Override
    public int compareTo(PrintfRecord r) {
        return this.formattedString.compareTo(r.formattedString);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.records == null) {
            throw new InvalidObjectException("record list is null");
        }
        ArrayList<ValueRecord> copy = new ArrayList<ValueRecord>(this.records.size());
        copy.addAll(this.records);
        this.records = copy;
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        return this.formattedString;
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(PrintfRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"records", "formattedString"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

