/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.actions;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.ComboCompletionDialog;
import jsyntaxpane.actions.SyntaxAction;
import jsyntaxpane.util.Configuration;

public class ComboCompletionAction
extends TextAction
implements SyntaxAction {
    private static final Set<String> CLOSING = new HashSet<String>(){
        {
            this.add(")");
            this.add("}");
            this.add("[");
        }
    };
    private static final String MEMBER_SEPARATOR = ".";
    Map<String, String> completions;
    ComboCompletionDialog dlg;
    private String[] items;

    public ComboCompletionAction() {
        super("COMBO_COMPLETION");
    }

    public void actionPerformed(ActionEvent e) {
        JTextComponent target = this.getTextComponent(e);
        if (target != null && target.getDocument() instanceof SyntaxDocument) {
            SyntaxDocument sDoc = (SyntaxDocument)target.getDocument();
            int dot = target.getCaretPosition();
            Token token = sDoc.getTokenAt(dot);
            String abbrev = "";
            try {
                if (token != null) {
                    abbrev = token.getText(sDoc);
                    while (CLOSING.contains(abbrev)) {
                        token = sDoc.getTokenAt(token.start - 1);
                        abbrev = token.getText(sDoc);
                    }
                    if (MEMBER_SEPARATOR.equals(abbrev)) {
                        abbrev = "[" + ActionUtils.getTokenStringAt(sDoc, token.start - 1) + "]" + abbrev;
                    } else {
                        Token prev = sDoc.getTokenAt(token.start - 1);
                        if (prev != null && MEMBER_SEPARATOR.equals(prev.getText(sDoc))) {
                            abbrev = "[" + ActionUtils.getTokenStringAt(sDoc, prev.start - 1) + "]" + MEMBER_SEPARATOR + abbrev;
                        }
                    }
                    sDoc.remove(token.start, token.length);
                    dot = token.start;
                }
                Frame frame = ActionUtils.getFrameFor(target);
                if (this.dlg == null) {
                    this.dlg = new ComboCompletionDialog(frame, true, this.items);
                }
                this.dlg.setLocationRelativeTo(frame);
                Point p = frame.getLocation();
                Rectangle rt = target.modelToView(dot);
                Point loc = new Point(rt.x, rt.y);
                loc = SwingUtilities.convertPoint(target, loc, frame);
                SwingUtilities.convertPointToScreen(loc, frame);
                this.dlg.setLocation(loc);
                this.dlg.setFonts(target.getFont());
                this.dlg.setText(abbrev);
                this.dlg.setVisible(true);
                String res = this.dlg.getResult();
                ActionUtils.insertMagicString(target, dot, res);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ComboCompletionAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void config(Configuration config, String prefix, String name) {
        this.items = config.getPrefixPropertyList(prefix, name + ".Items");
    }

    public TextAction getAction(String key) {
        return this;
    }
}

