# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
import os
import random
from xml.dom import minidom
from xml.dom.minidom import Document
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp
from math import *
import Image
import StringIO
import subprocess

def isWindows():
  try:
    WinVersion=QSysInfo().WindowsVersion
    return True
  except:
    return False


def buildSound(VideoporamaInstance, urlIn, urlOut, TstartV, duration, vol=256, fadeIn=0.0, fadeOut=0.0) :
  """Function to compose sound with fade in, fade out, from movie sound ou sound file"""
  command = u"\"%sffmpeg\" -vn -ss %f -t %f -i \"%s\" -vol %d -f s16le -acodec pcm_s16le -ar 48000 -ac 2 - | \"%ssox\" -t raw -c 2 -r 48000 -b 16 --endian little -e signed-integer - -t wav -c 2 -r 48000 -b 16 --endian little -e signed-integer \"%s\" fade h %f %f %f " % ( \
                  VideoporamaInstance.I, \
                  TstartV, \
                  duration, \
                  urlIn, \
                  vol, \
                  VideoporamaInstance.S, \
                  urlOut, \
                  fadeIn, \
                  duration, \
                  fadeOut)
  if isWindows() :
    Process = subprocess.Popen(command.encode('iso-8859-1'),shell=True,stdin=file('nul','a'),stderr=file('nul','a'),stdout=file('nul','a'))
  else:
    Process = subprocess.Popen(command.encode('utf-8'),shell=True)
  Process.wait()
  if not QFile(urlOut).exists() :
    return False
  return True
    
	
#Execute a commande and wait for it finished. Return True if OK
def ExecuteCommande(Commande,Parent=None):
  BoolReturn=False
  print "Commande="+unicode(Commande)
  if isWindows() : 
    Commande=u"\""+unicode(Commande)+"\""
    Process = subprocess.Popen(Commande.encode('iso-8859-1'),shell=True,stdin=file('nul','a'),stderr=file('nul','a'),stdout=file('nul','a'))
  else:
    Process = subprocess.Popen(Commande.encode('utf-8'),shell=True)
  Process.wait()
  return True

#Transform a Path to a relatif path accordind to ProjectFilePathName
def MakeRelatif(ProjectFilePathName,PathToTransform):
  if ProjectFilePathName=="" or PathToTransform=="": return PathToTransform
  else : 
    RelatifBasePath=QFileInfo(ProjectFilePathName).absolutePath()
    return unicode(QDir(RelatifBasePath).relativeFilePath(PathToTransform))

#Transform a Path to an absolut path accordind to ProjectFilePathName
def MakeAbsolut(ProjectFilePathName,PathToTransform):
  if ProjectFilePathName=="" or PathToTransform=="":
    None
  else : 
    RelatifBasePath=QFileInfo(ProjectFilePathName).absolutePath()
    PathToTransform=unicode(QDir().cleanPath(QDir(RelatifBasePath).absoluteFilePath(PathToTransform)))
  return PathToTransform

#--------------------------------------------------------------------
#Function call to draw a ruller + zone define by start/end
#  CustomWidget   QLabel use for drawing
#  Start          QDateTime containing the start of the zone
#  End            QDateTime containing the start of the zone
#  TotalDuration  QDateTime containing the total duration
#--------------------------------------------------------------------
def DrawMovieRuller(CustomWidget,Start,End,TotalDuration):
  Width        = CustomWidget.width()
  Height       = CustomWidget.height()
  MinTickSpace = 30                       # Not less than 30 pixels between to tick

  # Prepare QPainter
  Img=QImage(QSize(Width,Height),QImage.Format_ARGB32_Premultiplied)
  Painter=QPainter(Img)
  OptionText=QTextOption(Qt.AlignCenter)
  Font=QFont("DejaVu Sans",int(7),QFont.Normal,QFont.StyleNormal)
  Painter.setFont(Font)
  Painter.fillRect(QRect(0,0,Width,Height),QColor(Qt.white))

  if QTime(0,0,0).msecsTo(TotalDuration)!=0:
    # Draw zone
    if Start!=None and End!=None:
      PosStart=int(float(Width)*(float(QTime(0,0,0).msecsTo(Start))/float(QTime(0,0,0).msecsTo(TotalDuration))))
      PosEnd  =int(float(Width)*(float(QTime(0,0,0).msecsTo(End))/float(QTime(0,0,0).msecsTo(TotalDuration))))
      Painter.fillRect(QRect(PosStart,12,PosEnd-PosStart,Height-14),QColor(Qt.blue))

    # Now : Draw line and texte of the ruller

    #Define an echelle
    Duration=float(QTime(0,0,0).msecsTo(TotalDuration))/float(1000)   # Calc duration in sec (float)

    # Test for MinTickSpace pixels between 2 ticks
    if (float(Width)/float(Duration))>MinTickSpace:
      Ech     ="S"                                # Use sec as echelle
      SizeTick=float(Width)/Duration
    elif (float(Width)/float(Duration/10))>MinTickSpace:
      Ech="10S"                                   # Use 10 sec as echelle
      SizeTick=float(Width)/float(Duration/10)
    elif (float(Width)/float(Duration/60))>MinTickSpace:
      Ech="M"                                     # Use minute as echelle
      SizeTick=float(Width)/float(Duration/60)
    elif (float(Width)/float(Duration/600))>MinTickSpace:
      Ech="10M"                                   # Use 10 minute as echelle
      SizeTick=float(Width)/float(Duration/600)
    else:
      Ech="H"                                     # Use hour as echelle
      SizeTick=float(Width)/float(Duration/3600)

    # Calc NbrTick to draw
    NbrTick=float(Width)/SizeTick

    TimeSec =float(0)
    TimeMin =float(0)
    TimeHour=float(0)

    Cur=float(0)
    while Cur<Width:
      
      Painter.drawLine(int(Cur*SizeTick),10,int(Cur*SizeTick),Height)
      
      # Draw text
      if Ech=="H" : Text=str(int(TimeHour)).rjust(2,'0')+":"+str(int(TimeMin)).rjust(2,'0')
      else :        Text=str(int(TimeMin)).rjust(2,'0')+":"+str(int(TimeSec)).rjust(2,'0')
      Painter.drawText(int(Cur*SizeTick),9,Text)

      # Draw intermediate tick and then increment time depending on echelle
      if Ech=="S":
        TimeSec+=1
      elif Ech=="10S":
        if (MinTickSpace*2)<SizeTick: # Test if we can draw an intermediate tick
          Painter.drawLine(int((Cur+0.5)*SizeTick),10,int((Cur+0.5)*SizeTick),Height)
          # Draw text
          Text=str(int(TimeMin)).rjust(2,'0')+":"+str(int(TimeSec+5)).rjust(2,'0')
          Painter.drawText(int((Cur+0.5)*SizeTick),9,Text)
        TimeSec+=10
      elif Ech=="M":
        if (MinTickSpace*2)<SizeTick: # Test if we can draw an intermediate tick
          Painter.drawLine(int((Cur+0.5)*SizeTick),10,int((Cur+0.5)*SizeTick),Height)
          # Draw text
          Text=str(int(TimeMin)).rjust(2,'0')+":"+str(int(TimeSec+30)).rjust(2,'0')
          Painter.drawText(int((Cur+0.5)*SizeTick),9,Text)
        TimeMin+=1
      elif Ech=="10M":
        if (MinTickSpace*2)<SizeTick: # Test if we can draw an intermediate tick
          Painter.drawLine(int((Cur+0.5)*SizeTick),10,int((Cur+0.5)*SizeTick),Height)
          # Draw text
          Text=str(int(TimeMin+5)).rjust(2,'0')+":"+str(int(TimeSec)).rjust(2,'0')
          Painter.drawText(int((Cur+0.5)*SizeTick),9,Text)
        TimeMin+=10
      else:
        if (MinTickSpace*2)<SizeTick: # Test if we can draw an intermediate tick
          Painter.drawLine(int((Cur+0.5)*SizeTick),10,int((Cur+0.5)*SizeTick),Height)
          # Draw text
          Text=str(int(TimeHour)).rjust(2,'0')+":"+str(int(TimeMin+30)).rjust(2,'0')
          Painter.drawText(int((Cur+0.5)*SizeTick),9,Text)
        TimeHour+=1

      # Adjust time
      if TimeSec>59:
        TimeSec-=60
        TimeMin+=1
      if TimeMin>59:
        TimeMin-=60
        TimeHour+=1

      # Go to next tick
      Cur=Cur+1
  Painter.end()
  CustomWidget.setPixmap(QPixmap.fromImage(Img))

#Function for text conversion to keep specials caracters in XML
def ToHTML(Text):
  Text=QString(Text)
  NewText=QString("")
  i=0
  while i<len(Text):
    c=Text.at(i).unicode()
    if c==10 or c==13: NewText=NewText+"&#13;"
    elif c==32:        NewText=NewText+"&#32;"
    else :             NewText=NewText+Text.at(i)
    i+=1
  return NewText

def FromHTML(Text):
  NewText=QString(Text).replace("&#32;"," ")
  NewText=QString(NewText).replace("&#13;","\n")
  return NewText

#Load image and place it to a background (in image source size)
def LoadAndPrepareImage(FilePathName,ConfAutoRotate,bgfile,bgcolor,imgwide,Orientation,SourceImage=None):
    # Load source image from disk and prepare it with background and correct geometry
    if FilePathName!="" : 
      if SourceImage==None : SourceImage=QImage(FilePathName)
      # Obtain the exif data to determine if the image should be rotated
      if ConfAutoRotate=="1": SourceImage=ExivProcess(SourceImage,Orientation)
      # It's time to calcul xmax and ymax use in pixel display mode
      SourceXMax=float(SourceImage.width())
      SourceYMax=float(SourceImage.height())
    else :
      if imgwide==1 : xmax=1920
      else :          xmax=1440
      ymax=1080
      if bgfile != "" :
        # Create Background Item backgroundi
        bkgpix = QImage(bgfile)
        # Scale image to correct without aspect ratio
        SourceImage=bkgpix.scaled(xmax,ymax,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
      else :
        SourceImage=QImage(QSize(xmax,ymax),QImage.Format_ARGB32_Premultiplied)
        p=QPainter(SourceImage)
        p.fillRect(QRect(0,0,xmax,ymax),toqcolor(QString(bgcolor).toInt(16)[0]))
        p.end()

    # It's time to calcul xmax and ymax use in pixel display mode
    SourceXMax=float(SourceImage.width())
    SourceYMax=float(SourceImage.height())

    # Calc xmax/ymax in source image unit
    xmax=SourceXMax
    if imgwide==1 : ymax=float((xmax/16)*9)
    else :          ymax=float((xmax/4)*3)
    if ymax<SourceYMax: #Retry for OuputWidth if image is not landscape
      ymax=SourceYMax
      if imgwide==1 : xmax=float((ymax/9)*16)
      else :          xmax=float((ymax/3)*4)
      
    # Virtualy center image (in source image unit)
    VirtX=(xmax-SourceXMax)/2
    VirtY=(ymax-SourceYMax)/2

    # if background needed
    if VirtX>0 or VirtY>0:
      # Prepare background
      if bgfile != "" :
        # Create Background Item backgroundi
        bkgpix = QImage(bgfile)
        # Scale image to correct without aspect ratio
        bkgpix=bkgpix.scaled(xmax,ymax,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
      else :
        # Create Background Item backgroundc
        bkgpix = QImage(QSize(xmax,ymax),QImage.Format_ARGB32_Premultiplied)
        p=QPainter(bkgpix)
        p.fillRect(QRect(0,0,xmax,ymax),toqcolor(QString(bgcolor).toInt(16)[0]))
        p.end()
      # Add source image to bakground (center)
      p=QPainter(bkgpix)
      p.drawImage(VirtX,VirtY,SourceImage)
      p.end()
      SourceImage=bkgpix
    return SourceImage,SourceXMax,SourceYMax

def GetAttributeXML(xmlPoint,Attribut,Default):
  Value=xmlPoint.getAttribute(Attribut)
  if Value=="": Value=Default
  return Value
  
def GetAttributeXMLInt(xmlPoint,Attribut,Default):
  Value=xmlPoint.getAttribute(Attribut)
  if Value=="": Value=Default
  else: Value=int(Value)
  return Value

#Add Text item included in the xmlPoint node to SourceImage in QImage format
def ApplyTextToQImage(SourceImage,xmlPoint,DrawSelectionBox=False):
    if xmlPoint==None: return
    # Get size
    OuputWidth  =float(SourceImage.width())
    OutputHeight=float(SourceImage.height())
    # Load text if some exist
    xmlText=xmlPoint.getElementsByTagName(u"Text")
    if xmlText.length>0 :
      xmlText =xmlText[0]
      TextNum =0
      while xmlText.getElementsByTagName(u"Text-"+str(TextNum)).length>0 :
        CurXMLText      =xmlText.getElementsByTagName(u"Text-"+str(TextNum))[0]
        x               =float(CurXMLText.getAttribute(u"X"))
        y               =float(CurXMLText.getAttribute(u"Y"))
        w               =float(CurXMLText.getAttribute(u"W"))
        h               =float(CurXMLText.getAttribute(u"H"))
        Texte           =FromHTML(CurXMLText.getAttribute(u"Text"))
        FontName        =GetAttributeXML(CurXMLText,u"FontName","DejaVu Sans")
        FontSize        =GetAttributeXMLInt(CurXMLText,u"FontSize",12)
        FontColor       =GetAttributeXML(CurXMLText,u"FontColor","ffffff")
        FontShadowColor =GetAttributeXML(CurXMLText,u"FontShadowColor","5f5f5f")
        IsBold          =GetAttributeXMLInt(CurXMLText,u"IsBold",0)!=0
        IsItalic        =GetAttributeXMLInt(CurXMLText,u"IsItalic",0)!=0
        IsUnderline     =GetAttributeXMLInt(CurXMLText,u"IsUnderline",0)!=0
        HAlign          =GetAttributeXMLInt(CurXMLText,u"HAlign",1)
        VAlign          =GetAttributeXMLInt(CurXMLText,u"VAlign",1)
        StyleText       =GetAttributeXMLInt(CurXMLText,u"StyleText",1)
        BackgroundForm  =GetAttributeXMLInt(CurXMLText,u"BackgroundForm",1)
        BackgroundStyle =GetAttributeXMLInt(CurXMLText,u"BackgroundStyle",0)
        BackgroundColor =GetAttributeXML(CurXMLText,u"BackgroundColor","afafaf")
        PenSize         =GetAttributeXMLInt(CurXMLText,u"PenSize",1)
        PenColor        =GetAttributeXML(CurXMLText,u"PenColor","ffffff")

        # Create font
        if IsBold : bold=QFont.Bold
        else : bold=QFont.Normal
        if IsItalic: Italic=QFont.StyleItalic
        else : Italic=QFont.StyleNormal

        font=QFont(FontName,int(FontSize),bold,Italic)
        if IsUnderline: font.setUnderline(True)
        else : font.setUnderline(False)

        # Scale font
        Factor=(OuputWidth/640)*float(FontSize)
        #font.setPointSizeF(Factor) #Trouble with PointSize : use PixelSize instead
        font.setPixelSize(int(Factor))

        # Setup horizontal alignement
        if HAlign==0:   Option=Qt.AlignLeft
        elif HAlign==1: Option=Qt.AlignHCenter
        elif HAlign==2: Option=Qt.AlignRight
        elif HAlign==3: Option=Qt.AlignJustify

        # Setup vertical alignement
        if VAlign==0:   Option=Option|Qt.AlignTop
        elif VAlign==1: Option=Option|Qt.AlignVCenter
        elif VAlign==2: Option=Option|Qt.AlignBottom

        # Setup text option
        OptionText=QTextOption(Option)
        OptionText.setWrapMode(QTextOption.WordWrap)

        MarginX=float(PenSize)/2+1+1
        MarginY=float(PenSize)/2+1

        if BackgroundForm==3: # 3=Buble
          MarginX=MarginX+OuputWidth/250
          MarginY=MarginY+OutputHeight/250
        elif BackgroundForm==4: # 2=Ellipse
          RX=float(w*OuputWidth/2)
          RY=float(h*OutputHeight/2)
          cos45=0.29  #1-cos(radians(45))
          sin45=0.29  #1-sin(radians(45))
          MarginX=MarginX+(cos45*RX)
          MarginY=MarginY+(sin45*RY)

        p=QPainter(SourceImage)
        # Paint background if needed
        if BackgroundForm!=0:   # 0=None
          # Prepare Pen & Brush
          if PenSize==0:
            Pen=Qt.NoPen
          else:
            Pen=QPen(toqcolor(QString(PenColor).toInt(16)[0]))
            Pen.setWidth(PenSize)
            Pen.setJoinStyle(Qt.RoundJoin)
          p.setPen(Pen)
          p.setBrush(QBrush(toqcolor(QString(BackgroundColor).toInt(16)[0])))
          # Set Transparency
          if BackgroundStyle==0:   p.setOpacity(1)
          elif BackgroundStyle==1: p.setOpacity(0.75)
          elif BackgroundStyle==2: p.setOpacity(0.50)
          elif BackgroundStyle==3: p.setOpacity(0.25)
          elif BackgroundStyle==4: p.setBrush(Qt.NoBrush)
          # Draw the form
          if BackgroundForm==1:    p.drawRect(QRectF(x*OuputWidth,y*OutputHeight,w*OuputWidth,h*OutputHeight))
          elif BackgroundForm==2:
            RayX=float(OuputWidth)/10
            if RayX>10: RayX=10
            if RayX<4:  RayX=4
            RayY=float(OutputHeight)/10
            if RayY>10: RayY=10
            if RayY<4:  RayY=4
            p.drawRoundedRect(QRectF(x*OuputWidth,y*OutputHeight,w*OuputWidth,h*OutputHeight),RayX,RayY,Qt.AbsoluteSize)
          elif BackgroundForm==3:  p.drawRoundedRect(QRectF(x*OuputWidth,y*OutputHeight,w*OuputWidth,h*OutputHeight),50,50,Qt.RelativeSize)
          elif BackgroundForm==4:  p.drawEllipse(QRectF(x*OuputWidth,y*OutputHeight,w*OuputWidth,h*OutputHeight))
          p.setOpacity(1)
          p.setBrush(Qt.NoBrush)

        # Paint Shadow of the text
        p.setFont(font)
        Pen=QPen(toqcolor(QString(FontShadowColor).toInt(16)[0]))
        Pen.setCapStyle(Qt.RoundCap)
        Pen.setJoinStyle(Qt.RoundJoin)
        p.setPen(Pen)
        if StyleText==0:    # 0=normal
          None
        elif StyleText==1:  #1=outerline
          p.drawText(QRectF(x*float(OuputWidth)+MarginX-1,y*float(OutputHeight)+MarginY-1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX-1,y*float(OutputHeight)+MarginY+1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX+1,y*float(OutputHeight)+MarginY+1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX+1,y*float(OutputHeight)+MarginY-1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX  ,y*float(OutputHeight)+MarginY-1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX  ,y*float(OutputHeight)+MarginY+1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX-1,y*float(OutputHeight)+MarginY  ,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
          p.drawText(QRectF(x*float(OuputWidth)+MarginX+1,y*float(OutputHeight)+MarginY  ,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
        elif StyleText==2:  #2=shadow up-left
          p.drawText(QRectF(x*float(OuputWidth)+MarginX-1,y*float(OutputHeight)+MarginY-1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
        elif StyleText==3:  #3=shadow up-right
          p.drawText(QRectF(x*float(OuputWidth)+MarginX+1,y*float(OutputHeight)+MarginY-1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
        elif StyleText==4:  #4=shadow bt-left
          p.drawText(QRectF(x*float(OuputWidth)+MarginX-1,y*float(OutputHeight)+MarginY+1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)
        elif StyleText==5:  #5=shadow bt-right
          p.drawText(QRectF(x*float(OuputWidth)+MarginX+1,y*float(OutputHeight)+MarginY+1,w*OuputWidth-2*MarginX,h*OutputHeight-2*MarginY),Texte,OptionText)

        # Paint text
        p.setPen(toqcolor(QString(FontColor).toInt(16)[0]))
        p.drawText(QRectF(x*float(OuputWidth)+MarginX,y*float(OutputHeight)+MarginY,w*float(OuputWidth)-2*MarginX,h*float(OutputHeight)-2*MarginY),Texte,OptionText)

        if DrawSelectionBox==True:
          #define a pen for the selection rectangle
          col=QColor(0x55,0x55,0x55)
          pen=QPen(col)
          pen.setWidth(1)
          pen.setJoinStyle(Qt.RoundJoin)
          pen.setStyle(Qt.DotLine)
          p.setPen(pen)
          p.setBrush(Qt.NoBrush)
          p.setCompositionMode(QPainter.RasterOp_SourceXorDestination)
          p.drawRect(QRectF(x*OuputWidth,y*OutputHeight,w*OuputWidth,h*OutputHeight))
          p.setCompositionMode(QPainter.CompositionMode_SourceOver)

        p.end()

        # Go to next text item
        TextNum+=1

    return SourceImage

#----------------------------------------------------------------------------------------------------------------------
# Rotate Source image if needed depend on exivData
#----------------------------------------------------------------------------------------------------------------------
def ExivProcess(SourceImage,orientation):
    # Use exif orientation to determine if the image should be rotated
    # A good explanation of the exif orientation tag is available at http://jpegclub.org/exif_orientation.html
    if orientation == 8:
      #Rotating image anti-clockwise by 90 degrees...'
      matrix=QMatrix()
      matrix.rotate(-90)
      SourceImage=SourceImage.transformed(matrix)
    elif orientation == 3:
      #Rotating image clockwise by 180 degrees...'
      matrix=QMatrix()
      matrix.rotate(180)
      SourceImage=SourceImage.transformed(matrix)
    elif orientation == 6:
      #Rotating image clockwise by 90 degrees...'
      matrix=QMatrix()
      matrix.rotate(90)
      SourceImage=SourceImage.transformed(matrix)
    return SourceImage

#----------------------------------------------------------------------------------------------------------------------
# convert an Image in PIL format to a QImage object
#----------------------------------------------------------------------------------------------------------------------
def PilToQImage(pilimage):
    fp = StringIO.StringIO()
    pilimage.save(fp, "BMP")
    qimage = QImage()
    qimage.loadFromData(fp.getvalue(), "BMP")
    return qimage

#----------------------------------------------------------------------------------------------------------------------
# convert a QImage object to an Image in PIL format
#----------------------------------------------------------------------------------------------------------------------
def QImageToPil(qimage):
    buffer = QBuffer()
    buffer.open(QIODevice.WriteOnly)
    qimage.save(buffer, "BMP")
    fp = StringIO.StringIO()
    fp.write(buffer.data())
    buffer.close()
    fp.seek(0)
    return Image.open(fp)

#----------------------------------------------------------------------------------------------------------------------

def colortohex(color):
  r=int(int(color)/65536)
  g=int((int(color)-r*65536)/256)
  b=int(int(color)-r*65536-g*256)
  rr=hexp(r)
  gg=hexp(g)
  bb=hexp(b)
  colorh=str(rr.strip("0x").upper().rjust(2,"0")+gg.strip("0x").upper().rjust(2,"0")+bb.strip("0x").upper().rjust(2,"0")).encode('utf-8')
  return colorh

def toqcolor(color): #OK QT4
  r=int(int(color)/65536)
  g=int((int(color)-r*65536)/256)
  b=int(int(color)-r*65536-g*256)
  qcolor=QColor(r,g,b)
  return qcolor
  
def frameToTime(frameNbr, ips=25) :  
  sec=float(frameNbr) / ips
  seconde=str(sec % 60).split(".")
  minute=int(sec / 60)
  heure=int(minute / 60)
  timesnd="%s:%s:%s.%s" % (str(heure).rjust(2,'0'),str(minute).rjust(2,'0'),seconde[0].rjust(2,'0'),seconde[1].ljust(3,'0')[0:3])
  return timesnd

#----------------------------------------------------------------------------------------------------------------------

def lumaList() :
  # Change type to QStringList to allow sort functionality
  lumask=QStringList()
  lumal=QStringList()
  z=0
  b=os.listdir(os.getcwdu()+QDir().separator().toAscii()+u"luma/")
  for c in b :
    if not c.startswith(".") :
      lumask.append(os.getcwdu()+QDir().separator().toAscii()+u"luma/"+c)
      lumal.append(c)
      z+=1
  # sort list
  lumask.sort()
  lumal.sort()
  return (lumask, lumal)

def randomTransi() :
  #Construit un tableau des options de transition
  DefTrOpt= [
    [0,1],  #None
    [1,1],  #Fade
    [2,9],  #Zoom in
    [3,9],  #Zoom out
    [4,8],  #Slide
    [5,4],  #Cube
    [6,4],  #Push
    [7,0]   #Luma
  ]

  #Ajoute les luma (qui sont lus sur le disque)
  DefTrOpt[7][1]=len(lumaList()[0])

  #Calcul le nombre de transition
  MaxTr=0
  for i in DefTrOpt : MaxTr=MaxTr+i[1]
  
  #Génère un nombre aléatoire dans la fourchette
  TrRnd=random.randint(1, MaxTr)
  
  #Décompose le résultat en Transition + option de transition
  CurTr=0
  while TrRnd>DefTrOpt[CurTr][1]:
    TrRnd=TrRnd-DefTrOpt[CurTr][1]
    CurTr=CurTr+1
  
  if CurTr<=7 :
    TrType=DefTrOpt[CurTr][0]
    TrOpt=TrRnd-1
  else:
    TrType=0
    TrOpt=0
    
  return (TrType, TrOpt)

#-------------------------------------------------------------------------------------
# Global functions definition
#-------------------------------------------------------------------------------------
# Function use to validate directory path windows/linux
#-------------------------------------------------------------------------------------
def validatePath(PathToCheck,AddSep=True):
    if PathToCheck=="" : return PathToCheck
    if AddSep==True :
      if PathToCheck[len(PathToCheck)-1]!=QDir().separator().toAscii() : PathToCheck=PathToCheck+QDir().separator().toAscii()
    Path=QDir().toNativeSeparators(PathToCheck)
    if isWindows() : 
      Path=unicode(Path).encode('iso-8859-1')
    else:
      Path=unicode(PathToCheck)
    return Path

#-------------------------------------------------------------------------------------
# Function use to validate directory path windows/linux
#-------------------------------------------------------------------------------------
#version for subprocess.Popen
def validateCommande(CommandeToCheck,AddWindowsExe=True):
    if isWindows() : 
      i=0
      Commande=unicode("")
      while i<len(CommandeToCheck):
        if CommandeToCheck[i]==u'/' :
          Commande=Commande+u'\\\\'
        else:
          Commande=Commande+CommandeToCheck[i]
        i+=1
      if AddWindowsExe==True: Commande=Commande+u".exe"
      Commande=u"\""+Commande+u"\""
      Commande=unicode(Commande).encode('iso-8859-1')
    else:
      Commande=unicode(CommandeToCheck).encode('utf-8')
    return Commande

#-------------------------------------------------------------------------------------
# Function use to check if a directory is writable (windows/linux)
#-------------------------------------------------------------------------------------
def IsPathWritable(Path):
    if isWindows() : 
      i=0
      PathToTest=""
      while i<len(Path):
        if Path[i]=="\\":
          PathToTest=PathToTest+"\\\\"
        else:
          PathToTest=PathToTest+Path[i]
        i+=1
      PathToTest=unicode(PathToTest).encode('iso-8859-1')
      return os.access(PathToTest,os.W_OK)
    else:
      return os.access(unicode(Path).encode('utf-8'),os.W_OK)

#-------------------------------------------------------------------------------------
# Function use to check if a binary file exist (windows/linux)
#-------------------------------------------------------------------------------------
def IsBinaryFileExist(Path):
    if isWindows() : 
      i=0
      PathToTest=""
      while i<len(Path):
        if Path[i]=="\\":
          PathToTest=PathToTest+"\\\\"
        else:
          PathToTest=PathToTest+Path[i]
        i+=1
      if unicode(PathToTest).endswith(".exe")==False :
        PathToTest=PathToTest+u".exe"
      PathToTest=unicode(PathToTest).encode('iso-8859-1')
      return os.path.isfile(PathToTest)
    else:
      return os.path.exists(Path)

#-------------------------------------------------------------------------------------
# Function use to check if a file exist (windows/linux)
#-------------------------------------------------------------------------------------
def IsFileExist(Path):
    if isWindows() : 
      i=0
      PathToTest=""
      while i<len(Path):
        if Path[i]=="\\":
          PathToTest=PathToTest+u"\\\\"
        else:
          PathToTest=PathToTest+Path[i]
        i+=1
      PathToTest=unicode(PathToTest).encode('iso-8859-1')
      return os.path.isfile(PathToTest)
    else:
      return os.path.exists(Path)

#-------------------------------------------------------------------------------------
# Function use to load data from XML project file
#   If NameValue not exist in the XML, add-it using DefaultValue
#-------------------------------------------------------------------------------------
def LoadValueFromXMLFile(XMLObject,NameValue,DefaultValue,Tree="configuration"):
  try:
    ReturnValue=XMLObject.getElementsByTagName(NameValue)[0].childNodes[0].nodeValue
  except:
    ReturnValue=unicode(DefaultValue)
    if ReturnValue!="":
      doc=Document()
      xmlchild = doc.createElement(unicode(NameValue))
      xmlchild.appendChild(doc.createTextNode(unicode(ReturnValue)))
      xmltag=XMLObject.getElementsByTagName(Tree)[0]
      xmltag.appendChild(xmlchild)
  return ReturnValue.strip()

#-------------------------------------------------------------------------------------
# Function use to update data into XML
#   If NameValue not exist in the XML, add-it
#-------------------------------------------------------------------------------------
def UpdateConfigurationXMLFile(XMLObject,NameValue,Value,Tree="configuration"):
  #if property is empty, remove it !
  if Value=="": 
    xmltag=XMLObject.getElementsByTagName(Tree)[0]
    try:
      xmlchild=XMLObject.getElementsByTagName(NameValue)[0]
      xmltag.removeChild(xmlchild)
    except:
      None
  else:
    try: 
      doc=Document()
      xmlchild = doc.createTextNode(Value)
      xmltag=XMLObject.getElementsByTagName(NameValue)[0]
      xmltag.replaceChild(xmlchild,xmltag.childNodes[0])
    except :
      if Value!="": 
        xmlchild = doc.createElement(NameValue)
        xmlchild.appendChild(doc.createTextNode(Value))
        xmltag=XMLObject.getElementsByTagName(Tree)[0]
        xmltag.appendChild(xmlchild)

#-------------------------------------------------------------------------------------
# Function use to load data from XML project file
#-------------------------------------------------------------------------------------
def LoadAttributFromXMLFile(XMLObject,NameValue,NameAttribut,Tree=u"Videoporama"):
  try:
    xmltag=XMLObject.getElementsByTagName(Tree)[0]
    try: 
      xmlchild=XMLObject.getElementsByTagName(NameValue)[0]
      ReturnValue=xmlchild.getAttribute(NameAttribut)
    except :
      ReturnValue=""
  except :
    ReturnValue=""
  return ReturnValue

#-------------------------------------------------------------------------------------
# Function use to save data from XML project file
#   If NameValue not exist in the XML, add-it using DefaultValue
#-------------------------------------------------------------------------------------
def UpdateAttributXMLFile(XMLObject,NameValue,NameAttribut,Value,Tree=u"Videoporama"):
  xmltag=XMLObject.getElementsByTagName(Tree)[0]
  try: 
    xmlchild=XMLObject.getElementsByTagName(NameValue)[0]
    xmlchild.setAttribute(NameAttribut,Value)
    xmltag.appendChild(xmlchild)
  except :
    doc=Document()
    xmlchild=doc.createElement(NameValue)
    xmlchild.setAttribute(NameAttribut,Value)
    xmltag.appendChild(xmlchild)

#-------------------------------------------------------------------------------------
#Function use to search a specific element by his Name attribut
#-------------------------------------------------------------------------------------
def getElementsByAttributName(XMLObject,Name):
    for SubElement in XMLObject.childNodes :
      if SubElement.nodeType==SubElement.ELEMENT_NODE:
        if SubElement.getAttribute("Name")==Name: return SubElement
    return None

#-------------------------------------------------------------------------------------
# Function use to load data from XML project file
#-------------------------------------------------------------------------------------
def LoadAttributSubFromXMLFile(XMLObject,NameValue,SubNameValue,NameAttribut,Tree=u"Videoporama"):
  xmltag=XMLObject.getElementsByTagName(Tree)[0]
  try: 
    xmlchild=XMLObject.getElementsByTagName(NameValue)[0]
    xmlSubChild=xmlchild.getElementsByTagName(SubNameValue)[0]
    ReturnValue=xmlSubChild.getAttribute(NameAttribut)
  except :
    ReturnValue=""
  return ReturnValue

#-------------------------------------------------------------------------------------
# Function use to update data into XML
#   If NameValue not exist in the XML, add-it using DefaultValue
#-------------------------------------------------------------------------------------
def UpdateAttributSubXMLFile(XMLObject,NameValue,SubNameValue,NameAttribut,Value,Tree=u"Videoporama"):
  xmltag=XMLObject.getElementsByTagName(Tree)[0]
  try: 
    xmlchild=XMLObject.getElementsByTagName(NameValue)[0]
    xmlSubChild=xmlchild.getElementsByTagName(SubNameValue)[0]
    xmlSubChild.setAttribute(NameAttribut,Value)
    xmlchild.appendChild(xmlSubChild)
    xmltag.appendChild(xmlchild)
  except :
    doc=Document()
    xmlchild=XMLObject.getElementsByTagName(NameValue)[0]
    xmlSubChild=doc.createElement(SubNameValue)
    xmlSubChild.setAttribute(NameAttribut,Value)
    xmlchild.appendChild(xmlSubChild)
    xmltag.appendChild(xmlchild)

#-------------------------------------------------------------------------------------
# Function use to translate color
#-------------------------------------------------------------------------------------
def toqcolor(color):
  #--------------- BUG:invalid literal for int() with base 10
  r=int(int(color)/65536)
  g=int((int(color)-r*65536)/256)
  b=int(int(color)-r*65536-g*256)
  qcolor=QColor(r,g,b)
  return qcolor

#-------------------------------------------------------------------------------------
# Function use to translate color
#-------------------------------------------------------------------------------------
def colortohex(color):
  r=int(int(color)/65536)
  g=int((int(color)-r*65536)/256)
  b=int(int(color)-r*65536-g*256)
  rr=hexp(r)
  gg=hexp(g)
  bb=hexp(b)
  colorh=str(rr.strip("0x").upper().rjust(2,"0")+gg.strip("0x").upper().rjust(2,"0")+bb.strip("0x").upper().rjust(2,"0"))
  return colorh

#-------------------------------------------------------------------------------------
# Function use return the list of transition
#-------------------------------------------------------------------------------------
# Transition name
def LstTransi(self):
  lstT=QStringList()
  lstT.append(self.qtapp.translate("main","None"))
  lstT.append(self.qtapp.translate("main","Fade"))
  lstT.append(self.qtapp.translate("main","Zoom in"))
  lstT.append(self.qtapp.translate("main","Zoom out"))
  lstT.append(self.qtapp.translate("main","Slide"))
  lstT.append(self.qtapp.translate("main","Cube"))
  lstT.append(self.qtapp.translate("main","Push"))
  lstT.append(self.qtapp.translate("main","Luma"))
  return lstT

# Transition option
def getTrOptionLst(self,tr) : #OK QT4
  LS=QStringList()
  if tr <= 1 or tr ==8 :
    LS.append(self.qtapp.translate("main","No Option"))
  elif tr == 2 : # ZOOM IN
    LS.append(self.qtapp.translate("main","Since the center"))
    LS.append(self.qtapp.translate("main","Since center of the left edge"))
    LS.append(self.qtapp.translate("main","Since center of the right edge"))
    LS.append(self.qtapp.translate("main","Since center of the top edge"))
    LS.append(self.qtapp.translate("main","Since center of the bottom edge"))
    LS.append(self.qtapp.translate("main","Since the upper left corner"))
    LS.append(self.qtapp.translate("main","Since the upper right corner"))
    LS.append(self.qtapp.translate("main","Since the lower left corner"))
    LS.append(self.qtapp.translate("main","Since the lower right corner"))
  elif tr == 3 :  # ZOOM OUT
    LS.append(self.qtapp.translate("main","Towards the center"))
    LS.append(self.qtapp.translate("main","Towards the center of the left edge"))
    LS.append(self.qtapp.translate("main","Towards the center of the right edge"))
    LS.append(self.qtapp.translate("main","Towards the center of the top edge"))
    LS.append(self.qtapp.translate("main","Towards the center of the bottom edge"))
    LS.append(self.qtapp.translate("main","Towards the upper left corner"))
    LS.append(self.qtapp.translate("main","Towards the upper right corner"))
    LS.append(self.qtapp.translate("main","Towards the lower left corner"))
    LS.append(self.qtapp.translate("main","Towards the lower right corner"))
  elif tr == 4 :  # SLIDE
    LS.append(self.qtapp.translate("main","Left towards right"))
    LS.append(self.qtapp.translate("main","Right towards left"))
    LS.append(self.qtapp.translate("main","Top towards bottom"))
    LS.append(self.qtapp.translate("main","Bottom towards top"))
    LS.append(self.qtapp.translate("main","Since the upper left corner"))
    LS.append(self.qtapp.translate("main","Since the upper right corner"))
    LS.append(self.qtapp.translate("main","Since the lower left corner"))
    LS.append(self.qtapp.translate("main","Since the lower right corner"))
  elif tr >= 5 and tr < 7 :
    LS.append(self.qtapp.translate("main","Left towards right"))
    LS.append(self.qtapp.translate("main","Right towards left"))
    LS.append(self.qtapp.translate("main","Top towards bottom"))
    LS.append(self.qtapp.translate("main","Bottom towards top"))
  elif tr == 7 :
    b=os.listdir(os.getcwd()+"/luma/")
    for c in b :
      if not c.startswith(".") :
        d=os.path.splitext(c)
        LS.append(d[0])
    #Sort the list only for LUMA !
    LS.sort()
  return LS
