# -*- coding: utf-8 -*-

## This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from Documentation import *

class DocHelp(QDialog,Ui_Documentation) : #OK QT4
    def __init__(self, Videoporama, HtmlFile, parent=None):
      super(DocHelp, self).__init__(parent)
      self.setupUi(self)
      self.Videoporama=Videoporama
      PathName=u"help/"+HtmlFile
      self.textBrowser.setUrl(QUrl(PathName))
      self.textBrowser.history().clear()
      self.SetupInterface(True)
      self.Videoporama.qtapp.connect(self.closeabout,SIGNAL("clicked()"),self,SLOT("close()"))
      self.Videoporama.qtapp.connect(self.BackwardBt,SIGNAL("clicked()"),self.DocumentationBackward)
      self.Videoporama.qtapp.connect(self.ForwardBt,SIGNAL("clicked()"),self.DocumentationForward)
      self.Videoporama.qtapp.connect(self.textBrowser,SIGNAL("loadFinished(bool)"),self.SetupInterface)

    def SetupInterface(self,IsOk):
      self.BackwardBt.setEnabled(self.textBrowser.history().canGoBack() and self.textBrowser.history().currentItemIndex()>1)
      self.ForwardBt.setEnabled(self.textBrowser.history().canGoForward())
      
    def DocumentationBackward(self) :
      self.textBrowser.back()

    def DocumentationForward(self) :
      self.textBrowser.forward()
