/*
 * ===========================
 * VDK Builder
 * Version 1
 * Revision 0.2
 * March 2000
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

/*
  NLS translation tables
 */
char* folder_widget_titles[] =
{
  N_("Buttons"), N_("Containers"), N_("Dialogs"),
  N_("Misc"), N_("Text"),N_("Plugins"),N_("Gnome widgets"),
  N_("Xdb widgets"),
  0
};
/*
  NLS translation tables
 */
char* main_menu_prompts[] =
{
  N_("File"), // 0
  N_("New.."), // 1
  N_("_Project"), // 2
  N_("_Unit"), // 3
  N_("Form"), // 4
  N_("Default"), // 5
  N_("Scrolled"), // 6
  N_("Paned"), // 7
  N_("_Open.."), // 8
  N_("Project"), // 9
  N_("File"), // 10
  N_("Save"), // 11
  N_("Save All"), //12 
  N_("_Quit VDKBuilder"), // 13
  N_("_Edit"),  // 14
  N_("_Search"), // 15
  N_("_View"), // 16
  N_("View Units"), // 17
  N_("View Forms"), // 18
  N_("Project"), // 19
  N_("Add to project"), // 20
  N_("Remove from project"), // 21
  N_("Components"), // 22
  N_("_Tools"), // 23
  N_("_Help"), // 24
  N_("Tutorial"), // 25
  N_("About VDK Builder"), // 26
  N_("_Make"), // 27
  N_("Op_tions"), // 28
  N_("Make clean"), // 29
  N_("Search"), // 30
  N_("Repeat Search"), // 31
  N_("Replace"), // 32
  N_("Undo"), // 33
  N_("Redo"), // 34
  N_("Syntax Hilight (F6)"), // 35
  N_("Run debugger"), // 36
  N_("Set Builder environment"), // 37
  N_("Grep"), // 38
  N_("Autoconf/Automake"), // 39
  N_("Autogen"),  // 40
  N_("Make"), // 41
  N_("Make clean"), // 42 
  N_("Make dist"),  // 43
  N_("Make distclean"), // 44
  N_("VDK Reference Manual"), // 45
  N_("XDatabase tools"), // 46
  N_("XDB Support"), // 47
  N_("Editor short cuts (F1)"), // 48
  N_("Reopen"), // 49
  N_("Hints editor"), // 50
  0
};
/*
  NLS translation tables
 */
char *main_toolbar_tips[] =
{
  N_("New Project"), N_("New Unit"), N_("New Form"), N_("Open project"),
  N_("Open File"), N_("Save project"), N_("Save File"), 0
};

char *main_toolbar1_tips[] =
{
  N_("Toggle unit/form"), N_("Run"), N_("Cancel selection"), 
  N_("Call emacs as external editor"),0
};
/*
  NLS translation tables
 */
char * container_widgets_tips[] =
{
  N_("Vert box"), N_("Hor box"), N_("Frame"),
  N_("Table"), N_("Vert paned"), N_("Hor paned"),
  N_("Notebook"), N_("Handlebox"), N_("Toolbar"),
  N_("Scrolled"), N_("Menu bar"), N_("Vert Radio Button Group"),
  N_("Hor Radio Button Group"),N_("Fixed"), 
  0
};
/*
  NLS translation tables
 */
char * button_widgets_tips[] =
{
  N_("VDKCustom Button"), N_("Spin button"),
  N_("Check button"), N_("Radio button"),
  0
};
/*
  NLS translation tables
 */
char * text_widgets_tips[] =
{
  N_("Label"), N_("Entry"), N_("Text"),
  0
};
/*
  NLS translation tables
 */
char * misc_widgets_tips[] =
{
  N_("Canvas"), N_("Pixmap"), N_("Image"),N_("Progress bar"),
  N_("Slider"), N_("Status bar"), N_("Timer"),
  N_("Custom list"), N_("Combo box"), N_("Custom tree"),
  N_("Hor separator"), N_("Vert separator"), N_("Grid"),
  N_("Place holder"),N_("Tree view"),
  0
};
/*
  NLS translation tables
 */
char * gnome_widgets_tips[] =
{
  N_("Gnome application bar"),N_("Gnome date Edit"),
  N_("Gnome entry"),
  0
};

/*
  NLS translation tables
 */
char * xdb_widgets_tips[] =
{
  N_("xdb entry"),N_("xdb list"), N_("xdb check button"),
  N_("xdb memo"), 
  0
};
/*
  NLS translation tables
 */
char * prjman_prompts[] =
{
  N_("Project manager"), N_("New project"), N_("Add a unit"),
  N_("Remove a unit"), N_("Edit unit"), N_("Form attributes"),
  N_("Add Member"), N_("Declared"), N_("Defined"), // 6 7 8 9 for class viewer
  N_("Update"),
  0
};
/*
  NLS translation tables
 */
char * user_messages[] =
{
  N_("Quit VDKBuilder ?"), N_("Ok"), N_("No"),
  N_("Cancel"), N_("defaults file missing, aborting.."),
  N_("modified, has to be saved ?"), N_("Unknown unit type"),
  N_("unit can't be added"), N_("can't be closed"),
  N_("bad reading or unknown project file"),
  N_("incorrect project version"),
  N_("main unit can't be removed"),
  N_("unit already in project"),
  0
};
/*
  NLS translation tables
 */
char * prj_status[] =
{
  N_("Status: never saved"), 
  N_("Status: unsaved"),
  N_("Status: saved"),
  0
};
/*
  NLS translation tables
 */
char* file_dialog_prompts[] =
{
  N_("Open a project"),
  N_("Open a file"),
  N_("Add a unit to project"),
  N_("Save project as.."),
  N_("Save file as.."),
  0
};
/*
  NLS translation tables
 */
char* editor_prompts[] =
{
  N_("VDKBuilder editor"),  N_("Modified:"),  N_("Line:"), // 0 1 2
  N_("Toggle unit header/source"),  N_("Close this page"),  N_("Save as.."), // 3 4 5
  N_("No more undo's"),  N_("Fontifyng"),  N_("done"), // 6 7 8
  N_("Save"),  N_("Shows/hides line numbers"),  N_("Shows/hides messages list"), // 9 10 11
  0
};
/*
  NLS translation tables
 */
char* source_prompts[] =
{
  "\n// do not remove this mark: %s\n// end of file:%s_gui.%s\n", // 0
  "\n// do not remove this mark: %s\n// end of file:%s.%s\n", // 1
  "/*\n%s gui header\n*/", // 2
  "\n/*\ndeclaring signal and events\ndynamics tables\n*/", // 3
  "\n/*\ndefining signal and events\ndynamics tables\n*/", // 4
  "\n/*\ndefining signal static table\n*/", // 5
  "\n/*\nmain form setup\n*/", // 6
  "\n/* default useless form */", // 7
  "signal response method", // 8
  "asks user before closing", // 9
  "form event response method", // 10
  "/*\n%s Console Application", // 11
  "\nMain unit header file: %s.%s", // 12
  "/*\n%s %s Application", // 13
  "Plain VDK", // 14
  "VDK Gnome compliant", // 15
  "\n// gui object declarations", // 16
  "\n// vdkbuilder reserved gui construction", // 17
  "\n/*\n gui setup include", // 18
  "\n do not patch below here\n*/", // 19
  "\n/*\nform GUI setup\n*/", // 20
  "\nimplementation file:%s.%s", // 21
  "\n/*\nform constructor\n*/", // 22
  "\n/*\nform destructor\n*/", // 23
  "\n/*\nform setup\n*/", // 24
  "\n// put your code below here", // 25
  "\nheader file: %s.%s", // 26
  "\nMain unit implementation file:%s.%s", // 27
  "\n/*\nmain program\n*/", // 28
  "\n/*\nmain form constructor\n*/", // 29
  "\n/*\napplication constructor\n*/", // 30
  "\n/*\napplication destructor\n*/", // 31
  "/*\n%s ConsoleApplication", // 32
  "\nMain unit implementation file:%s.%s", // 33
  "\n/*\nAuthor:\t%s", // 34
  "\nE-mail:\t%s\n*/", // 35
  "\n/*\nLicense:\n\
\tThis program is free software; you can redistribute it and/or modify\n\
\tit under the terms of the GNU General Public License as published by\n\
\tthe Free Software Foundation; either version 2 of the License, or\n\
\tat your option any later version.\n*/\n", // 36
  "\n/*\nCopyright %s - %d, all rights reserved\n*/\n", // 37
"\n/*\n** WARNING ** - File written by VDKBuilder, unuseful edit it\n*/\n", // 38
  0
};




/*
  NLS translation tables
 */
char* wi_prompts[] =
{
  N_("Connects form to selected event"), // 0
  N_("Disconnects form to selected event"), // 1
  N_("Drops a <%s> into %s"), // 2
  N_("Duplicated connection"), // 3
  N_("Connection not found"), // 4
  N_("Duplicated response function"), // 5
  N_("Duplicated name"), // 6
  N_("Widget name can't be cancelled"), // 7
  N_("WI: no object selected"), // 8
  N_("Properties"), // 9
  N_("Delete signal response"), // 10
  N_("Common properties"), // 11
  N_("Set name"), // 12
  N_("Widget names must follow C++ naming rules"), // 13
  N_("Widget state"), // 14
  N_("Set color"), // 15
  N_("Set font"), // 16
  N_("Justification"), // 17
  N_("Expand"), // 18
  N_("Fill"), // 19
  N_("Padding:"), // 20
  N_("Repack"), // 21
  N_("Box Preview"), // 22
  N_("Side"), // 23
  N_("Anchor"), // 24
  N_("Fill X"), // 25
  N_("Fill Y"), // 26
  N_("Reconfigure"), // 27
  N_("Set tooltip"), // 28
  N_("Set tag"), // 29
  N_("WI: disabled"), // 30
  N_("Signals"), // 31
  N_("Form events"), // 32
  N_("Class response method"), // 33
  N_("Reuse this"), // 34
  N_("Restore default"), // 35
  N_("Public"), // 36
  0
};

/*
  NLS translation tables
 */
char* popmenu_prompts[] =
{
  N_("Cut"), // 0
  N_("Copy"), // 1
  N_("Paste"), // 2
  N_("Paste others"), // 3
  N_("Drop widget"), // 5
  0
};
/*
  NLS translation tables
 */
char* vdkbmaker_prompts[] =
{
  N_("Begin"),
  N_("Runs child process"),
  N_("Kill or Close"),
  N_("Kills child process or close form if no child is running"),
  0
};
/*
  NLS translation tables
 */
char* prjoptions_prompts[] =
{
  N_("Project options"), // 0
  N_("C compiler"), // 1
  N_("C++ compiler"), // 2
  N_("Linker"), // 3
  N_("Compilation flags"), // 4
  N_("Defines"), // 5
  N_("Include paths"), // 6
  N_("Shared libs"), // 7
  N_("Debugger"), // 8
  N_("Program args"), // 9
  N_("Package version"), // 10
  N_("Close and save"), // 11
  N_("Cancel"), // 12
  N_("Package name"), // 13
  N_("NLS Support"), // 14
  0
};
/*
  NLS translation tables
 */
char* search_dialog_prompts[] =
{
  N_("Find Text"),
  N_("Find"),
  N_("Text to find"),
  N_("Previous search"),
  N_("Options"),
  N_("Case sensitive"),
  N_("Whole words only"),
  N_("Regular expressions"),
  N_("Directions"),
  N_("Forward"),
  N_("Backward"),
  N_("Scope"),
  N_("Global"),
  N_("Selected text"),
  N_("Origin"),
  N_("From cursor"),
  N_("Entire scope"),
  N_("Ok"),
  N_("Cancel"),
  N_("Reached end of buffer"),
  N_("continue from beginning ?"),
  0
};
/*
  NLS translation tables
 */
char* replace_dialog_prompts[] =
{
  N_("Replace Text"),
  N_("Replace"),
  N_("Text to find:"),
  N_("Text to replace:"),
  N_("Options"),
  N_("Case sensitive"),
  N_("Whole words only"),
  N_("Regular expressions"),
  N_("Prompt on replace"),
  N_("Directions"),
  N_("Forward"),
  N_("Backward"),
  N_("Scope"),
  N_("Global"),
  N_("Selected text"),
  N_("Origin"),
  N_("From cursor"),
  N_("Entire scope"),
  N_("Ok"),
  N_("Replace All"),
  N_("Cancel"),
  N_("Replace occurrence of:"),
  N_("with:"),
  N_("Yes"),
  N_("No"),
  0
};
/*
  NLS translation tables
 */
char* about_dlg_text[] =
{
  "Mario Motta",
  "Ionutz Borcoman",
  "Tim Lorenz",
  0
};
/*
  NLS translation tables
 */
char* wi_widget_prompts[] =
{
  N_("Set Caption"), // 0
  N_("Caption wrap"), // 1
  N_("Editable"), // 2
  N_("Sorted"), // 3
  N_("Hidden"), // 4
  N_("CaseSensitive"), // 5
  N_("Set Relief"), // 6
  N_("Set glyph"), // 7
  N_(".xpm -> project dir"), // 8
  N_("Copy .xpm to project dir (recommended)"), // 9
  N_("Set sel mode"), // 10
  N_("Column title: "), // 11
  N_("AutoResize"), // 12
  N_("Set border shadow"), // 13
  N_("ShowTime"), // 14
  N_("Format H 24"), // 15
  N_("Hidden"), // 16
  N_("Text"), // 17
  N_("Max chars"), // 18
  N_("Set min size"), // 19  
  N_("Select parent container"), // 20
  N_("Remove box"), // 21
  N_("Remove fixed"), // 22
  N_("Set grid options"), // 23
  N_("Have grid"), // 24
  N_("V spacing: "), // 25
  N_("H spacing: "), // 26
  N_("Set form title"), // 27
  N_("Set back pixmap"), // 28
  N_("Set focus widget"), // 29
  N_("Remove frame"), // 30
  N_("Set border width"), // 31
  N_("Label: "), // 32
  N_("Set shadow/align"), // 33
  N_("Progress bar"), // 34
  N_("History id"), // 35
  N_("Max saved"), // 36
  N_("Rows visibles"), // 37
  N_("Cols visibles"), // 38
  N_("Remove handle"), // 39
  N_("Set shadow"), // 40
  N_("Ckecked"), // 41
  N_("Tab label: "), // 42
  N_("Scrollable"), // 43
  N_("PopUp"), // 44
  N_("Minimum value"), // 45
  N_("Maximum value"), // 46
  N_("Set BlockCount"), // 47
  N_("Set bar style"), // 48
  N_("Set orientation"), // 49
  N_("Activity mode"), // 50
  N_("Def constructor"), // 51
  N_("Set lower bound"), // 52
  N_("Set upper bound"), // 53
  N_("Set step"), // 54
  N_("Set update policy"), // 55
  N_("Set digits"), // 56
  N_("Set default value"), // 57
  N_("Set icon by data"), // 58
  N_("Check this if you want set icon by data\n(icon must be non NULL)"), // 59
  N_("Set display type"), // 60
  N_("Set initial position"), // 61
  N_("Freeze form size"), // 62
  N_("Set minimum size, form can't be shrinked below"), // 63
  0
};

