/* m68k-atari.tos.h
   created from m68k-atari.tos.bin, 19182 (0x4aee) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2013 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2013 Laszlo Molnar
   Copyright (C) 2000-2013 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_M68K_ATARI_TOS_SIZE    19182
#define STUB_M68K_ATARI_TOS_ADLER32 0x3f8e8ba1
#define STUB_M68K_ATARI_TOS_CRC32   0x5e331155

unsigned char stub_m68k_atari_tos[19182] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0,  4,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 26,152,  1,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 84,  0, 81, 32,  8,103,  6, 46,104,  0,  4, 96,  4, 32, 47,
/* 0x0040 */   0,  4, 72,231,127,254, 32, 64, 80,136, 44, 88, 40, 14, 32,188,
/* 0x0050 */   0,  0,  0,  0,221,216, 32,206, 32,188,  0,  0,  0,  0,221,216,
/* 0x0060 */  40, 80, 32,206, 32,188,  0,  0,  0,  0, 71,238,  0,  0, 38, 68,
/* 0x0070 */ 214,252,  0,  0, 38, 68,215,252,  0,  0,  0,  0,112,  0, 48, 60,
/* 0x0080 */   0,  0, 32, 60,  0,  0,  0,  0, 73,236,255, 96, 76,236, 39,238,
/* 0x0090 */   0,120, 72,227,119,228, 76,236, 39,238,  0, 80, 72,227,119,228,
/* 0x00a0 */  76,236, 39,238,  0, 40, 72,227,119,228, 76,212, 39,238, 72,227,
/* 0x00b0 */ 119,228, 39, 36, 83,128,102,  0, 83, 64,102,  0, 81,200,  0,  0,
/* 0x00c0 */ 112,  0, 39, 36, 81,200,255,252, 65,250,  0,  0, 47,  4,122,  0,
/* 0x00d0 */  63, 32, 83,133,100,250, 63,124, 78,113,  0,  0, 97,  0,112,128,
/* 0x00e0 */ 126,255,124,152,235, 78, 40, 68,112,128,126,255,124,176,233, 78,
/* 0x00f0 */  40, 68,112,128,126,  0,124,176,233, 78, 40, 68, 78,238,  0,  0,
/* 0x0100 */  32, 68, 78,232,  0,  0, 65,238,127,255, 78,232,  0,  0, 32, 68,
/* 0x0110 */ 209,252,  0,  0,  0,  0, 78,208, 44,195, 44,195, 44,195, 44,195,
/* 0x0120 */  44,195, 83,134,102,  0, 83, 70,102,  0, 81,206,  0,  0, 72,120,
/* 0x0130 */ 255,255, 66,167, 47, 60,  1, 84,  0, 22, 78, 65, 79,239,  0, 12,
/* 0x0140 */  74,128,103, 96, 72,122,  0, 16, 63, 60,  0, 38, 78, 78, 92,143,
/* 0x0150 */  96, 82, 46, 73, 78,208, 47, 56,  0, 16, 47, 56,  0, 44, 47, 56,
/* 0x0160 */   0,244, 34, 79, 65,250,255,236, 33,200,  0, 16, 33,200,  0, 44,
/* 0x0170 */  33,200,  0,244, 78,113, 65,250,  0,  6,244,248, 96, 22, 65,250,
/* 0x0180 */   0, 20, 78,122,  0,  2, 34,  0,  0, 65,  8,  8, 78,123, 16,  2,
/* 0x0190 */  78,123,  0,  2, 33,223,  0,244, 33,223,  0, 44, 33,223,  0, 16,
/* 0x01a0 */  78,113, 78,117, 78,117, 79,250,  0,  0,112,  0, 65,250,  0,  2,
/* 0x01b0 */  33,  3, 81,200,255,252, 76,223,127,254, 32,  8,103,  2,159,207,
/* 0x01c0 */  78,249, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,
/* 0x01d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x01e0 */   0, 45, 24,219,208,  0,100,  8,102,248, 16, 27,209,  0,101,242,
/* 0x01f0 */ 114,  1,118,  0,208,  0,102,  4, 16, 27,209,  0,211,129,208,  0,
/* 0x0200 */ 100,242,102,  6, 16, 27,209,  0,100,234, 87,129,101, 10,225,137,
/* 0x0210 */  18, 27, 70,129,103, 72, 42,  1,208,  0,102,  4, 16, 27,209,  0,
/* 0x0220 */ 215, 67,208,  0,102,  4, 16, 27,209,  0,215, 67, 74, 67,102, 26,
/* 0x0230 */  82, 67,208,  0,102,  4, 16, 27,209,  0,215, 67,208,  0,100,242,
/* 0x0240 */ 102,  6, 16, 27,209,  0,100,234, 84, 67, 69,244, 88,  0, 34,  5,
/* 0x0250 */ 146,134,215, 71, 24,218, 24,218, 81,203,255,252, 96,134, 24,219,
/* 0x0260 */ 208,  0,100,  8,102,248, 16, 27,209,  0,101,242,114,  1,118,  0,
/* 0x0270 */ 208,  0,102,  4, 16, 27,209,  0,211, 65,208,  0,100,  8,102, 22,
/* 0x0280 */  16, 27,209,  0,101, 16, 83, 65,208,  0,102,  4, 16, 27,209,  0,
/* 0x0290 */ 211, 65,106,220, 96, 88, 87, 65,101, 12,225,137, 18, 27, 70,129,
/* 0x02a0 */ 226,129, 42,  1, 96,  8,208,  0,102,  4, 16, 27,209,  0,215, 67,
/* 0x02b0 */ 208,  0,102,  4, 16, 27,209,  0,215, 67, 74, 67,102, 26, 82, 67,
/* 0x02c0 */ 208,  0,102,  4, 16, 27,209,  0,215, 67,208,  0,100,242,102,  6,
/* 0x02d0 */  16, 27,209,  0,100,234, 84, 67, 69,244, 88,  0, 34,  5,146,134,
/* 0x02e0 */ 215, 71, 24,218, 24,218, 81,203,255,252, 96,  0,255,116, 24,219,
/* 0x02f0 */ 208,  0,100,  8,102,248, 16, 27,209,  0,101,242,114,  1,118,  0,
/* 0x0300 */ 208,  0,102,  4, 16, 27,209,  0,211, 65,208,  0,100,  8,102, 22,
/* 0x0310 */  16, 27,209,  0,101, 16, 83, 65,208,  0,102,  4, 16, 27,209,  0,
/* 0x0320 */ 211, 65,106,220, 96, 96, 87, 65,101, 22,225,137, 18, 27, 70,129,
/* 0x0330 */ 226,129,100, 24,208,  0,102,  4, 16, 27,209,  0,215, 67, 96, 48,
/* 0x0340 */  34,  5,208,  0,102,  4, 16, 27,209,  0,101,232, 82, 67,208,  0,
/* 0x0350 */ 102,  4, 16, 27,209,  0,101,220,208,  0,102,  4, 16, 27,209,  0,
/* 0x0360 */ 215, 67,208,  0,100,242,102,  6, 16, 27,209,  0,100,234, 84, 67,
/* 0x0370 */  42,  1, 69,244, 24,  0,146,134,215, 71, 24,218, 24,218, 81,203,
/* 0x0380 */ 255,252, 96,  0,255,108, 24,219,208,  0,102,  4, 16, 27,209,  0,
/* 0x0390 */ 101,244,114,  1,118,  0,208,  0,102,  4, 16, 27,209,  0,211,129,
/* 0x03a0 */ 208,  0,102,  4, 16, 27,209,  0,100,236, 87,129,101, 10,225,137,
/* 0x03b0 */  18, 27, 70,129,103, 70, 42,  1,208,  0,102,  4, 16, 27,209,  0,
/* 0x03c0 */ 215, 67,208,  0,102,  4, 16, 27,209,  0,215, 67, 74, 67,102, 24,
/* 0x03d0 */  82, 67,208,  0,102,  4, 16, 27,209,  0,215, 67,208,  0,102,  4,
/* 0x03e0 */  16, 27,209,  0,100,236, 84, 67, 69,244, 88,  0, 34,  5,146,134,
/* 0x03f0 */ 215, 71, 24,218, 24,218, 81,203,255,252, 96,140, 24,219,208,  0,
/* 0x0400 */ 102,  4, 16, 27,209,  0,101,244,114,  1,118,  0,208,  0,102,  4,
/* 0x0410 */  16, 27,209,  0,211, 65,208,  0,102,  4, 16, 27,209,  0,101, 16,
/* 0x0420 */  83, 65,208,  0,102,  4, 16, 27,209,  0,211, 65,106,222, 96, 86,
/* 0x0430 */  87, 65,101, 12,225,137, 18, 27, 70,129,226,129, 42,  1, 96,  8,
/* 0x0440 */ 208,  0,102,  4, 16, 27,209,  0,215, 67,208,  0,102,  4, 16, 27,
/* 0x0450 */ 209,  0,215, 67, 74, 67,102, 24, 82, 67,208,  0,102,  4, 16, 27,
/* 0x0460 */ 209,  0,215, 67,208,  0,102,  4, 16, 27,209,  0,100,236, 84, 67,
/* 0x0470 */  69,244, 88,  0, 34,  5,146,134,215, 71, 24,218, 24,218, 81,203,
/* 0x0480 */ 255,252, 96,  0,255,122, 24,219,208,  0,102,  4, 16, 27,209,  0,
/* 0x0490 */ 101,244,114,  1,118,  0,208,  0,102,  4, 16, 27,209,  0,211, 65,
/* 0x04a0 */ 208,  0,102,  4, 16, 27,209,  0,101, 16, 83, 65,208,  0,102,  4,
/* 0x04b0 */  16, 27,209,  0,211, 65,106,222, 96, 94, 87, 65,101, 22,225,137,
/* 0x04c0 */  18, 27, 70,129,226,129,100, 24,208,  0,102,  4, 16, 27,209,  0,
/* 0x04d0 */ 215, 67, 96, 46, 34,  5,208,  0,102,  4, 16, 27,209,  0,101,232,
/* 0x04e0 */  82, 67,208,  0,102,  4, 16, 27,209,  0,101,220,208,  0,102,  4,
/* 0x04f0 */  16, 27,209,  0,215, 67,208,  0,102,  4, 16, 27,209,  0,100,236,
/* 0x0500 */  84, 67, 42,  1, 69,244, 24,  0,146,134,215, 71, 24,218, 24,218,
/* 0x0510 */  81,203,255,252, 96,  0,255,114, 46, 15, 79,239,  0,  0, 84,139,
/* 0x0520 */  36, 79, 72, 82, 47, 60,  0,  0,  0,  0, 47,  4, 72,106,  0,  4,
/* 0x0530 */  47, 60,  0,  0,  0,  0, 47, 11, 72,106,  0,  8, 47,  0, 37,124,
/* 0x0540 */   0,  0,  0,  0,  0,  8, 79,239,255,188, 72,231, 63, 58, 32,111,
/* 0x0550 */   0,112, 67,232,  0,  4, 47, 73,  0, 46,114,  0, 18, 40,  0,  2,
/* 0x0560 */ 112,  1, 36,  0,227,170, 34,  2, 83,129, 47, 65,  0, 56,114,  0,
/* 0x0570 */  18, 40,  0,  1,227,168, 83,128, 47, 64,  0, 60,118,  0, 22, 16,
/* 0x0580 */  47, 67,  0, 64, 34,111,  0,124, 66,145, 38,111,  0,136, 66,147,
/* 0x0590 */ 114,  0, 18, 40,  0,  1,210,131, 32, 60,  0,  0,  3,  0,227,168,
/* 0x05a0 */   6,128,  0,  0,  7, 54, 32,111,  0, 46,114,  0, 96,  6, 48,252,
/* 0x05b0 */   4,  0, 82,129,176,129,102,246, 32, 47,  0,116,208,175,  0,120,
/* 0x05c0 */  47, 64,  0, 84, 40,111,  0,116,122,  0,114,  0, 32, 47,  0, 84,
/* 0x05d0 */ 144,175,  0,116,176,129,103,  0,  8, 46,225,141,138, 28, 82,129,
/* 0x05e0 */ 116,  5,180,129,102,230, 66,175,  0, 50, 66, 47,  0, 55, 66,175,
/* 0x05f0 */   0, 68,118,  1, 47, 67,  0,104, 47, 67,  0, 72, 47, 67,  0, 76,
/* 0x0600 */  47, 67,  0, 80,120,255, 96,  0,  7,204, 12,132,  0,255,255,255,
/* 0x0610 */  98, 14,185,239,  0, 84,103,  0,  7,238,225,140,225,141,138, 28,
/* 0x0620 */  44, 47,  0, 50,204,175,  0, 56, 46, 47,  0, 68,233,143, 32,  6,
/* 0x0630 */ 208,135, 32, 64,209,192, 36,111,  0, 46,213,200, 52, 18, 32,  4,
/* 0x0640 */ 114, 11,226,168,118,  0, 54,  2, 47,  3, 47,  0, 97,  0,  0,  0,
/* 0x0650 */  80,143, 32, 64,176,133, 99,  0,  1,166, 32, 60,  0,  0,  8,  0,
/* 0x0660 */ 144,131,234,128,212, 64, 52,130, 34, 47,  0, 50,194,175,  0, 60,
/* 0x0670 */  36, 47,  0, 64,229,169,112,  0, 16, 47,  0, 55,116,  8,148,175,
/* 0x0680 */   0, 64,228,160,210,128, 32,  1,208,129,208,129,118,  9,231,168,
/* 0x0690 */ 208,175,  0, 46,  6,128,  0,  0, 14,108, 47, 64,  0, 96,112,  6,
/* 0x06a0 */ 176,175,  0, 68,109,  8, 40,  8,126,  1, 96,  0,  1, 14, 32, 47,
/* 0x06b0 */   0, 50,144,175,  0,104, 34,111,  0,128, 16, 49,  8,  0,  2,128,
/* 0x06c0 */   0,  0,  0,255, 38, 64, 40,  8,126,  1, 12,132,  0,255,255,255,
/* 0x06d0 */  98, 14,185,239,  0, 84,103,  0,  7, 46,225,140,225,141,138, 28,
/* 0x06e0 */ 215,203, 38, 11,  2,131,  0,  0,  1,  0, 32,  3,208,131,208,175,
/* 0x06f0 */   0, 96, 44, 71,221,199, 65,246,  8,  0, 69,232,  2,  0, 52, 18,
/* 0x0700 */  32,  4,114, 11,226,168,124,  0, 60,  2, 47,  6, 47,  0, 97,  0,
/* 0x0710 */   0,  0, 80,143, 34,  0,176,133, 99, 24, 32, 60,  0,  0,  8,  0,
/* 0x0720 */ 144,134,234,128,212, 64, 52,130, 46, 14, 74,131,102,116, 40,  1,
/* 0x0730 */  96, 24,152,128,154,128, 48,  2,234, 72,148, 64, 52,130, 32, 71,
/* 0x0740 */  65,240,120,  1, 46,  8, 74,131,103,112, 12,135,  0,  0,  0,255,
/* 0x0750 */ 110,104, 96,  0,255,118, 12,132,  0,255,255,255, 98, 14,185,239,
/* 0x0760 */   0, 84,103,  0,  6,162,225,140,225,141,138, 28, 44,  7,220,135,
/* 0x0770 */  36,111,  0, 96,213,198, 52, 18, 32,  4,114, 11,226,168,118,  0,
/* 0x0780 */  54,  2, 47,  3, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133,
/* 0x0790 */  99, 20, 32, 60,  0,  0,  8,  0,144,131,234,128,212, 64, 52,130,
/* 0x07a0 */  46,  6, 40,  1, 96, 20,152,128,154,128, 48,  2,234, 72,148, 64,
/* 0x07b0 */  52,130, 32, 71, 65,240,120,  1, 46,  8, 12,135,  0,  0,  0,255,
/* 0x07c0 */ 111,148, 31, 71,  0, 55, 38,111,  0,128, 34,111,  0, 50, 19,135,
/* 0x07d0 */ 184,  0, 32,  9, 82,128,114,  3,178,175,  0, 68,109,  8, 66,175,
/* 0x07e0 */   0, 68, 96,  0,  5,236,116,  9,180,175,  0, 68,109,  8, 87,175,
/* 0x07f0 */   0, 68, 96,  0,  5,220, 93,175,  0, 68, 96,  0,  5,212, 38,  4,
/* 0x0800 */ 150,128,154,128, 48,  2,234, 72,148, 64, 52,130, 12,131,  0,255,
/* 0x0810 */ 255,255, 98, 14,185,239,  0, 84,103,  0,  5,236,225,139,225,141,
/* 0x0820 */ 138, 28, 32, 47,  0, 68,208,128, 38,111,  0, 46,215,192, 69,235,
/* 0x0830 */   1,128, 52, 18, 32,  3,114, 11,226,168,120,  0, 56,  2, 47,  4,
/* 0x0840 */  47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133, 99, 66, 32, 60,
/* 0x0850 */   0,  0,  8,  0,144,132,234,128,212, 64, 52,130,116,  6,180,175,
/* 0x0860 */   0, 68,109,  6, 66,175,  0, 68, 96,  6,118,  3, 47, 67,  0, 68,
/* 0x0870 */  38,111,  0, 46, 71,235,  6,100, 47,111,  0, 76,  0, 80, 47,111,
/* 0x0880 */   0, 72,  0, 76, 47,111,  0,104,  0, 72, 36,  1, 96,  0,  2,  8,
/* 0x0890 */ 150,128,154,128, 48,  2,234, 72,148, 64, 52,130, 12,131,  0,255,
/* 0x08a0 */ 255,255, 98, 14,185,239,  0, 84,103,  0,  5, 92,225,139,225,141,
/* 0x08b0 */ 138, 28, 69,235,  1,152, 52, 18, 32,  3,114, 11,226,168,120,  0,
/* 0x08c0 */  56,  2, 47,  4, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133,
/* 0x08d0 */  99,  0,  0,190, 32, 60,  0,  0,  8,  0,144,132,234,128,212, 64,
/* 0x08e0 */  52,130, 12,129,  0,255,255,255, 99,  4, 36,  1, 96, 16,185,239,
/* 0x08f0 */   0, 84,103,  0,  5, 18, 36,  1,225,138,225,141,138, 28, 32,  7,
/* 0x0900 */ 208,135,208,175,  0, 46, 34,  6,210,134, 32, 64,209,193, 69,232,
/* 0x0910 */   1,224, 54, 18, 32,  2,114, 11,226,168,120,  0, 56,  3, 47,  4,
/* 0x0920 */  47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133, 99, 82, 32, 60,
/* 0x0930 */   0,  0,  8,  0,144,132,234,128,214, 64, 52,131, 74,175,  0, 50,
/* 0x0940 */ 103,  0,  4,196,116,  6,180,175,  0, 68,109,  8,118,  9, 47, 67,
/* 0x0950 */   0, 68, 96,  6,112, 11, 47, 64,  0, 68, 32, 47,  0, 50,144,175,
/* 0x0960 */   0,104, 32,111,  0,128, 31,112,  8,  0,  0, 55, 34,111,  0, 50,
/* 0x0970 */  19,175,  0, 55,136,  0, 32,  9, 82,128, 40,  1, 96,  0,  4, 82,
/* 0x0980 */ 148,128,154,128, 48,  3,234, 72,150, 64, 52,131, 96,  0,  0,234,
/* 0x0990 */ 150,128,154,128, 48,  2,234, 72,148, 64, 52,130, 12,131,  0,255,
/* 0x09a0 */ 255,255, 98, 14,185,239,  0, 84,103,  0,  4, 92,225,139,225,141,
/* 0x09b0 */ 138, 28, 69,235,  1,176, 52, 18, 32,  3,114, 11,226,168,120,  0,
/* 0x09c0 */  56,  2, 47,  4, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133,
/* 0x09d0 */  99, 20, 32, 60,  0,  0,  8,  0,144,132,234,128,212, 64, 52,130,
/* 0x09e0 */  32, 47,  0, 72, 96, 92, 40,  3,152,128,154,128, 48,  2,234, 72,
/* 0x09f0 */ 148, 64, 52,130, 12,132,  0,255,255,255, 98, 14,185,239,  0, 84,
/* 0x0a00 */ 103,  0,  4,  4,225,140,225,141,138, 28, 69,235,  1,200, 54, 18,
/* 0x0a10 */  32,  4,116, 11,228,168,116,  0, 52,  3, 47,  2, 47,  0, 97,  0,
/* 0x0a20 */   0,  0, 80,143, 34,  0,176,133, 99, 38, 32, 60,  0,  0,  8,  0,
/* 0x0a30 */ 144,130,234,128,214, 64, 52,131, 32, 47,  0, 76, 47,111,  0, 72,
/* 0x0a40 */   0, 76, 47,111,  0,104,  0, 72, 47, 64,  0,104, 36,  1, 96, 40,
/* 0x0a50 */  36,  4,148,128,154,128, 48,  3,234, 72,150, 64, 52,131, 32, 47,
/* 0x0a60 */   0, 80, 47,111,  0, 76,  0, 80, 47,111,  0, 72,  0, 76, 47,111,
/* 0x0a70 */   0,104,  0, 72, 47, 64,  0,104,118,  6,182,175,  0, 68,109,  8,
/* 0x0a80 */ 112,  8, 47, 64,  0, 68, 96,  6,114, 11, 47, 65,  0, 68, 38,111,
/* 0x0a90 */   0, 46, 71,235, 10,104, 12,130,  0,255,255,255, 98, 14,185,239,
/* 0x0aa0 */   0, 84,103,  0,  3, 98,225,138,225,141,138, 28, 54, 19, 32,  2,
/* 0x0ab0 */ 114, 11,226,168,120,  0, 56,  3, 47,  4, 47,  0, 97,  0,  0,  0,
/* 0x0ac0 */  80,143, 34,  0,176,133, 99, 36, 32, 60,  0,  0,  8,  0,144,132,
/* 0x0ad0 */ 234,128,214, 64, 54,131,233,142, 71,243,104,  4, 46, 11, 40,  1,
/* 0x0ae0 */  48,124,  0,  3, 66,175,  0, 88, 96,  0,  0,142, 40,  2,152,128,
/* 0x0af0 */ 154,128, 48,  3,234, 72,150, 64, 54,131, 12,132,  0,255,255,255,
/* 0x0b00 */  98, 14,185,239,  0, 84,103,  0,  2,254,225,140,225,141,138, 28,
/* 0x0b10 */  69,235,  0,  2, 52, 18, 32,  4,118, 11,230,168,118,  0, 54,  2,
/* 0x0b20 */  47,  3, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133, 99, 42,
/* 0x0b30 */  32, 60,  0,  0,  8,  0,144,131,234,128,212, 64, 52,130,233,142,
/* 0x0b40 */  65,243,104,  0, 46,  8,  6,135,  0,  0,  1,  4, 40,  1, 48,124,
/* 0x0b50 */   0,  3,112,  8, 47, 64,  0, 88, 96, 30,152,128,154,128, 48,  2,
/* 0x0b60 */ 234, 72,148, 64, 52,130, 46, 11,  6,135,  0,  0,  2,  4, 48,124,
/* 0x0b70 */   0,  8,114, 16, 47, 65,  0, 88, 44,  8, 54,124,  0,  1, 12,132,
/* 0x0b80 */   0,255,255,255, 98, 14,185,239,  0, 84,103,  0,  2,122,225,140,
/* 0x0b90 */ 225,141,138, 28, 77,243,184,  0, 69,246,120,  0, 52, 18, 32,  4,
/* 0x0ba0 */ 118, 11,230,168,118,  0, 54,  2, 47,  3, 47,  0, 47, 72,  0, 50,
/* 0x0bb0 */  97,  0,  0,  0, 80,143, 34,  0, 32,111,  0, 42,176,133, 99, 20,
/* 0x0bc0 */  32, 60,  0,  0,  8,  0,144,131,234,128,212, 64, 52,130, 38, 78,
/* 0x0bd0 */  40,  1, 96, 16,152,128,154,128, 48,  2,234, 72,148, 64, 52,130,
/* 0x0be0 */  71,243,184,  1, 83,134,102,150,112,  1, 34,  8,227,168,151,192,
/* 0x0bf0 */ 215,239,  0, 88, 47, 75,  0,100,116,  3,180,175,  0, 68,109,  0,
/* 0x0c00 */   1,138, 32, 11,180,139,108,  2,112,  3,239,136,208,175,  0, 46,
/* 0x0c10 */  46,  0,  6,135,  0,  0,  3, 96, 54,124,  0,  1,124,  6, 12,132,
/* 0x0c20 */   0,255,255,255, 98, 14,185,239,  0, 84,103,  0,  1,218,225,140,
/* 0x0c30 */ 225,141,138, 28, 77,243,184,  0, 69,246,120,  0, 52, 18, 32,  4,
/* 0x0c40 */ 118, 11,230,168,118,  0, 54,  2, 47,  3, 47,  0, 97,  0,  0,  0,
/* 0x0c50 */  80,143, 34,  0,176,133, 99, 20, 32, 60,  0,  0,  8,  0,144,131,
/* 0x0c60 */ 234,128,212, 64, 52,130, 38, 78, 40,  1, 96, 16,152,128,154,128,
/* 0x0c70 */  48,  2,234, 72,148, 64, 52,130, 71,243,184,  1, 83,134,102,158,
/* 0x0c80 */ 114,192,210,139,112,  3,176,129,108,  0,  0,242, 36,  1,226,130,
/* 0x0c90 */  46,  2, 83,135, 16, 60,  0,  1,192,129,118,  2,128,131, 22, 60,
/* 0x0ca0 */   0, 13,182,129,109, 28, 38,  0,239,171, 32,  3,208,131,208,175,
/* 0x0cb0 */   0, 46,210,129,144,129,  6,128,  0,  0,  5, 94, 47, 64,  0, 92,
/* 0x0cc0 */  96, 62, 34,  2, 91,129, 12,132,  0,255,255,255, 98, 14,185,239,
/* 0x0cd0 */   0, 84,103,  0,  1, 50,225,140,225,141,138, 28,226,140,208,128,
/* 0x0ce0 */ 184,133, 98,  6,154,132,116,  1,128,130, 83,129,102,216, 32,111,
/* 0x0cf0 */   0, 46, 65,232,  6, 68, 47, 72,  0, 92, 38,  0,233,139,126,  4,
/* 0x0d00 */  48,124,  0,  1, 54,124,  0,  1, 12,132,  0,255,255,255, 98, 14,
/* 0x0d10 */ 185,239,  0, 84,103,  0,  0,240,225,140,225,141,138, 28, 77,243,
/* 0x0d20 */ 184,  0, 36,111,  0, 92,213,206, 52, 18, 32,  4,114, 11,226,168,
/* 0x0d30 */ 124,  0, 60,  2, 47,  6, 47,  0, 47, 72,  0, 50, 97,  0,  0,  0,
/* 0x0d40 */  80,143, 34,  0, 32,111,  0, 42,176,133, 99, 20, 32, 60,  0,  0,
/* 0x0d50 */   8,  0,144,134,234,128,212, 64, 52,130, 38, 78, 40,  1, 96, 20,
/* 0x0d60 */ 152,128,154,128, 48,  2,234, 72,148, 64, 52,130, 71,243,184,  1,
/* 0x0d70 */  36,  8,134,130, 83,135,103,  6,209,200, 96,140, 38,  1, 82,131,
/* 0x0d80 */  47, 67,  0,104,103, 90, 94,175,  0, 68, 38, 47,  0,104,182,175,
/* 0x0d90 */   0, 50, 98,114, 32, 47,  0, 50,144,131, 36,111,  0,128,213,192,
/* 0x0da0 */  34,111,  0,128,211,239,  0, 50, 32, 47,  0, 50, 31, 82,  0, 55,
/* 0x0db0 */  18,175,  0, 55, 82,128, 34, 47,  0, 50, 38,111,  0,100, 65,243,
/* 0x0dc0 */  24,  2,177,192,103, 10, 82,138, 82,137,176,175,  0,132,102,220,
/* 0x0dd0 */  47, 64,  0, 50, 36, 47,  0, 50,180,175,  0,132,101,  0,248, 44,
/* 0x0de0 */  12,132,  0,255,255,255, 98,  8,185,239,  0, 84,103, 24, 82,140,
/* 0x0df0 */ 153,239,  0,116, 32,111,  0,124, 32,140, 34,111,  0,136, 34,175,
/* 0x0e00 */   0, 50,112,  0, 96,  2,112,  1, 76,223, 92,252, 79,239,  0, 68,
/* 0x0e10 */  79,239,255,188, 72,231, 63, 58, 32,111,  0,112, 67,232,  0,  4,
/* 0x0e20 */  47, 73,  0, 46,114,  0, 18, 40,  0,  2,112,  1, 36,  0,227,170,
/* 0x0e30 */  34,  2, 83,129, 47, 65,  0, 56,114,  0, 18, 40,  0,  1,227,168,
/* 0x0e40 */  83,128, 47, 64,  0, 60,118,  0, 22, 16, 47, 67,  0, 64, 34,111,
/* 0x0e50 */   0,124, 66,145, 38,111,  0,136, 66,147,114,  0, 18, 40,  0,  1,
/* 0x0e60 */ 210,131, 32, 60,  0,  0,  3,  0,227,168,  6,128,  0,  0,  7, 54,
/* 0x0e70 */  32,111,  0, 46,114,  0, 96,  6, 48,252,  4,  0, 82,129,176,129,
/* 0x0e80 */ 102,246, 32, 47,  0,116,208,175,  0,120, 47, 64,  0, 84, 40,111,
/* 0x0e90 */   0,116,122,  0,114,  0, 32, 47,  0, 84,144,175,  0,116,176,129,
/* 0x0ea0 */ 103,  0,  8, 46,225,141,138, 28, 82,129,116,  5,180,129,102,230,
/* 0x0eb0 */  66,175,  0, 50, 66, 47,  0, 55, 66,175,  0, 68,118,  1, 47, 67,
/* 0x0ec0 */   0,104, 47, 67,  0, 72, 47, 67,  0, 76, 47, 67,  0, 80,120,255,
/* 0x0ed0 */  96,  0,  7,204, 12,132,  0,255,255,255, 98, 14,185,239,  0, 84,
/* 0x0ee0 */ 103,  0,  7,238,225,140,225,141,138, 28, 44, 47,  0, 50,204,175,
/* 0x0ef0 */   0, 56, 46, 47,  0, 68,233,143, 32,  6,208,135, 32, 64,209,192,
/* 0x0f00 */  36,111,  0, 46,213,200, 52, 18, 32,  4,114, 11,226,168,118,  0,
/* 0x0f10 */  54,  2, 47,  3, 47,  0, 97,  0,  0,  0, 80,143, 32, 64,176,133,
/* 0x0f20 */  99,  0,  1,166, 32, 60,  0,  0,  8,  0,144,131,234,128,212, 64,
/* 0x0f30 */  52,130, 34, 47,  0, 50,194,175,  0, 60, 36, 47,  0, 64,229,169,
/* 0x0f40 */ 112,  0, 16, 47,  0, 55,116,  8,148,175,  0, 64,228,160,210,128,
/* 0x0f50 */  32,  1,208,129,208,129,118,  9,231,168,208,175,  0, 46,  6,128,
/* 0x0f60 */   0,  0, 14,108, 47, 64,  0, 96,112,  6,176,175,  0, 68,109,  8,
/* 0x0f70 */  40,  8,126,  1, 96,  0,  1, 14, 32, 47,  0, 50,144,175,  0,104,
/* 0x0f80 */  34,111,  0,128, 16, 49,  8,  0,  2,128,  0,  0,  0,255, 38, 64,
/* 0x0f90 */  40,  8,126,  1, 12,132,  0,255,255,255, 98, 14,185,239,  0, 84,
/* 0x0fa0 */ 103,  0,  7, 46,225,140,225,141,138, 28,215,203, 38, 11,  2,131,
/* 0x0fb0 */   0,  0,  1,  0, 32,  3,208,131,208,175,  0, 96, 44, 71,221,199,
/* 0x0fc0 */  65,246,  8,  0, 69,232,  2,  0, 52, 18, 32,  4,114, 11,226,168,
/* 0x0fd0 */ 124,  0, 60,  2, 47,  6, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,
/* 0x0fe0 */ 176,133, 99, 24, 32, 60,  0,  0,  8,  0,144,134,234,128,212, 64,
/* 0x0ff0 */  52,130, 46, 14, 74,131,102,116, 40,  1, 96, 24,152,128,154,128,
/* 0x1000 */  48,  2,234, 72,148, 64, 52,130, 32, 71, 65,240,120,  1, 46,  8,
/* 0x1010 */  74,131,103,112, 12,135,  0,  0,  0,255,110,104, 96,  0,255,118,
/* 0x1020 */  12,132,  0,255,255,255, 98, 14,185,239,  0, 84,103,  0,  6,162,
/* 0x1030 */ 225,140,225,141,138, 28, 44,  7,220,135, 36,111,  0, 96,213,198,
/* 0x1040 */  52, 18, 32,  4,114, 11,226,168,118,  0, 54,  2, 47,  3, 47,  0,
/* 0x1050 */  97,  0,  0,  0, 80,143, 34,  0,176,133, 99, 20, 32, 60,  0,  0,
/* 0x1060 */   8,  0,144,131,234,128,212, 64, 52,130, 46,  6, 40,  1, 96, 20,
/* 0x1070 */ 152,128,154,128, 48,  2,234, 72,148, 64, 52,130, 32, 71, 65,240,
/* 0x1080 */ 120,  1, 46,  8, 12,135,  0,  0,  0,255,111,148, 31, 71,  0, 55,
/* 0x1090 */  38,111,  0,128, 34,111,  0, 50, 19,135,184,  0, 32,  9, 82,128,
/* 0x10a0 */ 114,  3,178,175,  0, 68,109,  8, 66,175,  0, 68, 96,  0,  5,236,
/* 0x10b0 */ 116,  9,180,175,  0, 68,109,  8, 87,175,  0, 68, 96,  0,  5,220,
/* 0x10c0 */  93,175,  0, 68, 96,  0,  5,212, 38,  4,150,128,154,128, 48,  2,
/* 0x10d0 */ 234, 72,148, 64, 52,130, 12,131,  0,255,255,255, 98, 14,185,239,
/* 0x10e0 */   0, 84,103,  0,  5,236,225,139,225,141,138, 28, 32, 47,  0, 68,
/* 0x10f0 */ 208,128, 38,111,  0, 46,215,192, 69,235,  1,128, 52, 18, 32,  3,
/* 0x1100 */ 114, 11,226,168,120,  0, 56,  2, 47,  4, 47,  0, 97,  0,  0,  0,
/* 0x1110 */  80,143, 34,  0,176,133, 99, 66, 32, 60,  0,  0,  8,  0,144,132,
/* 0x1120 */ 234,128,212, 64, 52,130,116,  6,180,175,  0, 68,109,  6, 66,175,
/* 0x1130 */   0, 68, 96,  6,118,  3, 47, 67,  0, 68, 38,111,  0, 46, 71,235,
/* 0x1140 */   6,100, 47,111,  0, 76,  0, 80, 47,111,  0, 72,  0, 76, 47,111,
/* 0x1150 */   0,104,  0, 72, 36,  1, 96,  0,  2,  8,150,128,154,128, 48,  2,
/* 0x1160 */ 234, 72,148, 64, 52,130, 12,131,  0,255,255,255, 98, 14,185,239,
/* 0x1170 */   0, 84,103,  0,  5, 92,225,139,225,141,138, 28, 69,235,  1,152,
/* 0x1180 */  52, 18, 32,  3,114, 11,226,168,120,  0, 56,  2, 47,  4, 47,  0,
/* 0x1190 */  97,  0,  0,  0, 80,143, 34,  0,176,133, 99,  0,  0,190, 32, 60,
/* 0x11a0 */   0,  0,  8,  0,144,132,234,128,212, 64, 52,130, 12,129,  0,255,
/* 0x11b0 */ 255,255, 99,  4, 36,  1, 96, 16,185,239,  0, 84,103,  0,  5, 18,
/* 0x11c0 */  36,  1,225,138,225,141,138, 28, 32,  7,208,135,208,175,  0, 46,
/* 0x11d0 */  34,  6,210,134, 32, 64,209,193, 69,232,  1,224, 54, 18, 32,  2,
/* 0x11e0 */ 114, 11,226,168,120,  0, 56,  3, 47,  4, 47,  0, 97,  0,  0,  0,
/* 0x11f0 */  80,143, 34,  0,176,133, 99, 82, 32, 60,  0,  0,  8,  0,144,132,
/* 0x1200 */ 234,128,214, 64, 52,131, 74,175,  0, 50,103,  0,  4,196,116,  6,
/* 0x1210 */ 180,175,  0, 68,109,  8,118,  9, 47, 67,  0, 68, 96,  6,112, 11,
/* 0x1220 */  47, 64,  0, 68, 32, 47,  0, 50,144,175,  0,104, 32,111,  0,128,
/* 0x1230 */  31,112,  8,  0,  0, 55, 34,111,  0, 50, 19,175,  0, 55,136,  0,
/* 0x1240 */  32,  9, 82,128, 40,  1, 96,  0,  4, 82,148,128,154,128, 48,  3,
/* 0x1250 */ 234, 72,150, 64, 52,131, 96,  0,  0,234,150,128,154,128, 48,  2,
/* 0x1260 */ 234, 72,148, 64, 52,130, 12,131,  0,255,255,255, 98, 14,185,239,
/* 0x1270 */   0, 84,103,  0,  4, 92,225,139,225,141,138, 28, 69,235,  1,176,
/* 0x1280 */  52, 18, 32,  3,114, 11,226,168,120,  0, 56,  2, 47,  4, 47,  0,
/* 0x1290 */  97,  0,  0,  0, 80,143, 34,  0,176,133, 99, 20, 32, 60,  0,  0,
/* 0x12a0 */   8,  0,144,132,234,128,212, 64, 52,130, 32, 47,  0, 72, 96, 92,
/* 0x12b0 */  40,  3,152,128,154,128, 48,  2,234, 72,148, 64, 52,130, 12,132,
/* 0x12c0 */   0,255,255,255, 98, 14,185,239,  0, 84,103,  0,  4,  4,225,140,
/* 0x12d0 */ 225,141,138, 28, 69,235,  1,200, 54, 18, 32,  4,116, 11,228,168,
/* 0x12e0 */ 116,  0, 52,  3, 47,  2, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,
/* 0x12f0 */ 176,133, 99, 38, 32, 60,  0,  0,  8,  0,144,130,234,128,214, 64,
/* 0x1300 */  52,131, 32, 47,  0, 76, 47,111,  0, 72,  0, 76, 47,111,  0,104,
/* 0x1310 */   0, 72, 47, 64,  0,104, 36,  1, 96, 40, 36,  4,148,128,154,128,
/* 0x1320 */  48,  3,234, 72,150, 64, 52,131, 32, 47,  0, 80, 47,111,  0, 76,
/* 0x1330 */   0, 80, 47,111,  0, 72,  0, 76, 47,111,  0,104,  0, 72, 47, 64,
/* 0x1340 */   0,104,118,  6,182,175,  0, 68,109,  8,112,  8, 47, 64,  0, 68,
/* 0x1350 */  96,  6,114, 11, 47, 65,  0, 68, 38,111,  0, 46, 71,235, 10,104,
/* 0x1360 */  12,130,  0,255,255,255, 98, 14,185,239,  0, 84,103,  0,  3, 98,
/* 0x1370 */ 225,138,225,141,138, 28, 54, 19, 32,  2,114, 11,226,168,120,  0,
/* 0x1380 */  56,  3, 47,  4, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133,
/* 0x1390 */  99, 36, 32, 60,  0,  0,  8,  0,144,132,234,128,214, 64, 54,131,
/* 0x13a0 */ 233,142, 71,243,104,  4, 46, 11, 40,  1, 48,124,  0,  3, 66,175,
/* 0x13b0 */   0, 88, 96,  0,  0,142, 40,  2,152,128,154,128, 48,  3,234, 72,
/* 0x13c0 */ 150, 64, 54,131, 12,132,  0,255,255,255, 98, 14,185,239,  0, 84,
/* 0x13d0 */ 103,  0,  2,254,225,140,225,141,138, 28, 69,235,  0,  2, 52, 18,
/* 0x13e0 */  32,  4,118, 11,230,168,118,  0, 54,  2, 47,  3, 47,  0, 97,  0,
/* 0x13f0 */   0,  0, 80,143, 34,  0,176,133, 99, 42, 32, 60,  0,  0,  8,  0,
/* 0x1400 */ 144,131,234,128,212, 64, 52,130,233,142, 65,243,104,  0, 46,  8,
/* 0x1410 */   6,135,  0,  0,  1,  4, 40,  1, 48,124,  0,  3,112,  8, 47, 64,
/* 0x1420 */   0, 88, 96, 30,152,128,154,128, 48,  2,234, 72,148, 64, 52,130,
/* 0x1430 */  46, 11,  6,135,  0,  0,  2,  4, 48,124,  0,  8,114, 16, 47, 65,
/* 0x1440 */   0, 88, 44,  8, 54,124,  0,  1, 12,132,  0,255,255,255, 98, 14,
/* 0x1450 */ 185,239,  0, 84,103,  0,  2,122,225,140,225,141,138, 28, 77,243,
/* 0x1460 */ 184,  0, 69,246,120,  0, 52, 18, 32,  4,118, 11,230,168,118,  0,
/* 0x1470 */  54,  2, 47,  3, 47,  0, 47, 72,  0, 50, 97,  0,  0,  0, 80,143,
/* 0x1480 */  34,  0, 32,111,  0, 42,176,133, 99, 20, 32, 60,  0,  0,  8,  0,
/* 0x1490 */ 144,131,234,128,212, 64, 52,130, 38, 78, 40,  1, 96, 16,152,128,
/* 0x14a0 */ 154,128, 48,  2,234, 72,148, 64, 52,130, 71,243,184,  1, 83,134,
/* 0x14b0 */ 102,150,112,  1, 34,  8,227,168,151,192,215,239,  0, 88, 47, 75,
/* 0x14c0 */   0,100,116,  3,180,175,  0, 68,109,  0,  1,138, 32, 11,180,139,
/* 0x14d0 */ 108,  2,112,  3,239,136,208,175,  0, 46, 46,  0,  6,135,  0,  0,
/* 0x14e0 */   3, 96, 54,124,  0,  1,124,  6, 12,132,  0,255,255,255, 98, 14,
/* 0x14f0 */ 185,239,  0, 84,103,  0,  1,218,225,140,225,141,138, 28, 77,243,
/* 0x1500 */ 184,  0, 69,246,120,  0, 52, 18, 32,  4,118, 11,230,168,118,  0,
/* 0x1510 */  54,  2, 47,  3, 47,  0, 97,  0,  0,  0, 80,143, 34,  0,176,133,
/* 0x1520 */  99, 20, 32, 60,  0,  0,  8,  0,144,131,234,128,212, 64, 52,130,
/* 0x1530 */  38, 78, 40,  1, 96, 16,152,128,154,128, 48,  2,234, 72,148, 64,
/* 0x1540 */  52,130, 71,243,184,  1, 83,134,102,158,114,192,210,139,112,  3,
/* 0x1550 */ 176,129,108,  0,  0,242, 36,  1,226,130, 46,  2, 83,135, 16, 60,
/* 0x1560 */   0,  1,192,129,118,  2,128,131, 22, 60,  0, 13,182,129,109, 28,
/* 0x1570 */  38,  0,239,171, 32,  3,208,131,208,175,  0, 46,210,129,144,129,
/* 0x1580 */   6,128,  0,  0,  5, 94, 47, 64,  0, 92, 96, 62, 34,  2, 91,129,
/* 0x1590 */  12,132,  0,255,255,255, 98, 14,185,239,  0, 84,103,  0,  1, 50,
/* 0x15a0 */ 225,140,225,141,138, 28,226,140,208,128,184,133, 98,  6,154,132,
/* 0x15b0 */ 116,  1,128,130, 83,129,102,216, 32,111,  0, 46, 65,232,  6, 68,
/* 0x15c0 */  47, 72,  0, 92, 38,  0,233,139,126,  4, 48,124,  0,  1, 54,124,
/* 0x15d0 */   0,  1, 12,132,  0,255,255,255, 98, 14,185,239,  0, 84,103,  0,
/* 0x15e0 */   0,240,225,140,225,141,138, 28, 77,243,184,  0, 36,111,  0, 92,
/* 0x15f0 */ 213,206, 52, 18, 32,  4,114, 11,226,168,124,  0, 60,  2, 47,  6,
/* 0x1600 */  47,  0, 47, 72,  0, 50, 97,  0,  0,  0, 80,143, 34,  0, 32,111,
/* 0x1610 */   0, 42,176,133, 99, 20, 32, 60,  0,  0,  8,  0,144,134,234,128,
/* 0x1620 */ 212, 64, 52,130, 38, 78, 40,  1, 96, 20,152,128,154,128, 48,  2,
/* 0x1630 */ 234, 72,148, 64, 52,130, 71,243,184,  1, 36,  8,134,130, 83,135,
/* 0x1640 */ 103,  6,209,200, 96,140, 38,  1, 82,131, 47, 67,  0,104,103, 90,
/* 0x1650 */  94,175,  0, 68, 38, 47,  0,104,182,175,  0, 50, 98,114, 32, 47,
/* 0x1660 */   0, 50,144,131, 36,111,  0,128,213,192, 34,111,  0,128,211,239,
/* 0x1670 */   0, 50, 32, 47,  0, 50, 31, 82,  0, 55, 18,175,  0, 55, 82,128,
/* 0x1680 */  34, 47,  0, 50, 38,111,  0,100, 65,243, 24,  2,177,192,103, 10,
/* 0x1690 */  82,138, 82,137,176,175,  0,132,102,220, 47, 64,  0, 50, 36, 47,
/* 0x16a0 */   0, 50,180,175,  0,132,101,  0,248, 44, 12,132,  0,255,255,255,
/* 0x16b0 */  98,  8,185,239,  0, 84,103, 24, 82,140,153,239,  0,116, 32,111,
/* 0x16c0 */   0,124, 32,140, 34,111,  0,136, 34,175,  0, 50,112,  0, 96,  2,
/* 0x16d0 */ 112,  1, 76,223, 92,252, 79,239,  0, 68,118,  0, 79,234,255, 96,
/* 0x16e0 */  46,195, 46,195, 46,195, 46,195,190,143,102,244, 32, 78,114,  1,
/* 0x16f0 */  34, 68,211,216,211,195,217,145, 22, 24,103, 10,182,  1,102,244,
/* 0x1700 */  67,233,  0,254, 96,242,124,  0, 60, 60,  0,  0, 44, 60,  0,  0,
/* 0x1710 */   0,  0, 78,215, 65,239,  0,  4, 50, 24, 48, 24,192,216,194,208,
/* 0x1720 */ 208, 65, 72, 64, 66, 64, 50, 47,  0,  6,194,208,208,129, 78,117,
/* 0x1730 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x1740 */  50, 45,109, 54, 56,107, 10, 10, 83,101, 99,116,105,111,110,115,
/* 0x1750 */  58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32,
/* 0x1760 */  32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77,
/* 0x1770 */  65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32,
/* 0x1780 */  32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110,
/* 0x1790 */  32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32,101,110,116,114,
/* 0x17a0 */ 121, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x17b0 */  51, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x17c0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52,
/* 0x17d0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x17e0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x17f0 */  89, 10, 32, 32, 49, 32,115,101,116, 95,117,112, 50, 49, 95, 97,
/* 0x1800 */  54, 46,119, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48,
/* 0x1810 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1820 */  32, 32, 48, 48, 48, 48, 48, 48, 54, 97, 32, 32, 50, 42, 42, 48,
/* 0x1830 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1840 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32,
/* 0x1850 */ 115,101,116, 95,117,112, 50, 49, 95,100, 52, 46,119, 32, 48, 48,
/* 0x1860 */  48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1870 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1880 */  48, 48, 54,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1890 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x18a0 */  68, 79, 78, 76, 89, 10, 32, 32, 51, 32,115,101,116, 95,117,112,
/* 0x18b0 */  50, 49, 95,100, 52, 46,108, 32, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x18c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x18d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 52, 32, 32,
/* 0x18e0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x18f0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1900 */  32, 32, 52, 32,108,111,111,112, 49, 95,115,101,116, 95, 99,111,
/* 0x1910 */ 117,110,116, 46, 98, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x1920 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1930 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 99, 32, 32, 50, 42,
/* 0x1940 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1950 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1960 */  53, 32,108,111,111,112, 49, 95,115,101,116, 95, 99,111,117,110,
/* 0x1970 */ 116, 46,119, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48,
/* 0x1980 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1990 */  32, 32, 48, 48, 48, 48, 48, 48, 55,101, 32, 32, 50, 42, 42, 48,
/* 0x19a0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x19b0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32,
/* 0x19c0 */ 108,111,111,112, 49, 95,115,101,116, 95, 99,111,117,110,116, 46,
/* 0x19d0 */ 108, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,
/* 0x19e0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x19f0 */  48, 48, 48, 48, 48, 48, 56, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a00 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1a10 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32,108,111,
/* 0x1a20 */ 111,112, 49, 95,108, 97, 98,101,108, 32, 32, 32, 48, 48, 48, 48,
/* 0x1a30 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1a40 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1a50 */  56, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1a60 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56,
/* 0x1a70 */  32,108,111,111,112, 49, 46,102, 97,115,116, 32, 32, 32, 32, 48,
/* 0x1a80 */  48, 48, 48, 48, 48, 50, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a90 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1aa0 */  48, 48, 48, 56, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ab0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1ac0 */  32, 32, 57, 32,108,111,111,112, 49, 46,115,109, 97,108,108, 32,
/* 0x1ad0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,
/* 0x1ae0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1af0 */  48, 48, 48, 48, 48, 48, 98, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1b00 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1b10 */  76, 89, 10, 32, 49, 48, 32,108,111,111,112, 49, 95,115,117, 98,
/* 0x1b20 */ 113,108, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b40 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 52, 32, 32, 50, 42, 42,
/* 0x1b50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1b60 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49,
/* 0x1b70 */  32,108,111,111,112, 49, 95,115,117, 98,113,119, 32, 32, 32, 48,
/* 0x1b80 */  48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b90 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1ba0 */  48, 48, 48, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1bb0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1bc0 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32,108,111,111,112, 49,
/* 0x1bd0 */  95,100, 98,114, 97, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1be0 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1bf0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 99, 32,
/* 0x1c00 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1c10 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1c20 */  10, 32, 49, 51, 32,108,111,111,112, 50, 46,102, 97,115,116, 32,
/* 0x1c30 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48,
/* 0x1c40 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c50 */  32, 48, 48, 48, 48, 48, 48, 99, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x1c60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1c70 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32,108,
/* 0x1c80 */ 111,111,112, 50, 46,115,109, 97,108,108, 32, 32, 32, 48, 48, 48,
/* 0x1c90 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ca0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1cb0 */  48, 99, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1cc0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x1cd0 */  53, 32, 99,111,112,121, 95,116,111, 95,115,116, 97, 99,107, 32,
/* 0x1ce0 */  48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1d00 */  48, 48, 48, 48, 99, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1d10 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1d20 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 54, 32,110,114,118, 50,
/* 0x1d30 */  98, 46,105,110,105,116, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d40 */  48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1d50 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100,101,
/* 0x1d60 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1d70 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 55, 32,110,
/* 0x1d80 */ 114,118, 50,100, 46,105,110,105,116, 32, 32, 32, 32, 48, 48, 48,
/* 0x1d90 */  48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1da0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1db0 */  48,101, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1dc0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x1dd0 */  56, 32,110,114,118, 50,101, 46,105,110,105,116, 32, 32, 32, 32,
/* 0x1de0 */  48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1df0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1e00 */  48, 48, 48, 48,102, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1e10 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1e20 */  10, 32, 49, 57, 32,106,109,112, 95,100,101, 99,111,109,112,114,
/* 0x1e30 */ 101,115,115,111,114, 95, 97, 54, 46,119, 32, 48, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1e50 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102,
/* 0x1e60 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1e70 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1e80 */  76, 89, 10, 32, 50, 48, 32,106,109,112, 95,100,101, 99,111,109,
/* 0x1e90 */ 112,114,101,115,115,111,114, 95,100, 52, 46,119, 32, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1eb0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ec0 */  49, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1ed0 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1ee0 */  79, 78, 76, 89, 10, 32, 50, 49, 32,106,109,112, 95,100,101, 99,
/* 0x1ef0 */ 111,109,112,114,101,115,115,111,114, 95, 97, 54, 46,119, 50, 32,
/* 0x1f00 */  48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1f10 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1f20 */  48, 48, 48, 49, 48, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1f30 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1f40 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32,106,109,112, 95,
/* 0x1f50 */ 100,101, 99,111,109,112,114,101,115,115,111,114, 95,100, 52, 46,
/* 0x1f60 */ 108, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48,
/* 0x1f70 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1f80 */  48, 48, 48, 48, 48, 49, 48,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1f90 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1fa0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 99,111,
/* 0x1fb0 */ 100,101, 95,111,110, 95,115,116, 97, 99,107, 32, 48, 48, 48, 48,
/* 0x1fc0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1fd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x1fe0 */  49, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1ff0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 52,
/* 0x2000 */  32, 99,108,101, 97,114, 95,100,105,114,116,121, 95, 98,115,115,
/* 0x2010 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2030 */  48, 48, 48, 48, 49, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2040 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2050 */  89, 10, 32, 50, 53, 32,108,111,111,112, 51, 95,108, 97, 98,101,
/* 0x2060 */ 108, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2070 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2080 */  32, 32, 48, 48, 48, 48, 48, 49, 49, 56, 32, 32, 50, 42, 42, 48,
/* 0x2090 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x20a0 */  79, 78, 76, 89, 10, 32, 50, 54, 32,108,111,111,112, 51, 46,115,
/* 0x20b0 */ 109, 97,108,108, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x20c0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 56, 32, 32, 50,
/* 0x20e0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x20f0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32,108,111,111,112,
/* 0x2100 */  51, 46,102, 97,115,116, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2110 */  48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2120 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 97,
/* 0x2130 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2140 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32,108,
/* 0x2150 */ 111,111,112, 51, 95,115,117, 98,113,108, 32, 32, 32, 48, 48, 48,
/* 0x2160 */  48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2170 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2180 */  49, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2190 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x21a0 */  79, 78, 76, 89, 10, 32, 50, 57, 32,108,111,111,112, 51, 95,115,
/* 0x21b0 */ 117, 98,113,119, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x21c0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x21d0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50, 54, 32, 32, 50,
/* 0x21e0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x21f0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2200 */  51, 48, 32,108,111,111,112, 51, 95,100, 98,114, 97, 32, 32, 32,
/* 0x2210 */  32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2230 */  48, 48, 48, 48, 49, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2240 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2250 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49, 32,102,108,117,
/* 0x2260 */ 115,104, 95, 99, 97, 99,104,101, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2270 */  48, 55, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50,
/* 0x2290 */ 101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x22a0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 50, 32,
/* 0x22b0 */ 114,101,115,116,111,114,101, 95,115,116, 97, 99,107, 32, 48, 48,
/* 0x22c0 */  48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22d0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x22e0 */  48, 49, 97, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x22f0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2300 */  68, 79, 78, 76, 89, 10, 32, 51, 51, 32, 99,108,101, 97,114, 95,
/* 0x2310 */ 100,105,114,116,121, 95,115,116, 97, 99,107, 32, 48, 48, 48, 48,
/* 0x2320 */  48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2330 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x2340 */  97, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2350 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2360 */  78, 76, 89, 10, 32, 51, 52, 32,115,116, 97,114,116, 95,112,114,
/* 0x2370 */ 111,103,114, 97,109, 32, 48, 48, 48, 48, 48, 48, 48, 99, 32, 32,
/* 0x2380 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2390 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 98, 54, 32, 32, 50, 42,
/* 0x23a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x23b0 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 53, 32, 85, 80, 88, 49, 72,
/* 0x23c0 */  69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50,
/* 0x23d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x23e0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 99, 50, 32,
/* 0x23f0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2400 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 54, 32, 67, 85,
/* 0x2410 */  84, 80, 79, 73, 78, 84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2420 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2430 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x2440 */ 101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2450 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55,
/* 0x2460 */  32,110,114,118, 50, 98, 95, 56, 46,102, 97,115,116, 32, 32, 48,
/* 0x2470 */  48, 48, 48, 48, 48, 55, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2480 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2490 */  48, 48, 49,101, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x24a0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x24b0 */  32, 51, 56, 32,110,114,118, 50,100, 95, 56, 46,102, 97,115,116,
/* 0x24c0 */  32, 32, 48, 48, 48, 48, 48, 48, 57, 48, 32, 32, 48, 48, 48, 48,
/* 0x24d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x24e0 */  48, 48, 48, 48, 48, 50, 53,101, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x24f0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2500 */  76, 89, 10, 32, 51, 57, 32,110,114,118, 50,101, 95, 56, 46,102,
/* 0x2510 */  97,115,116, 32, 32, 48, 48, 48, 48, 48, 48, 57, 56, 32, 32, 48,
/* 0x2520 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2530 */  48, 32, 32, 48, 48, 48, 48, 48, 50,101,101, 32, 32, 50, 42, 42,
/* 0x2540 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2550 */  68, 79, 78, 76, 89, 10, 32, 52, 48, 32,110,114,118, 50, 98, 95,
/* 0x2560 */  56, 46,115,109, 97,108,108, 32, 48, 48, 48, 48, 48, 48, 55, 54,
/* 0x2570 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2580 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 56, 54, 32, 32,
/* 0x2590 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x25a0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32,110,114,118,
/* 0x25b0 */  50,100, 95, 56, 46,115,109, 97,108,108, 32, 48, 48, 48, 48, 48,
/* 0x25c0 */  48, 56, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x25d0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51,102,
/* 0x25e0 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x25f0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 50, 32,
/* 0x2600 */ 110,114,118, 50,101, 95, 56, 46,115,109, 97,108,108, 32, 48, 48,
/* 0x2610 */  48, 48, 48, 48, 57, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2620 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2630 */  48, 52, 56, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2640 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2650 */  52, 51, 32,108,122,109, 97, 46,105,110,105,116, 32, 32, 32, 32,
/* 0x2660 */  32, 48, 48, 48, 48, 48, 48, 50,101, 32, 32, 48, 48, 48, 48, 48,
/* 0x2670 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2680 */  48, 48, 48, 48, 53, 49, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2690 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x26a0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32,108,122,109,
/* 0x26b0 */  97, 46,102, 97,115,116, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x26c0 */  56, 99, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x26d0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 53, 52,
/* 0x26e0 */  54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x26f0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2700 */  76, 89, 10, 32, 52, 53, 32,108,122,109, 97, 46,115,109, 97,108,
/* 0x2710 */ 108, 32, 32, 32, 32, 48, 48, 48, 48, 48, 56, 99, 97, 32, 32, 48,
/* 0x2720 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2730 */  48, 32, 32, 48, 48, 48, 48, 48,101, 49, 48, 32, 32, 50, 42, 42,
/* 0x2740 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2750 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 54,
/* 0x2760 */  32,108,122,109, 97, 46,102,105,110,105,115,104, 32, 32, 32, 48,
/* 0x2770 */  48, 48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2780 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2790 */  48, 49, 54,100, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x27a0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x27b0 */  32, 52, 55, 32,114,101,108,111, 99, 32, 32, 32, 32, 32, 32, 32,
/* 0x27c0 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 97, 32, 32, 48, 48, 48, 48,
/* 0x27d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x27e0 */  48, 48, 48, 48, 49, 54,101, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x27f0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2800 */  76, 89, 10, 32, 52, 56, 32,108,111,111,112, 51, 95,115,101,116,
/* 0x2810 */  95, 99,111,117,110,116, 46, 98, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2820 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2830 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 48, 54, 32,
/* 0x2840 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x2850 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2860 */  10, 32, 52, 57, 32,108,111,111,112, 51, 95,115,101,116, 95, 99,
/* 0x2870 */ 111,117,110,116, 46,119, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x2880 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2890 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 48, 56, 32, 32, 50,
/* 0x28a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x28b0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x28c0 */  53, 48, 32,108,111,111,112, 51, 95,115,101,116, 95, 99,111,117,
/* 0x28d0 */ 110,116, 46,108, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,
/* 0x28e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x28f0 */  48, 32, 32, 48, 48, 48, 48, 49, 55, 48, 99, 32, 32, 50, 42, 42,
/* 0x2900 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x2910 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 49,
/* 0x2920 */  32,106,109,112, 95,115,116, 97, 99,107, 32, 32, 32, 32, 32, 48,
/* 0x2930 */  48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2940 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2950 */  48, 49, 55, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2960 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2970 */  32, 53, 50, 32, 95, 95,109,117,108,115,105, 51, 32, 32, 32, 32,
/* 0x2980 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48, 48, 48, 48,
/* 0x2990 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x29a0 */  48, 48, 48, 48, 49, 55, 49, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x29b0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x29c0 */  76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58,
/* 0x29d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x29e0 */  32, 32,108,111,111,112, 49, 95,108, 97, 98,101,108,  9, 48, 48,
/* 0x29f0 */  48, 48, 48, 48, 48, 48, 32,108,111,111,112, 49, 95,108, 97, 98,
/* 0x2a00 */ 101,108, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2a10 */  32,100, 32, 32,102,108,117,115,104, 95, 99, 97, 99,104,101,  9,
/* 0x2a20 */  48, 48, 48, 48, 48, 48, 48, 48, 32,102,108,117,115,104, 95, 99,
/* 0x2a30 */  97, 99,104,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2a40 */  32, 32, 32,100, 32, 32,108,111,111,112, 51, 95,108, 97, 98,101,
/* 0x2a50 */ 108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,111,111,112, 51,
/* 0x2a60 */  95,108, 97, 98,101,108, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2a70 */ 108, 32, 32, 32, 32,100, 32, 32, 95, 95,109,117,108,115,105, 51,
/* 0x2a80 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95, 95,109,117,108,115,
/* 0x2a90 */ 105, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2aa0 */  32,100, 32, 32,101,110,116,114,121,  9, 48, 48, 48, 48, 48, 48,
/* 0x2ab0 */  48, 48, 32,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ac0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32,115,101,116, 95,117,112,
/* 0x2ad0 */  50, 49, 95, 97, 54, 46,119,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ae0 */  32,115,101,116, 95,117,112, 50, 49, 95, 97, 54, 46,119, 10, 48,
/* 0x2af0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2b00 */ 115,101,116, 95,117,112, 50, 49, 95,100, 52, 46,119,  9, 48, 48,
/* 0x2b10 */  48, 48, 48, 48, 48, 48, 32,115,101,116, 95,117,112, 50, 49, 95,
/* 0x2b20 */ 100, 52, 46,119, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2b30 */  32, 32, 32,100, 32, 32,115,101,116, 95,117,112, 50, 49, 95,100,
/* 0x2b40 */  52, 46,108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,101,116,
/* 0x2b50 */  95,117,112, 50, 49, 95,100, 52, 46,108, 10, 48, 48, 48, 48, 48,
/* 0x2b60 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,111,112,
/* 0x2b70 */  49, 95,115,101,116, 95, 99,111,117,110,116, 46, 98,  9, 48, 48,
/* 0x2b80 */  48, 48, 48, 48, 48, 48, 32,108,111,111,112, 49, 95,115,101,116,
/* 0x2b90 */  95, 99,111,117,110,116, 46, 98, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ba0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,111,112, 49, 95,
/* 0x2bb0 */ 115,101,116, 95, 99,111,117,110,116, 46,119,  9, 48, 48, 48, 48,
/* 0x2bc0 */  48, 48, 48, 48, 32,108,111,111,112, 49, 95,115,101,116, 95, 99,
/* 0x2bd0 */ 111,117,110,116, 46,119, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2be0 */ 108, 32, 32, 32, 32,100, 32, 32,108,111,111,112, 49, 95,115,101,
/* 0x2bf0 */ 116, 95, 99,111,117,110,116, 46,108,  9, 48, 48, 48, 48, 48, 48,
/* 0x2c00 */  48, 48, 32,108,111,111,112, 49, 95,115,101,116, 95, 99,111,117,
/* 0x2c10 */ 110,116, 46,108, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2c20 */  32, 32, 32,100, 32, 32,108,111,111,112, 49, 46,102, 97,115,116,
/* 0x2c30 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,111,111,112, 49, 46,
/* 0x2c40 */ 102, 97,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2c50 */  32, 32, 32,100, 32, 32,108,111,111,112, 49, 46,115,109, 97,108,
/* 0x2c60 */ 108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,111,111,112, 49,
/* 0x2c70 */  46,115,109, 97,108,108, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2c80 */ 108, 32, 32, 32, 32,100, 32, 32,108,111,111,112, 49, 95,115,117,
/* 0x2c90 */  98,113,108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,111,111,
/* 0x2ca0 */ 112, 49, 95,115,117, 98,113,108, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cb0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,111,112, 49, 95,
/* 0x2cc0 */ 115,117, 98,113,119,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2cd0 */ 111,111,112, 49, 95,115,117, 98,113,119, 10, 48, 48, 48, 48, 48,
/* 0x2ce0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,111,112,
/* 0x2cf0 */  49, 95,100, 98,114, 97,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2d00 */ 108,111,111,112, 49, 95,100, 98,114, 97, 10, 48, 48, 48, 48, 48,
/* 0x2d10 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,111,112,
/* 0x2d20 */  50, 46,102, 97,115,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2d30 */ 108,111,111,112, 50, 46,102, 97,115,116, 10, 48, 48, 48, 48, 48,
/* 0x2d40 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,111,112,
/* 0x2d50 */  50, 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d60 */  32,108,111,111,112, 50, 46,115,109, 97,108,108, 10, 48, 48, 48,
/* 0x2d70 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,111,
/* 0x2d80 */ 112,121, 95,116,111, 95,115,116, 97, 99,107,  9, 48, 48, 48, 48,
/* 0x2d90 */  48, 48, 48, 48, 32, 99,111,112,121, 95,116,111, 95,115,116, 97,
/* 0x2da0 */  99,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2db0 */  32,100, 32, 32,110,114,118, 50, 98, 46,105,110,105,116,  9, 48,
/* 0x2dc0 */  48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50, 98, 46,105,110,
/* 0x2dd0 */ 105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2de0 */  32,100, 32, 32,110,114,118, 50,100, 46,105,110,105,116,  9, 48,
/* 0x2df0 */  48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50,100, 46,105,110,
/* 0x2e00 */ 105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2e10 */  32,100, 32, 32,110,114,118, 50,101, 46,105,110,105,116,  9, 48,
/* 0x2e20 */  48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50,101, 46,105,110,
/* 0x2e30 */ 105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2e40 */  32,100, 32, 32,106,109,112, 95,100,101, 99,111,109,112,114,101,
/* 0x2e50 */ 115,115,111,114, 95, 97, 54, 46,119,  9, 48, 48, 48, 48, 48, 48,
/* 0x2e60 */  48, 48, 32,106,109,112, 95,100,101, 99,111,109,112,114,101,115,
/* 0x2e70 */ 115,111,114, 95, 97, 54, 46,119, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e80 */  48, 32,108, 32, 32, 32, 32,100, 32, 32,106,109,112, 95,100,101,
/* 0x2e90 */  99,111,109,112,114,101,115,115,111,114, 95,100, 52, 46,119,  9,
/* 0x2ea0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,106,109,112, 95,100,101, 99,
/* 0x2eb0 */ 111,109,112,114,101,115,115,111,114, 95,100, 52, 46,119, 10, 48,
/* 0x2ec0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x2ed0 */ 106,109,112, 95,100,101, 99,111,109,112,114,101,115,115,111,114,
/* 0x2ee0 */  95, 97, 54, 46,119, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2ef0 */ 106,109,112, 95,100,101, 99,111,109,112,114,101,115,115,111,114,
/* 0x2f00 */  95, 97, 54, 46,119, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f10 */ 108, 32, 32, 32, 32,100, 32, 32,106,109,112, 95,100,101, 99,111,
/* 0x2f20 */ 109,112,114,101,115,115,111,114, 95,100, 52, 46,108,  9, 48, 48,
/* 0x2f30 */  48, 48, 48, 48, 48, 48, 32,106,109,112, 95,100,101, 99,111,109,
/* 0x2f40 */ 112,114,101,115,115,111,114, 95,100, 52, 46,108, 10, 48, 48, 48,
/* 0x2f50 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,111,
/* 0x2f60 */ 100,101, 95,111,110, 95,115,116, 97, 99,107,  9, 48, 48, 48, 48,
/* 0x2f70 */  48, 48, 48, 48, 32, 99,111,100,101, 95,111,110, 95,115,116, 97,
/* 0x2f80 */  99,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x2f90 */  32,100, 32, 32, 99,108,101, 97,114, 95,100,105,114,116,121, 95,
/* 0x2fa0 */  98,115,115,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,108,101,
/* 0x2fb0 */  97,114, 95,100,105,114,116,121, 95, 98,115,115, 10, 48, 48, 48,
/* 0x2fc0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,108,111,
/* 0x2fd0 */ 111,112, 51, 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48,
/* 0x2fe0 */  48, 48, 32,108,111,111,112, 51, 46,115,109, 97,108,108, 10, 48,
/* 0x2ff0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3000 */ 108,111,111,112, 51, 46,102, 97,115,116,  9, 48, 48, 48, 48, 48,
/* 0x3010 */  48, 48, 48, 32,108,111,111,112, 51, 46,102, 97,115,116, 10, 48,
/* 0x3020 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3030 */ 108,111,111,112, 51, 95,115,117, 98,113,108,  9, 48, 48, 48, 48,
/* 0x3040 */  48, 48, 48, 48, 32,108,111,111,112, 51, 95,115,117, 98,113,108,
/* 0x3050 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3060 */  32, 32,108,111,111,112, 51, 95,115,117, 98,113,119,  9, 48, 48,
/* 0x3070 */  48, 48, 48, 48, 48, 48, 32,108,111,111,112, 51, 95,115,117, 98,
/* 0x3080 */ 113,119, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3090 */  32,100, 32, 32,108,111,111,112, 51, 95,100, 98,114, 97,  9, 48,
/* 0x30a0 */  48, 48, 48, 48, 48, 48, 48, 32,108,111,111,112, 51, 95,100, 98,
/* 0x30b0 */ 114, 97, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x30c0 */  32,100, 32, 32,114,101,115,116,111,114,101, 95,115,116, 97, 99,
/* 0x30d0 */ 107,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,115,116,111,
/* 0x30e0 */ 114,101, 95,115,116, 97, 99,107, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x30f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,108,101, 97,114, 95,
/* 0x3100 */ 100,105,114,116,121, 95,115,116, 97, 99,107,  9, 48, 48, 48, 48,
/* 0x3110 */  48, 48, 48, 48, 32, 99,108,101, 97,114, 95,100,105,114,116,121,
/* 0x3120 */  95,115,116, 97, 99,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3130 */ 108, 32, 32, 32, 32,100, 32, 32,115,116, 97,114,116, 95,112,114,
/* 0x3140 */ 111,103,114, 97,109,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,
/* 0x3150 */ 116, 97,114,116, 95,112,114,111,103,114, 97,109, 10, 48, 48, 48,
/* 0x3160 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80,
/* 0x3170 */  88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3180 */  85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3190 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 85, 84, 80, 79, 73,
/* 0x31a0 */  78, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 85, 84, 80,
/* 0x31b0 */  79, 73, 78, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x31c0 */  32, 32, 32,100, 32, 32,110,114,118, 50, 98, 95, 56, 46,102, 97,
/* 0x31d0 */ 115,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50,
/* 0x31e0 */  98, 95, 56, 46,102, 97,115,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x31f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50,100, 95,
/* 0x3200 */  56, 46,102, 97,115,116,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3210 */ 110,114,118, 50,100, 95, 56, 46,102, 97,115,116, 10, 48, 48, 48,
/* 0x3220 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,
/* 0x3230 */ 118, 50,101, 95, 56, 46,102, 97,115,116,  9, 48, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 32,110,114,118, 50,101, 95, 56, 46,102, 97,115,116,
/* 0x3250 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3260 */  32, 32,110,114,118, 50, 98, 95, 56, 46,115,109, 97,108,108,  9,
/* 0x3270 */  48, 48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50, 98, 95, 56,
/* 0x3280 */  46,115,109, 97,108,108, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3290 */ 108, 32, 32, 32, 32,100, 32, 32,110,114,118, 50,100, 95, 56, 46,
/* 0x32a0 */ 115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,
/* 0x32b0 */ 114,118, 50,100, 95, 56, 46,115,109, 97,108,108, 10, 48, 48, 48,
/* 0x32c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,110,114,
/* 0x32d0 */ 118, 50,101, 95, 56, 46,115,109, 97,108,108,  9, 48, 48, 48, 48,
/* 0x32e0 */  48, 48, 48, 48, 32,110,114,118, 50,101, 95, 56, 46,115,109, 97,
/* 0x32f0 */ 108,108, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3300 */  32,100, 32, 32,108,122,109, 97, 46,105,110,105,116,  9, 48, 48,
/* 0x3310 */  48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 46,105,110,105,116,
/* 0x3320 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3330 */  32, 32,108,122,109, 97, 46,102, 97,115,116,  9, 48, 48, 48, 48,
/* 0x3340 */  48, 48, 48, 48, 32,108,122,109, 97, 46,102, 97,115,116, 10, 48,
/* 0x3350 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3360 */ 108,122,109, 97, 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48,
/* 0x3370 */  48, 48, 48, 32,108,122,109, 97, 46,115,109, 97,108,108, 10, 48,
/* 0x3380 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3390 */ 108,122,109, 97, 46,102,105,110,105,115,104,  9, 48, 48, 48, 48,
/* 0x33a0 */  48, 48, 48, 48, 32,108,122,109, 97, 46,102,105,110,105,115,104,
/* 0x33b0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x33c0 */  32, 32,114,101,108,111, 99,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33d0 */  32,114,101,108,111, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x33e0 */ 108, 32, 32, 32, 32,100, 32, 32,108,111,111,112, 51, 95,115,101,
/* 0x33f0 */ 116, 95, 99,111,117,110,116, 46, 98,  9, 48, 48, 48, 48, 48, 48,
/* 0x3400 */  48, 48, 32,108,111,111,112, 51, 95,115,101,116, 95, 99,111,117,
/* 0x3410 */ 110,116, 46, 98, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3420 */  32, 32, 32,100, 32, 32,108,111,111,112, 51, 95,115,101,116, 95,
/* 0x3430 */  99,111,117,110,116, 46,119,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3440 */  32,108,111,111,112, 51, 95,115,101,116, 95, 99,111,117,110,116,
/* 0x3450 */  46,119, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3460 */  32,100, 32, 32,108,111,111,112, 51, 95,115,101,116, 95, 99,111,
/* 0x3470 */ 117,110,116, 46,108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3480 */ 111,111,112, 51, 95,115,101,116, 95, 99,111,117,110,116, 46,108,
/* 0x3490 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x34a0 */  32, 32,106,109,112, 95,115,116, 97, 99,107,  9, 48, 48, 48, 48,
/* 0x34b0 */  48, 48, 48, 48, 32,106,109,112, 95,115,116, 97, 99,107, 10, 48,
/* 0x34c0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x34d0 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,
/* 0x34e0 */ 114,105,103, 95,112, 95,116,108,101,110, 10, 48, 48, 48, 48, 48,
/* 0x34f0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3500 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103, 95,
/* 0x3510 */ 112, 95,100,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3520 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x3530 */  48, 48, 48, 48, 48, 48, 32,111,114,105,103, 95,112, 95, 98,108,
/* 0x3540 */ 101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x3550 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x3560 */  48, 48, 32,117,112, 50, 49, 95, 97, 54, 10, 48, 48, 48, 48, 48,
/* 0x3570 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3580 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,117,112, 50, 49, 95,
/* 0x3590 */ 100, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x35a0 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x35b0 */  48, 48, 32,108,111,111,112, 49, 95, 99,111,117,110,116, 10, 48,
/* 0x35c0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x35d0 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x35e0 */ 111,111,112, 50, 95, 99,111,117,110,116, 10, 48, 48, 48, 48, 48,
/* 0x35f0 */  48, 48, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,
/* 0x3600 */ 116, 95,112,114,111,103,114, 97,109,  9, 48, 48, 48, 48, 48, 48,
/* 0x3610 */  48, 48, 32, 99,111,100,101, 95,111,110, 95,115,116, 97, 99,107,
/* 0x3620 */  95,101,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x3630 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x3640 */  48, 48, 48, 48, 32, 99,111,112,121, 95,116,111, 95,115,116, 97,
/* 0x3650 */  99,107, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3660 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x3670 */  48, 48, 48, 48, 48, 48, 32,102,108,117,115,104, 95, 99, 97, 99,
/* 0x3680 */ 104,101, 95,114,116,115, 95,111,102,102,115,101,116, 10, 48, 48,
/* 0x3690 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x36a0 */  85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,117,112,
/* 0x36b0 */  51, 49, 95, 97, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x36c0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x36d0 */  48, 48, 48, 48, 48, 32,117,112, 51, 49, 95,100, 52, 10, 48, 48,
/* 0x36e0 */  48, 48, 48, 48, 55, 54, 32,103, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x36f0 */ 108,117,115,104, 95, 99, 97, 99,104,101,  9, 48, 48, 48, 48, 48,
/* 0x3700 */  48, 48, 48, 32,102,108,117,115,104, 95, 99, 97, 99,104,101, 95,
/* 0x3710 */ 114,116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x3720 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 48, 32, 99,108,101, 97,114, 95,100,105,114,116,121, 95,
/* 0x3740 */ 115,116, 97, 99,107, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x3750 */  48, 54, 32,103, 32, 32, 32, 32, 32, 32, 32, 99,108,101, 97,114,
/* 0x3760 */  95,100,105,114,116,121, 95,115,116, 97, 99,107,  9, 48, 48, 48,
/* 0x3770 */  48, 48, 48, 48, 48, 32, 99,108,101, 97,114, 95,100,105,114,116,
/* 0x3780 */ 121, 95,115,116, 97, 99,107, 95,108,111,111,112, 10, 48, 48, 48,
/* 0x3790 */  48, 48, 48, 48, 50, 32,103, 32, 32, 32, 32, 32, 32, 32,110,114,
/* 0x37a0 */ 118, 50, 98, 95, 56, 46,102, 97,115,116,  9, 48, 48, 48, 48, 48,
/* 0x37b0 */  48, 48, 48, 32,110,114,118, 50, 98, 95, 56, 95,102, 97,115,116,
/* 0x37c0 */  95,100,101, 99,111,109,112,114, 95,115,116, 97,114,116, 10, 48,
/* 0x37d0 */  48, 48, 48, 48, 48, 48, 50, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x37e0 */ 110,114,118, 50,100, 95, 56, 46,102, 97,115,116,  9, 48, 48, 48,
/* 0x37f0 */  48, 48, 48, 48, 48, 32,110,114,118, 50,100, 95, 56, 95,102, 97,
/* 0x3800 */ 115,116, 95,100,101, 99,111,109,112,114, 95,115,116, 97,114,116,
/* 0x3810 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32,103, 32, 32, 32, 32, 32,
/* 0x3820 */  32, 32,110,114,118, 50,101, 95, 56, 46,102, 97,115,116,  9, 48,
/* 0x3830 */  48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50,101, 95, 56, 95,
/* 0x3840 */ 102, 97,115,116, 95,100,101, 99,111,109,112,114, 95,115,116, 97,
/* 0x3850 */ 114,116, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32,103, 32, 32, 32,
/* 0x3860 */  32, 32, 32, 32,110,114,118, 50, 98, 95, 56, 46,115,109, 97,108,
/* 0x3870 */ 108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,114,118, 50, 98,
/* 0x3880 */  95, 56, 95,115,109, 97,108,108, 95,100,101, 99,111,109,112,114,
/* 0x3890 */  95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x38a0 */ 103, 32, 32, 32, 32, 32, 32, 32,110,114,118, 50,100, 95, 56, 46,
/* 0x38b0 */ 115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,
/* 0x38c0 */ 114,118, 50,100, 95, 56, 95,115,109, 97,108,108, 95,100,101, 99,
/* 0x38d0 */ 111,109,112,114, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48,
/* 0x38e0 */  48, 48, 50, 32,103, 32, 32, 32, 32, 32, 32, 32,110,114,118, 50,
/* 0x38f0 */ 101, 95, 56, 46,115,109, 97,108,108,  9, 48, 48, 48, 48, 48, 48,
/* 0x3900 */  48, 48, 32,110,114,118, 50,101, 95, 56, 95,115,109, 97,108,108,
/* 0x3910 */  95,100,101, 99,111,109,112,114, 95,115,116, 97,114,116, 10, 48,
/* 0x3920 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3930 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3940 */ 122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116,
/* 0x3950 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3960 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3970 */  32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x3980 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x3990 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97,
/* 0x39a0 */  95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x39b0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x39c0 */  48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,112,114,111,112,
/* 0x39d0 */ 101,114,116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x39e0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x39f0 */  48, 48, 48, 48, 48, 48, 32,108,111,111,112, 51, 95, 99,111,117,
/* 0x3a00 */ 110,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3a10 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,101,110,116,114,
/* 0x3a20 */ 121, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x3a30 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x3a40 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 99, 32, 82, 95,
/* 0x3a50 */  54, 56, 75, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a60 */ 111,114,105,103, 95,112, 95,116,108,101,110, 10, 48, 48, 48, 48,
/* 0x3a70 */  48, 48, 50, 54, 32, 82, 95, 54, 56, 75, 95, 51, 50, 32, 32, 32,
/* 0x3a80 */  32, 32, 32, 32, 32, 32, 32,111,114,105,103, 95,112, 95,100,108,
/* 0x3a90 */ 101,110, 10, 48, 48, 48, 48, 48, 48, 51, 50, 32, 82, 95, 54, 56,
/* 0x3aa0 */  75, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,111,114,
/* 0x3ab0 */ 105,103, 95,112, 95, 98,108,101,110, 10, 10, 82, 69, 76, 79, 67,
/* 0x3ac0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x3ad0 */  82, 32, 91,115,101,116, 95,117,112, 50, 49, 95, 97, 54, 46,119,
/* 0x3ae0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x3af0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3b00 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 54,
/* 0x3b10 */  56, 75, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,117,
/* 0x3b20 */ 112, 50, 49, 95, 97, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x3b30 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x3b40 */ 115,101,116, 95,117,112, 50, 49, 95,100, 52, 46,119, 93, 58, 10,
/* 0x3b50 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x3b60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x3b70 */  10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 54, 56, 75, 95,
/* 0x3b80 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,117,112, 50, 49,
/* 0x3b90 */  95,100, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x3ba0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,115,101,116,
/* 0x3bb0 */  95,117,112, 50, 49, 95,100, 52, 46,108, 93, 58, 10, 79, 70, 70,
/* 0x3bc0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x3bd0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x3be0 */  48, 48, 48, 48, 48, 52, 32, 82, 95, 54, 56, 75, 95, 51, 50, 32,
/* 0x3bf0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,117,112, 50, 49, 95,100, 52,
/* 0x3c00 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x3c10 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,111,111,112, 49, 95,
/* 0x3c20 */ 115,101,116, 95, 99,111,117,110,116, 46, 98, 93, 58, 10, 79, 70,
/* 0x3c30 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x3c40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x3c50 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 54, 56, 75, 95, 56, 32,
/* 0x3c60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,111,111,112, 49, 95,
/* 0x3c70 */  99,111,117,110,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x3c80 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,
/* 0x3c90 */ 111,111,112, 49, 95,115,101,116, 95, 99,111,117,110,116, 46,119,
/* 0x3ca0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x3cb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3cc0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 54,
/* 0x3cd0 */  56, 75, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x3ce0 */ 111,111,112, 49, 95, 99,111,117,110,116, 10, 10, 82, 69, 76, 79,
/* 0x3cf0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x3d00 */  79, 82, 32, 91,108,111,111,112, 49, 95,115,101,116, 95, 99,111,
/* 0x3d10 */ 117,110,116, 46,108, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x3d20 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3d30 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d40 */  50, 32, 82, 95, 54, 56, 75, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x3d50 */  32, 32, 32, 32,108,111,111,112, 49, 95, 99,111,117,110,116, 10,
/* 0x3d60 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x3d70 */  82, 68, 83, 32, 70, 79, 82, 32, 91,108,111,111,112, 49, 95,115,
/* 0x3d80 */ 117, 98,113,108, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x3d90 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3da0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x3db0 */  32, 82, 95, 54, 56, 75, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x3dc0 */  32, 32, 32,108,111,111,112, 49, 95,108, 97, 98,101,108, 43, 48,
/* 0x3dd0 */ 120,102,102,102,102,102,102,102,102, 10, 10, 82, 69, 76, 79, 67,
/* 0x3de0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x3df0 */  82, 32, 91,108,111,111,112, 49, 95,115,117, 98,113,119, 93, 58,
/* 0x3e00 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3e10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3e20 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 54, 56, 75,
/* 0x3e30 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,111,111,
/* 0x3e40 */ 112, 49, 95,108, 97, 98,101,108, 43, 48,120,102,102,102,102,102,
/* 0x3e50 */ 102,102,102, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x3e60 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,111,111,
/* 0x3e70 */ 112, 49, 95,100, 98,114, 97, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x3e80 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e90 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 50, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32,
/* 0x3eb0 */  32, 32, 32, 32, 32, 32,108,111,111,112, 49, 95,108, 97, 98,101,
/* 0x3ec0 */ 108, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x3ed0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,111,111,112, 50,
/* 0x3ee0 */  46,102, 97,115,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x3ef0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f00 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f10 */  49, 32, 82, 95, 54, 56, 75, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f20 */  32, 32, 32, 32,108,111,111,112, 50, 95, 99,111,117,110,116, 10,
/* 0x3f30 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x3f40 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 99,111,112,121, 95,116,111,
/* 0x3f50 */  95,115,116, 97, 99,107, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x3f60 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f70 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x3f80 */  48, 50, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32,
/* 0x3f90 */  32, 32, 32, 32, 32, 99,111,100,101, 95,111,110, 95,115,116, 97,
/* 0x3fa0 */  99,107, 95,101,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x3fb0 */  82, 95, 54, 56, 75, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fc0 */  32, 32, 99,111,112,121, 95,116,111, 95,115,116, 97, 99,107, 95,
/* 0x3fd0 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 54,
/* 0x3fe0 */  56, 75, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x3ff0 */ 108,117,115,104, 95, 99, 97, 99,104,101, 95,114,116,115, 95,111,
/* 0x4000 */ 102,102,115,101,116, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82,
/* 0x4010 */  95, 54, 56, 75, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4020 */  32,102,108,117,115,104, 95, 99, 97, 99,104,101, 43, 48,120,102,
/* 0x4030 */ 102,102,102,102,102,102,102, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4040 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4050 */  91,106,109,112, 95,100,101, 99,111,109,112,114,101,115,115,111,
/* 0x4060 */ 114, 95, 97, 54, 46,119, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4070 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4080 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4090 */  48, 50, 32, 82, 95, 54, 56, 75, 95, 49, 54, 32, 32, 32, 32, 32,
/* 0x40a0 */  32, 32, 32, 32, 32,117,112, 51, 49, 95, 97, 54, 10, 10, 82, 69,
/* 0x40b0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x40c0 */  32, 70, 79, 82, 32, 91,106,109,112, 95,100,101, 99,111,109,112,
/* 0x40d0 */ 114,101,115,115,111,114, 95,100, 52, 46,119, 93, 58, 10, 79, 70,
/* 0x40e0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x40f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4100 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 54, 56, 75, 95, 49, 54,
/* 0x4110 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,117,112, 51, 49, 95,100,
/* 0x4120 */  52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4130 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,106,109,112, 95,100,
/* 0x4140 */ 101, 99,111,109,112,114,101,115,115,111,114, 95, 97, 54, 46,119,
/* 0x4150 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4160 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4170 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95,
/* 0x4180 */  54, 56, 75, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4190 */ 117,112, 51, 49, 95, 97, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x41a0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x41b0 */  91,106,109,112, 95,100,101, 99,111,109,112,114,101,115,115,111,
/* 0x41c0 */ 114, 95,100, 52, 46,108, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x41d0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x41e0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x41f0 */  48, 52, 32, 82, 95, 54, 56, 75, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x4200 */  32, 32, 32, 32, 32,117,112, 51, 49, 95,100, 52, 10, 10, 82, 69,
/* 0x4210 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4220 */  32, 70, 79, 82, 32, 91,108,111,111,112, 51, 95,115,117, 98,113,
/* 0x4230 */ 108, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x4240 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4250 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,
/* 0x4260 */  54, 56, 75, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4270 */ 108,111,111,112, 51, 95,108, 97, 98,101,108, 43, 48,120,102,102,
/* 0x4280 */ 102,102,102,102,102,102, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4290 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x42a0 */ 108,111,111,112, 51, 95,115,117, 98,113,119, 93, 58, 10, 79, 70,
/* 0x42b0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x42c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x42d0 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 54, 56, 75, 95, 80, 67,
/* 0x42e0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,111,111,112, 51, 95,
/* 0x42f0 */ 108, 97, 98,101,108, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4300 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4310 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,111,111,112, 51, 95,
/* 0x4320 */ 100, 98,114, 97, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4330 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4340 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4350 */  32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x4360 */  32, 32, 32,108,111,111,112, 51, 95,108, 97, 98,101,108, 10, 10,
/* 0x4370 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4380 */  68, 83, 32, 70, 79, 82, 32, 91,114,101,115,116,111,114,101, 95,
/* 0x4390 */ 115,116, 97, 99,107, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x43a0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x43b0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x43c0 */  50, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32,
/* 0x43d0 */  32, 32, 32, 32, 99,111,100,101, 95,111,110, 95,115,116, 97, 99,
/* 0x43e0 */ 107, 95,101,110,100, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x43f0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4400 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,108,101, 97,114, 95,
/* 0x4410 */ 100,105,114,116,121, 95,115,116, 97, 99,107, 93, 58, 10, 79, 70,
/* 0x4420 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4430 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4440 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 54, 56, 75, 95, 56, 32,
/* 0x4450 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,101, 97,114, 95,
/* 0x4460 */ 100,105,114,116,121, 95,115,116, 97, 99,107, 95,108,101,110, 10,
/* 0x4470 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4480 */  82, 68, 83, 32, 70, 79, 82, 32, 91,108,122,109, 97, 46,105,110,
/* 0x4490 */ 105,116, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x44a0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x44b0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x44c0 */  95, 54, 56, 75, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x44d0 */  32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,
/* 0x44e0 */ 115,116, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 54, 56,
/* 0x44f0 */  75, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,
/* 0x4500 */ 109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x4510 */  97, 32, 82, 95, 54, 56, 75, 95, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4520 */  32, 32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48,
/* 0x4530 */  48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 54, 56, 75, 95, 51, 50,
/* 0x4540 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,
/* 0x4550 */ 114,111,112,101,114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67,
/* 0x4560 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4570 */  82, 32, 91,108,122,109, 97, 46,102, 97,115,116, 93, 58, 10, 79,
/* 0x4580 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4590 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x45a0 */  48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 54, 56, 75, 95, 80,
/* 0x45b0 */  67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,
/* 0x45c0 */ 115,105, 51, 10, 48, 48, 48, 48, 48, 49, 99, 97, 32, 82, 95, 54,
/* 0x45d0 */  56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95,
/* 0x45e0 */  95,109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48, 50, 52, 50,
/* 0x45f0 */  32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x4600 */  32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 48, 48, 48, 48,
/* 0x4610 */  48, 50,102,101, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32,
/* 0x4620 */  32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10,
/* 0x4630 */  48, 48, 48, 48, 48, 51, 56, 50, 32, 82, 95, 54, 56, 75, 95, 80,
/* 0x4640 */  67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,
/* 0x4650 */ 115,105, 51, 10, 48, 48, 48, 48, 48, 51,100,101, 32, 82, 95, 54,
/* 0x4660 */  56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95,
/* 0x4670 */  95,109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48, 52, 56, 50,
/* 0x4680 */  32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x4690 */  32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 48, 48, 48, 48,
/* 0x46a0 */  48, 52,100, 97, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32,
/* 0x46b0 */  32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10,
/* 0x46c0 */  48, 48, 48, 48, 48, 53, 55, 56, 32, 82, 95, 54, 56, 75, 95, 80,
/* 0x46d0 */  67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,
/* 0x46e0 */ 115,105, 51, 10, 48, 48, 48, 48, 48, 53,101, 48, 32, 82, 95, 54,
/* 0x46f0 */  56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95,
/* 0x4700 */  95,109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48, 54, 54, 99,
/* 0x4710 */  32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x4720 */  32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 48, 48, 48, 48,
/* 0x4730 */  48, 55, 48, 56, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32,
/* 0x4740 */  32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10,
/* 0x4750 */  48, 48, 48, 48, 48, 55,102, 56, 32, 82, 95, 54, 56, 75, 95, 80,
/* 0x4760 */  67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,
/* 0x4770 */ 115,105, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4780 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,122,109,
/* 0x4790 */  97, 46,115,109, 97,108,108, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x47a0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x47b0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x47c0 */  49, 48, 56, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32,
/* 0x47d0 */  32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 48,
/* 0x47e0 */  48, 48, 48, 48, 49, 99, 97, 32, 82, 95, 54, 56, 75, 95, 80, 67,
/* 0x47f0 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,
/* 0x4800 */ 105, 51, 10, 48, 48, 48, 48, 48, 50, 52, 50, 32, 82, 95, 54, 56,
/* 0x4810 */  75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,
/* 0x4820 */ 109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48, 50,102,101, 32,
/* 0x4830 */  82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x4840 */  32, 32, 95, 95,109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48,
/* 0x4850 */  51, 56, 50, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32,
/* 0x4860 */  32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 48,
/* 0x4870 */  48, 48, 48, 48, 51,100,101, 32, 82, 95, 54, 56, 75, 95, 80, 67,
/* 0x4880 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,
/* 0x4890 */ 105, 51, 10, 48, 48, 48, 48, 48, 52, 56, 50, 32, 82, 95, 54, 56,
/* 0x48a0 */  75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,
/* 0x48b0 */ 109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48, 52,100, 97, 32,
/* 0x48c0 */  82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x48d0 */  32, 32, 95, 95,109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48,
/* 0x48e0 */  53, 55, 56, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32,
/* 0x48f0 */  32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 48,
/* 0x4900 */  48, 48, 48, 48, 53,101, 48, 32, 82, 95, 54, 56, 75, 95, 80, 67,
/* 0x4910 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,
/* 0x4920 */ 105, 51, 10, 48, 48, 48, 48, 48, 54, 54, 99, 32, 82, 95, 54, 56,
/* 0x4930 */  75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 95, 95,
/* 0x4940 */ 109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48, 55, 48, 56, 32,
/* 0x4950 */  82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x4960 */  32, 32, 95, 95,109,117,108,115,105, 51, 10, 48, 48, 48, 48, 48,
/* 0x4970 */  55,102, 56, 32, 82, 95, 54, 56, 75, 95, 80, 67, 49, 54, 32, 32,
/* 0x4980 */  32, 32, 32, 32, 32, 32, 95, 95,109,117,108,115,105, 51, 10, 10,
/* 0x4990 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x49a0 */  68, 83, 32, 70, 79, 82, 32, 91,108,111,111,112, 51, 95,115,101,
/* 0x49b0 */ 116, 95, 99,111,117,110,116, 46, 98, 93, 58, 10, 79, 70, 70, 83,
/* 0x49c0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x49d0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x49e0 */  48, 48, 48, 48, 49, 32, 82, 95, 54, 56, 75, 95, 56, 32, 32, 32,
/* 0x49f0 */  32, 32, 32, 32, 32, 32, 32, 32,108,111,111,112, 51, 95, 99,111,
/* 0x4a00 */ 117,110,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4a10 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,108,111,111,
/* 0x4a20 */ 112, 51, 95,115,101,116, 95, 99,111,117,110,116, 46,119, 93, 58,
/* 0x4a30 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4a40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4a50 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 54, 56, 75,
/* 0x4a60 */  95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,111,111,
/* 0x4a70 */ 112, 51, 95, 99,111,117,110,116, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4a80 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4a90 */  32, 91,108,111,111,112, 51, 95,115,101,116, 95, 99,111,117,110,
/* 0x4aa0 */ 116, 46,108, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4ab0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ac0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x4ad0 */  82, 95, 54, 56, 75, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ae0 */  32, 32,108,111,111,112, 51, 95, 99,111,117,110,116, 10
};
