---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, correspondance
---

# Comment préparer une lettre ?

LaTeX fournit par défaut une classe <ctanpkg:letter>, généralement 
peu appréciée. Même son auteur semble depuis longtemps avoir renoncé 
à l'utiliser. Elle est cependant décrite ci-dessous afin que vous
puissiez l'observer.

Heureusement, d'autres extensions plus renommées existent et sont listées 
ci-après. 

Si jamais elles ne répondent pas à vos attentes, une stratégie courante 
est de faire les choses soi-même. Kopka et Daly (dans leur 
[Guide to LaTeX](isbn:978-0-3211-7385-0)) tout comme Donald Knuth 
(pour une utilisation avec Plain TeX, dans le TeX​book) propose des exemples 
de cela. 

Pour les plus curieux, la dernière version des commandes de Knuth apparaît 
dans [sa bibliothèque locale](ctanpkg:knuth-local) sur le CTAN. Elle est mise 
à jour en même temps que TeX lui-même, donc pas très souvent, 
mais la dernière version date de février 2021.

:::{todo} Ajouter des exemples
:::


## Avec la classe <ctanpkg:lettre>

La classe <ctanpkg:lettre> de Denis Mégevand est un outil très bien fait 
et adaptable à toutes les situations (voir l'exemple ci-dessous). 

```
\documentclass[french]{lettre}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{letter}{Mme Marie-Paule \textsc{Kluth}\\
   Alcatel Alsthom Recherche\\
   Route de Nozay\\
   \textbf{F-91460 Marcoussis}}

\address{Denis Mégevand\\Genève}
\notelephone\nofax\nolieu\nodate
\signature{Denis Mégevand}
\def\concname{Objet :~}
\conc{FAQ de \TeX{}}

\opening{Chère Madame,}
Je vous remercie de citer ma classe lettre dans le \S20.1 de votre FAQ 
sur \TeX{}. Il est exact que l'on peut faire beaucoup de choses avec cette
classe dans le domaine de la correspondance, notamment des lettres 
et des télécopies (fax). On peut également obtenir une page d'étiquettes
avec les adresses des destinataires des lettres contenues dans le document.

Tous les paramètres de mise-en-page, ainsi que les chaînes "Concerne", "Cc", 
"PS", etc. peuvent être facilement modifiés.
\closing{Meilleures salutations}
\cc{À personne !}
\end{letter}
\end{document}
```

Vous pouvez ne pas indiquer de date à la lettre avec la commande `\nodate`.


## Avec la classe <ctanpkg:letter>

LaTeX fournit par défaut une classe <ctanpkg:letter>, généralement 
peu appréciée. Même son auteur semble depuis longtemps avoir renoncé 
à l'utiliser. Si vous voulez néanmoins l'essayer, mais que sa façon 
de positionner verticalement le texte vous irrite, vous pouvez ajouter le bout 
de code suivant :

```{noedit}
\makeatletter
\let\@texttop\relax
\makeatother
```

La classe <ctanpkg:letter> définit les commandes :
- `\address` qui définit l'adresse de l'expéditeur placée, en haut à gauche 
  de la première page si l'on utilise une mise en page à la française, 
  ou en haut à droite dans le cas d'une mise en page anglo-saxonne 
  (solution par défaut) ;
- `\signature` prépare la signature de l'auteur de la lettre. Celle-ci sera
  placée en bas à droite de la dernière page de la lettre ;
- `\begin{letter}` prend en argument le nom du destinataire ;
- `\opening` et `\closing` permettent respectivement d'ouvrir et de fermer  
  la lettre généralement par des formules de politesse ;
- `\makelabels` est utilisé dans le préambule et permet de générer une liste
  des adresses des destinataires pour préparer un mailing.

Un certain nombre d'autres commandes permet de générer des champs spécifiques 
tels que : pièces jointes, post-scriptum... De manière générale, 
le positionnement des différents champs dépend de la langue utilisée 
dans la lettre.

Notez que lorsque plusieurs environnements `letter` sont utilisés 
dans un même source, ils produiront chacun une lettre. Toutes ces lettres
auront la même adresse d'expéditeur et la même signature.

```
\documentclass[french]{letter}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \name{expediteur}
  \address{adresse \\ de l'expéditeur}
  \signature{signature \\ de l'expéditeur}

\begin{document}
\begin{letter}{le destinataire}
   \opening{Cher destinataire,}

   texte -- texte -- texte -- texte -- texte --
   texte -- texte -- texte -- texte -- texte --
   texte -- texte -- texte -- texte -- texte --
   texte -- texte -- texte -- texte -- texte --
   texte -- texte -- texte -- texte -- texte --
   texte -- texte -- texte -- texte -- texte --
   texte -- texte -- texte -- texte -- texte --

   \closing{Formule de politesse}
   \ps{PS : j'ai oublié...}
   \cc{Monsieur Truc.}
   \encl{pièces jointes}
\end{letter}
\end{document}
```

Si vous utilisez l'extension <ctanpkg:e-french>, la disposition 
des champs utilisés change puisque les lettres anglo-saxonnes ne respectent pas
la même typographie que les françaises.


## Avec la classe <ctanpkg:fribrief>

La classe <ctanpkg:fribrief> permet également de mettre en page des lettres.


## Avec la classe <ctanpkg:akletter>

La classe <ctanpkg:akletter> est une extension de la classe lettre classique. 
Elle permet notamment de définir son propre en-tête et de gérer la position 
de l'adresse pour des enveloppes à fenêtre.


## Avec la classe <ctanpkg:newlfm>

La classe la plus importante et la plus complète est <ctanpkg:newlfm>. Le `lfm`
de son nom suggère que la classe peut créer des **l**ettres, des **f**ax 
et des **m**émos. Sa documentation est volumineuse et l'extension semble 
très flexible.


## Avec la classe <ctanpkg:isodoc>


## Avec la classe <ctanpkg:dinbrief>

La classe <ctanpkg:dinbrief>, bien que souvent recommandée, n'est documentée
qu'en allemand.


## Avec les classes <ctanpkg:KOMA-script>

La classe <ctanpkg:scrlttr2> de l'ensemble <ctanpkg:KOMA-script> dispose 
d'une documentation en anglais et 
[en français](/1_generalites/documentation/documents/documents_extensions/koma-script_en_francais),

Notez que la classe `scrlettr` de ce même ensemble permet de positionner 
une adresse pour une enveloppe à fenêtre.


## Avec les classes <ctanpkg:ntgclass>

La classe [brief](ctanpkg:ntgclass) au sein des classes <ctanpkg:ntgclass> 
permet de gérer des lettres mais sa [documentation](texdoc:brief) est 
uniquement en néerlandais.


:::{sources}
- [Letters and the like](faquk:FAQ-letterclass)
- [Écrire des lettres en LaTeX](https://zestedesavoir.com/tutoriels/508/ecrire-des-lettres-en-latex/), 
  sur [Zeste de savoir](https://zestedesavoir.com/)
:::