/* http.c generated by valac 0.34.7, the Vala compiler
 * generated from http.vala, do not modify */

/*
 *    Copyright (C) 1999, 2000,
 *    Dirk-Jan C. Binnema <djcb@dds.nl>,
 *    Arjan Scherpenisse <acscherp@wins.uva.nl>
 *    Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* HTTP fetches. */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TG_TYPE_GUI (tg_gui_get_type ())
#define TG_GUI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_GUI, TgGui))
#define TG_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_GUI, TgGuiClass))
#define TG_IS_GUI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_GUI))
#define TG_IS_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_GUI))
#define TG_GUI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_GUI, TgGuiClass))

typedef struct _TgGui TgGui;
typedef struct _TgGuiClass TgGuiClass;

#define TG_TYPE_CHANNEL (tg_channel_get_type ())
#define TG_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_CHANNEL, TgChannel))
#define TG_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_CHANNEL, TgChannelClass))
#define TG_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_CHANNEL))
#define TG_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_CHANNEL))
#define TG_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_CHANNEL, TgChannelClass))

typedef struct _TgChannel TgChannel;
typedef struct _TgChannelClass TgChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	TG_HTTP_ERROR_PIXBUF,
	TG_HTTP_ERROR_VFS,
	TG_HTTP_ERROR_HTTPQUERY
} TgHttpError;
#define TG_HTTP_ERROR tg_http_error_quark ()


GQuark tg_http_error_quark (void);
GType tg_gui_get_type (void) G_GNUC_CONST;
GdkPixbuf* tg_http_get_image (TgGui* gui, GError** error);
GType tg_channel_get_type (void) G_GNUC_CONST;
TgChannel* tg_gui_get_current_channel (TgGui* self);
gint tg_gui_get_subpage_number (TgGui* self);
const gchar* tg_channel_get_subpage_url (TgChannel* self);
gint tg_gui_get_page_number (TgGui* self);
const gchar* tg_channel_get_page_url (TgChannel* self);


GQuark tg_http_error_quark (void) {
	return g_quark_from_static_string ("tg_http_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* tg_http_get_image (TgGui* gui, GError** error) {
	GdkPixbuf* result = NULL;
	TgChannel* channel = NULL;
	TgGui* _tmp0_ = NULL;
	TgChannel* _tmp1_ = NULL;
	TgChannel* _tmp2_ = NULL;
	TgChannel* _tmp3_ = NULL;
	gchar* url = NULL;
	TgGui* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
	GFile* http_file = NULL;
	const gchar* _tmp41_ = NULL;
	GFile* _tmp42_ = NULL;
	GFileInputStream* http_input = NULL;
	GdkPixbufLoader* loader = NULL;
	GdkPixbufLoader* _tmp52_ = NULL;
	guint8* buf = NULL;
	guint8* _tmp53_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbufLoader* _tmp82_ = NULL;
	GdkPixbuf* _tmp83_ = NULL;
	GdkPixbuf* _tmp84_ = NULL;
	GdkPixbuf* _tmp85_ = NULL;
	GdkPixbuf* _tmp88_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (gui != NULL, NULL);
	_tmp0_ = gui;
	_tmp1_ = tg_gui_get_current_channel (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	channel = _tmp3_;
	url = NULL;
	_tmp4_ = gui;
	_tmp5_ = tg_gui_get_subpage_number (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		gchar* subpage_url = NULL;
		TgChannel* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_ = NULL;
		_tmp7_ = channel;
		_tmp8_ = tg_channel_get_subpage_url (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		subpage_url = _tmp10_;
		_tmp12_ = subpage_url;
		if (_tmp12_ != NULL) {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = subpage_url;
			_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			const gchar* _tmp14_ = NULL;
			TgGui* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			TgGui* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gchar* _tmp21_ = NULL;
			_tmp14_ = subpage_url;
			_tmp15_ = gui;
			_tmp16_ = tg_gui_get_page_number (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = gui;
			_tmp19_ = tg_gui_get_subpage_number (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf (_tmp14_, _tmp17_, _tmp20_);
			_g_free0 (url);
			url = _tmp21_;
		}
		_g_free0 (subpage_url);
	}
	_tmp23_ = url;
	if (_tmp23_ == NULL) {
		_tmp22_ = TRUE;
	} else {
		const gchar* _tmp24_ = NULL;
		_tmp24_ = url;
		_tmp22_ = g_strcmp0 (_tmp24_, "") == 0;
	}
	if (_tmp22_) {
		gchar* page_url = NULL;
		TgChannel* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		const gchar* _tmp30_ = NULL;
		_tmp25_ = channel;
		_tmp26_ = tg_channel_get_page_url (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup (_tmp27_);
		page_url = _tmp28_;
		_tmp30_ = page_url;
		if (_tmp30_ != NULL) {
			const gchar* _tmp31_ = NULL;
			_tmp31_ = page_url;
			_tmp29_ = g_strcmp0 (_tmp31_, "") != 0;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			const gchar* _tmp32_ = NULL;
			TgGui* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gchar* _tmp36_ = NULL;
			_tmp32_ = page_url;
			_tmp33_ = gui;
			_tmp34_ = tg_gui_get_page_number (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf (_tmp32_, _tmp35_);
			_g_free0 (url);
			url = _tmp36_;
		}
		_g_free0 (page_url);
	}
	_tmp38_ = url;
	if (_tmp38_ == NULL) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_ = NULL;
		_tmp39_ = url;
		_tmp37_ = g_strcmp0 (_tmp39_, "") == 0;
	}
	if (_tmp37_) {
		GError* _tmp40_ = NULL;
		_tmp40_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_HTTPQUERY, "");
		_inner_error_ = _tmp40_;
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp41_ = url;
	_tmp42_ = g_file_new_for_uri (_tmp41_);
	http_file = _tmp42_;
	{
		GFileInputStream* _tmp43_ = NULL;
		GFileInputStream* _tmp44_ = NULL;
		GFileInputStream* _tmp45_ = NULL;
		_tmp44_ = g_file_read (http_file, NULL, &_inner_error_);
		_tmp43_ = _tmp44_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp45_ = _tmp43_;
		_tmp43_ = NULL;
		_g_object_unref0 (http_input);
		http_input = _tmp45_;
		_g_object_unref0 (_tmp43_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp46_ = NULL;
		GError* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		GError* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		GError* _tmp51_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = url;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_warning ("http.vala:63: Unable to fetch '%s': %s", _tmp46_, _tmp48_);
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		_tmp51_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_VFS, _tmp50_);
		_inner_error_ = _tmp51_;
		_g_error_free0 (e);
		goto __finally6;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp52_ = gdk_pixbuf_loader_new ();
	loader = _tmp52_;
	_tmp53_ = g_new0 (guint8, 4096);
	buf = _tmp53_;
	buf_length1 = 4096;
	_buf_size_ = buf_length1;
	{
		gboolean _tmp54_ = FALSE;
		_tmp54_ = TRUE;
		while (TRUE) {
			gssize bytes_read = 0L;
			if (!_tmp54_) {
			}
			_tmp54_ = FALSE;
			{
				gssize _tmp55_ = 0L;
				GFileInputStream* _tmp56_ = NULL;
				guint8* _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
				gssize _tmp58_ = 0L;
				gssize _tmp59_ = 0L;
				_tmp56_ = http_input;
				_tmp57_ = buf;
				_tmp57__length1 = buf_length1;
				_tmp58_ = g_input_stream_read ((GInputStream*) _tmp56_, _tmp57_, (gsize) _tmp57__length1, NULL, &_inner_error_);
				_tmp55_ = _tmp58_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_IO_ERROR) {
						goto __catch7_g_io_error;
					}
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				bytes_read = _tmp55_;
				_tmp59_ = bytes_read;
				if (_tmp59_ == ((gssize) 0)) {
					break;
				}
			}
			goto __finally7;
			__catch7_g_io_error:
			{
				GError* e = NULL;
				const gchar* _tmp60_ = NULL;
				GError* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				GError* _tmp63_ = NULL;
				const gchar* _tmp64_ = NULL;
				GError* _tmp65_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp60_ = url;
				_tmp61_ = e;
				_tmp62_ = _tmp61_->message;
				g_warning ("http.vala:76: Unable to read data from '%s': %s", _tmp60_, _tmp62_);
				_tmp63_ = e;
				_tmp64_ = _tmp63_->message;
				_tmp65_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_VFS, _tmp64_);
				_inner_error_ = _tmp65_;
				_g_error_free0 (e);
				goto __finally7;
			}
			__finally7:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == TG_HTTP_ERROR) {
					g_propagate_error (error, _inner_error_);
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					return NULL;
				} else {
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			{
				GdkPixbufLoader* _tmp66_ = NULL;
				guint8* _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gssize _tmp68_ = 0L;
				_tmp66_ = loader;
				_tmp67_ = buf;
				_tmp67__length1 = buf_length1;
				_tmp68_ = bytes_read;
				gdk_pixbuf_loader_write (_tmp66_, _tmp67_ + 0, (gsize) (((gint) _tmp68_) - 0), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch8_g_error;
				}
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp69_ = NULL;
				GError* _tmp70_ = NULL;
				const gchar* _tmp71_ = NULL;
				GError* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				GError* _tmp74_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp69_ = url;
				_tmp70_ = e;
				_tmp71_ = _tmp70_->message;
				g_warning ("http.vala:83: Unable to parse image from '%s': %s", _tmp69_, _tmp71_);
				_tmp72_ = e;
				_tmp73_ = _tmp72_->message;
				_tmp74_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, _tmp73_);
				_inner_error_ = _tmp74_;
				_g_error_free0 (e);
				goto __finally8;
			}
			__finally8:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == TG_HTTP_ERROR) {
					g_propagate_error (error, _inner_error_);
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					return NULL;
				} else {
					buf = (g_free (buf), NULL);
					_g_object_unref0 (loader);
					_g_object_unref0 (http_input);
					_g_object_unref0 (http_file);
					_g_free0 (url);
					_g_object_unref0 (channel);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	{
		GdkPixbufLoader* _tmp75_ = NULL;
		_tmp75_ = loader;
		gdk_pixbuf_loader_close (_tmp75_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp76_ = NULL;
		GError* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		GError* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		GError* _tmp81_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp76_ = url;
		_tmp77_ = e;
		_tmp78_ = _tmp77_->message;
		g_warning ("http.vala:91: Unable to parse image from '%s': %s", _tmp76_, _tmp78_);
		_tmp79_ = e;
		_tmp80_ = _tmp79_->message;
		_tmp81_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, _tmp80_);
		_inner_error_ = _tmp81_;
		_g_error_free0 (e);
		goto __finally9;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp82_ = loader;
	_tmp83_ = gdk_pixbuf_loader_get_pixbuf (_tmp82_);
	_tmp84_ = _g_object_ref0 (_tmp83_);
	pixbuf = _tmp84_;
	_tmp85_ = pixbuf;
	if (_tmp85_ == NULL) {
		const gchar* _tmp86_ = NULL;
		GError* _tmp87_ = NULL;
		_tmp86_ = url;
		g_warning ("http.vala:98: Pixbuf loader did not create a pixbuf from '%s'", _tmp86_);
		_tmp87_ = g_error_new_literal (TG_HTTP_ERROR, TG_HTTP_ERROR_PIXBUF, "");
		_inner_error_ = _tmp87_;
		if (_inner_error_->domain == TG_HTTP_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pixbuf);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			return NULL;
		} else {
			_g_object_unref0 (pixbuf);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (loader);
			_g_object_unref0 (http_input);
			_g_object_unref0 (http_file);
			_g_free0 (url);
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp88_ = pixbuf;
	pixbuf = NULL;
	result = _tmp88_;
	_g_object_unref0 (pixbuf);
	buf = (g_free (buf), NULL);
	_g_object_unref0 (loader);
	_g_object_unref0 (http_input);
	_g_object_unref0 (http_file);
	_g_free0 (url);
	_g_object_unref0 (channel);
	return result;
}



