C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LECRER
C                       *****************
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   LECTURE ET INTERPRETATION DU FICHIER syrthes.ray        *
C              Lecture de la correspondance entre references           *
C              et type de CL                                           *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! M  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "optct.h"
#include "xrefer.h"
#include "nlofes.h"
#include "nlofct.h"
C
C**********************************************************************
C
C
      INTEGER I,N,I1,I2,II1,II2,NB,LCH
C
      INTEGER ITAB(NRFMAX)
      CHARACTER*200 CHAINE,FORMA
C
C**********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      DO 1 I=1,NRFMAX
        IREFRA(I) = 0
        IRERCS(I) = 0
        IRERCF(I) = 0
        IRERTI(I) = 0
        IRERFI(I) = 0
        IRERPE(I) = 0
    1 CONTINUE
C
      DO 2 I=1,NRFMAX
         ITAB(I) = 0
    2 CONTINUE
C
C    
C
C     1- LECTURE DES REFERENCES DES CATEGORIES DE NOEUDS 
C     ==================================================
C
      REWIND(NFCLRA)
C
   10 CONTINUE
C
      CHAINE = ' '
      READ(NFCLRA,1000,END=999) CHAINE
C
      IF (CHAINE(1:1) .EQ. '/') GOTO 10
C
      CALL POSCOT(CHAINE,I1,I2,LCH)
C
      IF (I1 .EQ. 0) GOTO 10
C
C
C     1.2- NOEUDS SOLIDES AVEC RAYONNEMENT CONFINE
C     --------------------------------------------
      IF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS OU FACES SOLIDES AVEC RAYONNEMENT CONFINE')
     &   THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 120 N=1,NB
           IREFRA(ITAB(N)) = 1
  120    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 121 N=1,NRFMAX
             IREFRA(N) = 1
  121      CONTINUE
         ENDIF
C
C
C     1.3- REFERENCES NOEUDS FLUIDES PAROI EQUIVALENTE
C     --------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'REFERENCES NOEUDS FLUIDES PAROI EQUIVALENTE')
     &   THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 130 N=1,NB
           IREFRF(ITAB(N)) = 1
  130   CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 131 N=1,NRFMAX
             IREFRF(N) = 1
  131      CONTINUE
         ENDIF
C
C
C     1.4- RAYONNNEMENT : FACES COUPLEES AU SOLIDE
C     --------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'RAYONNEMENT : REFERENCES FACES COUPLEES AU SOLIDE') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 140 N=1,NB
           IRERCS(ITAB(N)) = 1
  140    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 141 N=1,NRFMAX
             IRERCS(N) = 1
  141      CONTINUE
         ENDIF
C
C     1.5- RAYONNNEMENT : NOEUDS OU FACES COUPLE(ES) AU FLUIDE
C     --------------------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'RAYONNEMENT : REFERENCES FACES PAROI EQUIVALENTE '//
     & 'COUPLEES AU FLUIDE') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 150 N=1,NB
           IRERCF(ITAB(N)) = 1
  150    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 151 N=1,NRFMAX
             IRERCF(N) = 1
  151      CONTINUE
         ENDIF
C
C
C     1.6- RAYONNNEMENT : FACES A TEMPERATURE IMPOSEE
C     -----------------------------------------------
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'RAYONNEMENT : REFERENCES FACES TEMPERATURE IMPOSEE') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 160 N=1,NB
           IRERTI(ITAB(N)) = 1
  160    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 161 N=1,NRFMAX
             IRERTI(N) = 1
  161      CONTINUE
         ENDIF
C
C
C     1.7- RAYONNNEMENT : FACES A FLUX IMPOSE
C     --------------------------------------- 
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'RAYONNEMENT : REFERENCES FACES FLUX IMPOSE') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 170 N=1,NB
           IRERFI(ITAB(N)) = 1
  170    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 171 N=1,NRFMAX
             IRERFI(N) = 1
  171      CONTINUE
         ENDIF
C
C
C     1.8- RAYONNNEMENT : FACES A PAROI EQUIVALENTE
C     --------------------------------------------- 
      ELSEIF ( CHAINE(I1:I2).EQ.
     & 'RAYONNEMENT : REFERENCES FACES PAROI EQUIVALENTE') THEN
C
         II1 = I2+2
         CALL POSLIS(CHAINE(I2+2:),NB,II1,II2,LCH)
         I1 = I2 + II1 + 1
         I2 = I1 + LCH - 1
         CALL CHFORM('I',CHAINE(I1:I2),LCH,NB,FORMA)
         READ(CHAINE(I1:I2),FORMA,ERR=9999) (ITAB(I),I=1,NB)
         IF (ITAB(1).EQ.0) NB = 0
C
         DO 180 N=1,NB
           IRERPE(ITAB(N)) = 1
  180    CONTINUE
C
         IF (ITAB(1).LE.-1) THEN
           DO 181 N=1,NRFMAX
             IRERPE(N) = 1
  181      CONTINUE
         ENDIF
C
C
      ENDIF
C
      GOTO 10
C
 999  CONTINUE
C
C     8- IMPRESSION POUR VERIFICATIONS
C     ================================
C
      IF (NBLBLR.GE.2) THEN
C
C
        NB = 0
        DO 810 N=1,NRFMAX
         IF (IREFRF(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  810   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8010) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 820 N=1,NRFMAX
         IF (IREFRA(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  820   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8020) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 830 N=1,NRFMAX
         IF (IRERCS(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  830   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8030) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 840 N=1,NRFMAX
         IF (IRERCF(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  840   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8040) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 850 N=1,NRFMAX
         IF (IRERTI(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  850   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8050) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 860 N=1,NRFMAX
         IF (IRERFI(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  860   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8060) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 870 N=1,NRFMAX
         IF (IRERPE(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  870   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8070) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 880 N=1,NRFMAX
         IF (IRESTE(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
  880   CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8080) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 881 N=1,NRFMAX
         IF (IRESTF(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
 881  CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8081) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 882 N=1,NRFMAX
         IF (IRESTS(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
 882  CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8082) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 883 N=1,NRFMAX
         IF (IRESTB(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
 883  CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8083) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
        NB = 0
        DO 884 N=1,NRFMAX
         IF (IRESTC(N).NE.0) THEN
            NB = NB + 1
            ITAB(NB) = N
         ENDIF
 884  CONTINUE
        IF (NB.NE.0) THEN
          WRITE(NFECRA,8084) 
          WRITE(NFECRA,8000) (ITAB(N),N=1,NB)
        ENDIF      
C
      ENDIF
C   
C
      GOTO 300
C
C     3. GESTION DES ERREURS DE LECTURE
C     =================================
C
 9999 WRITE(NFECRA,3000) CHAINE
      STOP
C
  300 CONTINUE
C
C--------
C FORMATS
C--------
 1000 FORMAT(A200)
C
 8000 FORMAT(3X,32I3,/)
 8010 FORMAT(/,' *** LECRER : REFERENCES DES NOEUDS DU FLUIDE ',
     &      'NON COUPLES MAIS SOUMIS AU RAYONNEMENT')
 8020 FORMAT(/,' *** LECRER : REFERENCES DES NOEUDS DU SOLIDE ',
     &         'AVEC RAYONNEMENT CONFINE')
 8030 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES COUPLEES ',
     &         'AU SOLIDE')
 8040 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES COUPLEES ',
     &         'AU FLUIDE (Traitement equivalent)')
 8050 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES ',
     &         'DE TYPE TEMPERATURE IMPOSEE')
 8060 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES ',
     &         'DE TYPE FLUX IMPOSE')
 8070 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES ',
     &         'DE TYPE PAROI EQUIVALENTE ISOLEE')
 8080 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES MSTS AVEC COEFF D''E'
     &        ,'CHANGE (OU ISOLEES)')
 8081 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES MSTS',
     &         'COUPLEES AU FLUIDE')
 8082 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES MSTS',
     &         'COUPLEES AU SOLIDE')
 8083 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES ',
     &         'EPAISSEUR DU MSTS')
 8084 FORMAT(/,' *** LECRER : MAILLAGE RAYONNEMENT ',/,
     &         '              REFERENCES DES FACES COUPLEES SOLIDE ',
     &         'CONTACT AVEC MSTS')
 3000 FORMAT(/,' %% ERREUR LECRER : Erreur dans le fichier de donnees',
     * /,20X,'au cours de la lecture des references',/,
     *   20X,'Ligne concernee : ',A)
C----
C FIN
C----
C
      RETURN
      END
