#include "stealth.ih"

void usage(std::string const &progname)
{
    cout <<
        progname << " by Frank B. Brokken (f.b.brokken@rug.nl)\n"
        "\n" <<
        progname << " V" << version << "\n"
        "SSH-based Trust Enhancement Acquired through a Locally Trusted "
                                                                    "Host\n"
        "Copyright (c) GPL " << year << "\n"
        "\n"
        "Usage 1:\n"
        "   " << progname << " options policy\n"
        "Where:\n"
        "   options: (long options between parentheses) select from:\n"
        "       -c: (--parse-config-file) process the config file,\n"
        "           no further action, report the results to std output.\n"
        "       -d: (--debug) write debug messages to std error\n"
        "       -e: (--echo-commands) echo commands to std error when they\n"
        "           are processed (implied by -d)\n"
        "       -h (--help): show this usage info\n"
        "       -i <interval>[m]: (--random-interval) start the "
                                            "scan between now and\n"
        "           a random interval of interval seconds, or minutes "
                                                "if an `m' is\n"
        "            appended to the specified interval.\n"
        "            Requires --repeat and --keep-alive.\n"
        "       -n: (--no-child-processes) no child processes are\n"
        "            executed: child actions are faked to be OK.\n"
        "       -o: (--only-stdout) scan report is written to "
                                    "stdout. No mail is sent.\n"
        "       -q: (--quiet) suppress progress messages to stderr.\n"
        "       -r <nr>: (--run-command) only run command <nr> "
                                                "(natural  number).\n"
        "       -s <skipfiles>: (--skip-files) skip the integrity checks of\n"
        "            files having their absolute path names listed in the "
                                                                    "file\n"
        "            'skipfiles'\n"
        "       -v: (--version): display version information (and exit).\n"
        "   --keep-alive pidfile: keep running as a daemon, wake up"
                                                   " at interrupts.\n"
        "   --max-size <size>[BKMG]: files retrieved by GET may at most\n"
        "           have <size> bytes (B), Kbytes (K), Mbytes (M), "
                                                                "Gbytes (G)\n"
        "           default: 10M, default spec. unit: B\n"
        "   --repeat <seconds>: keep running as a daemon, wake up at\n"
        "           interrupts. or after <seconds> seconds.\n"
        "           Requires --keep-alive.\n"
        "   --usage: provide this help (and exit)\n"
        "   --help: provide this help (and exit)\n"
        "   policy: path to the policyfile\n"
        "\n"
        "Usage 2:\n"
        "   " << progname << 
            " {--reload,--rerun,--resume,--suppress,--terminate} pidfile\n"
        "Where:\n"
        "   --reload: reload a " << progname << " process's configuration "
                                                                    "files\n"
        "   --rerun: restart a " << progname << " integrity scan\n"
        "   --resume: resume " << progname << " following --suppress\n"
        "   --suppress: suppress " << progname << " activities\n"
        "   --terminate: terminate " << progname << "\n"
        "   pidfile: file containing the pid of the stealth process to "
                                                                "rerun or\n"
        "            terminate.\n" <<
        "\n";
}
