/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;

public final class UIUtil {
    public static Window findDialogWindow(Component component) {
        Window result = null;
        Component comp = component;
        if (comp instanceof Window) {
            result = (Window)comp;
        } else {
            comp = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
            result = UIUtil.findDialogWindow(comp);
        }
        return result;
    }

    public static Frame findFrame(Component component) {
        Frame result = null;
        Component comp = component;
        if (comp instanceof JFrame) {
            result = (JFrame)comp;
        } else {
            comp = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
            result = UIUtil.findFrame(comp);
        }
        return result;
    }

    public static JPopupMenu findTopLevelPopupMenu(Component component) {
        JPopupMenu higher;
        JPopupMenu result = null;
        Component comp = component;
        if (component instanceof JPopupMenu) {
            result = (JPopupMenu)component;
            comp = result.getInvoker();
        } else {
            comp = component.getParent();
        }
        if (comp != null && (higher = UIUtil.findTopLevelPopupMenu(comp)) != null) {
            result = higher;
        }
        return result;
    }

    @Deprecated
    public static Point getLocationOnScreen(MouseEvent e) {
        Component comp = e.getComponent();
        Point screenCompLoc = comp.getLocationOnScreen();
        Point result = new Point(screenCompLoc.x + e.getX(), screenCompLoc.y + e.getY());
        return result;
    }

    private UIUtil() {
    }
}

