#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc FIRSTDef {} {
    global first
    global ifirst

    set ifirst(top) .first
    set ifirst(mb) .firstmb

    set first(sky) fk5
    set first(rformat) arcmin
    set first(width) 15
    set first(height) 15
    set first(mode) new
    set first(save) 0
    set first(valid) 1
    set first(survey) first
}

proc FIRSTDialog {} {
    global first
    global ifirst
    global wcs

    if [winfo exists $ifirst(top)] {
	raise $ifirst(top)
	return
    }

    set varname dfirst
    upvar #0 $varname var
    global $varname

    set var(top) $ifirst(top)
    set var(mb) $ifirst(mb)
    set var(sky) $first(sky)
    set var(skyformat) $wcs(skyformat)
    set var(rformat) $first(rformat)
    set var(width) $first(width)
    set var(height) $first(height)
    set var(mode) $first(mode)
    set var(save) $first(save)
    set var(valid) $first(valid)
    set var(survey) $first(survey)

    set w $var(top)
    IMGSVRInit $varname "VLA-FIRST [msgcat::mc {Server}]" FIRSTExec FIRSTAck

    IMGSVRUpdate $varname 1
}

proc FIRSTExec {varname} {
    upvar #0 $varname var
    global $varname

    if {$var(save)} {
	set var(fn) [SaveFileDialog savefitsfbox]
	if {$var(fn) == {}} {
	    return
	}

    } else {
	set var(fn) [tmpnam ds9first ".fits"]
    }

    # skyformat
    switch -- $var(skyformat) {
	degrees {
	    set xx [uformat d h: $var(x)]
	    set yy [uformat d d: $var(y)]
	}
	sexagesimal {
	    set xx $var(x)
	    set yy $var(y)
	}
    }

    # size - convert to arcmin
    switch -- $var(rformat) {
	degrees {
	    set ww [expr $var(width)*60.]
	    set hh [expr $var(height)*60.]
	}
	arcmin {
	    set ww $var(width)
	    set hh $var(height)
	}
	arcsec {
	    set ww [expr $var(width)/60.]
	    set hh [expr $var(height)/60.]
	}
    }

    # now to radius
    set rr [expr sqrt($ww*$ww+$hh*$hh)/2.]
    if {$rr>60} {
	set rr 60
    }

    set var(query) [http::formatQuery .submit "Extract the Cutout" RA "$xx $yy" Equinox J2000 ImageSize $rr MaxInt 10 .cgifields ImageType ImageType "FITS Image"]
    set var(url) "http://third.ucllnl.org/cgi-bin/firstcutout"
    IMGSVRLoad $varname
}

proc FIRSTAck {varname} {
    upvar #0 $varname var
    global $varname

set msg {Acknowledgments for the VLA FIRST 

This major undertaking has received the generous technical and
scientific support of many individuals. The NRAO staff has provided
extremely valuable assistance in many aspects of the observations
themselves and in the area of software support; in particular, we are
grateful to Rick Perley, Ken Sowinski, Barry Clark, and Bill Cotton in
this regard. The support of the NRAO Director, Paul van den Bout, and
the yeoman service provided by Frazer Owen as Chair of the Survey
Oversight Committee are also greatly appreciated. We also thank the
members of the Oversight Committee (Ken Chambers, Eric Feigelson,
Jackie Hewitt, Gillian Knapp, and Rogier Windhorst) for their time and
wise counsel in this enterprise.

Acknowledgment is also due our colleagues who are involved in the
ongoing FIRST effort, including Richard McMahon and Isobel Hook. This
work is supported in part under the auspices of the Department of
Energy by Lawrence Livermore National Laboratory under contract
No. W-7405-ENG-48 and the Institute for Geophysics and Planetary
Physics, whose director Charles Alcock has been particularly
supportive. We also acknowledge a generous planning grant from the
CalSpace Institute; support from the STScI archive group, STScI
director Bob Williams, and the STScI Director's Discretionary Research
Fund; computing resources from Columbia University; a grant from the
National Science Foundation; a gift of computing equipment from Sun
Microsystems; a NATO travel grant to support our collaboration with
Richard McMahon; and an award from the National Geographic Society
which, in the spirit of their support 40 years ago for the Palomar
Observatory Sky Survey, will be providing funds to continue our
charting of the Universe.
}

SimpleTextDialog ${varname}ack [msgcat::mc {Acknowledgment}] 80 40 insert top $msg
}

# Process Cmds

proc ProcessFIRSTCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    FIRSTDialog
    IMGSVRProcessCmd $varname $iname dfirst
}

proc ProcessSendFIRSTCmd {proc id param} {
    FIRSTDialog
    IMGSVRProcessSendCmd $proc $id $param dfirst
}
