# Rust by Example

[Rust][rust] is a modern systems programming language focusing on safety, speed,
and concurrency. It accomplishes these goals by being memory safe without using 
garbage collection.

Rust by Example (RBE) is a collection of runnable examples that illustrate various Rust
concepts and standard libraries. To get even more out of these examples, don't forget
to [install Rust locally][install] and check out the [official docs][std]. 
Additionally for the curious, you can also [check out the source code for this site][home].

Now let's begin!

- [Hello World](hello.md) - Start with a traditional Hello World program.

- [Primitives](primitives.md) - Learn about signed integers, unsigned integers and other primitives.

- [Custom Types](custom_types.md) - `struct` and `enum`.

- [Variable Bindings](variable_bindings.md) - mutable bindings, scope, shadowing.

- [Types](types.md) - Learn about changing and defining types.

- [Conversion](conversion.md)

- [Expressions](expression.md)

- [Flow of Control](flow_control.md) - `if`/`else`, `for`, and others.

- [Functions](fn.md) - Learn about Methods, Closures and Higher Order Functions.

- [Modules](mod.md) - Organize code using modules

- [Crates](crates.md) - A crate is a compilation unit in Rust. Learn to create a library.

- [Cargo](cargo.md) - Go through some basic features of the official Rust package management tool.

- [Attributes](attribute.md) - An attribute is metadata applied to some module, crate or item.

- [Generics](generics.md) - Learn about writing a function or data type which can work for multiple types of arguments.

- [Scoping rules](scope.md) - Scopes play an important part in ownership, borrowing, and lifetimes.

- [Traits](trait.md) - A trait is a collection of methods defined for an unknown type: `Self`

- [Macros](macros.md)

- [Error handling](error.md) - Learn Rust way of handling failures.

- [Std library types](std.md) - Learn about some custom types provided by `std` library.

- [Std misc](std_misc.md) - More custom types for file handling, threads.

- [Testing](testing.md) - All sorts of testing in Rust.

- [Unsafe Operations](unsafe.md)

- [Compatibility](compatibility.md)

- [Meta](meta.md) - Documentation, Benchmarking.


[rust]: https://www.rust-lang.org/
[install]: https://www.rust-lang.org/tools/install
[std]: https://doc.rust-lang.org/std/
[home]: https://github.com/rust-lang/rust-by-example
