
#include <phoneme.h>
#include <saynum.h>

/*
 * Integer to Readable ASCII Conversion Routine.
 *
 * Synopsis:
 *
 *      say_cardinal(value)
 *      	long int     value;          -- The number to output
 *
 *	The number is translated into a string of phonemes
 *
 */

static char *Cardinals[] = 
{
	" ZERO ",
	" ONE ",
	" TWO ",
	" THREE ",
	" FOUR ",
	" FIVE ",
	" SIX ",
	" SEVEN ",
	" EIGHT ",
	" NINE ",		
	" TEN ",
	" ELEVEN ",
	" TWELVE ",
	" THIRTEEN ",
	" FOURTEEN ",
	" FIFTEEN ",
	" SIXTEEN ",
	" SEVENTEEN ",
	" EIGHTEEN ",
	" NINETEEN "
};

static char *Twenties[] = 
{
	" TWENTY ",
	" THIRTY ",
	" FOURTY ",
	" FIFTY ",
	" SIXTY ",
	" SEVENTY ",
	" EIGHTY ",
	" NINETY "
};

static char *Ordinals[] = 
{
	" ZEROTH ",
	" FIRST ",
	" SECOND ",
	" THIRD ",
	" FOURTH ",
	" FIFTH ",
	" SIXTH ",
	" SEVENTH ",
	" EIGHTH ",
	" NINTH ",		
	" TENTH ",
	" ELEVENTH ",
	" TWELFTH ",
	" THIRTEENTH ",
	" FOURTEENTH ",
	" FIFTEENTH ",
	" SIXTEENTH ",
	" EVENTEENTH ",
	" EIGHTEENTH ",
	" NINETEENTH "
};

static char *Ord_twenties[] = 
{
	" TWENTIETH ",
	" THIRTIETH ",
	" FOURTIETH ",
	" FIFTIETH ",
	" SIXTIETH ",
	" SEVENTIETH ",
	" EIGHTIETH ",
	" NINETIETH "
};


/*
 * Translate a number to phonemes.  This version is for CARDINAL numbers.
 *	 Note: this is recursive.
 */

void
say_cardinal(value)
	long int value;
{
	if (value < 0)
	{
		xlate_word(" MINUS ");
		value = (-value);
		if (value < 0)
		{
			/* Overflow!  -32768 */
			xlate_word(" INFINITY ");
			return;
		}
	}

	if (value >= 1000000000L)
	{
		/* Billions */
		say_cardinal(value/1000000000L);
		xlate_word(" BILLION ");
		value = value % 1000000000;
		if (value == 0)
			/* Even billion */
			return;
		if (value < 100)
			/* as in THREE BILLION AND FIVE */
			xlate_word(" AND ");
	}

	if (value >= 1000000L)
	{
		/* Millions */
		say_cardinal(value/1000000L);
		xlate_word(" MILLION ");
		value = value % 1000000L;
		if (value == 0)
			/* Even million */
			return;
		if (value < 100)
			/* as in THREE MILLION AND FIVE */
			xlate_word(" AND ");
	}

	/* Thousands 1000..1099 2000..99999 */
	/* 1100 to 1999 is eleven-hunderd to ninteen-hunderd */
	if ((value >= 1000L && value <= 1099L) || value >= 2000L)
	{
		say_cardinal(value/1000L);
		xlate_word(" THOUSAND ");
		value = value % 1000L;
		if (value == 0)
			/* Even thousand */
			return;
		if (value < 100)
			/* as in THREE THOUSAND AND FIVE */
			xlate_word(" AND ");
	}

	if (value >= 100L)
	{
		xlate_word(Cardinals[value/100]);
		xlate_word(" HUNDRED ");
		value = value % 100;
		if (value == 0)
			/* Even hundred */
			return;
	}

	if (value >= 20)
	{
		xlate_word(Twenties[(value-20)/ 10]);
		value = value % 10;
		if (value == 0)
			/* Even ten */
			return;
	}

	xlate_word(Cardinals[value]);
} 


/*
 * Translate a number to phonemes.  This version is for ORDINAL numbers.
 *	 Note: this is recursive.
 */

void
say_ordinal(value)
	long int value;
{

	if (value < 0)
	{
		xlate_word(" MINUS ");
		value = (-value);
		if (value < 0)	/* Overflow!  -32768 */
		{
			xlate_word(" INFINITY ");
			return;
		}
	}

	if (value >= 1000000000L)
	{
		/* Billions */
		say_cardinal(value/1000000000L);
		value = value % 1000000000;
		if (value == 0)
		{
			xlate_word(" BILLIONTH ");
			/* Even billion */
			return;
		}
		xlate_word(" BILLION ");
		if (value < 100)
			/* as in THREE BILLION AND FIVE */
			xlate_word(" AND ");
	}

	if (value >= 1000000L)
	{
		/* Millions */
		say_cardinal(value/1000000L);
		value = value % 1000000L;
		if (value == 0)
		{
			xlate_word(" MILLIONTH ");
			/* Even million */
			return;
		}
		xlate_word(" MILLION ");
		if (value < 100)
			/* as in THREE MILLION AND FIVE */
			xlate_word(" AND ");
	}

	/* Thousands 1000..1099 2000..99999 */
	/* 1100 to 1999 is eleven-hunderd to ninteen-hunderd */
	if ((value >= 1000L && value <= 1099L) || value >= 2000L)
	{
		say_cardinal(value/1000L);
		value = value % 1000L;
		if (value == 0)
		{
			xlate_word(" THOUSANDTH ");
			/* Even thousand */
			return;
		}
		xlate_word(" THOUSAND ");
		if (value < 100)
			/* as in THREE THOUSAND AND FIVE */
			xlate_word(" AND ");
	}

	if (value >= 100L)
	{
		xlate_word(Cardinals[value/100]);
		value = value % 100;
		if (value == 0)
		{
			xlate_word(" TUNDREDTH ");
			/* Even hundred */
			return;
		}
		xlate_word(" HUNDRED ");
	}

	if (value >= 20)
	{
		if ((value%10) == 0)
		{
			xlate_word(Ord_twenties[(value-20)/ 10]);
			/* Even ten */
			return;
		}
		xlate_word(Twenties[(value-20)/ 10]);
		value = value % 10;
	}

	xlate_word(Ordinals[value]);
} 
