# Security Policies and Procedures

We take security seriously, and encourage everyone to use the last version of
radare2 from git if possible. We do not backport security fixes to old
releases.

Security bugs are considered top priority and a fix is required within 24 hours
of disclosure.

## Reporting a vulnerability

If you discover a security issue in radare2 (or any related project under the
radareorg umbrella), please submit a public issue in the [GitHub issue
section](https://github.com/radareorg/radare2/issues) repository for that
project.

If possible, we would appreciate a pull request with your suggested fix
instead of leaving it to a reproducer. This is typically faster than reporting
the error and explaining it for someone who can fix it.

See [Error diagnosis](DEVELOPERS.md#Error_diagnosis) for details.

## Disclosure policy

We don't believe in secrecy when security matters. Keeping the bugs for
yourself or for a limited amount of people results in a false sense of
security for the community.

We encourage full disclosure of any and all security bugs in radare2's codebase.

Please see the "Reporting a vulnerability" section above for information on how
to report a bug. If you do not have or can not create a GitHub account, you may
email the bug details to `pancake@nopcode.org` and we will create the issue and
fix on your behalf.

## Privacy

While we are able to publicly acknowledge you for your contribution to radare2
for helping us keep our software secure for users, if you so choose we will
keep your contribution anonymous.

To cover those situations we recommend you to create a GitHub, Telegram or IRC
accounts and report it in the public channel, DMs to the author are also fine.

## Bounties

There is currently no bug bounty program for r2.
