% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-normal.R
\docType{class}
\name{Zelig-normal-class}
\alias{Zelig-normal-class}
\alias{znormal}
\title{Normal Regression for Continuous Dependent Variables}
\arguments{
\item{model}{the name of a statistical model to estimate.
For a list of other supported models and their documentation see:
\url{http://docs.zeligproject.org/articles/}.}

\item{data}{the name of a data frame containing the variables
referenced in the formula or a list of multiply imputed data frames
each having the same variable names and row numbers (created by
\code{Amelia} or \code{\link{to_zelig_mi}}).}

\item{...}{additional arguments passed to \code{zelig},
relevant for the model to be estimated.}

\item{by}{a factor variable contained in \code{data}. If supplied,
\code{zelig} will subset
the data frame based on the levels in the \code{by} variable, and
estimate a model for each subset. This can save a considerable amount of
effort. You may also use \code{by} to run models using MatchIt
subclasses.}

\item{cite}{If is set to 'TRUE' (default), the model citation will be printed
to the console.}

\item{below}{(defaults to 0) The point at which the dependent variable is censored from below. If any values in the dependent variable are observed to be less than the censoring point, it is assumed that that particular observation is censored from below at the observed value. (See for a Bayesian implementation that supports both left and right censoring.)}

\item{robust}{defaults to FALSE. If TRUE, zelig() computes robust standard errors based on sandwich estimators (see and ) and the options selected in cluster.}

\item{if}{robust = TRUE, you may select a variable to define groups of correlated observations. Let x3 be a variable that consists of either discrete numeric values, character strings, or factors that define strata. Then
z.out <- zelig(y ~ x1 + x2, robust = TRUE, cluster = "x3", model = "tobit", data = mydata)
means that the observations can be correlated within the strata defined by the variable x3, and that robust standard errors should be calculated according to those clusters. If robust = TRUE but cluster is not specified, zelig() assumes that each observation falls into its own cluster.}

\item{formula}{a model fitting formula}
}
\value{
Depending on the class of model selected, \code{zelig} will return
  an object with elements including \code{coefficients}, \code{residuals},
  and \code{formula} which may be summarized using
  \code{summary(z.out)} or individually extracted using, for example,
  \code{coef(z.out)}. See
  \url{http://docs.zeligproject.org/articles/getters.html} for a list of
  functions to extract model components. You can also extract whole fitted
  model objects using \code{\link{from_zelig_model}}.
}
\description{
Normal Regression for Continuous Dependent Variables
}
\details{
Additional parameters avaialable to this model include:
\itemize{
  \item \code{weights}: vector of weight values or a name of a variable in the dataset
  by which to weight the model. For more information see:
  \url{http://docs.zeligproject.org/articles/weights.html}.
  \item \code{bootstrap}: logical or numeric. If \code{FALSE} don't use bootstraps to
  robustly estimate uncertainty around model parameters due to sampling error.
  If an integer is supplied, the number of boostraps to run.
  For more information see:
  \url{http://docs.zeligproject.org/articles/bootstraps.html}.
}
}

\examples{
data(macro)
z.out1 <- zelig(unem ~ gdp + capmob + trade, model = "normal",
data = macro)
summary(z.out1)
x.high <- setx(z.out1, trade = quantile(macro$trade, 0.8))
x.low <- setx(z.out1, trade = quantile(macro$trade, 0.2))
s.out1 <- sim(z.out1, x = x.high, x1 = x.low)
summary(s.out1)
plot(s.out1)


}
\seealso{
Vignette: \url{http://docs.zeligproject.org/articles/zelig_normal.html}
}
