% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umify.R
\name{umify}
\alias{umify}
\title{Quantile normalization of cell-level data to match typical UMI count data}
\usage{
umify(counts)
}
\arguments{
\item{counts}{A matrix of class dgCMatrix with genes as rows and columns as cells}
}
\value{
A UMI-fied count matrix
}
\description{
Quantile normalization of cell-level data to match typical UMI count data
}
\section{Details}{

sctransform::vst operates under the assumption that gene counts approximately 
follow a Negative Binomial dristribution. For UMI-based data that seems to be 
the case, however, non-UMI data does not behave in the same way. 
In some cases it might be better to to apply a transformation to such data 
to make it look like UMI data. This function applies such a transformation function.

Cells in the input matrix are processed independently. For each cell
the non-zero data is transformed to quantile values. Based on the number of genes 
detected a smooth function is used to predict the UMI-like counts.

The functions have be trained on various public data sets and come as part of the 
package (see umify_data data set in this package).
}

\examples{
\donttest{
silly_example <- umify(pbmc)
}
}
