% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsei.R
\name{hfti}
\alias{hfti}
\title{Least Squares Solution using Householder Transformation}
\usage{
hfti(a, b, tol = 1e-07)
}
\arguments{
\item{a}{Design matrix.}

\item{b}{Response vector or matrix.}

\item{tol}{Tolerance for determining the pseudorank.}
}
\value{
\item{b}{first \code{krank} elements contains the solution}
\item{krank}{psuedo-rank} \item{rnorm}{Euclidean norm of the residual
vector.}
}
\description{
Solves the least squares problem using Householder forward triangulation
with column interchanges. It is an R interface to the HFTI function that is
described in Lawson and Hanson (1974, 1995). Its Fortran implementation is
public domain and is available at \url{http://www.netlib.org/lawson-hanson/}.
}
\details{
Given matrix \code{a} and vector \code{b}, \code{hfti} solves the least
squares problem:

\deqn{\mathrm{minimize\ \ } || a x - b ||.}{minimize || a x - b ||.}
}
\examples{

a = matrix(rnorm(10*4), nrow=10)
b = a \%*\% c(0,1,-1,1) + rnorm(10)
hfti(a, b)

}
\references{
Lawson and Hanson (1974, 1995). Solving least squares problems.
Englewood Cliffs, N.J., Prentice-Hall.
}
\seealso{
\code{\link{lsei}}, \code{\link{nnls}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{algebra}
\keyword{array}
