% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{pkg_lifecycle_statuses}
\alias{pkg_lifecycle_statuses}
\alias{lint_lifecycle}
\alias{lint_tidyverse_lifecycle}
\title{Lint usages of functions that have a non-stable life cycle.}
\usage{
pkg_lifecycle_statuses(
  package,
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired")
)

lint_lifecycle(
  packages,
  path = ".",
  pattern = "[.][Rr](md)?",
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired")
)

lint_tidyverse_lifecycle(
  path = ".",
  pattern = "[.][Rr](md)?",
  which = c("superseded", "deprecated", "questioning", "defunct", "experimental",
    "soft-deprecated", "retired")
)
}
\arguments{
\item{package}{The name of an installed package.}

\item{which}{The lifecycle statuses to retrieve.
Include \code{NA} if you want to include functions without a specified lifecycle
status in the results.}

\item{packages}{One or more installed packages to query for lifecycle statuses.}

\item{path}{The directory path to the files you want to search.}

\item{pattern}{Any files matching this pattern will be searched. The default
searches any files ending in \code{.R} or \code{.Rmd}.}
}
\description{
\itemize{
\item \code{lint_lifecycle} dynamically queries the package documentation for packages
in \code{packages} for lifecycle annotations and then searches the directory in
\code{path} for usages of those functions.
\item \code{lint_tidyverse_lifecycle} is a convenience function to call \code{lint_lifecycle}
for all the packages in the tidyverse.
\item \code{pkg_lifecycle_statuses} returns a data frame of functions with lifecycle
annotations for an installed package.
}
}
