% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classes.R
\docType{class}
\name{DiversityCurve-class}
\alias{DiversityCurve-class}
\alias{DiversityCurve}
\alias{print,DiversityCurve-method}
\alias{DiversityCurve-method}
\alias{plot,DiversityCurve,missing-method}
\alias{plot,DiversityCurve,numeric-method}
\title{S4 class defining a diversity curve}
\usage{
\S4method{print}{DiversityCurve}(x)

\S4method{plot}{DiversityCurve,missing}(x, y, ...)

\S4method{plot}{DiversityCurve,numeric}(x, y, ...)
}
\arguments{
\item{x}{DiversityCurve object}

\item{y}{diversity order to plot (q).}

\item{...}{arguments to pass to \link{plotDiversityCurve} or \link{plotDiversityTest}.}
}
\description{
\code{DiversityCurve} defines diversity (\eqn{D}) scores over multiple diversity 
orders (\eqn{Q}).
}
\section{Slots}{

\describe{
\item{\code{diversity}}{data.frame defining the diversity curve with the following columns:
\itemize{
  \item  \code{GROUP}:    group label.
  \item  \code{Q}:        diversity order.
  \item  \code{D}:        mean diversity index over all bootstrap 
                          realizations.
  \item  \code{D_SD}:     standard deviation of the diversity index 
                          over all bootstrap realizations.
  \item  \code{D_LOWER}:  diversity lower confidence inverval bound.
  \item  \code{D_UPPER}:  diversity upper confidence interval bound.
  \item  \code{E}:        evenness index calculated as \code{D} 
                          divided by \code{D} at \code{Q=0}.
  \item  \code{E_LOWER}:  evenness lower confidence inverval bound.
  \item  \code{E_UPPER}:  eveness upper confidence interval bound.
}}

\item{\code{tests}}{data.frame describing the significance test results with columns:
\itemize{
  \item  \code{TEST}:        string listing the two groups tested.
  \item  \code{DELTA_MEAN}:  mean of the \eqn{D} bootstrap delta 
                             distribution for the test.
  \item  \code{DELTA_SD}:    standard deviation of the \eqn{D} 
                             bootstrap delta distribution for the test.
  \item  \code{PVALUE}:      p-value for the test.
}}

\item{\code{group_by}}{string specifying the name of the grouping column in diversity calculation.}

\item{\code{groups}}{vector specifying the names of unique groups in group column in diversity calculation.}

\item{\code{method}}{string specifying the type of diversity calculated.}

\item{\code{q}}{vector of diversity hill diversity indices used for computing diversity.}

\item{\code{n}}{numeric vector indication the number of sequences sampled in each group.}

\item{\code{ci}}{confidence interval defining the upper and lower bounds 
(a value between 0 and 1).}
}}

