% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMOFA.R
\name{createMOFAobject}
\alias{createMOFAobject}
\title{Initialize a MOFA object}
\usage{
createMOFAobject(data)
}
\arguments{
\item{data}{either a \code{\link{MultiAssayExperiment}}
or a list of matrices with features as rows and samples as columns.}
}
\value{
Returns an untrained \code{\link{MOFAmodel}} object. \cr
Next step is to define the training, model and data processing options (see  \code{\link{prepareMOFA}})
}
\description{
Method to initialize a \code{\link{MOFAmodel}} object with a multi-omics data set.
}
\details{
If the multi-omics data is provided as a list of matrices, please make sure that features 
are stored as rows and samples are stored as columns. \cr 
If the matrices have sample names, we will use them to match the different matrices,
 filling the corresponding missing values. \cr
If matrices have no column names, all matrices must have the same number of columns,
 and you are responsible for filling any missing values.
}
\examples{
# Option 1: Create a MOFAobject from a list of matrices, features in rows and samples in columns.
data("CLL_data", package = "MOFAdata")
MOFAobject <- createMOFAobject(CLL_data)

# Option 2: Create a MOFAobject from a MultiAssayExperiment
library(MultiAssayExperiment)
data("CLL_data", package = "MOFAdata")
data("CLL_covariates", package = "MOFAdata")
mae_CLL <- MultiAssayExperiment(experiments = CLL_data, colData = CLL_covariates)
MOFAobject <- createMOFAobject(mae_CLL)

# next, this object can be passed to prepareMOFA and runMOFA
# (training in runMOFA can take some time):
\dontrun{
# MOFAobject <- prepareMOFA(MOFAobject)
# MOFAobject <- runMOFA(MOFAobject)
}
}
