#include "rxwidget.h"
#include "ui_rxwidget.h"

#include "global.h"
#include "dispatcher.h"
#include "configparams.h"
//#include "configdialog.h"
#include "supportfunctions.h"
#include "widgets/qvumeter.h"
#include "rxfunctions.h"
#include "filterparam.h"
//#ifndef QT_NO_DEBUG
//#include "scopeview.h"
//#endif
#include <QSettings>
#include <QCloseEvent>

rxWidget::rxWidget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::rxWidget)
{
    ui->setupUi(this);
}

rxWidget::~rxWidget()
{
    delete ui;
}

void rxWidget::init()
{
  int i;
  ui->sstvModeComboBox->addItem("Auto");
  for(i=0;i<NUMSSTVMODES-1;i++)
    {
      ui->sstvModeComboBox->addItem(getSSTVModeNameLong((esstvMode)i));
    }
  for(i=0;i<NUMFAXMODES;i++)
    {
      ui->faxModeComboBox->addItem(getFAXModeNameLong((efaxMode)i));
    }
  for(i=0;i<NUMRXFILTERS;i++)
    {
      ui->filterComboBox->addItem(filterStruct[i].filterName);
    }
  ui->faxComboBox->addItem("SSTV");
  ui->faxComboBox->addItem("FAX");
  readSettings();
  initView();
  initActions();
  ui->imageFrame->enablePopup(FALSE);
}

//void rxWidget::closeEvent ( QCloseEvent *e )
//{
//  slotExit();
//  e->ignore();
//}



void rxWidget::readSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("RX");
  useVIS=qSettings.value("useVIS",FALSE).toBool();
  autoSlantAdjust=qSettings.value("autoSlantAdjust",FALSE).toBool();
  autoSave=qSettings.value("autoSave",TRUE).toBool();
  //dxMode=qSettings.value("dxMode",FALSE).toBool();
  squelch=qSettings.value("squelch",1).toInt();
  filterIndex=(qSettings.value("filterIndex",0)).toInt();
  modeComboBoxIndexSSTV=((esstvMode)qSettings.value("modeComboBoxIndexSSTV",0).toInt());
  modeIndexFAX=((efaxMode)qSettings.value("modeIndexFAX",0).toInt());
  selectFax=qSettings.value("selectFax",FALSE).toBool();


// reead custom setting
  rxFAXParam.modulation=qSettings.value("modulation",0).toInt();
  rxFAXParam.aptStartFreq=qSettings.value("aptStartFreq",300).toInt();
  rxFAXParam.aptStartDuration=qSettings.value("aptStartDuration",5).toInt();
  rxFAXParam.aptStopFreq=qSettings.value("aptStopFreq",450).toInt();
  rxFAXParam.aptStopDuration=qSettings.value("aptStopDuration",5).toInt();
  rxFAXParam.colorMode=qSettings.value("colorMode",1).toInt();
  rxFAXParam.deviation=qSettings.value("deviation",400).toInt();
  rxFAXParam.inverted=qSettings.value("inverted",FALSE).toBool();
  rxFAXParam.ioc=qSettings.value("ioc",288).toInt();
  rxFAXParam.lpm=qSettings.value("lpm",120.).toDouble();
  rxFAXParam.numberOfDisplayLines=qSettings.value("numberOfDisplayLines",480).toInt();
  rxFAXParam.numberOfPhasingLines=qSettings.value("numberOfPhasingLines",20).toInt();
  rxFAXParam.subcarrier=qSettings.value("subcarrier",1900).toInt();

  copyCustomParam(FALSE);
  slotSetParams();
  qSettings.endGroup();
}

void rxWidget::writeSettings()
{
  QSettings qSettings;
  qSettings.beginGroup("RX");
  slotGetParams();
  qSettings.setValue( "useVIS",useVIS);
  qSettings.setValue( "autoSlantAdjust",autoSlantAdjust);
  qSettings.setValue( "autoSave",autoSave);
  //qSettings.setValue( "dxMode",dxMode);
  qSettings.setValue( "squelch",squelch);
  qSettings.setValue( "modeComboBoxIndexSSTV", modeComboBoxIndexSSTV);
  qSettings.setValue( "modeIndexFAX", modeIndexFAX);
  qSettings.setValue( "selectFax", selectFax);
  qSettings.setValue( "filterIndex", filterIndex);
  if(modeIndexFAX==FAXCUSTOM)
    {
      qSettings.setValue("modulation",(int)rxFAXParam.modulation);
      qSettings.setValue("aptStartFreq",rxFAXParam.aptStartFreq);
      qSettings.setValue("aptStartDuration",rxFAXParam.aptStartDuration);
      qSettings.setValue("aptStopFreq",rxFAXParam.aptStopFreq);
      qSettings.setValue("aptStopDuration",rxFAXParam.aptStopDuration);
      qSettings.setValue("colorMode",(int)rxFAXParam.colorMode);
      qSettings.setValue("deviation",rxFAXParam.deviation);
      qSettings.setValue("inverted",rxFAXParam.inverted);
      qSettings.setValue("ioc",(int)rxFAXParam.ioc);
      qSettings.setValue("lpm",rxFAXParam.lpm);
      qSettings.setValue("numberOfDisplayLines",(int)rxFAXParam.numberOfDisplayLines);
      qSettings.setValue("numberOfPhasingLines",(int)rxFAXParam.numberOfPhasingLines);
      qSettings.setValue("subcarrier",rxFAXParam.subcarrier);
    }
  qSettings.endGroup();
}

void rxWidget::slotGetParams()
{
  getValue(useVIS,ui->useVISCheckBox);
  getValue(autoSlantAdjust,ui->autoSlantAdjustCheckBox);
  getValue(autoSave,ui->autoSaveCheckBox);
  //getValue(dxMode,ui->dxModeCheckBox);
  getValue(squelch,ui->squelchSpinBox);
  getIndex(filterIndex,ui->filterComboBox);
  if(filterIndex<0) filterIndex=0;
  modeComboBoxIndexSSTV=(esstvMode)(ui->sstvModeComboBox->currentIndex());
  modeIndexFAX=(efaxMode)(ui->faxModeComboBox->currentIndex());
  selectFax=(ui->faxComboBox->currentIndex()==1);
  //directly setup activeFAXParams
  getIndex((int &)rxFAXParam.modulation,ui->modulationComboBox);
  getValue((int &)rxFAXParam.aptStartFreq,ui->aptStartFreqSpinBox);
  getValue(rxFAXParam.aptStartDuration,ui->aptStartDurationSpinBox);
  getValue(rxFAXParam.aptStopFreq,ui->aptStopFreqSpinBox);
  getValue(rxFAXParam.aptStopDuration,ui->aptStopDurationSpinBox);
  getIndex((int &)rxFAXParam.colorMode,ui->colorModeComboBox);
  getValue(rxFAXParam.deviation,ui->deviationSpinBox);
  getValue(rxFAXParam.inverted,ui->polarityCheckBox);
  getValue((int &)rxFAXParam.ioc,ui->iocSpinBox);
  getValue((double &)rxFAXParam.lpm,ui->lpmLineEdit);
  getValue((int &)rxFAXParam.numberOfDisplayLines,ui->linesSpinBox);
  getValue((int &)rxFAXParam.numberOfPhasingLines,ui->phasingLinesSpinBox);
  getValue(rxFAXParam.subcarrier,ui->subcarrierSpinBox);
  if(modeIndexFAX==FAXCUSTOM)
    {
      copyCustomParam(FALSE);
    }
  if(selectFax)
    {

      ui->sstvModeComboBox->setEnabled(FALSE);
      ui->faxModeComboBox->setEnabled(TRUE);
      ui->settingsTableWidget->setCurrentIndex(1);
    }
  else
    {
      ui->sstvModeComboBox->setEnabled(TRUE);
      ui->faxModeComboBox->setEnabled(FALSE);
      ui->settingsTableWidget->setCurrentIndex(0);
    }

}

void rxWidget::slotSetParams()
{

//	initializeFAXParametersIndex(modeIndexFAX);
  setValue(useVIS,ui->useVISCheckBox);
  setValue(autoSlantAdjust,ui->autoSlantAdjustCheckBox);
  setValue(autoSave,ui->autoSaveCheckBox);
  //setValue(dxMode,ui->dxModeCheckBox);
  setValue(squelch,ui->squelchSpinBox);
  setIndex(filterIndex,ui->filterComboBox);

  setIndex(((int)modeComboBoxIndexSSTV),ui->sstvModeComboBox);
  setIndex(((int)modeIndexFAX),ui->faxModeComboBox);

  setIndex(rxFAXParam.modulation,ui->modulationComboBox);
  setValue(rxFAXParam.aptStartFreq,ui->aptStartFreqSpinBox);
  setValue(rxFAXParam.aptStartDuration,ui->aptStartDurationSpinBox);
  setValue(rxFAXParam.aptStopFreq,ui->aptStopFreqSpinBox);
  setValue(rxFAXParam.aptStopDuration,ui->aptStopDurationSpinBox);
  setIndex(rxFAXParam.colorMode,ui->colorModeComboBox);
  setValue(rxFAXParam.deviation,ui->deviationSpinBox);
  setValue(rxFAXParam.inverted,ui->polarityCheckBox);
  setValue(rxFAXParam.ioc,ui->iocSpinBox);
  setValue(rxFAXParam.lpm,ui->lpmLineEdit);
  setValue(rxFAXParam.numberOfDisplayLines,ui->linesSpinBox);
  setValue(rxFAXParam.numberOfPhasingLines,ui->phasingLinesSpinBox);
  setValue(rxFAXParam.subcarrier,ui->subcarrierSpinBox);
  if(selectFax)
    {
      setIndex(1,ui->faxComboBox);
    }
  else setIndex(0,ui->faxComboBox);
}

void rxWidget::initView()
{
  QImage t(":/icons/splash.png");
  ui->imageFrame->open(t);
  rxViewer=ui->imageFrame;
  ui->syncWidget->setMaxValue(10.);
  ui->syncWidget->setMinValue(0.);
  ui->syncWidget->setColorHigh(Qt::green);
  ui->syncWidget->setColorLow(Qt::red);


//	ui->imageFrame->repaint();
}


void rxWidget::initActions()
{
  connect(ui->saveToolButton, SIGNAL(clicked()),SLOT(slotSaveImage()));
  connect(ui->startToolButton, SIGNAL(clicked()),SLOT(slotStartRX()));
  connect(ui->stopToolButton, SIGNAL(clicked()),SLOT(slotStopRX()));
  connect(ui->resyncToolButton, SIGNAL(clicked()),SLOT(slotResyncRX()));

  connect(ui->autoSlantAdjustCheckBox,SIGNAL(stateChanged(int)),SLOT(slotAdjustChanged(int)));
  connect(ui->useVISCheckBox,SIGNAL(stateChanged(int)),SLOT(slotUseVISChanged(int)));
  //connect(ui->dxModeCheckBox,SIGNAL(stateChanged(int)),SLOT(slotDXModeChanged(int)));
  connect(ui->faxComboBox,SIGNAL(activated(int)),SLOT(slotGetParams()));
  connect(ui->filterComboBox,SIGNAL(currentIndexChanged(int)),SLOT(slotFilterChanged(int)));
  connect(ui->squelchSpinBox,SIGNAL(valueChanged(int)),SLOT(slotSquelchChanged(int)));
  slotGetParams();
}



void rxWidget::slotStartRX()
{
  slotGetParams();
  dispatchPtr->startRX();
  statusBarPtr->showMessage("Starting Receive");
}


void rxWidget::slotStopRX()
{
  bool done;
  slotGetParams();
  statusBarPtr->showMessage("Stopping Receive");
  stopRxTxEvent *ce= new stopRxTxEvent;
  ce->waitFor(&done);
  QApplication::postEvent( dispatchPtr, ce );  // Qt will delete it when done
  while(!done)
  {
    QApplication::processEvents(QEventLoop::AllEvents,1);
  }

  //dispatchPtr->stopRXTX();

}

void rxWidget::slotResyncRX()
{
  slotGetParams();
  dispatchPtr->resyncRX();
  statusBarPtr->showMessage("Resync Receive");
}



void rxWidget::slotAdjustChanged(int b)
{
  autoSlantAdjust=b;
}

void rxWidget::slotUseVISChanged(int b)
{
  useVIS=b;
}

//void rxWidget::slotDXModeChanged(int b)
//{
//   dxMode=b;
//}

void rxWidget::slotSaveImage()
{
  dispatchPtr->saveRxImage();
}





void rxWidget::slotFilterChanged(int fIndex)
{
  filterIndex=fIndex;
  filterRXChangedEvent *stce= new filterRXChangedEvent(fIndex);
  QApplication::postEvent( dispatchPtr, stce );  // Qt will delete it when done
}

void rxWidget::slotSquelchChanged(int sql)
{
 squelch=sql;
}


