//
// C++ Implementation: qcskysystem
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "qcskysystem.hpp"
#include "camera.hpp"

qcSkySystem::qcSkySystem(QObject *parent, Camera * context)
: QObject(parent)
{
  my_context = context;
  nplanets      = 0 ;
  planet_data   = NULL ;
  nstars        = 1000 ;
  star_data     = NULL ;

  m_log01 = -log( 0.01 );
  sqrt_m_log01 = sqrt( m_log01 );

  myblack[0]             = 0.0;
  myblack[1]             = 0.0;
  myblack[2]             = 0.0;
  myblack[3]             = 1.0;
// sgVec4( 1.0, 1.0, 1.0, 1.0 )
  mywhite[0]             = 1.0;
  mywhite[1]             = 1.0;
  mywhite[2]             = 1.0;
  mywhite[3]             = 1.0;

//static sgVec4 translucent_white = { 1.0, 1.0, 1.0, 0.8 } ;
// sgVec4 { 0.39, 0.5, 0.74, 1.0 }
  base_sky_color[0]    = 0.39;
  base_sky_color[1]    = 0.5;
  base_sky_color[2]    = 0.74;
  base_sky_color[3]    = 1.0;
// sgVec4  { 0.84, 0.87, 1.0, 1.0 }
  base_fog_color[0]    = 0.84;
  base_fog_color[1]    = 0.87;
  base_fog_color[2]    = 1.00;
  base_fog_color[3]    = 1.00;
// sgVec4  { 0.2, 0.2, 0.2, 1.0 }
  base_ambient[0]      = 0.2;
  base_ambient[1]      = 0.2;
  base_ambient[2]      = 0.2;
  base_ambient[3]      = 1.0;

// sgVec4  { 1.0, 1.0, 1.0, 1.0 }
  base_diffuse[0]      = 1.0;
  base_diffuse[1]      = 1.0;
  base_diffuse[2]      = 1.0;
  base_diffuse[3]      = 1.0;
// sgVec4  { 1.0, 1.0, 1.0, 1.0 }
  base_specular[0]     = 1.0;
  base_specular[1]     = 1.0;
  base_specular[2]     = 1.0;
  base_specular[3]     = 1.0;

  star_data = add_stardata(nstars);
  build ( 80000, 80000, nplanets, planet_data, nstars, star_data );
}


qcSkySystem::~qcSkySystem()
{
}

void qcSkySystem::update( float dt )
{
      my_context->getCameraPosition ( campos.xyz );
      repositionFlat ( campos.xyz, 0, dt );
      modifyVisibility ( campos.xyz[SG_Z], dt );

      double sun_angle = getBody(0)->getAngle();
      double sky_brightness = (1.0 + cos(sun_angle))/2.0; // 0.0 - 1.0
      double scene_brightness = pow(sky_brightness,0.5);
        /* set sky color */
      sky_color[0] = base_sky_color[0] * sky_brightness;
      sky_color[1] = base_sky_color[1] * sky_brightness;
      sky_color[2] = base_sky_color[2] * sky_brightness;
      sky_color[3] = base_sky_color[3];

        /* set cloud and fog color */
      cloud_color[0] = fog_color[0] = base_fog_color[0] * sky_brightness;
      cloud_color[1] = fog_color[1] = base_fog_color[1] * sky_brightness;
      cloud_color[2] = fog_color[2] = base_fog_color[2] * sky_brightness;
      cloud_color[3] = fog_color[3] = base_fog_color[3];

        /* repaint the sky */
      repaint ( sky_color, fog_color, cloud_color, sun_angle, nplanets, planet_data, nstars, star_data );

        /* set light source */
      sgCoord sunpos;
//      bodies[0] -> getPosition ( & sunpos );
      getBody(0)-> getPosition ( & sunpos );
      ssgGetLight ( 0 ) -> setPosition ( sunpos.xyz ) ;

      scene_ambient[0] = base_ambient[0] * scene_brightness;
      scene_ambient[1] = base_ambient[1] * scene_brightness;
      scene_ambient[2] = base_ambient[2] * scene_brightness;
      scene_ambient[3] = 1.0;

      scene_diffuse[0] = base_diffuse[0] * scene_brightness;
      scene_diffuse[1] = base_diffuse[1] * scene_brightness;
      scene_diffuse[2] = base_diffuse[2] * scene_brightness;
      scene_diffuse[3] = 1.0;

      scene_specular[0] = base_specular[0] * scene_brightness;
      scene_specular[1] = base_specular[1] * scene_brightness;
      scene_specular[2] = base_specular[2] * scene_brightness;
      scene_specular[3] = 1.0;
      // GL_LIGHT_MODEL_AMBIENT has a default non-zero value so if
      // we only update GL_AMBIENT for our lights we will never get
      // a completely dark scene.  So, we set GL_LIGHT_MODEL_AMBIENT
      // explicitely to black.
      glLightModelfv( GL_LIGHT_MODEL_AMBIENT, myblack );
      ssgGetLight( 0 ) -> setColour( GL_AMBIENT, scene_ambient );
      ssgGetLight( 0 ) -> setColour( GL_DIFFUSE, scene_diffuse );
      ssgGetLight( 0 ) -> setColour( GL_SPECULAR, scene_specular );
}

void qcSkySystem::slot_update( float dt )
{
    update(dt);
}

void qcSkySystem::slot_preDraw()
{
    // Sky Fog
    /* Adjust fog based on visibility (when in clouds) */
    glClearColor ( fog_color[0], fog_color[1], fog_color[2], fog_color[3] ) ;
    glClear  ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;
    GLfloat fog_exp2_density = sqrt_m_log01 / getVisibility();
    glEnable( GL_FOG );
    glFogf  ( GL_FOG_DENSITY, fog_exp2_density);
    glFogi  ( GL_FOG_MODE,    GL_EXP2 );
    glFogfv ( GL_FOG_COLOR,   fog_color );
    // we need a white diffuse light for the phase of the moon
    ssgGetLight( 0 ) -> setColour( GL_DIFFUSE, mywhite );
    preDraw  ( );
    // return to the desired diffuse color
    ssgGetLight( 0 ) -> setColour( GL_DIFFUSE, scene_diffuse );
}

void qcSkySystem::slot_postDraw()
{
    my_context->getCameraPosition ( campos.xyz );
    postDraw ( campos.xyz[SG_Z] ); /* altitude */
    glDisable ( GL_FOG ) ;
}

sgdVec3* qcSkySystem::add_stardata(int nstars)
{
  sgdVec3 *star_data = new sgdVec3[nstars] ;
  for ( int a = 0; a < nstars; a++ )
  {
    star_data[a][0] = ssgaRandom() * SGD_PI ;
    star_data[a][1] = ssgaRandom() * SGD_PI ;
    star_data[a][2] = ssgaRandom() ;
  }
  return (star_data);
}
