# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AssessmentModeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the assessment mode."""

    IMAGE_DEFAULT = "ImageDefault"
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class InstanceViewTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """InstanceViewTypes."""

    INSTANCE_VIEW = "instanceView"


class PatchModeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the patch mode."""

    IMAGE_DEFAULT = "ImageDefault"
    AUTOMATIC_BY_PLATFORM = "AutomaticByPlatform"
    AUTOMATIC_BY_OS = "AutomaticByOS"
    MANUAL = "Manual"


class PublicNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The network access policy to determine if Azure Arc agents can use public Azure Arc service
    endpoints. Defaults to disabled (access to Azure Arc services only via private link).
    """

    ENABLED = "Enabled"
    """Allows Azure Arc agents to communicate with Azure Arc services over both public (internet) and
    #: private endpoints."""
    DISABLED = "Disabled"
    """Does not allow Azure Arc agents to communicate with Azure Arc services over public (internet)
    #: endpoints. The agents must use the private link."""


class StatusLevelTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The level code."""

    INFO = "Info"
    WARNING = "Warning"
    ERROR = "Error"


class StatusTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the hybrid machine agent."""

    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    ERROR = "Error"
