# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._authorization_management_client_enums import *


class ApprovalSettings(msrest.serialization.Model):
    """The approval settings.

    :param is_approval_required: Determine whether approval is required or not.
    :type is_approval_required: bool
    :param is_approval_required_for_extension: Determine whether approval is required for
     assignment extension.
    :type is_approval_required_for_extension: bool
    :param is_requestor_justification_required: Determine whether requestor justification required.
    :type is_requestor_justification_required: bool
    :param approval_mode: The type of rule. Possible values include: "SingleStage", "Serial",
     "Parallel", "NoApproval".
    :type approval_mode: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.ApprovalMode
    :param approval_stages: The approval stages of the request.
    :type approval_stages: list[~azure.mgmt.authorization.v2020_10_01_preview.models.ApprovalStage]
    """

    _attribute_map = {
        'is_approval_required': {'key': 'isApprovalRequired', 'type': 'bool'},
        'is_approval_required_for_extension': {'key': 'isApprovalRequiredForExtension', 'type': 'bool'},
        'is_requestor_justification_required': {'key': 'isRequestorJustificationRequired', 'type': 'bool'},
        'approval_mode': {'key': 'approvalMode', 'type': 'str'},
        'approval_stages': {'key': 'approvalStages', 'type': '[ApprovalStage]'},
    }

    def __init__(
        self,
        *,
        is_approval_required: Optional[bool] = None,
        is_approval_required_for_extension: Optional[bool] = None,
        is_requestor_justification_required: Optional[bool] = None,
        approval_mode: Optional[Union[str, "ApprovalMode"]] = None,
        approval_stages: Optional[List["ApprovalStage"]] = None,
        **kwargs
    ):
        super(ApprovalSettings, self).__init__(**kwargs)
        self.is_approval_required = is_approval_required
        self.is_approval_required_for_extension = is_approval_required_for_extension
        self.is_requestor_justification_required = is_requestor_justification_required
        self.approval_mode = approval_mode
        self.approval_stages = approval_stages


class ApprovalStage(msrest.serialization.Model):
    """The approval stage.

    :param approval_stage_time_out_in_days: The time in days when approval request would be timed
     out.
    :type approval_stage_time_out_in_days: int
    :param is_approver_justification_required: Determine whether approver need to provide
     justification for his decision.
    :type is_approver_justification_required: bool
    :param escalation_time_in_minutes: The time in minutes when the approval request would be
     escalated if the primary approver does not approves.
    :type escalation_time_in_minutes: int
    :param primary_approvers: The primary approver of the request.
    :type primary_approvers: list[~azure.mgmt.authorization.v2020_10_01_preview.models.UserSet]
    :param is_escalation_enabled: The value determine whether escalation feature is enabled.
    :type is_escalation_enabled: bool
    :param escalation_approvers: The escalation approver of the request.
    :type escalation_approvers: list[~azure.mgmt.authorization.v2020_10_01_preview.models.UserSet]
    """

    _attribute_map = {
        'approval_stage_time_out_in_days': {'key': 'approvalStageTimeOutInDays', 'type': 'int'},
        'is_approver_justification_required': {'key': 'isApproverJustificationRequired', 'type': 'bool'},
        'escalation_time_in_minutes': {'key': 'escalationTimeInMinutes', 'type': 'int'},
        'primary_approvers': {'key': 'primaryApprovers', 'type': '[UserSet]'},
        'is_escalation_enabled': {'key': 'isEscalationEnabled', 'type': 'bool'},
        'escalation_approvers': {'key': 'escalationApprovers', 'type': '[UserSet]'},
    }

    def __init__(
        self,
        *,
        approval_stage_time_out_in_days: Optional[int] = None,
        is_approver_justification_required: Optional[bool] = None,
        escalation_time_in_minutes: Optional[int] = None,
        primary_approvers: Optional[List["UserSet"]] = None,
        is_escalation_enabled: Optional[bool] = None,
        escalation_approvers: Optional[List["UserSet"]] = None,
        **kwargs
    ):
        super(ApprovalStage, self).__init__(**kwargs)
        self.approval_stage_time_out_in_days = approval_stage_time_out_in_days
        self.is_approver_justification_required = is_approver_justification_required
        self.escalation_time_in_minutes = escalation_time_in_minutes
        self.primary_approvers = primary_approvers
        self.is_escalation_enabled = is_escalation_enabled
        self.escalation_approvers = escalation_approvers


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message


class EligibleChildResource(msrest.serialization.Model):
    """Eligible child resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource scope Id.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EligibleChildResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class EligibleChildResourcesListResult(msrest.serialization.Model):
    """Eligible child resources list operation result.

    :param value: Eligible child resource list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.EligibleChildResource]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EligibleChildResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EligibleChildResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EligibleChildResourcesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.authorization.v2020_10_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~azure.mgmt.authorization.v2020_10_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ExpandedProperties(msrest.serialization.Model):
    """ExpandedProperties.

    :param scope: Details of the resource scope.
    :type scope: ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedPropertiesScope
    :param role_definition: Details of role definition.
    :type role_definition:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedPropertiesRoleDefinition
    :param principal: Details of the principal.
    :type principal:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedPropertiesPrincipal
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'ExpandedPropertiesScope'},
        'role_definition': {'key': 'roleDefinition', 'type': 'ExpandedPropertiesRoleDefinition'},
        'principal': {'key': 'principal', 'type': 'ExpandedPropertiesPrincipal'},
    }

    def __init__(
        self,
        *,
        scope: Optional["ExpandedPropertiesScope"] = None,
        role_definition: Optional["ExpandedPropertiesRoleDefinition"] = None,
        principal: Optional["ExpandedPropertiesPrincipal"] = None,
        **kwargs
    ):
        super(ExpandedProperties, self).__init__(**kwargs)
        self.scope = scope
        self.role_definition = role_definition
        self.principal = principal


class ExpandedPropertiesPrincipal(msrest.serialization.Model):
    """Details of the principal.

    :param id: Id of the principal.
    :type id: str
    :param display_name: Display name of the principal.
    :type display_name: str
    :param email: Email id of the principal.
    :type email: str
    :param type: Type of the principal.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        email: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(ExpandedPropertiesPrincipal, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.email = email
        self.type = type


class ExpandedPropertiesRoleDefinition(msrest.serialization.Model):
    """Details of role definition.

    :param id: Id of the role definition.
    :type id: str
    :param display_name: Display name of the role definition.
    :type display_name: str
    :param type: Type of the role definition.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(ExpandedPropertiesRoleDefinition, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class ExpandedPropertiesScope(msrest.serialization.Model):
    """Details of the resource scope.

    :param id: Scope id of the resource.
    :type id: str
    :param display_name: Display name of the resource.
    :type display_name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(ExpandedPropertiesScope, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class Permission(msrest.serialization.Model):
    """Role definition permissions.

    :param actions: Allowed actions.
    :type actions: list[str]
    :param not_actions: Denied actions.
    :type not_actions: list[str]
    :param data_actions: Allowed Data actions.
    :type data_actions: list[str]
    :param not_data_actions: Denied Data actions.
    :type not_data_actions: list[str]
    """

    _attribute_map = {
        'actions': {'key': 'actions', 'type': '[str]'},
        'not_actions': {'key': 'notActions', 'type': '[str]'},
        'data_actions': {'key': 'dataActions', 'type': '[str]'},
        'not_data_actions': {'key': 'notDataActions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        actions: Optional[List[str]] = None,
        not_actions: Optional[List[str]] = None,
        data_actions: Optional[List[str]] = None,
        not_data_actions: Optional[List[str]] = None,
        **kwargs
    ):
        super(Permission, self).__init__(**kwargs)
        self.actions = actions
        self.not_actions = not_actions
        self.data_actions = data_actions
        self.not_data_actions = not_data_actions


class PolicyAssignmentProperties(msrest.serialization.Model):
    """PolicyAssignmentProperties.

    :param scope: Details of the resource scope.
    :type scope:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentPropertiesScope
    :param role_definition: Details of role definition.
    :type role_definition:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentPropertiesRoleDefinition
    :param policy: Details of the policy.
    :type policy:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentPropertiesPolicy
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'PolicyAssignmentPropertiesScope'},
        'role_definition': {'key': 'roleDefinition', 'type': 'PolicyAssignmentPropertiesRoleDefinition'},
        'policy': {'key': 'policy', 'type': 'PolicyAssignmentPropertiesPolicy'},
    }

    def __init__(
        self,
        *,
        scope: Optional["PolicyAssignmentPropertiesScope"] = None,
        role_definition: Optional["PolicyAssignmentPropertiesRoleDefinition"] = None,
        policy: Optional["PolicyAssignmentPropertiesPolicy"] = None,
        **kwargs
    ):
        super(PolicyAssignmentProperties, self).__init__(**kwargs)
        self.scope = scope
        self.role_definition = role_definition
        self.policy = policy


class PolicyAssignmentPropertiesPolicy(msrest.serialization.Model):
    """Details of the policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Id of the policy.
    :type id: str
    :ivar last_modified_by: The name of the entity last modified it.
    :vartype last_modified_by: ~azure.mgmt.authorization.v2020_10_01_preview.models.Principal
    :param last_modified_date_time: The last modified date time.
    :type last_modified_date_time: ~datetime.datetime
    """

    _validation = {
        'last_modified_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'Principal'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        last_modified_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(PolicyAssignmentPropertiesPolicy, self).__init__(**kwargs)
        self.id = id
        self.last_modified_by = None
        self.last_modified_date_time = last_modified_date_time


class PolicyAssignmentPropertiesRoleDefinition(msrest.serialization.Model):
    """Details of role definition.

    :param id: Id of the role definition.
    :type id: str
    :param display_name: Display name of the role definition.
    :type display_name: str
    :param type: Type of the role definition.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(PolicyAssignmentPropertiesRoleDefinition, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class PolicyAssignmentPropertiesScope(msrest.serialization.Model):
    """Details of the resource scope.

    :param id: Scope id of the resource.
    :type id: str
    :param display_name: Display name of the resource.
    :type display_name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(PolicyAssignmentPropertiesScope, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class PolicyProperties(msrest.serialization.Model):
    """PolicyProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scope: Details of the resource scope.
    :vartype scope: ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyPropertiesScope
    """

    _validation = {
        'scope': {'readonly': True},
    }

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'PolicyPropertiesScope'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyProperties, self).__init__(**kwargs)
        self.scope = None


class PolicyPropertiesScope(msrest.serialization.Model):
    """Details of the resource scope.

    :param id: Scope id of the resource.
    :type id: str
    :param display_name: Display name of the resource.
    :type display_name: str
    :param type: Type of the resource.
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(PolicyPropertiesScope, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type


class Principal(msrest.serialization.Model):
    """The name of the entity last modified it.

    :param id: The id of the principal made changes.
    :type id: str
    :param display_name: The name of the principal made changes.
    :type display_name: str
    :param type: Type of principal such as user , group etc.
    :type type: str
    :param email: Email of principal.
    :type email: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        display_name: Optional[str] = None,
        type: Optional[str] = None,
        email: Optional[str] = None,
        **kwargs
    ):
        super(Principal, self).__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.type = type
        self.email = email


class RoleAssignment(msrest.serialization.Model):
    """Role Assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment ID.
    :vartype id: str
    :ivar name: The role assignment name.
    :vartype name: str
    :ivar type: The role assignment type.
    :vartype type: str
    :ivar scope: The role assignment scope.
    :vartype scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param description: Description of role assignment.
    :type description: str
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    :param delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
    :type delegated_managed_identity_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'readonly': True},
        'created_on': {'readonly': True},
        'updated_on': {'readonly': True},
        'created_by': {'readonly': True},
        'updated_by': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'str'},
        'delegated_managed_identity_resource_id': {'key': 'properties.delegatedManagedIdentityResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        description: Optional[str] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        delegated_managed_identity_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignment, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.description = description
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = None
        self.updated_on = None
        self.created_by = None
        self.updated_by = None
        self.delegated_managed_identity_resource_id = delegated_managed_identity_resource_id


class RoleAssignmentCreateParameters(msrest.serialization.Model):
    """Role assignment create parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar scope: The role assignment scope.
    :vartype scope: str
    :param role_definition_id: Required. The role definition ID.
    :type role_definition_id: str
    :param principal_id: Required. The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param description: Description of role assignment.
    :type description: str
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: Time it was created.
    :vartype created_on: ~datetime.datetime
    :ivar updated_on: Time it was updated.
    :vartype updated_on: ~datetime.datetime
    :ivar created_by: Id of the user who created the assignment.
    :vartype created_by: str
    :ivar updated_by: Id of the user who updated the assignment.
    :vartype updated_by: str
    :param delegated_managed_identity_resource_id: Id of the delegated managed identity resource.
    :type delegated_managed_identity_resource_id: str
    """

    _validation = {
        'scope': {'readonly': True},
        'role_definition_id': {'required': True},
        'principal_id': {'required': True},
        'created_on': {'readonly': True},
        'updated_on': {'readonly': True},
        'created_by': {'readonly': True},
        'updated_by': {'readonly': True},
    }

    _attribute_map = {
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'created_by': {'key': 'properties.createdBy', 'type': 'str'},
        'updated_by': {'key': 'properties.updatedBy', 'type': 'str'},
        'delegated_managed_identity_resource_id': {'key': 'properties.delegatedManagedIdentityResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        role_definition_id: str,
        principal_id: str,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        description: Optional[str] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        delegated_managed_identity_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentCreateParameters, self).__init__(**kwargs)
        self.scope = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.description = description
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = None
        self.updated_on = None
        self.created_by = None
        self.updated_by = None
        self.delegated_managed_identity_resource_id = delegated_managed_identity_resource_id


class RoleAssignmentFilter(msrest.serialization.Model):
    """Role Assignments filter.

    :param principal_id: Returns role assignment of the specific principal.
    :type principal_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentFilter, self).__init__(**kwargs)
        self.principal_id = principal_id


class RoleAssignmentListResult(msrest.serialization.Model):
    """Role assignment list operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Role assignment list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleAssignment"]] = None,
        **kwargs
    ):
        super(RoleAssignmentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RoleAssignmentSchedule(msrest.serialization.Model):
    """Role Assignment schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule Id.
    :vartype id: str
    :ivar name: The role assignment schedule name.
    :vartype name: str
    :ivar type: The role assignment schedule type.
    :vartype type: str
    :param scope: The role assignment schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_assignment_schedule_request_id: The id of roleAssignmentScheduleRequest used to
     create this roleAssignmentSchedule.
    :type role_assignment_schedule_request_id: str
    :param linked_role_eligibility_schedule_id: The id of roleEligibilitySchedule used to activated
     this roleAssignmentSchedule.
    :type linked_role_eligibility_schedule_id: str
    :param assignment_type: Assignment type of the role assignment schedule. Possible values
     include: "Activated", "Assigned".
    :type assignment_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.AssignmentType
    :param member_type: Membership type of the role assignment schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param status: The status of the role assignment schedule. Possible values include: "Accepted",
     "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: Start DateTime when role assignment schedule.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: End DateTime when role assignment schedule.
    :type end_date_time: ~datetime.datetime
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role assignment schedule was created.
    :type created_on: ~datetime.datetime
    :param updated_on: DateTime when role assignment schedule was modified.
    :type updated_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_assignment_schedule_request_id': {'key': 'properties.roleAssignmentScheduleRequestId', 'type': 'str'},
        'linked_role_eligibility_schedule_id': {'key': 'properties.linkedRoleEligibilityScheduleId', 'type': 'str'},
        'assignment_type': {'key': 'properties.assignmentType', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        role_assignment_schedule_request_id: Optional[str] = None,
        linked_role_eligibility_schedule_id: Optional[str] = None,
        assignment_type: Optional[Union[str, "AssignmentType"]] = None,
        member_type: Optional[Union[str, "MemberType"]] = None,
        status: Optional[Union[str, "Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["ExpandedProperties"] = None,
        **kwargs
    ):
        super(RoleAssignmentSchedule, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_assignment_schedule_request_id = role_assignment_schedule_request_id
        self.linked_role_eligibility_schedule_id = linked_role_eligibility_schedule_id
        self.assignment_type = assignment_type
        self.member_type = member_type
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.updated_on = updated_on
        self.expanded_properties = expanded_properties


class RoleAssignmentScheduleFilter(msrest.serialization.Model):
    """Role assignment schedule filter.

    :param principal_id: Returns role assignment schedule of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role assignment schedule of the specific role definition.
    :type role_definition_id: str
    :param status: Returns role assignment schedule instances of the specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleFilter, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status


class RoleAssignmentScheduleInstance(msrest.serialization.Model):
    """Information about current or upcoming role assignment schedule instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule instance ID.
    :vartype id: str
    :ivar name: The role assignment schedule instance name.
    :vartype name: str
    :ivar type: The role assignment schedule instance type.
    :vartype type: str
    :param scope: The role assignment schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_assignment_schedule_id: Id of the master role assignment schedule.
    :type role_assignment_schedule_id: str
    :param origin_role_assignment_id: Role Assignment Id in external system.
    :type origin_role_assignment_id: str
    :param status: The status of the role assignment schedule instance. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: The startDateTime of the role assignment schedule instance.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: The endDateTime of the role assignment schedule instance.
    :type end_date_time: ~datetime.datetime
    :param linked_role_eligibility_schedule_id: roleEligibilityScheduleId used to activate.
    :type linked_role_eligibility_schedule_id: str
    :param linked_role_eligibility_schedule_instance_id: roleEligibilityScheduleInstanceId linked
     to this roleAssignmentScheduleInstance.
    :type linked_role_eligibility_schedule_instance_id: str
    :param assignment_type: Assignment type of the role assignment schedule. Possible values
     include: "Activated", "Assigned".
    :type assignment_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.AssignmentType
    :param member_type: Membership type of the role assignment schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role assignment schedule was created.
    :type created_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_assignment_schedule_id': {'key': 'properties.roleAssignmentScheduleId', 'type': 'str'},
        'origin_role_assignment_id': {'key': 'properties.originRoleAssignmentId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'linked_role_eligibility_schedule_id': {'key': 'properties.linkedRoleEligibilityScheduleId', 'type': 'str'},
        'linked_role_eligibility_schedule_instance_id': {'key': 'properties.linkedRoleEligibilityScheduleInstanceId', 'type': 'str'},
        'assignment_type': {'key': 'properties.assignmentType', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        role_assignment_schedule_id: Optional[str] = None,
        origin_role_assignment_id: Optional[str] = None,
        status: Optional[Union[str, "Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        linked_role_eligibility_schedule_id: Optional[str] = None,
        linked_role_eligibility_schedule_instance_id: Optional[str] = None,
        assignment_type: Optional[Union[str, "AssignmentType"]] = None,
        member_type: Optional[Union[str, "MemberType"]] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["ExpandedProperties"] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleInstance, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_assignment_schedule_id = role_assignment_schedule_id
        self.origin_role_assignment_id = origin_role_assignment_id
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.linked_role_eligibility_schedule_id = linked_role_eligibility_schedule_id
        self.linked_role_eligibility_schedule_instance_id = linked_role_eligibility_schedule_instance_id
        self.assignment_type = assignment_type
        self.member_type = member_type
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.expanded_properties = expanded_properties


class RoleAssignmentScheduleInstanceFilter(msrest.serialization.Model):
    """Role assignment schedule instance filter.

    :param principal_id: Returns role assignment schedule instances of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role assignment schedule instances of the specific role
     definition.
    :type role_definition_id: str
    :param status: Returns role assignment schedule instances of the specific status.
    :type status: str
    :param role_assignment_schedule_id: Returns role assignment schedule instances belonging to a
     specific role assignment schedule.
    :type role_assignment_schedule_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'role_assignment_schedule_id': {'key': 'roleAssignmentScheduleId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        role_assignment_schedule_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleInstanceFilter, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status
        self.role_assignment_schedule_id = role_assignment_schedule_id


class RoleAssignmentScheduleInstanceListResult(msrest.serialization.Model):
    """Role assignment schedule instance list operation result.

    :param value: Role assignment schedule instance list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleInstance]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignmentScheduleInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleAssignmentScheduleInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleInstanceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentScheduleListResult(msrest.serialization.Model):
    """Role assignment schedule list operation result.

    :param value: Role assignment schedule list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentSchedule]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignmentSchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleAssignmentSchedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentScheduleRequest(msrest.serialization.Model):
    """Role Assignment schedule request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role assignment schedule request ID.
    :vartype id: str
    :ivar name: The role assignment schedule request name.
    :vartype name: str
    :ivar type: The role assignment schedule request type.
    :vartype type: str
    :ivar scope: The role assignment schedule request scope.
    :vartype scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Possible values include:
     "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :vartype principal_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param request_type: The type of the role assignment schedule request. Eg: SelfActivate,
     AdminAssign etc. Possible values include: "AdminAssign", "AdminRemove", "AdminUpdate",
     "AdminExtend", "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", "SelfRenew".
    :type request_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.RequestType
    :ivar status: The status of the role assignment schedule request. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :ivar approval_id: The approvalId of the role assignment schedule request.
    :vartype approval_id: str
    :param target_role_assignment_schedule_id: The resultant role assignment schedule id or the
     role assignment schedule id being updated.
    :type target_role_assignment_schedule_id: str
    :param target_role_assignment_schedule_instance_id: The role assignment schedule instance id
     being updated.
    :type target_role_assignment_schedule_instance_id: str
    :param schedule_info: Schedule info of the role assignment schedule.
    :type schedule_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequestPropertiesScheduleInfo
    :param linked_role_eligibility_schedule_id: The linked role eligibility schedule id - to
     activate an eligibility.
    :type linked_role_eligibility_schedule_id: str
    :param justification: Justification for the role assignment.
    :type justification: str
    :param ticket_info: Ticket Info of the role assignment.
    :type ticket_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequestPropertiesTicketInfo
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: DateTime when role assignment schedule request was created.
    :vartype created_on: ~datetime.datetime
    :ivar requestor_id: Id of the user who created this request.
    :vartype requestor_id: str
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'readonly': True},
        'principal_type': {'readonly': True},
        'status': {'readonly': True},
        'approval_id': {'readonly': True},
        'created_on': {'readonly': True},
        'requestor_id': {'readonly': True},
        'expanded_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'approval_id': {'key': 'properties.approvalId', 'type': 'str'},
        'target_role_assignment_schedule_id': {'key': 'properties.targetRoleAssignmentScheduleId', 'type': 'str'},
        'target_role_assignment_schedule_instance_id': {'key': 'properties.targetRoleAssignmentScheduleInstanceId', 'type': 'str'},
        'schedule_info': {'key': 'properties.scheduleInfo', 'type': 'RoleAssignmentScheduleRequestPropertiesScheduleInfo'},
        'linked_role_eligibility_schedule_id': {'key': 'properties.linkedRoleEligibilityScheduleId', 'type': 'str'},
        'justification': {'key': 'properties.justification', 'type': 'str'},
        'ticket_info': {'key': 'properties.ticketInfo', 'type': 'RoleAssignmentScheduleRequestPropertiesTicketInfo'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'requestor_id': {'key': 'properties.requestorId', 'type': 'str'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        request_type: Optional[Union[str, "RequestType"]] = None,
        target_role_assignment_schedule_id: Optional[str] = None,
        target_role_assignment_schedule_instance_id: Optional[str] = None,
        schedule_info: Optional["RoleAssignmentScheduleRequestPropertiesScheduleInfo"] = None,
        linked_role_eligibility_schedule_id: Optional[str] = None,
        justification: Optional[str] = None,
        ticket_info: Optional["RoleAssignmentScheduleRequestPropertiesTicketInfo"] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequest, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = None
        self.request_type = request_type
        self.status = None
        self.approval_id = None
        self.target_role_assignment_schedule_id = target_role_assignment_schedule_id
        self.target_role_assignment_schedule_instance_id = target_role_assignment_schedule_instance_id
        self.schedule_info = schedule_info
        self.linked_role_eligibility_schedule_id = linked_role_eligibility_schedule_id
        self.justification = justification
        self.ticket_info = ticket_info
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = None
        self.requestor_id = None
        self.expanded_properties = None


class RoleAssignmentScheduleRequestFilter(msrest.serialization.Model):
    """Role assignment schedule request filter.

    :param principal_id: Returns role assignment requests of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role assignment requests of the specific role definition.
    :type role_definition_id: str
    :param requestor_id: Returns role assignment requests created by specific principal.
    :type requestor_id: str
    :param status: Returns role assignment requests of specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'requestor_id': {'key': 'requestorId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        requestor_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestFilter, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.requestor_id = requestor_id
        self.status = status


class RoleAssignmentScheduleRequestListResult(msrest.serialization.Model):
    """Role assignment schedule request list operation result.

    :param value: Role assignment schedule request list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequest]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleAssignmentScheduleRequest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleAssignmentScheduleRequest"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleAssignmentScheduleRequestPropertiesScheduleInfo(msrest.serialization.Model):
    """Schedule info of the role assignment schedule.

    :param start_date_time: Start DateTime of the role assignment schedule.
    :type start_date_time: ~datetime.datetime
    :param expiration: Expiration of the role assignment schedule.
    :type expiration:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration
    """

    _attribute_map = {
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'expiration': {'key': 'expiration', 'type': 'RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration'},
    }

    def __init__(
        self,
        *,
        start_date_time: Optional[datetime.datetime] = None,
        expiration: Optional["RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration"] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestPropertiesScheduleInfo, self).__init__(**kwargs)
        self.start_date_time = start_date_time
        self.expiration = expiration


class RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration(msrest.serialization.Model):
    """Expiration of the role assignment schedule.

    :param type: Type of the role assignment schedule expiration. Possible values include:
     "AfterDuration", "AfterDateTime", "NoExpiration".
    :type type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Type
    :param end_date_time: End DateTime of the role assignment schedule.
    :type end_date_time: ~datetime.datetime
    :param duration: Duration of the role assignment schedule in TimeSpan.
    :type duration: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "Type"]] = None,
        end_date_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration, self).__init__(**kwargs)
        self.type = type
        self.end_date_time = end_date_time
        self.duration = duration


class RoleAssignmentScheduleRequestPropertiesTicketInfo(msrest.serialization.Model):
    """Ticket Info of the role assignment.

    :param ticket_number: Ticket number for the role assignment.
    :type ticket_number: str
    :param ticket_system: Ticket system name for the role assignment.
    :type ticket_system: str
    """

    _attribute_map = {
        'ticket_number': {'key': 'ticketNumber', 'type': 'str'},
        'ticket_system': {'key': 'ticketSystem', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ticket_number: Optional[str] = None,
        ticket_system: Optional[str] = None,
        **kwargs
    ):
        super(RoleAssignmentScheduleRequestPropertiesTicketInfo, self).__init__(**kwargs)
        self.ticket_number = ticket_number
        self.ticket_system = ticket_system


class RoleEligibilitySchedule(msrest.serialization.Model):
    """Role eligibility schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule Id.
    :vartype id: str
    :ivar name: The role eligibility schedule name.
    :vartype name: str
    :ivar type: The role eligibility schedule type.
    :vartype type: str
    :param scope: The role eligibility schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_eligibility_schedule_request_id: The id of roleEligibilityScheduleRequest used to
     create this roleAssignmentSchedule.
    :type role_eligibility_schedule_request_id: str
    :param member_type: Membership type of the role eligibility schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param status: The status of the role eligibility schedule. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: Start DateTime when role eligibility schedule.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: End DateTime when role eligibility schedule.
    :type end_date_time: ~datetime.datetime
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role eligibility schedule was created.
    :type created_on: ~datetime.datetime
    :param updated_on: DateTime when role eligibility schedule was modified.
    :type updated_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_eligibility_schedule_request_id': {'key': 'properties.roleEligibilityScheduleRequestId', 'type': 'str'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'updated_on': {'key': 'properties.updatedOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        role_eligibility_schedule_request_id: Optional[str] = None,
        member_type: Optional[Union[str, "MemberType"]] = None,
        status: Optional[Union[str, "Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        updated_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["ExpandedProperties"] = None,
        **kwargs
    ):
        super(RoleEligibilitySchedule, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_eligibility_schedule_request_id = role_eligibility_schedule_request_id
        self.member_type = member_type
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.updated_on = updated_on
        self.expanded_properties = expanded_properties


class RoleEligibilityScheduleFilter(msrest.serialization.Model):
    """Role eligibility schedule filter.

    :param principal_id: Returns role eligibility schedule of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role eligibility schedule of the specific role definition.
    :type role_definition_id: str
    :param status: Returns role eligibility schedule of the specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleFilter, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status


class RoleEligibilityScheduleInstance(msrest.serialization.Model):
    """Information about current or upcoming role eligibility schedule instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule instance ID.
    :vartype id: str
    :ivar name: The role eligibility schedule instance name.
    :vartype name: str
    :ivar type: The role eligibility schedule instance type.
    :vartype type: str
    :param scope: The role eligibility schedule scope.
    :type scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :param principal_type: The principal type of the assigned principal ID. Possible values
     include: "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :type principal_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param role_eligibility_schedule_id: Id of the master role eligibility schedule.
    :type role_eligibility_schedule_id: str
    :param status: The status of the role eligibility schedule instance. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :type status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :param start_date_time: The startDateTime of the role eligibility schedule instance.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: The endDateTime of the role eligibility schedule instance.
    :type end_date_time: ~datetime.datetime
    :param member_type: Membership type of the role eligibility schedule. Possible values include:
     "Inherited", "Direct", "Group".
    :type member_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.MemberType
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :param created_on: DateTime when role eligibility schedule was created.
    :type created_on: ~datetime.datetime
    :param expanded_properties: Additional properties of principal, scope and role definition.
    :type expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'role_eligibility_schedule_id': {'key': 'properties.roleEligibilityScheduleId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'member_type': {'key': 'properties.memberType', 'type': 'str'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        principal_type: Optional[Union[str, "PrincipalType"]] = None,
        role_eligibility_schedule_id: Optional[str] = None,
        status: Optional[Union[str, "Status"]] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        member_type: Optional[Union[str, "MemberType"]] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        created_on: Optional[datetime.datetime] = None,
        expanded_properties: Optional["ExpandedProperties"] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleInstance, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = principal_type
        self.role_eligibility_schedule_id = role_eligibility_schedule_id
        self.status = status
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.member_type = member_type
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = created_on
        self.expanded_properties = expanded_properties


class RoleEligibilityScheduleInstanceFilter(msrest.serialization.Model):
    """Role eligibility schedule instance filter.

    :param principal_id: Returns role eligibility schedule instances of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role eligibility schedule instances of the specific role
     definition.
    :type role_definition_id: str
    :param status: Returns role eligibility schedule instances of the specific status.
    :type status: str
    :param role_eligibility_schedule_id: Returns role eligibility schedule instances belonging to a
     specific role eligibility schedule.
    :type role_eligibility_schedule_id: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'role_eligibility_schedule_id': {'key': 'roleEligibilityScheduleId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        status: Optional[str] = None,
        role_eligibility_schedule_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleInstanceFilter, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.status = status
        self.role_eligibility_schedule_id = role_eligibility_schedule_id


class RoleEligibilityScheduleInstanceListResult(msrest.serialization.Model):
    """Role eligibility schedule instance list operation result.

    :param value: Role eligibility schedule instance list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleInstance]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleEligibilityScheduleInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleEligibilityScheduleInstance"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleInstanceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilityScheduleListResult(msrest.serialization.Model):
    """role eligibility schedule list operation result.

    :param value: role eligibility schedule list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilitySchedule]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleEligibilitySchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleEligibilitySchedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilityScheduleRequest(msrest.serialization.Model):
    """Role Eligibility schedule request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role eligibility schedule request ID.
    :vartype id: str
    :ivar name: The role eligibility schedule request name.
    :vartype name: str
    :ivar type: The role eligibility schedule request type.
    :vartype type: str
    :ivar scope: The role eligibility schedule request scope.
    :vartype scope: str
    :param role_definition_id: The role definition ID.
    :type role_definition_id: str
    :param principal_id: The principal ID.
    :type principal_id: str
    :ivar principal_type: The principal type of the assigned principal ID. Possible values include:
     "User", "Group", "ServicePrincipal", "ForeignGroup", "Device".
    :vartype principal_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PrincipalType
    :param request_type: The type of the role assignment schedule request. Eg: SelfActivate,
     AdminAssign etc. Possible values include: "AdminAssign", "AdminRemove", "AdminUpdate",
     "AdminExtend", "AdminRenew", "SelfActivate", "SelfDeactivate", "SelfExtend", "SelfRenew".
    :type request_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.RequestType
    :ivar status: The status of the role eligibility schedule request. Possible values include:
     "Accepted", "PendingEvaluation", "Granted", "Denied", "PendingProvisioning", "Provisioned",
     "PendingRevocation", "Revoked", "Canceled", "Failed", "PendingApprovalProvisioning",
     "PendingApproval", "FailedAsResourceIsLocked", "PendingAdminDecision", "AdminApproved",
     "AdminDenied", "TimedOut", "ProvisioningStarted", "Invalid", "PendingScheduleCreation",
     "ScheduleCreated", "PendingExternalProvisioning".
    :vartype status: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Status
    :ivar approval_id: The approvalId of the role eligibility schedule request.
    :vartype approval_id: str
    :param schedule_info: Schedule info of the role eligibility schedule.
    :type schedule_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo
    :param target_role_eligibility_schedule_id: The resultant role eligibility schedule id or the
     role eligibility schedule id being updated.
    :type target_role_eligibility_schedule_id: str
    :param target_role_eligibility_schedule_instance_id: The role eligibility schedule instance id
     being updated.
    :type target_role_eligibility_schedule_instance_id: str
    :param justification: Justification for the role eligibility.
    :type justification: str
    :param ticket_info: Ticket Info of the role eligibility.
    :type ticket_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequestPropertiesTicketInfo
    :param condition: The conditions on the role assignment. This limits the resources it can be
     assigned to. e.g.:
     @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     StringEqualsIgnoreCase 'foo_storage_container'.
    :type condition: str
    :param condition_version: Version of the condition. Currently accepted value is '2.0'.
    :type condition_version: str
    :ivar created_on: DateTime when role eligibility schedule request was created.
    :vartype created_on: ~datetime.datetime
    :ivar requestor_id: Id of the user who created this request.
    :vartype requestor_id: str
    :ivar expanded_properties: Additional properties of principal, scope and role definition.
    :vartype expanded_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ExpandedProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scope': {'readonly': True},
        'principal_type': {'readonly': True},
        'status': {'readonly': True},
        'approval_id': {'readonly': True},
        'created_on': {'readonly': True},
        'requestor_id': {'readonly': True},
        'expanded_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'principal_id': {'key': 'properties.principalId', 'type': 'str'},
        'principal_type': {'key': 'properties.principalType', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'approval_id': {'key': 'properties.approvalId', 'type': 'str'},
        'schedule_info': {'key': 'properties.scheduleInfo', 'type': 'RoleEligibilityScheduleRequestPropertiesScheduleInfo'},
        'target_role_eligibility_schedule_id': {'key': 'properties.targetRoleEligibilityScheduleId', 'type': 'str'},
        'target_role_eligibility_schedule_instance_id': {'key': 'properties.targetRoleEligibilityScheduleInstanceId', 'type': 'str'},
        'justification': {'key': 'properties.justification', 'type': 'str'},
        'ticket_info': {'key': 'properties.ticketInfo', 'type': 'RoleEligibilityScheduleRequestPropertiesTicketInfo'},
        'condition': {'key': 'properties.condition', 'type': 'str'},
        'condition_version': {'key': 'properties.conditionVersion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'requestor_id': {'key': 'properties.requestorId', 'type': 'str'},
        'expanded_properties': {'key': 'properties.expandedProperties', 'type': 'ExpandedProperties'},
    }

    def __init__(
        self,
        *,
        role_definition_id: Optional[str] = None,
        principal_id: Optional[str] = None,
        request_type: Optional[Union[str, "RequestType"]] = None,
        schedule_info: Optional["RoleEligibilityScheduleRequestPropertiesScheduleInfo"] = None,
        target_role_eligibility_schedule_id: Optional[str] = None,
        target_role_eligibility_schedule_instance_id: Optional[str] = None,
        justification: Optional[str] = None,
        ticket_info: Optional["RoleEligibilityScheduleRequestPropertiesTicketInfo"] = None,
        condition: Optional[str] = None,
        condition_version: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequest, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = None
        self.role_definition_id = role_definition_id
        self.principal_id = principal_id
        self.principal_type = None
        self.request_type = request_type
        self.status = None
        self.approval_id = None
        self.schedule_info = schedule_info
        self.target_role_eligibility_schedule_id = target_role_eligibility_schedule_id
        self.target_role_eligibility_schedule_instance_id = target_role_eligibility_schedule_instance_id
        self.justification = justification
        self.ticket_info = ticket_info
        self.condition = condition
        self.condition_version = condition_version
        self.created_on = None
        self.requestor_id = None
        self.expanded_properties = None


class RoleEligibilityScheduleRequestFilter(msrest.serialization.Model):
    """Role eligibility schedule request filter.

    :param principal_id: Returns role eligibility requests of the specific principal.
    :type principal_id: str
    :param role_definition_id: Returns role eligibility requests of the specific role definition.
    :type role_definition_id: str
    :param requestor_id: Returns role eligibility requests created by specific principal.
    :type requestor_id: str
    :param status: Returns role eligibility requests of specific status.
    :type status: str
    """

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'role_definition_id': {'key': 'roleDefinitionId', 'type': 'str'},
        'requestor_id': {'key': 'requestorId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_id: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        requestor_id: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestFilter, self).__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id
        self.requestor_id = requestor_id
        self.status = status


class RoleEligibilityScheduleRequestListResult(msrest.serialization.Model):
    """Role eligibility schedule request list operation result.

    :param value: Role eligibility schedule request list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequest]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleEligibilityScheduleRequest]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleEligibilityScheduleRequest"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleEligibilityScheduleRequestPropertiesScheduleInfo(msrest.serialization.Model):
    """Schedule info of the role eligibility schedule.

    :param start_date_time: Start DateTime of the role eligibility schedule.
    :type start_date_time: ~datetime.datetime
    :param expiration: Expiration of the role eligibility schedule.
    :type expiration:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration
    """

    _attribute_map = {
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'expiration': {'key': 'expiration', 'type': 'RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration'},
    }

    def __init__(
        self,
        *,
        start_date_time: Optional[datetime.datetime] = None,
        expiration: Optional["RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration"] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestPropertiesScheduleInfo, self).__init__(**kwargs)
        self.start_date_time = start_date_time
        self.expiration = expiration


class RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration(msrest.serialization.Model):
    """Expiration of the role eligibility schedule.

    :param type: Type of the role eligibility schedule expiration. Possible values include:
     "AfterDuration", "AfterDateTime", "NoExpiration".
    :type type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.Type
    :param end_date_time: End DateTime of the role eligibility schedule.
    :type end_date_time: ~datetime.datetime
    :param duration: Duration of the role eligibility schedule in TimeSpan.
    :type duration: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'end_date_time': {'key': 'endDateTime', 'type': 'iso-8601'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "Type"]] = None,
        end_date_time: Optional[datetime.datetime] = None,
        duration: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration, self).__init__(**kwargs)
        self.type = type
        self.end_date_time = end_date_time
        self.duration = duration


class RoleEligibilityScheduleRequestPropertiesTicketInfo(msrest.serialization.Model):
    """Ticket Info of the role eligibility.

    :param ticket_number: Ticket number for the role eligibility.
    :type ticket_number: str
    :param ticket_system: Ticket system name for the role eligibility.
    :type ticket_system: str
    """

    _attribute_map = {
        'ticket_number': {'key': 'ticketNumber', 'type': 'str'},
        'ticket_system': {'key': 'ticketSystem', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ticket_number: Optional[str] = None,
        ticket_system: Optional[str] = None,
        **kwargs
    ):
        super(RoleEligibilityScheduleRequestPropertiesTicketInfo, self).__init__(**kwargs)
        self.ticket_number = ticket_number
        self.ticket_system = ticket_system


class RoleManagementPolicy(msrest.serialization.Model):
    """Role management policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role management policy Id.
    :vartype id: str
    :ivar name: The role management policy name.
    :vartype name: str
    :ivar type: The role management policy type.
    :vartype type: str
    :param scope: The role management policy scope.
    :type scope: str
    :param display_name: The role management policy display name.
    :type display_name: str
    :param description: The role management policy description.
    :type description: str
    :param is_organization_default: The role management policy is default policy.
    :type is_organization_default: bool
    :ivar last_modified_by: The name of the entity last modified it.
    :vartype last_modified_by: ~azure.mgmt.authorization.v2020_10_01_preview.models.Principal
    :ivar last_modified_date_time: The last modified date time.
    :vartype last_modified_date_time: ~datetime.datetime
    :param rules: The rule applied to the policy.
    :type rules:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRule]
    :ivar effective_rules: The readonly computed rule applied to the policy.
    :vartype effective_rules:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRule]
    :ivar policy_properties: Additional properties of scope.
    :vartype policy_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'effective_rules': {'readonly': True},
        'policy_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_organization_default': {'key': 'properties.isOrganizationDefault', 'type': 'bool'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'Principal'},
        'last_modified_date_time': {'key': 'properties.lastModifiedDateTime', 'type': 'iso-8601'},
        'rules': {'key': 'properties.rules', 'type': '[RoleManagementPolicyRule]'},
        'effective_rules': {'key': 'properties.effectiveRules', 'type': '[RoleManagementPolicyRule]'},
        'policy_properties': {'key': 'properties.policyProperties', 'type': 'PolicyProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        is_organization_default: Optional[bool] = None,
        rules: Optional[List["RoleManagementPolicyRule"]] = None,
        **kwargs
    ):
        super(RoleManagementPolicy, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = scope
        self.display_name = display_name
        self.description = description
        self.is_organization_default = is_organization_default
        self.last_modified_by = None
        self.last_modified_date_time = None
        self.rules = rules
        self.effective_rules = None
        self.policy_properties = None


class RoleManagementPolicyRule(msrest.serialization.Model):
    """The role management policy rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RoleManagementPolicyApprovalRule, RoleManagementPolicyAuthenticationContextRule, RoleManagementPolicyEnablementRule, RoleManagementPolicyExpirationRule, RoleManagementPolicyNotificationRule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
    }

    _subtype_map = {
        'rule_type': {'RoleManagementPolicyApprovalRule': 'RoleManagementPolicyApprovalRule', 'RoleManagementPolicyAuthenticationContextRule': 'RoleManagementPolicyAuthenticationContextRule', 'RoleManagementPolicyEnablementRule': 'RoleManagementPolicyEnablementRule', 'RoleManagementPolicyExpirationRule': 'RoleManagementPolicyExpirationRule', 'RoleManagementPolicyNotificationRule': 'RoleManagementPolicyNotificationRule'}
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target: Optional["RoleManagementPolicyRuleTarget"] = None,
        **kwargs
    ):
        super(RoleManagementPolicyRule, self).__init__(**kwargs)
        self.id = id
        self.rule_type = None  # type: Optional[str]
        self.target = target


class RoleManagementPolicyApprovalRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param setting: The approval setting.
    :type setting: ~azure.mgmt.authorization.v2020_10_01_preview.models.ApprovalSettings
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'setting': {'key': 'setting', 'type': 'ApprovalSettings'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target: Optional["RoleManagementPolicyRuleTarget"] = None,
        setting: Optional["ApprovalSettings"] = None,
        **kwargs
    ):
        super(RoleManagementPolicyApprovalRule, self).__init__(id=id, target=target, **kwargs)
        self.rule_type = 'RoleManagementPolicyApprovalRule'  # type: str
        self.setting = setting


class RoleManagementPolicyAssignment(msrest.serialization.Model):
    """Role management policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The role management policy Id.
    :vartype id: str
    :ivar name: The role management policy name.
    :vartype name: str
    :ivar type: The role management policy type.
    :vartype type: str
    :param scope: The role management policy scope.
    :type scope: str
    :param role_definition_id: The role definition of management policy assignment.
    :type role_definition_id: str
    :param policy_id: The policy id role management policy assignment.
    :type policy_id: str
    :ivar policy_assignment_properties: Additional properties of scope, role definition and policy.
    :vartype policy_assignment_properties:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.PolicyAssignmentProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'policy_assignment_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'role_definition_id': {'key': 'properties.roleDefinitionId', 'type': 'str'},
        'policy_id': {'key': 'properties.policyId', 'type': 'str'},
        'policy_assignment_properties': {'key': 'properties.policyAssignmentProperties', 'type': 'PolicyAssignmentProperties'},
    }

    def __init__(
        self,
        *,
        scope: Optional[str] = None,
        role_definition_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        **kwargs
    ):
        super(RoleManagementPolicyAssignment, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.scope = scope
        self.role_definition_id = role_definition_id
        self.policy_id = policy_id
        self.policy_assignment_properties = None


class RoleManagementPolicyAssignmentListResult(msrest.serialization.Model):
    """Role management policy assignment list operation result.

    :param value: Role management policy assignment list.
    :type value:
     list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyAssignment]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleManagementPolicyAssignment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleManagementPolicyAssignment"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleManagementPolicyAssignmentListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleManagementPolicyAuthenticationContextRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param is_enabled: The value indicating if rule is enabled.
    :type is_enabled: bool
    :param claim_value: The claim value.
    :type claim_value: str
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'claim_value': {'key': 'claimValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target: Optional["RoleManagementPolicyRuleTarget"] = None,
        is_enabled: Optional[bool] = None,
        claim_value: Optional[str] = None,
        **kwargs
    ):
        super(RoleManagementPolicyAuthenticationContextRule, self).__init__(id=id, target=target, **kwargs)
        self.rule_type = 'RoleManagementPolicyAuthenticationContextRule'  # type: str
        self.is_enabled = is_enabled
        self.claim_value = claim_value


class RoleManagementPolicyEnablementRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param enabled_rules: The list of enabled rules.
    :type enabled_rules: list[str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.EnablementRules]
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'enabled_rules': {'key': 'enabledRules', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target: Optional["RoleManagementPolicyRuleTarget"] = None,
        enabled_rules: Optional[List[Union[str, "EnablementRules"]]] = None,
        **kwargs
    ):
        super(RoleManagementPolicyEnablementRule, self).__init__(id=id, target=target, **kwargs)
        self.rule_type = 'RoleManagementPolicyEnablementRule'  # type: str
        self.enabled_rules = enabled_rules


class RoleManagementPolicyExpirationRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param is_expiration_required: The value indicating whether expiration is required.
    :type is_expiration_required: bool
    :param maximum_duration: The maximum duration of expiration in timespan.
    :type maximum_duration: str
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'is_expiration_required': {'key': 'isExpirationRequired', 'type': 'bool'},
        'maximum_duration': {'key': 'maximumDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target: Optional["RoleManagementPolicyRuleTarget"] = None,
        is_expiration_required: Optional[bool] = None,
        maximum_duration: Optional[str] = None,
        **kwargs
    ):
        super(RoleManagementPolicyExpirationRule, self).__init__(id=id, target=target, **kwargs)
        self.rule_type = 'RoleManagementPolicyExpirationRule'  # type: str
        self.is_expiration_required = is_expiration_required
        self.maximum_duration = maximum_duration


class RoleManagementPolicyListResult(msrest.serialization.Model):
    """Role management policy list operation result.

    :param value: Role management policy list.
    :type value: list[~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicy]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleManagementPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RoleManagementPolicy"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleManagementPolicyListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleManagementPolicyNotificationRule(RoleManagementPolicyRule):
    """The role management policy rule.

    All required parameters must be populated in order to send to Azure.

    :param id: The id of the rule.
    :type id: str
    :param rule_type: Required. The type of rule.Constant filled by server.  Possible values
     include: "RoleManagementPolicyApprovalRule", "RoleManagementPolicyAuthenticationContextRule",
     "RoleManagementPolicyEnablementRule", "RoleManagementPolicyExpirationRule",
     "RoleManagementPolicyNotificationRule".
    :type rule_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleType
    :param target: The target of the current rule.
    :type target:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.RoleManagementPolicyRuleTarget
    :param notification_type: The type of notification. Possible values include: "Email".
    :type notification_type: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.NotificationDeliveryMechanism
    :param notification_level: The notification level. Possible values include: "None", "Critical",
     "All".
    :type notification_level: str or
     ~azure.mgmt.authorization.v2020_10_01_preview.models.NotificationLevel
    :param recipient_type: The recipient type. Possible values include: "Requestor", "Approver",
     "Admin".
    :type recipient_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.RecipientType
    :param notification_recipients: The list notification recipients.
    :type notification_recipients: list[str]
    :param is_default_recipients_enabled: Its value determine if the notification need to be sent
     to the recipient type specified in policy rule.
    :type is_default_recipients_enabled: bool
    """

    _validation = {
        'rule_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'target': {'key': 'target', 'type': 'RoleManagementPolicyRuleTarget'},
        'notification_type': {'key': 'notificationType', 'type': 'str'},
        'notification_level': {'key': 'notificationLevel', 'type': 'str'},
        'recipient_type': {'key': 'recipientType', 'type': 'str'},
        'notification_recipients': {'key': 'notificationRecipients', 'type': '[str]'},
        'is_default_recipients_enabled': {'key': 'isDefaultRecipientsEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        target: Optional["RoleManagementPolicyRuleTarget"] = None,
        notification_type: Optional[Union[str, "NotificationDeliveryMechanism"]] = None,
        notification_level: Optional[Union[str, "NotificationLevel"]] = None,
        recipient_type: Optional[Union[str, "RecipientType"]] = None,
        notification_recipients: Optional[List[str]] = None,
        is_default_recipients_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(RoleManagementPolicyNotificationRule, self).__init__(id=id, target=target, **kwargs)
        self.rule_type = 'RoleManagementPolicyNotificationRule'  # type: str
        self.notification_type = notification_type
        self.notification_level = notification_level
        self.recipient_type = recipient_type
        self.notification_recipients = notification_recipients
        self.is_default_recipients_enabled = is_default_recipients_enabled


class RoleManagementPolicyRuleTarget(msrest.serialization.Model):
    """The role management policy rule target.

    :param caller: The caller of the setting.
    :type caller: str
    :param operations: The type of operation.
    :type operations: list[str]
    :param level: The assignment level to which it is applied.
    :type level: str
    :param target_objects: The list of target objects.
    :type target_objects: list[str]
    :param inheritable_settings: The list of inheritable settings.
    :type inheritable_settings: list[str]
    :param enforced_settings: The list of enforced settings.
    :type enforced_settings: list[str]
    """

    _attribute_map = {
        'caller': {'key': 'caller', 'type': 'str'},
        'operations': {'key': 'operations', 'type': '[str]'},
        'level': {'key': 'level', 'type': 'str'},
        'target_objects': {'key': 'targetObjects', 'type': '[str]'},
        'inheritable_settings': {'key': 'inheritableSettings', 'type': '[str]'},
        'enforced_settings': {'key': 'enforcedSettings', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        caller: Optional[str] = None,
        operations: Optional[List[str]] = None,
        level: Optional[str] = None,
        target_objects: Optional[List[str]] = None,
        inheritable_settings: Optional[List[str]] = None,
        enforced_settings: Optional[List[str]] = None,
        **kwargs
    ):
        super(RoleManagementPolicyRuleTarget, self).__init__(**kwargs)
        self.caller = caller
        self.operations = operations
        self.level = level
        self.target_objects = target_objects
        self.inheritable_settings = inheritable_settings
        self.enforced_settings = enforced_settings


class UserSet(msrest.serialization.Model):
    """The detail of a user.

    :param user_type: The type of user. Possible values include: "User", "Group".
    :type user_type: str or ~azure.mgmt.authorization.v2020_10_01_preview.models.UserType
    :param is_backup: The value indicating whether the user is a backup fallback approver.
    :type is_backup: bool
    :param id: The object id of the user.
    :type id: str
    :param description: The description of the user.
    :type description: str
    """

    _attribute_map = {
        'user_type': {'key': 'userType', 'type': 'str'},
        'is_backup': {'key': 'isBackup', 'type': 'bool'},
        'id': {'key': 'id', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_type: Optional[Union[str, "UserType"]] = None,
        is_backup: Optional[bool] = None,
        id: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(UserSet, self).__init__(**kwargs)
        self.user_type = user_type
        self.is_backup = is_backup
        self.id = id
        self.description = description


class ValidationResponse(msrest.serialization.Model):
    """Validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_valid: Whether or not validation succeeded.
    :vartype is_valid: bool
    :param error_info: Failed validation result details.
    :type error_info:
     ~azure.mgmt.authorization.v2020_10_01_preview.models.ValidationResponseErrorInfo
    """

    _validation = {
        'is_valid': {'readonly': True},
    }

    _attribute_map = {
        'is_valid': {'key': 'isValid', 'type': 'bool'},
        'error_info': {'key': 'errorInfo', 'type': 'ValidationResponseErrorInfo'},
    }

    def __init__(
        self,
        *,
        error_info: Optional["ValidationResponseErrorInfo"] = None,
        **kwargs
    ):
        super(ValidationResponse, self).__init__(**kwargs)
        self.is_valid = None
        self.error_info = error_info


class ValidationResponseErrorInfo(msrest.serialization.Model):
    """Failed validation result details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code indicating why validation failed.
    :vartype code: str
    :ivar message: Message indicating why validation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidationResponseErrorInfo, self).__init__(**kwargs)
        self.code = None
        self.message = None
