;-------------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;-------------------------------------------------------------------------------
; pysycache-alphabet.scm : a script for make a cube cache for the ABCBook theme
;                          of the move activity
; Copyright (C) 2006 Vincent DEROO (vincent.pysycache@free.fr)
;-------------------------------------------------------------------------------
;
;
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License 
; as published by the Free Software Foundation; either version 2 
; of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc. : 
; 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (PutTheLetterInCube
	ShadowColor
	TopText
	TopTextFont
	Left
	Top
	Size
	GrowSelection
	Rotation
	BorderWidth
	)
		(gimp-palette-set-foreground ShadowColor)
		(let* 
					(	
						(LayText
							(car
							   (gimp-text-fontname
								MyImg -1
								Left Top
								TopText
								-1
								TRUE
								Size PIXELS
								TopTextFont)
						   )
						)						
						(larg (car (gimp-drawable-width LayText)))
                        (haut (car (gimp-drawable-height LayText)))
					)
					
					;rotation
					(let* 	(	(LayTourne (car  (gimp-drawable-transform-rotate LayText ( / ( * Rotation 3.1415926536 ) 180 ) FALSE  (+ Left (/ larg 2)) (+ Top (/ haut 2)) 0 2 FALSE 3 FALSE)))
							)
							(gimp-layer-translate LayText (- (/ larg 2)) (- (/ haut 2)) )
					)
					(if (= GrowSelection 1)
						;grow the selection
						(begin
							(gimp-layer-translate LayText -1 -1 )
							(gimp-selection-layer-alpha LayText)
					
;		;					(gimp-floating-sel-to-layer LayPiece)
;;							(gimp-image-merge-down myimg LayText 0)
							(gimp-image-merge-visible-layers MyImg 1)	
							;(gimp-selection-all LayText)
							(gimp-selection-grow MyImg BorderWidth)
							(let* 	(
								(mydraw (car (gimp-image-get-active-drawable MyImg)))
								)
								(gimp-edit-fill mydraw 0)
							)
						)
					)
		)
)


       
;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (script-fu-pysycache-abcbook
	img
	draw
	BackgroundFile
	ShadowColor
	
	FirstText
	FirstTextFont
	FirstTextSize
	FirstTextColor
	FirstRotation
	
	SecondText
	SecondTextFont
	SecondTextSize
	SecondTextColor
	SecondRotation
	
	BorderWidth
	)
	

	(let*	(	
				;(draw-type (car (gimp-drawable-type draw)))
				
				;recuperation de la taille de l'image originale
;				(ImgWidth (car (gimp-image-width img)))
;				(ImgHeight (car (gimp-image-height img)))
				
;				(MyImg (car (gimp-image-new ImgWidth ImgHeight RGB)))
;				(layBG (car (gimp-layer-new-from-drawable draw MyImg)))
				
				
			)

			(set! MyImg (car (gimp-file-load RUN-NONINTERACTIVE BackgroundFile BackgroundFile)))
;			(set! MyLay (car (gimp-layer-new-from-drawable draw MyImg)))

;			(gimp-image-add-layer MyImg MyLay -1)
;			(MyDraw (car (gimp-image-get-active-drawable MyImg)))
;			(set! MyDraw (car (gimp-image-get-active-drawable MyImg)))	

			;-------------------------- first letter ---------------------------
			;the shadow
			(PutTheLetterInCube ShadowColor FirstText FirstTextFont 170 315 FirstTextSize 1 FirstRotation BorderWidth)
			(PutTheLetterInCube FirstTextColor FirstText FirstTextFont 170 315 FirstTextSize 0 FirstRotation BorderWidth)

			;-------------------------- second letter  -------------------------
			;the shadow
			(PutTheLetterInCube ShadowColor SecondText SecondTextFont 450 270 SecondTextSize 1 SecondRotation BorderWidth)
			(PutTheLetterInCube SecondTextColor SecondText SecondTextFont 450 270 SecondTextSize 0 SecondRotation BorderWidth)

			(gimp-image-merge-visible-layers MyImg 1)

			(gimp-display-new MyImg)

	)
)


;-------------------------------------------------------------------------------
; Register in the Gimp menus
;-------------------------------------------------------------------------------
(script-fu-register "script-fu-pysycache-abcbook"
		    _"<Image>/Script-Fu/Pysycache/Theme ABC Book with pink and green cube..."
		    "Make the cube with a letter for the ABC Book of the Move theme"


		    "Vincent DEROO (contact.pysycache@free.fr)"
		    "Vincent DEROO"
		    "30/06/2006 - v 0.9"
		    "RGB GRAY RGBA GRAYA"
			
		    SF-IMAGE "Image" 0
			SF-DRAWABLE "Drawable" 0
			SF-FILENAME "Background" (string-append "" gimp-data-dir "/scripts/images/masque-image-alphabet-cube.png")
			SF-COLOR "Color of the shadow" '(20 20 20)
			
			SF-STRING "Lowercase letter" "a"
			SF-FONT "Font for the lowercase letter" "URW Chancery L, Italic"
			SF-ADJUSTMENT "Font size for the lowercase letter" '(200 10 400 1 10 0 1)
			SF-COLOR "Color of the lowercase letter" '(255 0 0)
			SF-ADJUSTMENT "Rotation for the lowercase letter" '(-22 -180 180 1 10 1 0)

			SF-STRING "Uppercase letter" "A"
			SF-FONT "Font for the uppercase letter" "Sans Bold"
			SF-ADJUSTMENT "Font size for the uppercase letter" '(160 10 400 1 10 0 1)
			SF-COLOR "Color of the uppercase letter" '(255 255 0)
			SF-ADJUSTMENT "Rotation for the uppercase letter" '(36 -180 180 1 10 1 0)

			SF-ADJUSTMENT "Border letter width" '(2 0 100 1 10 0 1)
			
)
