-- ----------------------------------------------------------------
-- Regression tests for inequality operator with v1 output.
-- ----------------------------------------------------------------

SELECT hll_set_output_version(1);

-- Undefined sets: f
SELECT E'\\x108c49'::hll <> E'\\x108c49'::hll;

-- Undefined, different metadata: t
SELECT E'\\x108c49'::hll <> E'\\x108b49'::hll;

-- Equal empty sets: f
SELECT hll_empty(11,5,256,1) <> hll_empty(11,5,256,1);

-- Different metadata: t
SELECT hll_empty(11,5,256,1) <> hll_empty(11,5,256,0);

-- Different metadata: t
SELECT hll_empty(11,5,256,1) <> hll_empty(11,5,128,1);

-- Different metadata: t
SELECT hll_empty(11,5,256,1) <> hll_empty(11,4,256,1);

-- Different metadata: t
SELECT hll_empty(11,5,256,1) <> hll_empty(10,5,256,1);

-- Same explicit: f
SELECT  E'\\x128b7f8895a3f5af28cafe'::hll <> E'\\x128b7f8895a3f5af28cafe'::hll;

-- Different explicit: t
SELECT  E'\\x128b7f8895a3f5af28cafe'::hll <> E'\\x128b7fda0ce907e4355b60'::hll;

-- Different explicit lengths: t
SELECT  E'\\x128b7f8895a3f5af28cafe'::hll <> E'\\x128b7f8895a3f5af28cafeda0ce907e4355b60'::hll;

-- Same sparse: f
SELECT E'\\x138b7f0001'::hll <> E'\\x138b7f0001'::hll;

-- Different sparse: t
SELECT E'\\x138b7f0001'::hll <> E'\\x138b7f0022'::hll;

-- Different sparse lengths: t
SELECT E'\\x138b7f0001'::hll <> E'\\x138b7f00410061'::hll;

-- Same compressed: f
SELECT hll_add(hll_empty(11,5,0,0), hll_hash_integer(1,0)) <>
E'\\x148b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'::hll;


-- Different compressed: t
SELECT hll_add(hll_empty(11,5,0,0), hll_hash_integer(2,0)) <>
E'\\x148b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000'::hll;

-- Different types: t
SELECT E'\\x108b7f'::hll <> hll_empty(11,5,256,1);
SELECT E'\\x108b7f'::hll <> E'\\x128b7f8895a3f5af28cafe'::hll;
SELECT E'\\x108b7f'::hll <> E'\\x138b7f0041'::hll;
SELECT E'\\x108b7f'::hll <> hll_add(hll_empty(11,5,0,0), hll_hash_integer(1,0));
SELECT hll_empty(11,5,256,1) <> E'\\x128b408895a3f5af28cafe'::hll;
SELECT hll_empty(11,5,256,1) <> E'\\x138b7f0001'::hll;
SELECT hll_empty(11,5,256,1) <>
           hll_add(hll_empty(11,5,0,0), hll_hash_integer(1,0));
SELECT E'\\x128b7f8895a3f5af28cafe'::hll <> E'\\x138b7f0022'::hll;
SELECT E'\\x128b7f8895a3f5af28cafe'::hll <>
           hll_add(hll_empty(11,5,0,0), hll_hash_integer(1,0));
SELECT E'\\x138c40afe180'::hll <>
           hll_add(hll_empty(11,5,0,0), hll_hash_integer(1,0));
