/*
 * Copyright 1997-98 by Pawel Krawczyk <kravietz@ceti.com.pl>
 *
 * See http://www.ceti.com.pl/~kravietz/progs/tacacs.html
 * for details.
 *
 * connect.c  Open connection to server.
 */

#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>

#include "../server.h"
#include "tacplus.h"
#include "libtac.h"

/* Returns file descriptor of open connection
   to the first available server from list passed
   in server table.
*/
int tac_connect(u_long *server, int servers) {
	struct sockaddr_in serv_addr;
	const struct servent *srv;
	int fd;
	int tries = 0;

	if(!servers) {
		nsyslog(LOG_ERR, "no TACACS+ servers defined");
		return(-1);
	}

	while(tries < servers) {	

 		bzero( (char *) &serv_addr, sizeof(serv_addr));
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_addr.s_addr = server[tries];

		srv = getservbyname("tacacs", "tcp");
		if(srv == NULL) 
			serv_addr.sin_port = htons(TAC_PLUS_PORT);
		else
			serv_addr.sin_port = srv->s_port;

		if((fd=socket(AF_INET, SOCK_STREAM, 0)) < 0) {
       	   		nsyslog(LOG_WARNING, 
				"socket creation error for %s: %m",
							dotted(server[tries]));
			tries++;
			continue;
		}

		if(connect(fd, (struct sockaddr *) &serv_addr, 
						sizeof(serv_addr)) < 0)
    		{
     	  		nsyslog(LOG_WARNING, 
				"connection to %s failed: %m",
						dotted(server[tries]));
			tries++;
			close(fd);
			continue;
    		}

		/* connected ok */
		TACDEBUG((LOG_DEBUG, "%s: connected to %s", __FUNCTION__, \
			       	dotted(server[tries])));

		return(fd);
	}

	/* all attempts failed */
	nsyslog(LOG_ERR, "all possible TACACS+ servers failed");
	return(-1);

} /* tac_connect */

