import sys


#---------------------------------------------------------------------------
def outputExternDefinitions(f, classList):
    for className in classList:
        f.write("extern void " + className + "_Init(vtkClientServerInterpreter* csi);\n")
    f.write("\n")


#---------------------------------------------------------------------------
def outputInitializeFunction(f, classList, outputFile):
    f.write(
        "//-------------------------------------------------------------------------\n"
        "/*\n"
        " * This function initializes the classes to be used by the interpreter.\n"
        " *\n"
        " * @param csi client server interpreter reference\n"
        " */\n"
        "extern \"C\" void VTK_WRAP_CS_EXPORT vtkParaviewMinInit_Initialize(\n"
        "  vtkClientServerInterpreter *csi)\n"
        "{\n"
        )
    for className in classList:
        f.write("  " + className + "_Init(csi);\n")
    f.write("}\n")


#---------------------------------------------------------------------------
def outputParaviewInitFile(classList, outputFile):
    f = open(outputFile, 'w')
    f.write(
        "//-------------------------------------------------------------------------\n"
        "/*\n"
        "* @file   vtkParaviewMinInit.cxx\n"
        "*\n"
        "* @brief  This file is autogenerated from WriteMinInit.py\n"
        "*/\n"
        "//-------------------------------------------------------------------------\n"
        "\n"                                
        "#include \"vtkClientServerInterpreter.h\"\n"
        "\n"
        "#ifndef PARAVIEW_BUILD_SHARED_LIBS\n"
        "/* #undef PARAVIEW_BUILD_SHARED_LIBS */\n"
        "#endif\n"
        "#if defined(PARAVIEW_BUILD_SHARED_LIBS) && defined(_WIN32)\n"
        "# define VTK_WRAP_CS_EXPORT __declspec(dllexport)\n"
        "#else\n"
        "# define VTK_WRAP_CS_EXPORT\n"
        "#endif\n\n"
        )
    outputExternDefinitions(f, classList)
    outputInitializeFunction(f, classList, outputFile)


#---------------------------------------------------------------------------
def main(argv=None):
    if not argv: argv = sys.argv
    if len(argv) != 3:
        print "Usage: python WriteMinInit.py <class-list-file> <output-file>"
        sys.exit(1)

    classes = list()
    inFile = open(argv[1], 'r')
    for line in inFile: classes.append(line.strip())
    outputParaviewInitFile(classes, argv[2])


#---------------------------------------------------------------------------
if __name__ == "__main__":
    main()

