/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.environment;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLEnvironmentalSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public abstract class BaseVisibilitySensor
extends BaseSensorNode
implements VRMLEnvironmentalSensorNodeType,
VRMLTimeDependentNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{52};
    protected static final int FIELD_CENTER = 3;
    protected static final int FIELD_SIZE = 4;
    protected static final int FIELD_ENTER_TIME = 7;
    protected static final int FIELD_EXIT_TIME = 8;
    protected static final int LAST_VISIBILITYSENSOR_INDEX = 8;
    private static final int NUM_FIELDS = 9;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter;
    protected float[] vfSize;
    protected double vfEnterTime;
    protected double vfExitTime;
    protected VRMLClock vrmlClock;

    protected BaseVisibilitySensor() {
        super("VisibilitySensor");
        this.hasChanged = new boolean[9];
        this.vfCenter = new float[3];
        this.vfSize = new float[3];
        this.vfEnabled = true;
        this.vfIsActive = false;
        this.vfEnterTime = -1.0;
        this.vfExitTime = -1.0;
    }

    protected BaseVisibilitySensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSensorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("size");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSize[0] = vRMLFieldData.floatArrayValue[0];
            this.vfSize[1] = vRMLFieldData.floatArrayValue[1];
            this.vfSize[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 14;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        if (n <= 2) {
            return super.getFieldValue(n);
        }
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfEnterTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfExitTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfSize, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfEnterTime);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfExitTime);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setSize(fArray);
                break;
            }
            case 3: {
                this.setCenter(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setSize(float[] fArray) {
        this.vfSize[0] = fArray[0];
        this.vfSize[1] = fArray[1];
        this.vfSize[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    protected void setCenter(float[] fArray) {
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BaseVisibilitySensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseVisibilitySensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseVisibilitySensor.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "size");
        BaseVisibilitySensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseVisibilitySensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseVisibilitySensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFTime", "enterTime");
        BaseVisibilitySensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFTime", "exitTime");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(4);
        fieldMap.put("size", n);
        fieldMap.put("set_size", n);
        fieldMap.put("size_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("enterTime", new Integer(7));
        fieldMap.put("exitTime", new Integer(8));
    }
}

