#! /bin/sh
#
### BEGIN INIT INFO
# Provides:          p3scan
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
### END INIT INFO
#
#   Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#   Modified for Debian by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#   Modified for p3scan by Mats Rynge <mats@rynge.net>
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/p3scan
NAME=p3scan
DESC="transparent pop3 virus- and spam-scanner"
PIDFILE=/run/$NAME/$NAME.pid

test -x $DAEMON || exit 0

set -e

# Read config
DEFAULTFILE=/etc/default/p3scan
DAEMON_OPTS=
if [ -f $DEFAULTFILE ]; then
    . $DEFAULTFILE
fi


check_running()
{
    start-stop-daemon --test --start --quiet \
        --pidfile $PIDFILE \
        --exec $DAEMON -- $DAEMON_OPTS
    return $?
}


case "$1" in
  start)
      if check_running; then
        echo -n "Starting $DESC: "
	if [ ! -e /run/$NAME ]; then
	    mkdir /run/$NAME
	    chown p3scan: /run/$NAME
	fi
        rm -rf /var/spool/p3scan/children/*
        start-stop-daemon --start --quiet \
            --pidfile $PIDFILE \
            --exec $DAEMON -- $DAEMON_OPTS
        echo "$NAME."
      else
        echo "$NAME is already running."
      fi
      ;;

  stop)
      if check_running; then
        echo "$NAME is not running."
        rm -f $PIDFILE
      else
        echo -n "Stopping $DESC: "
        start-stop-daemon --stop --retry 3 --quiet \
            --pidfile $PIDFILE \
            --exec $DAEMON || /bin/true
        echo "$NAME."
        rm -f $PIDFILE
      fi
      ;;

  restart|force-reload)
      $0 stop
      $0 start
      ;;

  *)
      N=/etc/init.d/$NAME
      echo "Usage: $N {start|stop|restart|force-reload}" >&2
      exit 1
      ;;
 
esac

exit 0

