###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_changetrack_priv_escalation_vuln.nasl 4842 2009-09-23 13:42:24Z sep $
#
# Changetrack Local Privilege Escalation Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900868);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.2");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3233");
  script_bugtraq_id(36420);
  script_name("Changetrack Local Privilege Escalation Vulnerability");
  desc = "
  Overview: This host has Changetrack installed and is prone to Local Privilege
  Escalation vulnerability.

  Vulnerability Insight:
  This flaw is generated because the application does not properly handle
  certain file names.

  Impact:
  Attacker may leverage this issue by executing arbitrary commands via CRLF
  sequences and shell metacharacters in a filename in a directory that is
  checked by changetrack.

  Impact Level: Application

  Affected Software/OS:
  Changetrack version 4.3

  Fix: Upgrade to Changetrack version 4.7 or later
  For updates refer, http://changetrack.sourceforge.net/

  References:
  http://bugs.debian.org/546791
  http://secunia.com/advisories/36756
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=546791
  http://www.openwall.com/lists/oss-security/2009/09/16/3

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Changetrack");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Privilege escalation");
  script_dependencies("secpod_changetrack_detect.nasl");
  script_require_keys("Changetrack/Ver");
  exit(0);
}


include("version_func.inc");

ctrack_ver = get_kb_item("Changetrack/Ver");
if(!ctrack_ver){
  exit(0);
}

# Check for Changetrack version 4.3
if(version_is_equal(version:ctrack_ver, test_version:"4.3")){
  security_hole(0);
}
