# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 702-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53749);
 script_cve_id("CVE-2005-0397", "CVE-2005-0759", "CVE-2005-0760", "CVE-2005-0762");
 script_bugtraq_id(12875);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 702-1 (imagemagick)";
 script_name(name);

 desc = "The remote host is missing an update to imagemagick
announced via advisory DSA 702-1.

Several vulnerabilities have been discovered in ImageMagick, a
commonly used image manipulation library.  These problems can be
exploited by a carefully crafted graphic image.  The Common
Vulnerabilities and Exposures project identifies the following
problems:

CVE-2005-0397

Tavis Ormandy discovered a format string vulnerability in the
filename handling code which allows a remote attacker to cause a
denial of service and possibly execute arbitrary code.

CVE-2005-0759

Andrei Nigmatulin discovered a denial of service condition which
can be caused by an invalid tag in a TIFF image.

CVE-2005-0760

Andrei Nigmatulin discovered that the TIFF decoder is vulnerable
to accessing memory out of bounds which will result in a
segmentation fault.

CVE-2005-0762

Andrei Nigmatulin discovered a buffer overflow in the SGI parser
which allows a remote attacker to execute arbitrary code via a
specially crafted SGI image file.

For the stable distribution (woody) these problems have been fixed in
version 5.4.4.5-1woody6.

For the unstable distribution (sid) these problems have been fixed in
version 6.0.6.2-2.2.

We recommend that you upgrade your imagemagick package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20702-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 702-1 (imagemagick)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"5.4.4.5-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++5", ver:"5.4.4.5-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++5-dev", ver:"5.4.4.5-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick5", ver:"5.4.4.5-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick5-dev", ver:"5.4.4.5-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"5.4.4.5-1woody6", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
