# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1219-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57654);
 script_cve_id("CVE-2005-3011", "CVE-2006-4810");
 script_bugtraq_id(14854,20959);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1219-1 (texinfo)";
 script_name(name);

 desc = "The remote host is missing an update to texinfo
announced via advisory DSA 1219-1.

Multiple vulnerabilities have been found in the GNU texinfo package, a
documentation system for on-line information and printed output.

CVE-2005-3011
Handling of temporary files is performed in an insecure manner, allowing
an attacker to overwrite any file writable by the victim.

CVE-2006-4810
A buffer overflow in util/texindex.c could allow an attacker to execute
arbitrary code with the victim's access rights by inducing the victim to
run texindex or tex2dvi on a specially crafted texinfo file.

For the stable distribution (sarge), these problems have been fixed in
version 4.7-2.2sarge2  Note that binary packages for the mipsel
architecture are not currently available due to technical problems with
the build host.  These packages will be made available as soon as
possible.

For unstable (sid) and the upcoming stable release (etch), these
problems have been fixed in version 4.8.dfsg.1-4

We recommend that you upgrade your texinfo package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201219-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1219-1 (texinfo)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"info", ver:"4.7-2.2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"texinfo", ver:"4.7-2.2sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
