#ifndef _DEFS_H
#define _DEFS_H

#define TYPICAL_FPS 60
#define FAKE_FPS 25  // Must be an integer.
// #define MAX_VIDEO_CARDS 16  // defined in shared_defs.h.
#define MAX_ALSA_CARDS 16
#define MAX_BUSES 256  // Audio buses.

// FRAME_SIZE is the default frame size, in bytes. FFmpeg inputs (video files and SRT streams)
// can allocate larger frames as needed; USB and DeckLink outputs always use FRAME_SIZE.
// We should eventually add support for at least DeckLink outputs, allowing us to capture
// 2160p frames. Also, it would allow us to lower the default frame size to the maximum
// bmusb supports (2 MB just about covers 1080i 4:2:2, then add some for 10-bit?) to waste
// less memory.
//
// As a general sanity check, we also have a MAX_FRAME_SIZE that even dynamic allocation
// will not go past.
#define FRAME_SIZE (8 << 20)  // 8 MB (just enough for 1080p RGBA).
#define MAX_FRAME_SIZE (140 << 20)  // 140 MB; enough for 8192*4320 RGBA and then some.

// For deinterlacing. See also comments on InputState.
#define FRAME_HISTORY_LENGTH 5

#define AUDIO_OUTPUT_CODEC_NAME "pcm_s32le"
#define DEFAULT_AUDIO_OUTPUT_BIT_RATE 0
#define DEFAULT_X264_OUTPUT_BIT_RATE 4500  // 5 Mbit after making room for some audio and TCP overhead.
#define DEFAULT_AV1_OUTPUT_BIT_RATE 4500  // Same.

#define LOCAL_DUMP_PREFIX "record-"
#define LOCAL_DUMP_SUFFIX ".nut"
#define DEFAULT_STREAM_MUX_NAME "nut"  // Only for HTTP. Local dump guesses from LOCAL_DUMP_SUFFIX.
#define DEFAULT_HTTPD_PORT 9095
#define DEFAULT_SRT_PORT 9710
#define DEFAULT_SRT_OUTPUT_LATENCY_MS 2000

// In number of frames. Comes in addition to any internal queues in x264
// (frame threading, lookahead, etc.).
#define X264_QUEUE_LENGTH 50
#define AV1_QUEUE_LENGTH 50

#define X264_DEFAULT_PRESET "ultrafast"
#define X264_DEFAULT_TUNE "film"

#define DEFAULT_AV1_PRESET 12
#define DEFAULT_AV1_FPS_NUM 60000
#define DEFAULT_AV1_FPS_DEN 1001

#endif  // !defined(_DEFS_H)
