/*
 * Copyright (c) 2003 Alban G. Hertroys
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * $Id: dautil.c,v 1.2 2003/02/10 12:35:04 dalroi Exp $
 */

#include "dockapp.h"
#include "dautil.h"

extern char *progName;


/*
 * Exported functions.
 */
void
DASetExpectedVersion(unsigned long expectedVersion)
{
    DAExpectedVersion = expectedVersion;

    if (expectedVersion > DA_VERSION)
	warn("Version of libdockapp (%u) is older than "
		"version expected (%u)",
		DA_VERSION,
		DAExpectedVersion);
}


Display*
DAGetDisplay(char *d, ...)
{
    /* Be backward compatible */
    if (DAExpectedVersion < 20030126) {
	va_list ap;
	int argc;
	char **argv;

	va_start(ap, d);
	argc = va_arg(ap, int);
	argv = va_arg(ap, char**);
	va_end(ap);

	DAOpenDisplay(d, argc, argv); /* sets progName too; used in warn() */

	warn("Expected version of libdockapp is not set.");
	warn("Obsolete call to DAGetDisplay().");

	return NULL;
    }

    return DADisplay;
}


void
DASetDisplay(Display *display)
{
    DADisplay = display;
}


Window
DAGetWindow(void)
{
    return DAWindow;
}


void
DASetWindow(Window window)
{
    DAWindow = window;
}


Window
DAGetLeader(void)
{
    return DALeader;
}


void
DASetLeader(Window leader)
{
    DALeader = leader;
}


Window
DAGetIconWindow(void)
{
    return DAIcon;
}


void
DASetIconWindow(Window icon_win)
{
    DAIcon = icon_win;
}


int
DAGetDepth(void)
{
    return DADepth;
}


void
DASetDepth(int depth)
{
    DADepth = depth;
}


Visual*
DAGetVisual(void)
{
    return DAVisual;
}


void
DASetVisual(Visual *visual)
{
    DAVisual = visual;
}


/*
 * Local functions
 */
void
warn(const char *fmt, ...)
{
    va_list ap;
    char *w_fmt;

    if (progName != NULL) {
	/* put default string in front of warning, add newline */
	w_fmt = malloc((strlen(progName) + strlen(fmt) +13) * sizeof(char));
	sprintf(w_fmt, "%s: warning: %s\n", progName, fmt);
    } else {
	w_fmt = malloc((strlen(fmt) +1) * sizeof(char));
	sprintf(w_fmt, "%s\n", fmt);
    }

    /* print the warning */
    va_start(ap, fmt);
    vfprintf(stderr, w_fmt, ap);
    va_end(ap);
}
