; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=avr -mattr=-eijmpcall | FileCheck %s --check-prefix=ICALL
; RUN: llc < %s -mtriple=avr -mattr=+eijmpcall | FileCheck %s --check-prefix=EICALL

; This test verifies the bug https://github.com/llvm/llvm-project/issues/58856

declare dso_local i16 @func()

define i16 @foo() {
; ICALL-LABEL: foo:
; ICALL:       ; %bb.0:
; ICALL-NEXT:    ldi r30, pm_lo8(func)
; ICALL-NEXT:    ldi r31, pm_hi8(func)
; ICALL-NEXT:    ;APP
; ICALL-NEXT:    ;NO_APP
; ICALL-NEXT:    icall
; ICALL-NEXT:    ret
;
; EICALL-LABEL: foo:
; EICALL:       ; %bb.0:
; EICALL-NEXT:    ldi r30, lo8_gs(func)
; EICALL-NEXT:    ldi r31, hi8_gs(func)
; EICALL-NEXT:    ;APP
; EICALL-NEXT:    ;NO_APP
; EICALL-NEXT:    eicall
; EICALL-NEXT:    ret
  %1 = tail call addrspace(0) ptr addrspace(1) asm "", "=r,0"(ptr addrspace(1) @func)
  %2 = tail call i16 %1()
  ret i16 %2
}
