; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=sse2    | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=sse4.2  | FileCheck %s --check-prefixes=SSE,SSE4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx     | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx2    | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW,AVX512BWNOVL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512vl,avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512VL,AVX512BWVL

define void @truncstore_v8i64_v8i32(<8 x i64> %x, <8 x i32>* %p, <8 x i32> %mask) {
; SSE2-LABEL: truncstore_v8i64_v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [4294967295,4294967295]
; SSE2-NEXT:    movdqa {{.*#+}} xmm12 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    pxor %xmm12, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [9223372039002259455,9223372039002259455]
; SSE2-NEXT:    movdqa %xmm11, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm11, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm10, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm1
; SSE2-NEXT:    pandn %xmm9, %xmm7
; SSE2-NEXT:    por %xmm1, %xmm7
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm12, %xmm1
; SSE2-NEXT:    movdqa %xmm11, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm11, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm10, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm13
; SSE2-NEXT:    pand %xmm13, %xmm0
; SSE2-NEXT:    pandn %xmm9, %xmm13
; SSE2-NEXT:    por %xmm0, %xmm13
; SSE2-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,2],xmm7[0,2]
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm12, %xmm0
; SSE2-NEXT:    movdqa %xmm11, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm11, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,3,3]
; SSE2-NEXT:    pxor %xmm2, %xmm12
; SSE2-NEXT:    movdqa %xmm11, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm12, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm11, %xmm12
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm12[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm1[1,1,3,3]
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm1, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    packssdw %xmm5, %xmm4
; SSE2-NEXT:    packsswb %xmm4, %xmm4
; SSE2-NEXT:    pmovmskb %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je .LBB0_2
; SSE2-NEXT:  # %bb.1: # %cond.store
; SSE2-NEXT:    movss %xmm13, (%rdi)
; SSE2-NEXT:  .LBB0_2: # %else
; SSE2-NEXT:    por %xmm10, %xmm0
; SSE2-NEXT:    por %xmm7, %xmm6
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB0_4
; SSE2-NEXT:  # %bb.3: # %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[1,1,2,3]
; SSE2-NEXT:    movd %xmm1, 4(%rdi)
; SSE2-NEXT:  .LBB0_4: # %else2
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pandn %xmm9, %xmm0
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    pandn %xmm9, %xmm6
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB0_6
; SSE2-NEXT:  # %bb.5: # %cond.store3
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm13[2,3,0,1]
; SSE2-NEXT:    movd %xmm1, 8(%rdi)
; SSE2-NEXT:  .LBB0_6: # %else4
; SSE2-NEXT:    por %xmm0, %xmm3
; SSE2-NEXT:    por %xmm6, %xmm2
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB0_8
; SSE2-NEXT:  # %bb.7: # %cond.store5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, 12(%rdi)
; SSE2-NEXT:  .LBB0_8: # %else6
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    jne .LBB0_9
; SSE2-NEXT:  # %bb.10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    jne .LBB0_11
; SSE2-NEXT:  .LBB0_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    jne .LBB0_13
; SSE2-NEXT:  .LBB0_14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    jne .LBB0_15
; SSE2-NEXT:  .LBB0_16: # %else14
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB0_9: # %cond.store7
; SSE2-NEXT:    movss %xmm2, 16(%rdi)
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB0_12
; SSE2-NEXT:  .LBB0_11: # %cond.store9
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,2,3]
; SSE2-NEXT:    movd %xmm0, 20(%rdi)
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    je .LBB0_14
; SSE2-NEXT:  .LBB0_13: # %cond.store11
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 24(%rdi)
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB0_16
; SSE2-NEXT:  .LBB0_15: # %cond.store13
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, 28(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v8i64_v8i32:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm8
; SSE4-NEXT:    pxor %xmm9, %xmm9
; SSE4-NEXT:    movapd {{.*#+}} xmm10 = [4294967295,4294967295]
; SSE4-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    movdqa %xmm1, %xmm6
; SSE4-NEXT:    pxor %xmm11, %xmm6
; SSE4-NEXT:    movdqa {{.*#+}} xmm7 = [9223372041149743103,9223372041149743103]
; SSE4-NEXT:    movdqa %xmm7, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm6, %xmm0
; SSE4-NEXT:    movapd %xmm10, %xmm6
; SSE4-NEXT:    blendvpd %xmm0, %xmm1, %xmm6
; SSE4-NEXT:    movdqa %xmm8, %xmm1
; SSE4-NEXT:    pxor %xmm11, %xmm1
; SSE4-NEXT:    movdqa %xmm7, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE4-NEXT:    movapd %xmm10, %xmm1
; SSE4-NEXT:    blendvpd %xmm0, %xmm8, %xmm1
; SSE4-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm6[0,2]
; SSE4-NEXT:    movdqa %xmm3, %xmm6
; SSE4-NEXT:    pxor %xmm11, %xmm6
; SSE4-NEXT:    movdqa %xmm7, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm6, %xmm0
; SSE4-NEXT:    movapd %xmm10, %xmm8
; SSE4-NEXT:    blendvpd %xmm0, %xmm3, %xmm8
; SSE4-NEXT:    pxor %xmm2, %xmm11
; SSE4-NEXT:    pcmpgtq %xmm11, %xmm7
; SSE4-NEXT:    movdqa %xmm7, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm2, %xmm10
; SSE4-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE4-NEXT:    pxor %xmm0, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm9, %xmm4
; SSE4-NEXT:    pxor %xmm0, %xmm4
; SSE4-NEXT:    packssdw %xmm5, %xmm4
; SSE4-NEXT:    packsswb %xmm4, %xmm4
; SSE4-NEXT:    pmovmskb %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB0_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB0_3
; SSE4-NEXT:  .LBB0_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB0_5
; SSE4-NEXT:  .LBB0_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB0_8
; SSE4-NEXT:  .LBB0_7: # %cond.store5
; SSE4-NEXT:    extractps $3, %xmm1, 12(%rdi)
; SSE4-NEXT:  .LBB0_8: # %else6
; SSE4-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm8[0,2]
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB0_9
; SSE4-NEXT:  # %bb.10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB0_11
; SSE4-NEXT:  .LBB0_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB0_13
; SSE4-NEXT:  .LBB0_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB0_15
; SSE4-NEXT:  .LBB0_16: # %else14
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB0_1: # %cond.store
; SSE4-NEXT:    movss %xmm1, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB0_4
; SSE4-NEXT:  .LBB0_3: # %cond.store1
; SSE4-NEXT:    extractps $1, %xmm1, 4(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB0_6
; SSE4-NEXT:  .LBB0_5: # %cond.store3
; SSE4-NEXT:    extractps $2, %xmm1, 8(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB0_7
; SSE4-NEXT:    jmp .LBB0_8
; SSE4-NEXT:  .LBB0_9: # %cond.store7
; SSE4-NEXT:    movss %xmm10, 16(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB0_12
; SSE4-NEXT:  .LBB0_11: # %cond.store9
; SSE4-NEXT:    extractps $1, %xmm10, 20(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB0_14
; SSE4-NEXT:  .LBB0_13: # %cond.store11
; SSE4-NEXT:    extractps $2, %xmm10, 24(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB0_16
; SSE4-NEXT:  .LBB0_15: # %cond.store13
; SSE4-NEXT:    extractps $3, %xmm10, 28(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v8i64_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm8
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372041149743103,9223372041149743103]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm9
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm6
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm5, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vpxor %xmm3, %xmm7, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpxor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vmovapd {{.*#+}} xmm5 = [4294967295,4294967295]
; AVX1-NEXT:    vblendvpd %xmm3, %xmm4, %xmm5, %xmm3
; AVX1-NEXT:    vblendvpd %xmm2, %xmm7, %xmm5, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %xmm6, %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vblendvpd %xmm9, %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX1-NEXT:    vmaskmovps %ymm0, %ymm8, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v8i64_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpxor %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm4
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm6, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm3[0,2],ymm0[4,6],ymm3[4,6]
; AVX2-NEXT:    vpmaskmovd %ymm0, %ymm2, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v8i64_v8i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovqd %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: truncstore_v8i64_v8i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512VL-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovqd %zmm0, (%rdi) {%k1}
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v8i64_v8i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BW-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovqd %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %a = icmp ne <8 x i32> %mask, zeroinitializer
  %b = icmp ult <8 x i64> %x, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %c = select <8 x i1> %b, <8 x i64> %x, <8 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %d = trunc <8 x i64> %c to <8 x i32>
  call void @llvm.masked.store.v8i32.p0v8i32(<8 x i32> %d, <8 x i32>* %p, i32 1, <8 x i1> %a)
  ret void
}

define void @truncstore_v8i64_v8i16(<8 x i64> %x, <8 x i16>* %p, <8 x i32> %mask) {
; SSE2-LABEL: truncstore_v8i64_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535]
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    pxor %xmm11, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [9223372039002324991,9223372039002324991]
; SSE2-NEXT:    movdqa %xmm10, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm12, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm13 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm13
; SSE2-NEXT:    pand %xmm13, %xmm2
; SSE2-NEXT:    pandn %xmm9, %xmm13
; SSE2-NEXT:    por %xmm2, %xmm13
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    pxor %xmm11, %xmm2
; SSE2-NEXT:    movdqa %xmm10, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm12, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm7, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    pandn %xmm9, %xmm2
; SSE2-NEXT:    por %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pxor %xmm11, %xmm3
; SSE2-NEXT:    movdqa %xmm10, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pandn %xmm9, %xmm6
; SSE2-NEXT:    por %xmm0, %xmm6
; SSE2-NEXT:    pxor %xmm1, %xmm11
; SSE2-NEXT:    movdqa %xmm10, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm11[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm9, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm13[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm1, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm4
; SSE2-NEXT:    packssdw %xmm5, %xmm4
; SSE2-NEXT:    packsswb %xmm4, %xmm4
; SSE2-NEXT:    pmovmskb %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB1_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB1_3
; SSE2-NEXT:  .LBB1_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB1_5
; SSE2-NEXT:  .LBB1_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB1_7
; SSE2-NEXT:  .LBB1_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    jne .LBB1_9
; SSE2-NEXT:  .LBB1_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    jne .LBB1_11
; SSE2-NEXT:  .LBB1_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    jne .LBB1_13
; SSE2-NEXT:  .LBB1_14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    jne .LBB1_15
; SSE2-NEXT:  .LBB1_16: # %else14
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB1_1: # %cond.store
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB1_4
; SSE2-NEXT:  .LBB1_3: # %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 2(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB1_6
; SSE2-NEXT:  .LBB1_5: # %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 4(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB1_8
; SSE2-NEXT:  .LBB1_7: # %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 6(%rdi)
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    je .LBB1_10
; SSE2-NEXT:  .LBB1_9: # %cond.store7
; SSE2-NEXT:    pextrw $4, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 8(%rdi)
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB1_12
; SSE2-NEXT:  .LBB1_11: # %cond.store9
; SSE2-NEXT:    pextrw $5, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 10(%rdi)
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    je .LBB1_14
; SSE2-NEXT:  .LBB1_13: # %cond.store11
; SSE2-NEXT:    pextrw $6, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 12(%rdi)
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB1_16
; SSE2-NEXT:  .LBB1_15: # %cond.store13
; SSE2-NEXT:    pextrw $7, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 14(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v8i64_v8i16:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm9
; SSE4-NEXT:    pxor %xmm8, %xmm8
; SSE4-NEXT:    movapd {{.*#+}} xmm6 = [65535,65535]
; SSE4-NEXT:    movdqa {{.*#+}} xmm10 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    movdqa %xmm1, %xmm7
; SSE4-NEXT:    pxor %xmm10, %xmm7
; SSE4-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854841343,9223372036854841343]
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm7, %xmm0
; SSE4-NEXT:    movapd %xmm6, %xmm7
; SSE4-NEXT:    blendvpd %xmm0, %xmm1, %xmm7
; SSE4-NEXT:    movdqa %xmm9, %xmm1
; SSE4-NEXT:    pxor %xmm10, %xmm1
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE4-NEXT:    movapd %xmm6, %xmm1
; SSE4-NEXT:    blendvpd %xmm0, %xmm9, %xmm1
; SSE4-NEXT:    packusdw %xmm7, %xmm1
; SSE4-NEXT:    movdqa %xmm3, %xmm7
; SSE4-NEXT:    pxor %xmm10, %xmm7
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm7, %xmm0
; SSE4-NEXT:    movapd %xmm6, %xmm7
; SSE4-NEXT:    blendvpd %xmm0, %xmm3, %xmm7
; SSE4-NEXT:    pxor %xmm2, %xmm10
; SSE4-NEXT:    pcmpgtq %xmm10, %xmm11
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm2, %xmm6
; SSE4-NEXT:    packusdw %xmm7, %xmm6
; SSE4-NEXT:    packusdw %xmm6, %xmm1
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE4-NEXT:    pxor %xmm0, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE4-NEXT:    pxor %xmm0, %xmm4
; SSE4-NEXT:    packssdw %xmm5, %xmm4
; SSE4-NEXT:    packsswb %xmm4, %xmm4
; SSE4-NEXT:    pmovmskb %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB1_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB1_3
; SSE4-NEXT:  .LBB1_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB1_5
; SSE4-NEXT:  .LBB1_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB1_7
; SSE4-NEXT:  .LBB1_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB1_9
; SSE4-NEXT:  .LBB1_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB1_11
; SSE4-NEXT:  .LBB1_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB1_13
; SSE4-NEXT:  .LBB1_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB1_15
; SSE4-NEXT:  .LBB1_16: # %else14
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB1_1: # %cond.store
; SSE4-NEXT:    pextrw $0, %xmm1, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB1_4
; SSE4-NEXT:  .LBB1_3: # %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm1, 2(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB1_6
; SSE4-NEXT:  .LBB1_5: # %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm1, 4(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB1_8
; SSE4-NEXT:  .LBB1_7: # %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm1, 6(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB1_10
; SSE4-NEXT:  .LBB1_9: # %cond.store7
; SSE4-NEXT:    pextrw $4, %xmm1, 8(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB1_12
; SSE4-NEXT:  .LBB1_11: # %cond.store9
; SSE4-NEXT:    pextrw $5, %xmm1, 10(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB1_14
; SSE4-NEXT:  .LBB1_13: # %cond.store11
; SSE4-NEXT:    pextrw $6, %xmm1, 12(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB1_16
; SSE4-NEXT:  .LBB1_15: # %cond.store13
; SSE4-NEXT:    pextrw $7, %xmm1, 14(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372036854841343,9223372036854841343]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm6, %xmm7
; AVX1-NEXT:    vpcmpgtq %xmm7, %xmm5, %xmm9
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm7
; AVX1-NEXT:    vpxor %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vmovapd {{.*#+}} xmm5 = [65535,65535]
; AVX1-NEXT:    vblendvpd %xmm3, %xmm7, %xmm5, %xmm3
; AVX1-NEXT:    vblendvpd %xmm4, %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vblendvpd %xmm9, %xmm6, %xmm5, %xmm3
; AVX1-NEXT:    vblendvpd %xmm8, %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmovmskps %ymm1, %eax
; AVX1-NEXT:    notl %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB1_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB1_3
; AVX1-NEXT:  .LBB1_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB1_5
; AVX1-NEXT:  .LBB1_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB1_7
; AVX1-NEXT:  .LBB1_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB1_9
; AVX1-NEXT:  .LBB1_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB1_11
; AVX1-NEXT:  .LBB1_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB1_13
; AVX1-NEXT:  .LBB1_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB1_15
; AVX1-NEXT:  .LBB1_16: # %else14
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB1_1: # %cond.store
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB1_4
; AVX1-NEXT:  .LBB1_3: # %cond.store1
; AVX1-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB1_6
; AVX1-NEXT:  .LBB1_5: # %cond.store3
; AVX1-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB1_8
; AVX1-NEXT:  .LBB1_7: # %cond.store5
; AVX1-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB1_10
; AVX1-NEXT:  .LBB1_9: # %cond.store7
; AVX1-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB1_12
; AVX1-NEXT:  .LBB1_11: # %cond.store9
; AVX1-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB1_14
; AVX1-NEXT:  .LBB1_13: # %cond.store11
; AVX1-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB1_16
; AVX1-NEXT:  .LBB1_15: # %cond.store13
; AVX1-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v8i64_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm5, %ymm1, %ymm6
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm7 = [9223372036854841343,9223372036854841343,9223372036854841343,9223372036854841343]
; AVX2-NEXT:    vpcmpgtq %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vblendvpd %ymm6, %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpxor %ymm5, %ymm0, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm1
; AVX2-NEXT:    vmovmskps %ymm1, %eax
; AVX2-NEXT:    notl %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB1_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB1_3
; AVX2-NEXT:  .LBB1_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB1_5
; AVX2-NEXT:  .LBB1_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB1_7
; AVX2-NEXT:  .LBB1_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB1_9
; AVX2-NEXT:  .LBB1_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB1_11
; AVX2-NEXT:  .LBB1_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB1_13
; AVX2-NEXT:  .LBB1_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB1_15
; AVX2-NEXT:  .LBB1_16: # %else14
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB1_1: # %cond.store
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB1_4
; AVX2-NEXT:  .LBB1_3: # %cond.store1
; AVX2-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB1_6
; AVX2-NEXT:  .LBB1_5: # %cond.store3
; AVX2-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB1_8
; AVX2-NEXT:  .LBB1_7: # %cond.store5
; AVX2-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB1_10
; AVX2-NEXT:  .LBB1_9: # %cond.store7
; AVX2-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB1_12
; AVX2-NEXT:  .LBB1_11: # %cond.store9
; AVX2-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB1_14
; AVX2-NEXT:  .LBB1_13: # %cond.store11
; AVX2-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB1_16
; AVX2-NEXT:  .LBB1_15: # %cond.store13
; AVX2-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v8i64_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB1_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB1_3
; AVX512F-NEXT:  .LBB1_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB1_5
; AVX512F-NEXT:  .LBB1_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB1_7
; AVX512F-NEXT:  .LBB1_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB1_9
; AVX512F-NEXT:  .LBB1_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB1_11
; AVX512F-NEXT:  .LBB1_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB1_13
; AVX512F-NEXT:  .LBB1_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB1_15
; AVX512F-NEXT:  .LBB1_16: # %else14
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB1_1: # %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB1_4
; AVX512F-NEXT:  .LBB1_3: # %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB1_6
; AVX512F-NEXT:  .LBB1_5: # %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB1_8
; AVX512F-NEXT:  .LBB1_7: # %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB1_10
; AVX512F-NEXT:  .LBB1_9: # %cond.store7
; AVX512F-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB1_12
; AVX512F-NEXT:  .LBB1_11: # %cond.store9
; AVX512F-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB1_14
; AVX512F-NEXT:  .LBB1_13: # %cond.store11
; AVX512F-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB1_16
; AVX512F-NEXT:  .LBB1_15: # %cond.store13
; AVX512F-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v8i64_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BW-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovqw %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v8i64_v8i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512BWVL-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovqw %zmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <8 x i32> %mask, zeroinitializer
  %b = icmp ult <8 x i64> %x, <i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535>
  %c = select <8 x i1> %b, <8 x i64> %x, <8 x i64> <i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535, i64 65535>
  %d = trunc <8 x i64> %c to <8 x i16>
  call void @llvm.masked.store.v8i16.p0v8i16(<8 x i16> %d, <8 x i16>* %p, i32 1, <8 x i1> %a)
  ret void
}

define void @truncstore_v8i64_v8i8(<8 x i64> %x, <8 x i8>* %p, <8 x i32> %mask) {
; SSE2-LABEL: truncstore_v8i64_v8i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [255,255]
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    movdqa %xmm1, %xmm7
; SSE2-NEXT:    pxor %xmm11, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [9223372039002259711,9223372039002259711]
; SSE2-NEXT:    movdqa %xmm10, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-NEXT:    pand %xmm12, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm7, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm1
; SSE2-NEXT:    pandn %xmm9, %xmm6
; SSE2-NEXT:    por %xmm1, %xmm6
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm11, %xmm1
; SSE2-NEXT:    movdqa %xmm10, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm12 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pand %xmm12, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm0
; SSE2-NEXT:    pandn %xmm9, %xmm7
; SSE2-NEXT:    por %xmm0, %xmm7
; SSE2-NEXT:    packuswb %xmm6, %xmm7
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm11, %xmm0
; SSE2-NEXT:    movdqa %xmm10, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pandn %xmm9, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm11
; SSE2-NEXT:    movdqa %xmm10, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn %xmm9, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm7
; SSE2-NEXT:    packuswb %xmm7, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm0, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm4
; SSE2-NEXT:    packssdw %xmm5, %xmm4
; SSE2-NEXT:    packsswb %xmm4, %xmm4
; SSE2-NEXT:    pmovmskb %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm7, %ecx
; SSE2-NEXT:    jne .LBB2_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB2_3
; SSE2-NEXT:  .LBB2_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB2_5
; SSE2-NEXT:  .LBB2_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB2_8
; SSE2-NEXT:  .LBB2_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 3(%rdi)
; SSE2-NEXT:  .LBB2_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    pextrw $2, %xmm7, %ecx
; SSE2-NEXT:    je .LBB2_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    movb %cl, 4(%rdi)
; SSE2-NEXT:  .LBB2_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB2_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    movb %ch, 5(%rdi)
; SSE2-NEXT:  .LBB2_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    pextrw $3, %xmm7, %ecx
; SSE2-NEXT:    jne .LBB2_13
; SSE2-NEXT:  # %bb.14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    jne .LBB2_15
; SSE2-NEXT:  .LBB2_16: # %else14
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB2_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB2_4
; SSE2-NEXT:  .LBB2_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB2_6
; SSE2-NEXT:  .LBB2_5: # %cond.store3
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB2_7
; SSE2-NEXT:    jmp .LBB2_8
; SSE2-NEXT:  .LBB2_13: # %cond.store11
; SSE2-NEXT:    movb %cl, 6(%rdi)
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB2_16
; SSE2-NEXT:  .LBB2_15: # %cond.store13
; SSE2-NEXT:    movb %ch, 7(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v8i64_v8i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm9
; SSE4-NEXT:    pxor %xmm8, %xmm8
; SSE4-NEXT:    movapd {{.*#+}} xmm6 = [255,255]
; SSE4-NEXT:    movdqa {{.*#+}} xmm10 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    movdqa %xmm1, %xmm7
; SSE4-NEXT:    pxor %xmm10, %xmm7
; SSE4-NEXT:    movdqa {{.*#+}} xmm11 = [9223372036854776063,9223372036854776063]
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm7, %xmm0
; SSE4-NEXT:    movapd %xmm6, %xmm7
; SSE4-NEXT:    blendvpd %xmm0, %xmm1, %xmm7
; SSE4-NEXT:    movdqa %xmm9, %xmm1
; SSE4-NEXT:    pxor %xmm10, %xmm1
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm1, %xmm0
; SSE4-NEXT:    movapd %xmm6, %xmm1
; SSE4-NEXT:    blendvpd %xmm0, %xmm9, %xmm1
; SSE4-NEXT:    packusdw %xmm7, %xmm1
; SSE4-NEXT:    movdqa %xmm3, %xmm7
; SSE4-NEXT:    pxor %xmm10, %xmm7
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm7, %xmm0
; SSE4-NEXT:    movapd %xmm6, %xmm7
; SSE4-NEXT:    blendvpd %xmm0, %xmm3, %xmm7
; SSE4-NEXT:    pxor %xmm2, %xmm10
; SSE4-NEXT:    pcmpgtq %xmm10, %xmm11
; SSE4-NEXT:    movdqa %xmm11, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm2, %xmm6
; SSE4-NEXT:    packusdw %xmm7, %xmm6
; SSE4-NEXT:    packusdw %xmm6, %xmm1
; SSE4-NEXT:    packuswb %xmm1, %xmm1
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE4-NEXT:    pxor %xmm0, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE4-NEXT:    pxor %xmm0, %xmm4
; SSE4-NEXT:    packssdw %xmm5, %xmm4
; SSE4-NEXT:    packsswb %xmm4, %xmm4
; SSE4-NEXT:    pmovmskb %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB2_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB2_3
; SSE4-NEXT:  .LBB2_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB2_5
; SSE4-NEXT:  .LBB2_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB2_7
; SSE4-NEXT:  .LBB2_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB2_9
; SSE4-NEXT:  .LBB2_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB2_11
; SSE4-NEXT:  .LBB2_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB2_13
; SSE4-NEXT:  .LBB2_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB2_15
; SSE4-NEXT:  .LBB2_16: # %else14
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB2_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm1, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB2_4
; SSE4-NEXT:  .LBB2_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm1, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB2_6
; SSE4-NEXT:  .LBB2_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm1, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB2_8
; SSE4-NEXT:  .LBB2_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm1, 3(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB2_10
; SSE4-NEXT:  .LBB2_9: # %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm1, 4(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB2_12
; SSE4-NEXT:  .LBB2_11: # %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm1, 5(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB2_14
; SSE4-NEXT:  .LBB2_13: # %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm1, 6(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB2_16
; SSE4-NEXT:  .LBB2_15: # %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm1, 7(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v8i64_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372036854776063,9223372036854776063]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm6, %xmm7
; AVX1-NEXT:    vpcmpgtq %xmm7, %xmm5, %xmm9
; AVX1-NEXT:    vpxor %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm7
; AVX1-NEXT:    vpxor %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vmovapd {{.*#+}} xmm5 = [255,255]
; AVX1-NEXT:    vblendvpd %xmm3, %xmm7, %xmm5, %xmm3
; AVX1-NEXT:    vblendvpd %xmm4, %xmm1, %xmm5, %xmm1
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vblendvpd %xmm9, %xmm6, %xmm5, %xmm3
; AVX1-NEXT:    vblendvpd %xmm8, %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    vmovmskps %ymm1, %eax
; AVX1-NEXT:    notl %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB2_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB2_3
; AVX1-NEXT:  .LBB2_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB2_5
; AVX1-NEXT:  .LBB2_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB2_7
; AVX1-NEXT:  .LBB2_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB2_9
; AVX1-NEXT:  .LBB2_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB2_11
; AVX1-NEXT:  .LBB2_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB2_13
; AVX1-NEXT:  .LBB2_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB2_15
; AVX1-NEXT:  .LBB2_16: # %else14
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB2_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB2_4
; AVX1-NEXT:  .LBB2_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB2_6
; AVX1-NEXT:  .LBB2_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB2_8
; AVX1-NEXT:  .LBB2_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB2_10
; AVX1-NEXT:  .LBB2_9: # %cond.store7
; AVX1-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB2_12
; AVX1-NEXT:  .LBB2_11: # %cond.store9
; AVX1-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB2_14
; AVX1-NEXT:  .LBB2_13: # %cond.store11
; AVX1-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB2_16
; AVX1-NEXT:  .LBB2_15: # %cond.store13
; AVX1-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v8i64_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm4 = [255,255,255,255]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm5, %ymm1, %ymm6
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm7 = [9223372036854776063,9223372036854776063,9223372036854776063,9223372036854776063]
; AVX2-NEXT:    vpcmpgtq %ymm6, %ymm7, %ymm6
; AVX2-NEXT:    vblendvpd %ymm6, %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpxor %ymm5, %ymm0, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vblendvpd %ymm5, %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm1
; AVX2-NEXT:    vmovmskps %ymm1, %eax
; AVX2-NEXT:    notl %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB2_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB2_3
; AVX2-NEXT:  .LBB2_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB2_5
; AVX2-NEXT:  .LBB2_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB2_7
; AVX2-NEXT:  .LBB2_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB2_9
; AVX2-NEXT:  .LBB2_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB2_11
; AVX2-NEXT:  .LBB2_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB2_13
; AVX2-NEXT:  .LBB2_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB2_15
; AVX2-NEXT:  .LBB2_16: # %else14
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB2_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB2_4
; AVX2-NEXT:  .LBB2_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB2_6
; AVX2-NEXT:  .LBB2_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB2_8
; AVX2-NEXT:  .LBB2_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB2_10
; AVX2-NEXT:  .LBB2_9: # %cond.store7
; AVX2-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB2_12
; AVX2-NEXT:  .LBB2_11: # %cond.store9
; AVX2-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB2_14
; AVX2-NEXT:  .LBB2_13: # %cond.store11
; AVX2-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB2_16
; AVX2-NEXT:  .LBB2_15: # %cond.store13
; AVX2-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v8i64_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB2_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB2_3
; AVX512F-NEXT:  .LBB2_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB2_5
; AVX512F-NEXT:  .LBB2_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB2_7
; AVX512F-NEXT:  .LBB2_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB2_9
; AVX512F-NEXT:  .LBB2_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB2_11
; AVX512F-NEXT:  .LBB2_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB2_13
; AVX512F-NEXT:  .LBB2_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB2_15
; AVX512F-NEXT:  .LBB2_16: # %else14
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB2_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB2_4
; AVX512F-NEXT:  .LBB2_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB2_6
; AVX512F-NEXT:  .LBB2_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB2_8
; AVX512F-NEXT:  .LBB2_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB2_10
; AVX512F-NEXT:  .LBB2_9: # %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB2_12
; AVX512F-NEXT:  .LBB2_11: # %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB2_14
; AVX512F-NEXT:  .LBB2_13: # %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB2_16
; AVX512F-NEXT:  .LBB2_15: # %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v8i64_v8i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BW-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovqb %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v8i64_v8i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512BWVL-NEXT:    vpminuq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovqb %zmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <8 x i32> %mask, zeroinitializer
  %b = icmp ult <8 x i64> %x, <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %c = select <8 x i1> %b, <8 x i64> %x, <8 x i64> <i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255, i64 255>
  %d = trunc <8 x i64> %c to <8 x i8>
  call void @llvm.masked.store.v8i8.p0v8i8(<8 x i8> %d, <8 x i8>* %p, i32 1, <8 x i1> %a)
  ret void
}

define void @truncstore_v4i64_v4i32(<4 x i64> %x, <4 x i32>* %p, <4 x i32> %mask) {
; SSE2-LABEL: truncstore_v4i64_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [4294967295,4294967295]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    pxor %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002259455,9223372039002259455]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm8, %xmm4
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm5
; SSE2-NEXT:    movdqa %xmm9, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm1[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pandn %xmm8, %xmm1
; SSE2-NEXT:    por %xmm0, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm4[0,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    movmskps %xmm3, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB3_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB3_3
; SSE2-NEXT:  .LBB3_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB3_5
; SSE2-NEXT:  .LBB3_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB3_7
; SSE2-NEXT:  .LBB3_8: # %else6
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB3_1: # %cond.store
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB3_4
; SSE2-NEXT:  .LBB3_3: # %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,1,2,3]
; SSE2-NEXT:    movd %xmm0, 4(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB3_6
; SSE2-NEXT:  .LBB3_5: # %cond.store3
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    movd %xmm0, 8(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB3_8
; SSE2-NEXT:  .LBB3_7: # %cond.store5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, 12(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v4i64_v4i32:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm8
; SSE4-NEXT:    pxor %xmm6, %xmm6
; SSE4-NEXT:    movapd {{.*#+}} xmm5 = [4294967295,4294967295]
; SSE4-NEXT:    movdqa {{.*#+}} xmm7 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    movdqa %xmm1, %xmm3
; SSE4-NEXT:    pxor %xmm7, %xmm3
; SSE4-NEXT:    movdqa {{.*#+}} xmm4 = [9223372041149743103,9223372041149743103]
; SSE4-NEXT:    movdqa %xmm4, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm3, %xmm0
; SSE4-NEXT:    movapd %xmm5, %xmm3
; SSE4-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE4-NEXT:    pxor %xmm8, %xmm7
; SSE4-NEXT:    pcmpgtq %xmm7, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm8, %xmm5
; SSE4-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm3[0,2]
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm6
; SSE4-NEXT:    movmskps %xmm6, %eax
; SSE4-NEXT:    xorl $15, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB3_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB3_3
; SSE4-NEXT:  .LBB3_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB3_5
; SSE4-NEXT:  .LBB3_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB3_7
; SSE4-NEXT:  .LBB3_8: # %else6
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB3_1: # %cond.store
; SSE4-NEXT:    movss %xmm5, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB3_4
; SSE4-NEXT:  .LBB3_3: # %cond.store1
; SSE4-NEXT:    extractps $1, %xmm5, 4(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB3_6
; SSE4-NEXT:  .LBB3_5: # %cond.store3
; SSE4-NEXT:    extractps $2, %xmm5, 8(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB3_8
; SSE4-NEXT:  .LBB3_7: # %cond.store5
; SSE4-NEXT:    extractps $3, %xmm5, 12(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372041149743103,9223372041149743103]
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpxor %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vmovapd {{.*#+}} xmm4 = [4294967295,4294967295]
; AVX1-NEXT:    vblendvpd %xmm2, %xmm5, %xmm4, %xmm2
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX1-NEXT:    vmaskmovps %xmm0, %xmm1, (%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v4i64_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm2 = [4294967295,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm3, %ymm0, %ymm3
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372041149743103,9223372041149743103,9223372041149743103,9223372041149743103]
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm4, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX2-NEXT:    vpmaskmovd %xmm0, %xmm1, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v4i64_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512F-NEXT:    vmovdqu32 %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: truncstore_v4i64_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vpminuq {{.*}}(%rip){1to4}, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovqd %ymm0, (%rdi) {%k1}
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v4i64_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlw $12, %k0, %k0
; AVX512BW-NEXT:    kshiftrw $12, %k0, %k1
; AVX512BW-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu32 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %a = icmp ne <4 x i32> %mask, zeroinitializer
  %b = icmp ult <4 x i64> %x, <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %c = select <4 x i1> %b, <4 x i64> %x, <4 x i64> <i64 4294967295, i64 4294967295, i64 4294967295, i64 4294967295>
  %d = trunc <4 x i64> %c to <4 x i32>
  call void @llvm.masked.store.v4i32.p0v4i32(<4 x i32> %d, <4 x i32>* %p, i32 1, <4 x i1> %a)
  ret void
}

define void @truncstore_v4i64_v4i16(<4 x i64> %x, <4 x i16>* %p, <4 x i32> %mask) {
; SSE2-LABEL: truncstore_v4i64_v4i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    pxor %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [9223372039002324991,9223372039002324991]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm4, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn %xmm8, %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm9, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    movmskps %xmm3, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB4_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB4_3
; SSE2-NEXT:  .LBB4_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB4_5
; SSE2-NEXT:  .LBB4_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB4_7
; SSE2-NEXT:  .LBB4_8: # %else6
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB4_1: # %cond.store
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB4_4
; SSE2-NEXT:  .LBB4_3: # %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 2(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB4_6
; SSE2-NEXT:  .LBB4_5: # %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 4(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB4_8
; SSE2-NEXT:  .LBB4_7: # %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 6(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v4i64_v4i16:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm8
; SSE4-NEXT:    pxor %xmm6, %xmm6
; SSE4-NEXT:    movapd {{.*#+}} xmm5 = [65535,65535]
; SSE4-NEXT:    movdqa {{.*#+}} xmm7 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    movdqa %xmm1, %xmm3
; SSE4-NEXT:    pxor %xmm7, %xmm3
; SSE4-NEXT:    movdqa {{.*#+}} xmm4 = [9223372036854841343,9223372036854841343]
; SSE4-NEXT:    movdqa %xmm4, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm3, %xmm0
; SSE4-NEXT:    movapd %xmm5, %xmm3
; SSE4-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE4-NEXT:    pxor %xmm8, %xmm7
; SSE4-NEXT:    pcmpgtq %xmm7, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm8, %xmm5
; SSE4-NEXT:    packusdw %xmm3, %xmm5
; SSE4-NEXT:    packusdw %xmm5, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm6
; SSE4-NEXT:    movmskps %xmm6, %eax
; SSE4-NEXT:    xorl $15, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB4_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB4_3
; SSE4-NEXT:  .LBB4_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB4_5
; SSE4-NEXT:  .LBB4_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB4_7
; SSE4-NEXT:  .LBB4_8: # %else6
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB4_1: # %cond.store
; SSE4-NEXT:    pextrw $0, %xmm5, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB4_4
; SSE4-NEXT:  .LBB4_3: # %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm5, 2(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB4_6
; SSE4-NEXT:  .LBB4_5: # %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm5, 4(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB4_8
; SSE4-NEXT:  .LBB4_7: # %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm5, 6(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v4i64_v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372036854841343,9223372036854841343]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vmovapd {{.*#+}} xmm5 = [65535,65535]
; AVX1-NEXT:    vblendvpd %xmm3, %xmm6, %xmm5, %xmm3
; AVX1-NEXT:    vblendvpd %xmm4, %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovmskps %xmm1, %eax
; AVX1-NEXT:    xorl $15, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB4_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB4_3
; AVX1-NEXT:  .LBB4_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB4_5
; AVX1-NEXT:  .LBB4_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB4_7
; AVX1-NEXT:  .LBB4_8: # %else6
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB4_1: # %cond.store
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB4_4
; AVX1-NEXT:  .LBB4_3: # %cond.store1
; AVX1-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB4_6
; AVX1-NEXT:  .LBB4_5: # %cond.store3
; AVX1-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB4_8
; AVX1-NEXT:  .LBB4_7: # %cond.store5
; AVX1-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v4i64_v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm4
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372036854841343,9223372036854841343,9223372036854841343,9223372036854841343]
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovmskps %xmm1, %eax
; AVX2-NEXT:    xorl $15, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB4_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB4_3
; AVX2-NEXT:  .LBB4_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB4_5
; AVX2-NEXT:  .LBB4_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB4_7
; AVX2-NEXT:  .LBB4_8: # %else6
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB4_1: # %cond.store
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB4_4
; AVX2-NEXT:  .LBB4_3: # %cond.store1
; AVX2-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB4_6
; AVX2-NEXT:  .LBB4_5: # %cond.store3
; AVX2-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB4_8
; AVX2-NEXT:  .LBB4_7: # %cond.store5
; AVX2-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v4i64_v4i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB4_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB4_3
; AVX512F-NEXT:  .LBB4_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB4_5
; AVX512F-NEXT:  .LBB4_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB4_7
; AVX512F-NEXT:  .LBB4_8: # %else6
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB4_1: # %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB4_4
; AVX512F-NEXT:  .LBB4_3: # %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB4_6
; AVX512F-NEXT:  .LBB4_5: # %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB4_8
; AVX512F-NEXT:  .LBB4_7: # %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v4i64_v4i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftld $28, %k0, %k0
; AVX512BW-NEXT:    kshiftrd $28, %k0, %k1
; AVX512BW-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu16 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v4i64_v4i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminuq {{.*}}(%rip){1to4}, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovqw %ymm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <4 x i32> %mask, zeroinitializer
  %b = icmp ult <4 x i64> %x, <i64 65535, i64 65535, i64 65535, i64 65535>
  %c = select <4 x i1> %b, <4 x i64> %x, <4 x i64> <i64 65535, i64 65535, i64 65535, i64 65535>
  %d = trunc <4 x i64> %c to <4 x i16>
  call void @llvm.masked.store.v4i16.p0v4i16(<4 x i16> %d, <4 x i16>* %p, i32 1, <4 x i1> %a)
  ret void
}

define void @truncstore_v4i64_v4i8(<4 x i64> %x, <4 x i8>* %p, <4 x i32> %mask) {
; SSE2-LABEL: truncstore_v4i64_v4i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [255,255]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [9223372039002259711,9223372039002259711]
; SSE2-NEXT:    movdqa %xmm10, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm7[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn %xmm8, %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm1, %xmm6
; SSE2-NEXT:    movdqa %xmm10, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm8, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pand %xmm8, %xmm0
; SSE2-NEXT:    pand %xmm8, %xmm4
; SSE2-NEXT:    packuswb %xmm0, %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm9
; SSE2-NEXT:    movmskps %xmm9, %ecx
; SSE2-NEXT:    xorl $15, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    jne .LBB5_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %cl
; SSE2-NEXT:    jne .LBB5_3
; SSE2-NEXT:  .LBB5_4: # %else2
; SSE2-NEXT:    testb $4, %cl
; SSE2-NEXT:    jne .LBB5_5
; SSE2-NEXT:  .LBB5_6: # %else4
; SSE2-NEXT:    testb $8, %cl
; SSE2-NEXT:    jne .LBB5_7
; SSE2-NEXT:  .LBB5_8: # %else6
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB5_1: # %cond.store
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    testb $2, %cl
; SSE2-NEXT:    je .LBB5_4
; SSE2-NEXT:  .LBB5_3: # %cond.store1
; SSE2-NEXT:    movb %ah, 1(%rdi)
; SSE2-NEXT:    testb $4, %cl
; SSE2-NEXT:    je .LBB5_6
; SSE2-NEXT:  .LBB5_5: # %cond.store3
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %cl
; SSE2-NEXT:    je .LBB5_8
; SSE2-NEXT:  .LBB5_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    movb %al, 3(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v4i64_v4i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm3
; SSE4-NEXT:    pxor %xmm8, %xmm8
; SSE4-NEXT:    movapd {{.*#+}} xmm7 = [255,255]
; SSE4-NEXT:    movdqa {{.*#+}} xmm6 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    movdqa %xmm0, %xmm5
; SSE4-NEXT:    pxor %xmm6, %xmm5
; SSE4-NEXT:    movdqa {{.*#+}} xmm4 = [9223372036854776063,9223372036854776063]
; SSE4-NEXT:    movdqa %xmm4, %xmm0
; SSE4-NEXT:    pcmpgtq %xmm5, %xmm0
; SSE4-NEXT:    movapd %xmm7, %xmm5
; SSE4-NEXT:    blendvpd %xmm0, %xmm3, %xmm5
; SSE4-NEXT:    pxor %xmm1, %xmm6
; SSE4-NEXT:    pcmpgtq %xmm6, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm1, %xmm7
; SSE4-NEXT:    movdqa {{.*#+}} xmm0 = <0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; SSE4-NEXT:    pshufb %xmm0, %xmm7
; SSE4-NEXT:    pshufb %xmm0, %xmm5
; SSE4-NEXT:    punpcklwd {{.*#+}} xmm5 = xmm5[0],xmm7[0],xmm5[1],xmm7[1],xmm5[2],xmm7[2],xmm5[3],xmm7[3]
; SSE4-NEXT:    pcmpeqd %xmm2, %xmm8
; SSE4-NEXT:    movmskps %xmm8, %eax
; SSE4-NEXT:    xorl $15, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB5_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB5_3
; SSE4-NEXT:  .LBB5_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB5_5
; SSE4-NEXT:  .LBB5_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB5_7
; SSE4-NEXT:  .LBB5_8: # %else6
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB5_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm5, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB5_4
; SSE4-NEXT:  .LBB5_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm5, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB5_6
; SSE4-NEXT:  .LBB5_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm5, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB5_8
; SSE4-NEXT:  .LBB5_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm5, 3(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v4i64_v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372036854776063,9223372036854776063]
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vpxor %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm5, %xmm3
; AVX1-NEXT:    vmovapd {{.*#+}} xmm5 = [255,255]
; AVX1-NEXT:    vblendvpd %xmm3, %xmm6, %xmm5, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = <0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX1-NEXT:    vpshufb %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vblendvpd %xmm4, %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovmskps %xmm1, %eax
; AVX1-NEXT:    xorl $15, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB5_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB5_3
; AVX1-NEXT:  .LBB5_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB5_5
; AVX1-NEXT:  .LBB5_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB5_7
; AVX1-NEXT:  .LBB5_8: # %else6
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB5_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB5_4
; AVX1-NEXT:  .LBB5_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB5_6
; AVX1-NEXT:  .LBB5_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB5_8
; AVX1-NEXT:  .LBB5_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v4i64_v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm3 = [255,255,255,255]
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm4
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [9223372036854776063,9223372036854776063,9223372036854776063,9223372036854776063]
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = <0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u>
; AVX2-NEXT:    vpshufb %xmm4, %xmm3, %xmm3
; AVX2-NEXT:    vpshufb %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpunpcklwd {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3]
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovmskps %xmm1, %eax
; AVX2-NEXT:    xorl $15, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB5_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB5_3
; AVX2-NEXT:  .LBB5_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB5_5
; AVX2-NEXT:  .LBB5_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB5_7
; AVX2-NEXT:  .LBB5_8: # %else6
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB5_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB5_4
; AVX2-NEXT:  .LBB5_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB5_6
; AVX2-NEXT:  .LBB5_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB5_8
; AVX2-NEXT:  .LBB5_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v4i64_v4i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB5_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB5_3
; AVX512F-NEXT:  .LBB5_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB5_5
; AVX512F-NEXT:  .LBB5_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB5_7
; AVX512F-NEXT:  .LBB5_8: # %else6
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB5_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB5_4
; AVX512F-NEXT:  .LBB5_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB5_6
; AVX512F-NEXT:  .LBB5_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB5_8
; AVX512F-NEXT:  .LBB5_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v4i64_v4i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlq $60, %k0, %k0
; AVX512BW-NEXT:    kshiftrq $60, %k0, %k1
; AVX512BW-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v4i64_v4i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminuq {{.*}}(%rip){1to4}, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovqb %ymm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <4 x i32> %mask, zeroinitializer
  %b = icmp ult <4 x i64> %x, <i64 255, i64 255, i64 255, i64 255>
  %c = select <4 x i1> %b, <4 x i64> %x, <4 x i64> <i64 255, i64 255, i64 255, i64 255>
  %d = trunc <4 x i64> %c to <4 x i8>
  call void @llvm.masked.store.v4i8.p0v4i8(<4 x i8> %d, <4 x i8>* %p, i32 1, <4 x i1> %a)
  ret void
}

define void @truncstore_v2i64_v2i32(<2 x i64> %x, <2 x i32>* %p, <2 x i64> %mask) {
; SSE2-LABEL: truncstore_v2i64_v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    pxor %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259455,9223372039002259455]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,2,2,3]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    movmskpd %xmm1, %eax
; SSE2-NEXT:    xorl $3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB6_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB6_3
; SSE2-NEXT:  .LBB6_4: # %else2
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB6_1: # %cond.store
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB6_4
; SSE2-NEXT:  .LBB6_3: # %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm0, 4(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v2i64_v2i32:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pxor %xmm3, %xmm3
; SSE4-NEXT:    movapd {{.*#+}} xmm4 = [4294967295,4294967295]
; SSE4-NEXT:    movdqa {{.*#+}} xmm5 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    pxor %xmm0, %xmm5
; SSE4-NEXT:    movdqa {{.*#+}} xmm0 = [9223372041149743103,9223372041149743103]
; SSE4-NEXT:    pcmpgtq %xmm5, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm2, %xmm4
; SSE4-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,2,2,3]
; SSE4-NEXT:    pcmpeqq %xmm1, %xmm3
; SSE4-NEXT:    movmskpd %xmm3, %eax
; SSE4-NEXT:    xorl $3, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB6_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB6_3
; SSE4-NEXT:  .LBB6_4: # %else2
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB6_1: # %cond.store
; SSE4-NEXT:    movd %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB6_4
; SSE4-NEXT:  .LBB6_3: # %cond.store1
; SSE4-NEXT:    pextrd $1, %xmm0, 4(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v2i64_v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,2],zero,zero
; AVX1-NEXT:    vmovapd {{.*#+}} xmm2 = [4294967295,4294967295]
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372041149743103,9223372041149743103]
; AVX1-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vblendvpd %xmm3, %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vmaskmovps %xmm0, %xmm1, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v2i64_v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,2],zero,zero
; AVX2-NEXT:    vmovapd {{.*#+}} xmm2 = [4294967295,4294967295]
; AVX2-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372041149743103,9223372041149743103]
; AVX2-NEXT:    vpcmpgtq %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vblendvpd %xmm3, %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vpmaskmovd %xmm0, %xmm1, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v2i64_v2i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512F-NEXT:    vmovdqu32 %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: truncstore_v2i64_v2i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestmq %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vpminuq {{.*}}(%rip), %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovqd %xmm0, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v2i64_v2i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlw $14, %k0, %k0
; AVX512BW-NEXT:    kshiftrw $14, %k0, %k1
; AVX512BW-NEXT:    vpmovusqd %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu32 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
  %a = icmp ne <2 x i64> %mask, zeroinitializer
  %b = icmp ult <2 x i64> %x, <i64 4294967295, i64 4294967295>
  %c = select <2 x i1> %b, <2 x i64> %x, <2 x i64> <i64 4294967295, i64 4294967295>
  %d = trunc <2 x i64> %c to <2 x i32>
  call void @llvm.masked.store.v2i32.p0v2i32(<2 x i32> %d, <2 x i32>* %p, i32 1, <2 x i1> %a)
  ret void
}

define void @truncstore_v2i64_v2i16(<2 x i64> %x, <2 x i16>* %p, <2 x i64> %mask) {
; SSE2-LABEL: truncstore_v2i64_v2i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    pxor %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002324991,9223372039002324991]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    movmskpd %xmm1, %eax
; SSE2-NEXT:    xorl $3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB7_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB7_3
; SSE2-NEXT:  .LBB7_4: # %else2
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB7_1: # %cond.store
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB7_4
; SSE2-NEXT:  .LBB7_3: # %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 2(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v2i64_v2i16:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pxor %xmm3, %xmm3
; SSE4-NEXT:    movapd {{.*#+}} xmm4 = [65535,65535]
; SSE4-NEXT:    movdqa {{.*#+}} xmm5 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    pxor %xmm0, %xmm5
; SSE4-NEXT:    movdqa {{.*#+}} xmm0 = [9223372036854841343,9223372036854841343]
; SSE4-NEXT:    pcmpgtq %xmm5, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm2, %xmm4
; SSE4-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[0,2,2,3]
; SSE4-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE4-NEXT:    pcmpeqq %xmm1, %xmm3
; SSE4-NEXT:    movmskpd %xmm3, %eax
; SSE4-NEXT:    xorl $3, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB7_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB7_3
; SSE4-NEXT:  .LBB7_4: # %else2
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB7_1: # %cond.store
; SSE4-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB7_4
; SSE4-NEXT:  .LBB7_3: # %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm0, 2(%rdi)
; SSE4-NEXT:    retq
;
; AVX-LABEL: truncstore_v2i64_v2i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vmovapd {{.*#+}} xmm3 = [65535,65535]
; AVX-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm4
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372036854841343,9223372036854841343]
; AVX-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vblendvpd %xmm4, %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vmovmskpd %xmm1, %eax
; AVX-NEXT:    xorl $3, %eax
; AVX-NEXT:    testb $1, %al
; AVX-NEXT:    jne .LBB7_1
; AVX-NEXT:  # %bb.2: # %else
; AVX-NEXT:    testb $2, %al
; AVX-NEXT:    jne .LBB7_3
; AVX-NEXT:  .LBB7_4: # %else2
; AVX-NEXT:    retq
; AVX-NEXT:  .LBB7_1: # %cond.store
; AVX-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX-NEXT:    testb $2, %al
; AVX-NEXT:    je .LBB7_4
; AVX-NEXT:  .LBB7_3: # %cond.store1
; AVX-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v2i64_v2i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB7_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB7_3
; AVX512F-NEXT:  .LBB7_4: # %else2
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB7_1: # %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB7_4
; AVX512F-NEXT:  .LBB7_3: # %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v2i64_v2i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftld $30, %k0, %k0
; AVX512BW-NEXT:    kshiftrd $30, %k0, %k1
; AVX512BW-NEXT:    vpmovusqw %zmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu16 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v2i64_v2i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmq %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminuq {{.*}}(%rip), %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovqw %xmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <2 x i64> %mask, zeroinitializer
  %b = icmp ult <2 x i64> %x, <i64 65535, i64 65535>
  %c = select <2 x i1> %b, <2 x i64> %x, <2 x i64> <i64 65535, i64 65535>
  %d = trunc <2 x i64> %c to <2 x i16>
  call void @llvm.masked.store.v2i16.p0v2i16(<2 x i16> %d, <2 x i16>* %p, i32 1, <2 x i1> %a)
  ret void
}

define void @truncstore_v2i64_v2i8(<2 x i64> %x, <2 x i8>* %p, <2 x i64> %mask) {
; SSE2-LABEL: truncstore_v2i64_v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    pxor %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259711,9223372039002259711]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movmskpd %xmm0, %eax
; SSE2-NEXT:    xorl $3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm4, %ecx
; SSE2-NEXT:    jne .LBB8_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB8_3
; SSE2-NEXT:  .LBB8_4: # %else2
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB8_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB8_4
; SSE2-NEXT:  .LBB8_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v2i64_v2i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    movapd {{.*#+}} xmm3 = [255,255]
; SSE4-NEXT:    movdqa {{.*#+}} xmm5 = [9223372036854775808,9223372036854775808]
; SSE4-NEXT:    pxor %xmm0, %xmm5
; SSE4-NEXT:    movdqa {{.*#+}} xmm0 = [9223372036854776063,9223372036854776063]
; SSE4-NEXT:    pcmpgtq %xmm5, %xmm0
; SSE4-NEXT:    blendvpd %xmm0, %xmm2, %xmm3
; SSE4-NEXT:    pshufb {{.*#+}} xmm3 = xmm3[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; SSE4-NEXT:    pcmpeqq %xmm1, %xmm4
; SSE4-NEXT:    movmskpd %xmm4, %eax
; SSE4-NEXT:    xorl $3, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB8_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB8_3
; SSE4-NEXT:  .LBB8_4: # %else2
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB8_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm3, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB8_4
; SSE4-NEXT:  .LBB8_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm3, 1(%rdi)
; SSE4-NEXT:    retq
;
; AVX-LABEL: truncstore_v2i64_v2i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vmovapd {{.*#+}} xmm3 = [255,255]
; AVX-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm4
; AVX-NEXT:    vmovdqa {{.*#+}} xmm5 = [9223372036854776063,9223372036854776063]
; AVX-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX-NEXT:    vblendvpd %xmm4, %xmm0, %xmm3, %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,8,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vmovmskpd %xmm1, %eax
; AVX-NEXT:    xorl $3, %eax
; AVX-NEXT:    testb $1, %al
; AVX-NEXT:    jne .LBB8_1
; AVX-NEXT:  # %bb.2: # %else
; AVX-NEXT:    testb $2, %al
; AVX-NEXT:    jne .LBB8_3
; AVX-NEXT:  .LBB8_4: # %else2
; AVX-NEXT:    retq
; AVX-NEXT:  .LBB8_1: # %cond.store
; AVX-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX-NEXT:    testb $2, %al
; AVX-NEXT:    je .LBB8_4
; AVX-NEXT:  .LBB8_3: # %cond.store1
; AVX-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v2i64_v2i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB8_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB8_3
; AVX512F-NEXT:  .LBB8_4: # %else2
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB8_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB8_4
; AVX512F-NEXT:  .LBB8_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v2i64_v2i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlq $62, %k0, %k0
; AVX512BW-NEXT:    kshiftrq $62, %k0, %k1
; AVX512BW-NEXT:    vpmovusqb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v2i64_v2i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmq %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminuq {{.*}}(%rip), %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovqb %xmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <2 x i64> %mask, zeroinitializer
  %b = icmp ult <2 x i64> %x, <i64 255, i64 255>
  %c = select <2 x i1> %b, <2 x i64> %x, <2 x i64> <i64 255, i64 255>
  %d = trunc <2 x i64> %c to <2 x i8>
  call void @llvm.masked.store.v2i8.p0v2i8(<2 x i8> %d, <2 x i8>* %p, i32 1, <2 x i1> %a)
  ret void
}

define void @truncstore_v16i32_v16i16(<16 x i32> %x, <16 x i16>* %p, <16 x i32> %mask) {
; SSE2-LABEL: truncstore_v16i32_v16i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm12, %xmm12
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    pxor %xmm11, %xmm9
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm10, %xmm8
; SSE2-NEXT:    pcmpgtd %xmm9, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm9
; SSE2-NEXT:    pand %xmm8, %xmm0
; SSE2-NEXT:    pxor %xmm9, %xmm8
; SSE2-NEXT:    por %xmm0, %xmm8
; SSE2-NEXT:    movdqa %xmm1, %xmm13
; SSE2-NEXT:    pxor %xmm11, %xmm13
; SSE2-NEXT:    movdqa %xmm10, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm13, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    pslld $16, %xmm8
; SSE2-NEXT:    psrad $16, %xmm8
; SSE2-NEXT:    packssdw %xmm0, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm12, %xmm7
; SSE2-NEXT:    pxor %xmm9, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm12, %xmm6
; SSE2-NEXT:    pxor %xmm9, %xmm6
; SSE2-NEXT:    packssdw %xmm7, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm12, %xmm5
; SSE2-NEXT:    pxor %xmm9, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm12, %xmm4
; SSE2-NEXT:    pxor %xmm9, %xmm4
; SSE2-NEXT:    packssdw %xmm5, %xmm4
; SSE2-NEXT:    packsswb %xmm6, %xmm4
; SSE2-NEXT:    pmovmskb %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je .LBB9_2
; SSE2-NEXT:  # %bb.1: # %cond.store
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:  .LBB9_2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB9_4
; SSE2-NEXT:  # %bb.3: # %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 2(%rdi)
; SSE2-NEXT:  .LBB9_4: # %else2
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    pxor %xmm11, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm11
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB9_6
; SSE2-NEXT:  # %bb.5: # %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 4(%rdi)
; SSE2-NEXT:  .LBB9_6: # %else4
; SSE2-NEXT:    movdqa %xmm10, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm10
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB9_8
; SSE2-NEXT:  # %bb.7: # %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 6(%rdi)
; SSE2-NEXT:  .LBB9_8: # %else6
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm9, %xmm0
; SSE2-NEXT:    pxor %xmm10, %xmm9
; SSE2-NEXT:    pand %xmm10, %xmm3
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    je .LBB9_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 8(%rdi)
; SSE2-NEXT:  .LBB9_10: # %else8
; SSE2-NEXT:    por %xmm0, %xmm2
; SSE2-NEXT:    por %xmm9, %xmm3
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB9_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    pextrw $5, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 10(%rdi)
; SSE2-NEXT:  .LBB9_12: # %else10
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    pslld $16, %xmm2
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    je .LBB9_14
; SSE2-NEXT:  # %bb.13: # %cond.store11
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 12(%rdi)
; SSE2-NEXT:  .LBB9_14: # %else12
; SSE2-NEXT:    psrad $16, %xmm3
; SSE2-NEXT:    psrad $16, %xmm2
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB9_16
; SSE2-NEXT:  # %bb.15: # %cond.store13
; SSE2-NEXT:    pextrw $7, %xmm8, %ecx
; SSE2-NEXT:    movw %cx, 14(%rdi)
; SSE2-NEXT:  .LBB9_16: # %else14
; SSE2-NEXT:    packssdw %xmm3, %xmm2
; SSE2-NEXT:    testl $256, %eax # imm = 0x100
; SSE2-NEXT:    jne .LBB9_17
; SSE2-NEXT:  # %bb.18: # %else16
; SSE2-NEXT:    testl $512, %eax # imm = 0x200
; SSE2-NEXT:    jne .LBB9_19
; SSE2-NEXT:  .LBB9_20: # %else18
; SSE2-NEXT:    testl $1024, %eax # imm = 0x400
; SSE2-NEXT:    jne .LBB9_21
; SSE2-NEXT:  .LBB9_22: # %else20
; SSE2-NEXT:    testl $2048, %eax # imm = 0x800
; SSE2-NEXT:    jne .LBB9_23
; SSE2-NEXT:  .LBB9_24: # %else22
; SSE2-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE2-NEXT:    jne .LBB9_25
; SSE2-NEXT:  .LBB9_26: # %else24
; SSE2-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE2-NEXT:    jne .LBB9_27
; SSE2-NEXT:  .LBB9_28: # %else26
; SSE2-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE2-NEXT:    jne .LBB9_29
; SSE2-NEXT:  .LBB9_30: # %else28
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    jne .LBB9_31
; SSE2-NEXT:  .LBB9_32: # %else30
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB9_17: # %cond.store15
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 16(%rdi)
; SSE2-NEXT:    testl $512, %eax # imm = 0x200
; SSE2-NEXT:    je .LBB9_20
; SSE2-NEXT:  .LBB9_19: # %cond.store17
; SSE2-NEXT:    pextrw $1, %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 18(%rdi)
; SSE2-NEXT:    testl $1024, %eax # imm = 0x400
; SSE2-NEXT:    je .LBB9_22
; SSE2-NEXT:  .LBB9_21: # %cond.store19
; SSE2-NEXT:    pextrw $2, %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 20(%rdi)
; SSE2-NEXT:    testl $2048, %eax # imm = 0x800
; SSE2-NEXT:    je .LBB9_24
; SSE2-NEXT:  .LBB9_23: # %cond.store21
; SSE2-NEXT:    pextrw $3, %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 22(%rdi)
; SSE2-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE2-NEXT:    je .LBB9_26
; SSE2-NEXT:  .LBB9_25: # %cond.store23
; SSE2-NEXT:    pextrw $4, %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 24(%rdi)
; SSE2-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE2-NEXT:    je .LBB9_28
; SSE2-NEXT:  .LBB9_27: # %cond.store25
; SSE2-NEXT:    pextrw $5, %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 26(%rdi)
; SSE2-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE2-NEXT:    je .LBB9_30
; SSE2-NEXT:  .LBB9_29: # %cond.store27
; SSE2-NEXT:    pextrw $6, %xmm2, %ecx
; SSE2-NEXT:    movw %cx, 28(%rdi)
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    je .LBB9_32
; SSE2-NEXT:  .LBB9_31: # %cond.store29
; SSE2-NEXT:    pextrw $7, %xmm2, %eax
; SSE2-NEXT:    movw %ax, 30(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v16i32_v16i16:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm9, %xmm9
; SSE4-NEXT:    movdqa {{.*#+}} xmm8 = [65535,65535,65535,65535]
; SSE4-NEXT:    pminud %xmm8, %xmm1
; SSE4-NEXT:    pminud %xmm8, %xmm0
; SSE4-NEXT:    packusdw %xmm1, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm9, %xmm7
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE4-NEXT:    pxor %xmm1, %xmm7
; SSE4-NEXT:    pcmpeqd %xmm9, %xmm6
; SSE4-NEXT:    pxor %xmm1, %xmm6
; SSE4-NEXT:    packssdw %xmm7, %xmm6
; SSE4-NEXT:    pcmpeqd %xmm9, %xmm5
; SSE4-NEXT:    pxor %xmm1, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm9, %xmm4
; SSE4-NEXT:    pxor %xmm1, %xmm4
; SSE4-NEXT:    packssdw %xmm5, %xmm4
; SSE4-NEXT:    packsswb %xmm6, %xmm4
; SSE4-NEXT:    pmovmskb %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB9_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB9_3
; SSE4-NEXT:  .LBB9_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB9_5
; SSE4-NEXT:  .LBB9_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB9_7
; SSE4-NEXT:  .LBB9_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB9_9
; SSE4-NEXT:  .LBB9_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB9_11
; SSE4-NEXT:  .LBB9_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB9_14
; SSE4-NEXT:  .LBB9_13: # %cond.store11
; SSE4-NEXT:    pextrw $6, %xmm0, 12(%rdi)
; SSE4-NEXT:  .LBB9_14: # %else12
; SSE4-NEXT:    pminud %xmm8, %xmm3
; SSE4-NEXT:    pminud %xmm8, %xmm2
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB9_16
; SSE4-NEXT:  # %bb.15: # %cond.store13
; SSE4-NEXT:    pextrw $7, %xmm0, 14(%rdi)
; SSE4-NEXT:  .LBB9_16: # %else14
; SSE4-NEXT:    packusdw %xmm3, %xmm2
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    jne .LBB9_17
; SSE4-NEXT:  # %bb.18: # %else16
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    jne .LBB9_19
; SSE4-NEXT:  .LBB9_20: # %else18
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    jne .LBB9_21
; SSE4-NEXT:  .LBB9_22: # %else20
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    jne .LBB9_23
; SSE4-NEXT:  .LBB9_24: # %else22
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    jne .LBB9_25
; SSE4-NEXT:  .LBB9_26: # %else24
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    jne .LBB9_27
; SSE4-NEXT:  .LBB9_28: # %else26
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    jne .LBB9_29
; SSE4-NEXT:  .LBB9_30: # %else28
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    jne .LBB9_31
; SSE4-NEXT:  .LBB9_32: # %else30
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB9_1: # %cond.store
; SSE4-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB9_4
; SSE4-NEXT:  .LBB9_3: # %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB9_6
; SSE4-NEXT:  .LBB9_5: # %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB9_8
; SSE4-NEXT:  .LBB9_7: # %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB9_10
; SSE4-NEXT:  .LBB9_9: # %cond.store7
; SSE4-NEXT:    pextrw $4, %xmm0, 8(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB9_12
; SSE4-NEXT:  .LBB9_11: # %cond.store9
; SSE4-NEXT:    pextrw $5, %xmm0, 10(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB9_13
; SSE4-NEXT:    jmp .LBB9_14
; SSE4-NEXT:  .LBB9_17: # %cond.store15
; SSE4-NEXT:    pextrw $0, %xmm2, 16(%rdi)
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    je .LBB9_20
; SSE4-NEXT:  .LBB9_19: # %cond.store17
; SSE4-NEXT:    pextrw $1, %xmm2, 18(%rdi)
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    je .LBB9_22
; SSE4-NEXT:  .LBB9_21: # %cond.store19
; SSE4-NEXT:    pextrw $2, %xmm2, 20(%rdi)
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    je .LBB9_24
; SSE4-NEXT:  .LBB9_23: # %cond.store21
; SSE4-NEXT:    pextrw $3, %xmm2, 22(%rdi)
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    je .LBB9_26
; SSE4-NEXT:  .LBB9_25: # %cond.store23
; SSE4-NEXT:    pextrw $4, %xmm2, 24(%rdi)
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    je .LBB9_28
; SSE4-NEXT:  .LBB9_27: # %cond.store25
; SSE4-NEXT:    pextrw $5, %xmm2, 26(%rdi)
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    je .LBB9_30
; SSE4-NEXT:  .LBB9_29: # %cond.store27
; SSE4-NEXT:    pextrw $6, %xmm2, 28(%rdi)
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    je .LBB9_32
; SSE4-NEXT:  .LBB9_31: # %cond.store29
; SSE4-NEXT:    pextrw $7, %xmm2, 30(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v16i32_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpminud %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpminud %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpminud %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackssdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpacksswb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB9_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB9_3
; AVX1-NEXT:  .LBB9_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB9_5
; AVX1-NEXT:  .LBB9_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB9_7
; AVX1-NEXT:  .LBB9_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB9_9
; AVX1-NEXT:  .LBB9_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB9_11
; AVX1-NEXT:  .LBB9_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB9_13
; AVX1-NEXT:  .LBB9_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB9_16
; AVX1-NEXT:  .LBB9_15: # %cond.store13
; AVX1-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX1-NEXT:  .LBB9_16: # %else14
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    jne .LBB9_17
; AVX1-NEXT:  # %bb.18: # %else16
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    jne .LBB9_19
; AVX1-NEXT:  .LBB9_20: # %else18
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    jne .LBB9_21
; AVX1-NEXT:  .LBB9_22: # %else20
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    jne .LBB9_23
; AVX1-NEXT:  .LBB9_24: # %else22
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    jne .LBB9_25
; AVX1-NEXT:  .LBB9_26: # %else24
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    jne .LBB9_27
; AVX1-NEXT:  .LBB9_28: # %else26
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    jne .LBB9_29
; AVX1-NEXT:  .LBB9_30: # %else28
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    jne .LBB9_31
; AVX1-NEXT:  .LBB9_32: # %else30
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB9_1: # %cond.store
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB9_4
; AVX1-NEXT:  .LBB9_3: # %cond.store1
; AVX1-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB9_6
; AVX1-NEXT:  .LBB9_5: # %cond.store3
; AVX1-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB9_8
; AVX1-NEXT:  .LBB9_7: # %cond.store5
; AVX1-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB9_10
; AVX1-NEXT:  .LBB9_9: # %cond.store7
; AVX1-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB9_12
; AVX1-NEXT:  .LBB9_11: # %cond.store9
; AVX1-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB9_14
; AVX1-NEXT:  .LBB9_13: # %cond.store11
; AVX1-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB9_15
; AVX1-NEXT:    jmp .LBB9_16
; AVX1-NEXT:  .LBB9_17: # %cond.store15
; AVX1-NEXT:    vpextrw $0, %xmm0, 16(%rdi)
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    je .LBB9_20
; AVX1-NEXT:  .LBB9_19: # %cond.store17
; AVX1-NEXT:    vpextrw $1, %xmm0, 18(%rdi)
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    je .LBB9_22
; AVX1-NEXT:  .LBB9_21: # %cond.store19
; AVX1-NEXT:    vpextrw $2, %xmm0, 20(%rdi)
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    je .LBB9_24
; AVX1-NEXT:  .LBB9_23: # %cond.store21
; AVX1-NEXT:    vpextrw $3, %xmm0, 22(%rdi)
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    je .LBB9_26
; AVX1-NEXT:  .LBB9_25: # %cond.store23
; AVX1-NEXT:    vpextrw $4, %xmm0, 24(%rdi)
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    je .LBB9_28
; AVX1-NEXT:  .LBB9_27: # %cond.store25
; AVX1-NEXT:    vpextrw $5, %xmm0, 26(%rdi)
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    je .LBB9_30
; AVX1-NEXT:  .LBB9_29: # %cond.store27
; AVX1-NEXT:    vpextrw $6, %xmm0, 28(%rdi)
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    je .LBB9_32
; AVX1-NEXT:  .LBB9_31: # %cond.store29
; AVX1-NEXT:    vpextrw $7, %xmm0, 30(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v16i32_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm5 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpminud %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpackssdw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX2-NEXT:    vpmovmskb %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB9_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB9_3
; AVX2-NEXT:  .LBB9_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB9_5
; AVX2-NEXT:  .LBB9_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB9_7
; AVX2-NEXT:  .LBB9_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB9_9
; AVX2-NEXT:  .LBB9_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB9_11
; AVX2-NEXT:  .LBB9_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB9_13
; AVX2-NEXT:  .LBB9_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB9_16
; AVX2-NEXT:  .LBB9_15: # %cond.store13
; AVX2-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX2-NEXT:  .LBB9_16: # %else14
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    jne .LBB9_17
; AVX2-NEXT:  # %bb.18: # %else16
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    jne .LBB9_19
; AVX2-NEXT:  .LBB9_20: # %else18
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    jne .LBB9_21
; AVX2-NEXT:  .LBB9_22: # %else20
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    jne .LBB9_23
; AVX2-NEXT:  .LBB9_24: # %else22
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    jne .LBB9_25
; AVX2-NEXT:  .LBB9_26: # %else24
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    jne .LBB9_27
; AVX2-NEXT:  .LBB9_28: # %else26
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    jne .LBB9_29
; AVX2-NEXT:  .LBB9_30: # %else28
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    jne .LBB9_31
; AVX2-NEXT:  .LBB9_32: # %else30
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB9_1: # %cond.store
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB9_4
; AVX2-NEXT:  .LBB9_3: # %cond.store1
; AVX2-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB9_6
; AVX2-NEXT:  .LBB9_5: # %cond.store3
; AVX2-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB9_8
; AVX2-NEXT:  .LBB9_7: # %cond.store5
; AVX2-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB9_10
; AVX2-NEXT:  .LBB9_9: # %cond.store7
; AVX2-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB9_12
; AVX2-NEXT:  .LBB9_11: # %cond.store9
; AVX2-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB9_14
; AVX2-NEXT:  .LBB9_13: # %cond.store11
; AVX2-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB9_15
; AVX2-NEXT:    jmp .LBB9_16
; AVX2-NEXT:  .LBB9_17: # %cond.store15
; AVX2-NEXT:    vpextrw $0, %xmm0, 16(%rdi)
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    je .LBB9_20
; AVX2-NEXT:  .LBB9_19: # %cond.store17
; AVX2-NEXT:    vpextrw $1, %xmm0, 18(%rdi)
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    je .LBB9_22
; AVX2-NEXT:  .LBB9_21: # %cond.store19
; AVX2-NEXT:    vpextrw $2, %xmm0, 20(%rdi)
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    je .LBB9_24
; AVX2-NEXT:  .LBB9_23: # %cond.store21
; AVX2-NEXT:    vpextrw $3, %xmm0, 22(%rdi)
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    je .LBB9_26
; AVX2-NEXT:  .LBB9_25: # %cond.store23
; AVX2-NEXT:    vpextrw $4, %xmm0, 24(%rdi)
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    je .LBB9_28
; AVX2-NEXT:  .LBB9_27: # %cond.store25
; AVX2-NEXT:    vpextrw $5, %xmm0, 26(%rdi)
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    je .LBB9_30
; AVX2-NEXT:  .LBB9_29: # %cond.store27
; AVX2-NEXT:    vpextrw $6, %xmm0, 28(%rdi)
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    je .LBB9_32
; AVX2-NEXT:  .LBB9_31: # %cond.store29
; AVX2-NEXT:    vpextrw $7, %xmm0, 30(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v16i32_v16i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusdw %zmm0, %ymm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB9_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB9_3
; AVX512F-NEXT:  .LBB9_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB9_5
; AVX512F-NEXT:  .LBB9_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB9_7
; AVX512F-NEXT:  .LBB9_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB9_9
; AVX512F-NEXT:  .LBB9_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB9_11
; AVX512F-NEXT:  .LBB9_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB9_13
; AVX512F-NEXT:  .LBB9_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB9_16
; AVX512F-NEXT:  .LBB9_15: # %cond.store13
; AVX512F-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX512F-NEXT:  .LBB9_16: # %else14
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    jne .LBB9_17
; AVX512F-NEXT:  # %bb.18: # %else16
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    jne .LBB9_19
; AVX512F-NEXT:  .LBB9_20: # %else18
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    jne .LBB9_21
; AVX512F-NEXT:  .LBB9_22: # %else20
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    jne .LBB9_23
; AVX512F-NEXT:  .LBB9_24: # %else22
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    jne .LBB9_25
; AVX512F-NEXT:  .LBB9_26: # %else24
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    jne .LBB9_27
; AVX512F-NEXT:  .LBB9_28: # %else26
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    jne .LBB9_29
; AVX512F-NEXT:  .LBB9_30: # %else28
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    jne .LBB9_31
; AVX512F-NEXT:  .LBB9_32: # %else30
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB9_1: # %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB9_4
; AVX512F-NEXT:  .LBB9_3: # %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB9_6
; AVX512F-NEXT:  .LBB9_5: # %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB9_8
; AVX512F-NEXT:  .LBB9_7: # %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB9_10
; AVX512F-NEXT:  .LBB9_9: # %cond.store7
; AVX512F-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB9_12
; AVX512F-NEXT:  .LBB9_11: # %cond.store9
; AVX512F-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB9_14
; AVX512F-NEXT:  .LBB9_13: # %cond.store11
; AVX512F-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB9_15
; AVX512F-NEXT:    jmp .LBB9_16
; AVX512F-NEXT:  .LBB9_17: # %cond.store15
; AVX512F-NEXT:    vpextrw $0, %xmm0, 16(%rdi)
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    je .LBB9_20
; AVX512F-NEXT:  .LBB9_19: # %cond.store17
; AVX512F-NEXT:    vpextrw $1, %xmm0, 18(%rdi)
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    je .LBB9_22
; AVX512F-NEXT:  .LBB9_21: # %cond.store19
; AVX512F-NEXT:    vpextrw $2, %xmm0, 20(%rdi)
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    je .LBB9_24
; AVX512F-NEXT:  .LBB9_23: # %cond.store21
; AVX512F-NEXT:    vpextrw $3, %xmm0, 22(%rdi)
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    je .LBB9_26
; AVX512F-NEXT:  .LBB9_25: # %cond.store23
; AVX512F-NEXT:    vpextrw $4, %xmm0, 24(%rdi)
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    je .LBB9_28
; AVX512F-NEXT:  .LBB9_27: # %cond.store25
; AVX512F-NEXT:    vpextrw $5, %xmm0, 26(%rdi)
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    je .LBB9_30
; AVX512F-NEXT:  .LBB9_29: # %cond.store27
; AVX512F-NEXT:    vpextrw $6, %xmm0, 28(%rdi)
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    je .LBB9_32
; AVX512F-NEXT:  .LBB9_31: # %cond.store29
; AVX512F-NEXT:    vpextrw $7, %xmm0, 30(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v16i32_v16i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BW-NEXT:    vpminud {{.*}}(%rip){1to16}, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovdw %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v16i32_v16i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BWVL-NEXT:    vpminud {{.*}}(%rip){1to16}, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovdw %zmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <16 x i32> %mask, zeroinitializer
  %b = icmp ult <16 x i32> %x, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %c = select <16 x i1> %b, <16 x i32> %x, <16 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %d = trunc <16 x i32> %c to <16 x i16>
  call void @llvm.masked.store.v16i16.p0v16i16(<16 x i16> %d, <16 x i16>* %p, i32 1, <16 x i1> %a)
  ret void
}

define void @truncstore_v16i32_v16i8(<16 x i32> %x, <16 x i8>* %p, <16 x i32> %mask) {
; SSE2-LABEL: truncstore_v16i32_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [255,255,255,255]
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm1, %xmm12
; SSE2-NEXT:    pxor %xmm11, %xmm12
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [2147483903,2147483903,2147483903,2147483903]
; SSE2-NEXT:    movdqa %xmm9, %xmm13
; SSE2-NEXT:    pcmpgtd %xmm12, %xmm13
; SSE2-NEXT:    pand %xmm13, %xmm1
; SSE2-NEXT:    pandn %xmm10, %xmm13
; SSE2-NEXT:    por %xmm1, %xmm13
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm11, %xmm1
; SSE2-NEXT:    movdqa %xmm9, %xmm12
; SSE2-NEXT:    pcmpgtd %xmm1, %xmm12
; SSE2-NEXT:    pand %xmm12, %xmm0
; SSE2-NEXT:    pandn %xmm10, %xmm12
; SSE2-NEXT:    por %xmm0, %xmm12
; SSE2-NEXT:    packuswb %xmm13, %xmm12
; SSE2-NEXT:    movdqa %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm11, %xmm0
; SSE2-NEXT:    movdqa %xmm9, %xmm1
; SSE2-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pandn %xmm10, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm11
; SSE2-NEXT:    pcmpgtd %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm9, %xmm2
; SSE2-NEXT:    pandn %xmm10, %xmm9
; SSE2-NEXT:    por %xmm2, %xmm9
; SSE2-NEXT:    packuswb %xmm1, %xmm9
; SSE2-NEXT:    packuswb %xmm9, %xmm12
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm0, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm6
; SSE2-NEXT:    pxor %xmm0, %xmm6
; SSE2-NEXT:    packssdw %xmm7, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE2-NEXT:    pxor %xmm0, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm4
; SSE2-NEXT:    packssdw %xmm5, %xmm4
; SSE2-NEXT:    packsswb %xmm6, %xmm4
; SSE2-NEXT:    pmovmskb %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm12, %ecx
; SSE2-NEXT:    jne .LBB10_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB10_3
; SSE2-NEXT:  .LBB10_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB10_5
; SSE2-NEXT:  .LBB10_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB10_8
; SSE2-NEXT:  .LBB10_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 3(%rdi)
; SSE2-NEXT:  .LBB10_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    pextrw $2, %xmm12, %ecx
; SSE2-NEXT:    je .LBB10_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    movb %cl, 4(%rdi)
; SSE2-NEXT:  .LBB10_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB10_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    movb %ch, 5(%rdi)
; SSE2-NEXT:  .LBB10_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    pextrw $3, %xmm12, %ecx
; SSE2-NEXT:    je .LBB10_14
; SSE2-NEXT:  # %bb.13: # %cond.store11
; SSE2-NEXT:    movb %cl, 6(%rdi)
; SSE2-NEXT:  .LBB10_14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB10_16
; SSE2-NEXT:  # %bb.15: # %cond.store13
; SSE2-NEXT:    movb %ch, 7(%rdi)
; SSE2-NEXT:  .LBB10_16: # %else14
; SSE2-NEXT:    testl $256, %eax # imm = 0x100
; SSE2-NEXT:    pextrw $4, %xmm12, %ecx
; SSE2-NEXT:    je .LBB10_18
; SSE2-NEXT:  # %bb.17: # %cond.store15
; SSE2-NEXT:    movb %cl, 8(%rdi)
; SSE2-NEXT:  .LBB10_18: # %else16
; SSE2-NEXT:    testl $512, %eax # imm = 0x200
; SSE2-NEXT:    je .LBB10_20
; SSE2-NEXT:  # %bb.19: # %cond.store17
; SSE2-NEXT:    movb %ch, 9(%rdi)
; SSE2-NEXT:  .LBB10_20: # %else18
; SSE2-NEXT:    testl $1024, %eax # imm = 0x400
; SSE2-NEXT:    pextrw $5, %xmm12, %ecx
; SSE2-NEXT:    je .LBB10_22
; SSE2-NEXT:  # %bb.21: # %cond.store19
; SSE2-NEXT:    movb %cl, 10(%rdi)
; SSE2-NEXT:  .LBB10_22: # %else20
; SSE2-NEXT:    testl $2048, %eax # imm = 0x800
; SSE2-NEXT:    je .LBB10_24
; SSE2-NEXT:  # %bb.23: # %cond.store21
; SSE2-NEXT:    movb %ch, 11(%rdi)
; SSE2-NEXT:  .LBB10_24: # %else22
; SSE2-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE2-NEXT:    pextrw $6, %xmm12, %ecx
; SSE2-NEXT:    je .LBB10_26
; SSE2-NEXT:  # %bb.25: # %cond.store23
; SSE2-NEXT:    movb %cl, 12(%rdi)
; SSE2-NEXT:  .LBB10_26: # %else24
; SSE2-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE2-NEXT:    je .LBB10_28
; SSE2-NEXT:  # %bb.27: # %cond.store25
; SSE2-NEXT:    movb %ch, 13(%rdi)
; SSE2-NEXT:  .LBB10_28: # %else26
; SSE2-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE2-NEXT:    pextrw $7, %xmm12, %ecx
; SSE2-NEXT:    jne .LBB10_29
; SSE2-NEXT:  # %bb.30: # %else28
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    jne .LBB10_31
; SSE2-NEXT:  .LBB10_32: # %else30
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB10_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB10_4
; SSE2-NEXT:  .LBB10_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB10_6
; SSE2-NEXT:  .LBB10_5: # %cond.store3
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB10_7
; SSE2-NEXT:    jmp .LBB10_8
; SSE2-NEXT:  .LBB10_29: # %cond.store27
; SSE2-NEXT:    movb %cl, 14(%rdi)
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    je .LBB10_32
; SSE2-NEXT:  .LBB10_31: # %cond.store29
; SSE2-NEXT:    movb %ch, 15(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v16i32_v16i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm8, %xmm8
; SSE4-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255]
; SSE4-NEXT:    pminud %xmm9, %xmm1
; SSE4-NEXT:    pminud %xmm9, %xmm0
; SSE4-NEXT:    packusdw %xmm1, %xmm0
; SSE4-NEXT:    pminud %xmm9, %xmm3
; SSE4-NEXT:    pminud %xmm9, %xmm2
; SSE4-NEXT:    packusdw %xmm3, %xmm2
; SSE4-NEXT:    packuswb %xmm2, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm7
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE4-NEXT:    pxor %xmm1, %xmm7
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm6
; SSE4-NEXT:    pxor %xmm1, %xmm6
; SSE4-NEXT:    packssdw %xmm7, %xmm6
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm5
; SSE4-NEXT:    pxor %xmm1, %xmm5
; SSE4-NEXT:    pcmpeqd %xmm8, %xmm4
; SSE4-NEXT:    pxor %xmm1, %xmm4
; SSE4-NEXT:    packssdw %xmm5, %xmm4
; SSE4-NEXT:    packsswb %xmm6, %xmm4
; SSE4-NEXT:    pmovmskb %xmm4, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB10_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB10_3
; SSE4-NEXT:  .LBB10_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB10_5
; SSE4-NEXT:  .LBB10_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB10_7
; SSE4-NEXT:  .LBB10_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB10_9
; SSE4-NEXT:  .LBB10_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB10_11
; SSE4-NEXT:  .LBB10_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB10_13
; SSE4-NEXT:  .LBB10_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB10_15
; SSE4-NEXT:  .LBB10_16: # %else14
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    jne .LBB10_17
; SSE4-NEXT:  .LBB10_18: # %else16
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    jne .LBB10_19
; SSE4-NEXT:  .LBB10_20: # %else18
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    jne .LBB10_21
; SSE4-NEXT:  .LBB10_22: # %else20
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    jne .LBB10_23
; SSE4-NEXT:  .LBB10_24: # %else22
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    jne .LBB10_25
; SSE4-NEXT:  .LBB10_26: # %else24
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    jne .LBB10_27
; SSE4-NEXT:  .LBB10_28: # %else26
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    jne .LBB10_29
; SSE4-NEXT:  .LBB10_30: # %else28
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    jne .LBB10_31
; SSE4-NEXT:  .LBB10_32: # %else30
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB10_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB10_4
; SSE4-NEXT:  .LBB10_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm0, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB10_6
; SSE4-NEXT:  .LBB10_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB10_8
; SSE4-NEXT:  .LBB10_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm0, 3(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB10_10
; SSE4-NEXT:  .LBB10_9: # %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB10_12
; SSE4-NEXT:  .LBB10_11: # %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm0, 5(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB10_14
; SSE4-NEXT:  .LBB10_13: # %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB10_16
; SSE4-NEXT:  .LBB10_15: # %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm0, 7(%rdi)
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    je .LBB10_18
; SSE4-NEXT:  .LBB10_17: # %cond.store15
; SSE4-NEXT:    pextrb $8, %xmm0, 8(%rdi)
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    je .LBB10_20
; SSE4-NEXT:  .LBB10_19: # %cond.store17
; SSE4-NEXT:    pextrb $9, %xmm0, 9(%rdi)
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    je .LBB10_22
; SSE4-NEXT:  .LBB10_21: # %cond.store19
; SSE4-NEXT:    pextrb $10, %xmm0, 10(%rdi)
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    je .LBB10_24
; SSE4-NEXT:  .LBB10_23: # %cond.store21
; SSE4-NEXT:    pextrb $11, %xmm0, 11(%rdi)
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    je .LBB10_26
; SSE4-NEXT:  .LBB10_25: # %cond.store23
; SSE4-NEXT:    pextrb $12, %xmm0, 12(%rdi)
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    je .LBB10_28
; SSE4-NEXT:  .LBB10_27: # %cond.store25
; SSE4-NEXT:    pextrb $13, %xmm0, 13(%rdi)
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    je .LBB10_30
; SSE4-NEXT:  .LBB10_29: # %cond.store27
; SSE4-NEXT:    pextrb $14, %xmm0, 14(%rdi)
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    je .LBB10_32
; SSE4-NEXT:  .LBB10_31: # %cond.store29
; SSE4-NEXT:    pextrb $15, %xmm0, 15(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255]
; AVX1-NEXT:    vpminud %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpminud %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpminud %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpminud %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpxor %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpackssdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackssdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpacksswb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB10_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB10_3
; AVX1-NEXT:  .LBB10_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB10_5
; AVX1-NEXT:  .LBB10_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB10_7
; AVX1-NEXT:  .LBB10_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB10_9
; AVX1-NEXT:  .LBB10_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB10_11
; AVX1-NEXT:  .LBB10_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB10_13
; AVX1-NEXT:  .LBB10_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB10_15
; AVX1-NEXT:  .LBB10_16: # %else14
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    jne .LBB10_17
; AVX1-NEXT:  .LBB10_18: # %else16
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    jne .LBB10_19
; AVX1-NEXT:  .LBB10_20: # %else18
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    jne .LBB10_21
; AVX1-NEXT:  .LBB10_22: # %else20
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    jne .LBB10_23
; AVX1-NEXT:  .LBB10_24: # %else22
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    jne .LBB10_25
; AVX1-NEXT:  .LBB10_26: # %else24
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    jne .LBB10_27
; AVX1-NEXT:  .LBB10_28: # %else26
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    jne .LBB10_29
; AVX1-NEXT:  .LBB10_30: # %else28
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    jne .LBB10_31
; AVX1-NEXT:  .LBB10_32: # %else30
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB10_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB10_4
; AVX1-NEXT:  .LBB10_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB10_6
; AVX1-NEXT:  .LBB10_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB10_8
; AVX1-NEXT:  .LBB10_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB10_10
; AVX1-NEXT:  .LBB10_9: # %cond.store7
; AVX1-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB10_12
; AVX1-NEXT:  .LBB10_11: # %cond.store9
; AVX1-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB10_14
; AVX1-NEXT:  .LBB10_13: # %cond.store11
; AVX1-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB10_16
; AVX1-NEXT:  .LBB10_15: # %cond.store13
; AVX1-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    je .LBB10_18
; AVX1-NEXT:  .LBB10_17: # %cond.store15
; AVX1-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    je .LBB10_20
; AVX1-NEXT:  .LBB10_19: # %cond.store17
; AVX1-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    je .LBB10_22
; AVX1-NEXT:  .LBB10_21: # %cond.store19
; AVX1-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    je .LBB10_24
; AVX1-NEXT:  .LBB10_23: # %cond.store21
; AVX1-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    je .LBB10_26
; AVX1-NEXT:  .LBB10_25: # %cond.store23
; AVX1-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    je .LBB10_28
; AVX1-NEXT:  .LBB10_27: # %cond.store25
; AVX1-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    je .LBB10_30
; AVX1-NEXT:  .LBB10_29: # %cond.store27
; AVX1-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    je .LBB10_32
; AVX1-NEXT:  .LBB10_31: # %cond.store29
; AVX1-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm5 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpminud %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpminud %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpackssdw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; AVX2-NEXT:    vpmovmskb %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB10_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB10_3
; AVX2-NEXT:  .LBB10_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB10_5
; AVX2-NEXT:  .LBB10_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB10_7
; AVX2-NEXT:  .LBB10_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB10_9
; AVX2-NEXT:  .LBB10_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB10_11
; AVX2-NEXT:  .LBB10_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB10_13
; AVX2-NEXT:  .LBB10_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB10_15
; AVX2-NEXT:  .LBB10_16: # %else14
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    jne .LBB10_17
; AVX2-NEXT:  .LBB10_18: # %else16
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    jne .LBB10_19
; AVX2-NEXT:  .LBB10_20: # %else18
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    jne .LBB10_21
; AVX2-NEXT:  .LBB10_22: # %else20
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    jne .LBB10_23
; AVX2-NEXT:  .LBB10_24: # %else22
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    jne .LBB10_25
; AVX2-NEXT:  .LBB10_26: # %else24
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    jne .LBB10_27
; AVX2-NEXT:  .LBB10_28: # %else26
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    jne .LBB10_29
; AVX2-NEXT:  .LBB10_30: # %else28
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    jne .LBB10_31
; AVX2-NEXT:  .LBB10_32: # %else30
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB10_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB10_4
; AVX2-NEXT:  .LBB10_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB10_6
; AVX2-NEXT:  .LBB10_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB10_8
; AVX2-NEXT:  .LBB10_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB10_10
; AVX2-NEXT:  .LBB10_9: # %cond.store7
; AVX2-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB10_12
; AVX2-NEXT:  .LBB10_11: # %cond.store9
; AVX2-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB10_14
; AVX2-NEXT:  .LBB10_13: # %cond.store11
; AVX2-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB10_16
; AVX2-NEXT:  .LBB10_15: # %cond.store13
; AVX2-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    je .LBB10_18
; AVX2-NEXT:  .LBB10_17: # %cond.store15
; AVX2-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    je .LBB10_20
; AVX2-NEXT:  .LBB10_19: # %cond.store17
; AVX2-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    je .LBB10_22
; AVX2-NEXT:  .LBB10_21: # %cond.store19
; AVX2-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    je .LBB10_24
; AVX2-NEXT:  .LBB10_23: # %cond.store21
; AVX2-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    je .LBB10_26
; AVX2-NEXT:  .LBB10_25: # %cond.store23
; AVX2-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    je .LBB10_28
; AVX2-NEXT:  .LBB10_27: # %cond.store25
; AVX2-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    je .LBB10_30
; AVX2-NEXT:  .LBB10_29: # %cond.store27
; AVX2-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    je .LBB10_32
; AVX2-NEXT:  .LBB10_31: # %cond.store29
; AVX2-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v16i32_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB10_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB10_3
; AVX512F-NEXT:  .LBB10_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB10_5
; AVX512F-NEXT:  .LBB10_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB10_7
; AVX512F-NEXT:  .LBB10_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB10_9
; AVX512F-NEXT:  .LBB10_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB10_11
; AVX512F-NEXT:  .LBB10_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB10_13
; AVX512F-NEXT:  .LBB10_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB10_15
; AVX512F-NEXT:  .LBB10_16: # %else14
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    jne .LBB10_17
; AVX512F-NEXT:  .LBB10_18: # %else16
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    jne .LBB10_19
; AVX512F-NEXT:  .LBB10_20: # %else18
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    jne .LBB10_21
; AVX512F-NEXT:  .LBB10_22: # %else20
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    jne .LBB10_23
; AVX512F-NEXT:  .LBB10_24: # %else22
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    jne .LBB10_25
; AVX512F-NEXT:  .LBB10_26: # %else24
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    jne .LBB10_27
; AVX512F-NEXT:  .LBB10_28: # %else26
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    jne .LBB10_29
; AVX512F-NEXT:  .LBB10_30: # %else28
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    jne .LBB10_31
; AVX512F-NEXT:  .LBB10_32: # %else30
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB10_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB10_4
; AVX512F-NEXT:  .LBB10_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB10_6
; AVX512F-NEXT:  .LBB10_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB10_8
; AVX512F-NEXT:  .LBB10_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB10_10
; AVX512F-NEXT:  .LBB10_9: # %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB10_12
; AVX512F-NEXT:  .LBB10_11: # %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB10_14
; AVX512F-NEXT:  .LBB10_13: # %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB10_16
; AVX512F-NEXT:  .LBB10_15: # %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    je .LBB10_18
; AVX512F-NEXT:  .LBB10_17: # %cond.store15
; AVX512F-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    je .LBB10_20
; AVX512F-NEXT:  .LBB10_19: # %cond.store17
; AVX512F-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    je .LBB10_22
; AVX512F-NEXT:  .LBB10_21: # %cond.store19
; AVX512F-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    je .LBB10_24
; AVX512F-NEXT:  .LBB10_23: # %cond.store21
; AVX512F-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    je .LBB10_26
; AVX512F-NEXT:  .LBB10_25: # %cond.store23
; AVX512F-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    je .LBB10_28
; AVX512F-NEXT:  .LBB10_27: # %cond.store25
; AVX512F-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    je .LBB10_30
; AVX512F-NEXT:  .LBB10_29: # %cond.store27
; AVX512F-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    je .LBB10_32
; AVX512F-NEXT:  .LBB10_31: # %cond.store29
; AVX512F-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v16i32_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BW-NEXT:    vpminud {{.*}}(%rip){1to16}, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovdb %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v16i32_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %zmm1, %zmm1, %k1
; AVX512BWVL-NEXT:    vpminud {{.*}}(%rip){1to16}, %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovdb %zmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <16 x i32> %mask, zeroinitializer
  %b = icmp ult <16 x i32> %x, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %c = select <16 x i1> %b, <16 x i32> %x, <16 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %d = trunc <16 x i32> %c to <16 x i8>
  call void @llvm.masked.store.v16i8.p0v16i8(<16 x i8> %d, <16 x i8>* %p, i32 1, <16 x i1> %a)
  ret void
}

define void @truncstore_v8i32_v8i16(<8 x i32> %x, <8 x i16>* %p, <8 x i32> %mask) {
; SSE2-LABEL: truncstore_v8i32_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    pxor %xmm7, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm6, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm0
; SSE2-NEXT:    pxor %xmm6, %xmm5
; SSE2-NEXT:    por %xmm0, %xmm5
; SSE2-NEXT:    pxor %xmm1, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm6, %xmm4
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pslld $16, %xmm4
; SSE2-NEXT:    psrad $16, %xmm4
; SSE2-NEXT:    pslld $16, %xmm5
; SSE2-NEXT:    psrad $16, %xmm5
; SSE2-NEXT:    packssdw %xmm4, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm2
; SSE2-NEXT:    pxor %xmm6, %xmm2
; SSE2-NEXT:    packssdw %xmm3, %xmm2
; SSE2-NEXT:    packsswb %xmm2, %xmm2
; SSE2-NEXT:    pmovmskb %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB11_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB11_3
; SSE2-NEXT:  .LBB11_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB11_5
; SSE2-NEXT:  .LBB11_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB11_7
; SSE2-NEXT:  .LBB11_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    jne .LBB11_9
; SSE2-NEXT:  .LBB11_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    jne .LBB11_11
; SSE2-NEXT:  .LBB11_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    jne .LBB11_13
; SSE2-NEXT:  .LBB11_14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    jne .LBB11_15
; SSE2-NEXT:  .LBB11_16: # %else14
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB11_1: # %cond.store
; SSE2-NEXT:    movd %xmm5, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB11_4
; SSE2-NEXT:  .LBB11_3: # %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm5, %ecx
; SSE2-NEXT:    movw %cx, 2(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB11_6
; SSE2-NEXT:  .LBB11_5: # %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm5, %ecx
; SSE2-NEXT:    movw %cx, 4(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB11_8
; SSE2-NEXT:  .LBB11_7: # %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm5, %ecx
; SSE2-NEXT:    movw %cx, 6(%rdi)
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    je .LBB11_10
; SSE2-NEXT:  .LBB11_9: # %cond.store7
; SSE2-NEXT:    pextrw $4, %xmm5, %ecx
; SSE2-NEXT:    movw %cx, 8(%rdi)
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB11_12
; SSE2-NEXT:  .LBB11_11: # %cond.store9
; SSE2-NEXT:    pextrw $5, %xmm5, %ecx
; SSE2-NEXT:    movw %cx, 10(%rdi)
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    je .LBB11_14
; SSE2-NEXT:  .LBB11_13: # %cond.store11
; SSE2-NEXT:    pextrw $6, %xmm5, %ecx
; SSE2-NEXT:    movw %cx, 12(%rdi)
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB11_16
; SSE2-NEXT:  .LBB11_15: # %cond.store13
; SSE2-NEXT:    pextrw $7, %xmm5, %eax
; SSE2-NEXT:    movw %ax, 14(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v8i32_v8i16:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    movdqa {{.*#+}} xmm5 = [65535,65535,65535,65535]
; SSE4-NEXT:    pminud %xmm5, %xmm1
; SSE4-NEXT:    pminud %xmm5, %xmm0
; SSE4-NEXT:    packusdw %xmm1, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE4-NEXT:    pxor %xmm1, %xmm3
; SSE4-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE4-NEXT:    pxor %xmm1, %xmm2
; SSE4-NEXT:    packssdw %xmm3, %xmm2
; SSE4-NEXT:    packsswb %xmm2, %xmm2
; SSE4-NEXT:    pmovmskb %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB11_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB11_3
; SSE4-NEXT:  .LBB11_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB11_5
; SSE4-NEXT:  .LBB11_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB11_7
; SSE4-NEXT:  .LBB11_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB11_9
; SSE4-NEXT:  .LBB11_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB11_11
; SSE4-NEXT:  .LBB11_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB11_13
; SSE4-NEXT:  .LBB11_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB11_15
; SSE4-NEXT:  .LBB11_16: # %else14
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB11_1: # %cond.store
; SSE4-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB11_4
; SSE4-NEXT:  .LBB11_3: # %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB11_6
; SSE4-NEXT:  .LBB11_5: # %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB11_8
; SSE4-NEXT:  .LBB11_7: # %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB11_10
; SSE4-NEXT:  .LBB11_9: # %cond.store7
; SSE4-NEXT:    pextrw $4, %xmm0, 8(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB11_12
; SSE4-NEXT:  .LBB11_11: # %cond.store9
; SSE4-NEXT:    pextrw $5, %xmm0, 10(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB11_14
; SSE4-NEXT:  .LBB11_13: # %cond.store11
; SSE4-NEXT:    pextrw $6, %xmm0, 12(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB11_16
; SSE4-NEXT:  .LBB11_15: # %cond.store13
; SSE4-NEXT:    pextrw $7, %xmm0, 14(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vmovmskps %ymm1, %eax
; AVX1-NEXT:    notl %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB11_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB11_3
; AVX1-NEXT:  .LBB11_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB11_5
; AVX1-NEXT:  .LBB11_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB11_7
; AVX1-NEXT:  .LBB11_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB11_9
; AVX1-NEXT:  .LBB11_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB11_11
; AVX1-NEXT:  .LBB11_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB11_13
; AVX1-NEXT:  .LBB11_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB11_15
; AVX1-NEXT:  .LBB11_16: # %else14
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB11_1: # %cond.store
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB11_4
; AVX1-NEXT:  .LBB11_3: # %cond.store1
; AVX1-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB11_6
; AVX1-NEXT:  .LBB11_5: # %cond.store3
; AVX1-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB11_8
; AVX1-NEXT:  .LBB11_7: # %cond.store5
; AVX1-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB11_10
; AVX1-NEXT:  .LBB11_9: # %cond.store7
; AVX1-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB11_12
; AVX1-NEXT:  .LBB11_11: # %cond.store9
; AVX1-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB11_14
; AVX1-NEXT:  .LBB11_13: # %cond.store11
; AVX1-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB11_16
; AVX1-NEXT:  .LBB11_15: # %cond.store13
; AVX1-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [65535,65535,65535,65535,65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vmovmskps %ymm1, %eax
; AVX2-NEXT:    notl %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB11_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB11_3
; AVX2-NEXT:  .LBB11_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB11_5
; AVX2-NEXT:  .LBB11_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB11_7
; AVX2-NEXT:  .LBB11_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB11_9
; AVX2-NEXT:  .LBB11_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB11_11
; AVX2-NEXT:  .LBB11_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB11_13
; AVX2-NEXT:  .LBB11_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB11_15
; AVX2-NEXT:  .LBB11_16: # %else14
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB11_1: # %cond.store
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB11_4
; AVX2-NEXT:  .LBB11_3: # %cond.store1
; AVX2-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB11_6
; AVX2-NEXT:  .LBB11_5: # %cond.store3
; AVX2-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB11_8
; AVX2-NEXT:  .LBB11_7: # %cond.store5
; AVX2-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB11_10
; AVX2-NEXT:  .LBB11_9: # %cond.store7
; AVX2-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB11_12
; AVX2-NEXT:  .LBB11_11: # %cond.store9
; AVX2-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB11_14
; AVX2-NEXT:  .LBB11_13: # %cond.store11
; AVX2-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB11_16
; AVX2-NEXT:  .LBB11_15: # %cond.store13
; AVX2-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v8i32_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusdw %zmm0, %ymm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB11_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB11_3
; AVX512F-NEXT:  .LBB11_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB11_5
; AVX512F-NEXT:  .LBB11_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB11_7
; AVX512F-NEXT:  .LBB11_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB11_9
; AVX512F-NEXT:  .LBB11_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB11_11
; AVX512F-NEXT:  .LBB11_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB11_13
; AVX512F-NEXT:  .LBB11_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB11_15
; AVX512F-NEXT:  .LBB11_16: # %else14
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB11_1: # %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB11_4
; AVX512F-NEXT:  .LBB11_3: # %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB11_6
; AVX512F-NEXT:  .LBB11_5: # %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB11_8
; AVX512F-NEXT:  .LBB11_7: # %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB11_10
; AVX512F-NEXT:  .LBB11_9: # %cond.store7
; AVX512F-NEXT:    vpextrw $4, %xmm0, 8(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB11_12
; AVX512F-NEXT:  .LBB11_11: # %cond.store9
; AVX512F-NEXT:    vpextrw $5, %xmm0, 10(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB11_14
; AVX512F-NEXT:  .LBB11_13: # %cond.store11
; AVX512F-NEXT:    vpextrw $6, %xmm0, 12(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB11_16
; AVX512F-NEXT:  .LBB11_15: # %cond.store13
; AVX512F-NEXT:    vpextrw $7, %xmm0, 14(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v8i32_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftld $24, %k0, %k0
; AVX512BW-NEXT:    kshiftrd $24, %k0, %k1
; AVX512BW-NEXT:    vpmovusdw %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu16 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v8i32_v8i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512BWVL-NEXT:    vpminud {{.*}}(%rip){1to8}, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovdw %ymm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <8 x i32> %mask, zeroinitializer
  %b = icmp ult <8 x i32> %x, <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %c = select <8 x i1> %b, <8 x i32> %x, <8 x i32> <i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535, i32 65535>
  %d = trunc <8 x i32> %c to <8 x i16>
  call void @llvm.masked.store.v8i16.p0v8i16(<8 x i16> %d, <8 x i16>* %p, i32 1, <8 x i1> %a)
  ret void
}

define void @truncstore_v8i32_v8i8(<8 x i32> %x, <8 x i8>* %p, <8 x i32> %mask) {
; SSE2-LABEL: truncstore_v8i32_v8i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [255,255,255,255]
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm7, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [2147483903,2147483903,2147483903,2147483903]
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pandn %xmm9, %xmm4
; SSE2-NEXT:    por %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm0, %xmm7
; SSE2-NEXT:    pcmpgtd %xmm7, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pandn %xmm9, %xmm6
; SSE2-NEXT:    por %xmm0, %xmm6
; SSE2-NEXT:    packuswb %xmm4, %xmm6
; SSE2-NEXT:    packuswb %xmm6, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    pxor %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm2
; SSE2-NEXT:    packssdw %xmm3, %xmm2
; SSE2-NEXT:    packsswb %xmm2, %xmm2
; SSE2-NEXT:    pmovmskb %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm6, %ecx
; SSE2-NEXT:    jne .LBB12_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB12_3
; SSE2-NEXT:  .LBB12_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB12_5
; SSE2-NEXT:  .LBB12_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB12_8
; SSE2-NEXT:  .LBB12_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 3(%rdi)
; SSE2-NEXT:  .LBB12_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    pextrw $2, %xmm6, %ecx
; SSE2-NEXT:    je .LBB12_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    movb %cl, 4(%rdi)
; SSE2-NEXT:  .LBB12_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB12_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    movb %ch, 5(%rdi)
; SSE2-NEXT:  .LBB12_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    pextrw $3, %xmm6, %ecx
; SSE2-NEXT:    jne .LBB12_13
; SSE2-NEXT:  # %bb.14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    jne .LBB12_15
; SSE2-NEXT:  .LBB12_16: # %else14
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB12_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB12_4
; SSE2-NEXT:  .LBB12_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB12_6
; SSE2-NEXT:  .LBB12_5: # %cond.store3
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB12_7
; SSE2-NEXT:    jmp .LBB12_8
; SSE2-NEXT:  .LBB12_13: # %cond.store11
; SSE2-NEXT:    movb %cl, 6(%rdi)
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB12_16
; SSE2-NEXT:  .LBB12_15: # %cond.store13
; SSE2-NEXT:    movb %ch, 7(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v8i32_v8i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm4, %xmm4
; SSE4-NEXT:    movdqa {{.*#+}} xmm5 = [255,255,255,255]
; SSE4-NEXT:    pminud %xmm5, %xmm1
; SSE4-NEXT:    pminud %xmm5, %xmm0
; SSE4-NEXT:    packusdw %xmm1, %xmm0
; SSE4-NEXT:    packuswb %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE4-NEXT:    pxor %xmm1, %xmm3
; SSE4-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE4-NEXT:    pxor %xmm1, %xmm2
; SSE4-NEXT:    packssdw %xmm3, %xmm2
; SSE4-NEXT:    packsswb %xmm2, %xmm2
; SSE4-NEXT:    pmovmskb %xmm2, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB12_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB12_3
; SSE4-NEXT:  .LBB12_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB12_5
; SSE4-NEXT:  .LBB12_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB12_7
; SSE4-NEXT:  .LBB12_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB12_9
; SSE4-NEXT:  .LBB12_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB12_11
; SSE4-NEXT:  .LBB12_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB12_13
; SSE4-NEXT:  .LBB12_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB12_15
; SSE4-NEXT:  .LBB12_16: # %else14
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB12_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB12_4
; SSE4-NEXT:  .LBB12_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm0, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB12_6
; SSE4-NEXT:  .LBB12_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB12_8
; SSE4-NEXT:  .LBB12_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm0, 3(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB12_10
; SSE4-NEXT:  .LBB12_9: # %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB12_12
; SSE4-NEXT:  .LBB12_11: # %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm0, 5(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB12_14
; SSE4-NEXT:  .LBB12_13: # %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB12_16
; SSE4-NEXT:  .LBB12_15: # %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm0, 7(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v8i32_v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255]
; AVX1-NEXT:    vpminud %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpminud %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    vmovmskps %ymm1, %eax
; AVX1-NEXT:    notl %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB12_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB12_3
; AVX1-NEXT:  .LBB12_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB12_5
; AVX1-NEXT:  .LBB12_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB12_7
; AVX1-NEXT:  .LBB12_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB12_9
; AVX1-NEXT:  .LBB12_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB12_11
; AVX1-NEXT:  .LBB12_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB12_13
; AVX1-NEXT:  .LBB12_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB12_15
; AVX1-NEXT:  .LBB12_16: # %else14
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB12_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB12_4
; AVX1-NEXT:  .LBB12_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB12_6
; AVX1-NEXT:  .LBB12_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB12_8
; AVX1-NEXT:  .LBB12_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB12_10
; AVX1-NEXT:  .LBB12_9: # %cond.store7
; AVX1-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB12_12
; AVX1-NEXT:  .LBB12_11: # %cond.store9
; AVX1-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB12_14
; AVX1-NEXT:  .LBB12_13: # %cond.store11
; AVX1-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB12_16
; AVX1-NEXT:  .LBB12_15: # %cond.store13
; AVX1-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v8i32_v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpminud %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vmovmskps %ymm1, %eax
; AVX2-NEXT:    notl %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB12_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB12_3
; AVX2-NEXT:  .LBB12_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB12_5
; AVX2-NEXT:  .LBB12_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB12_7
; AVX2-NEXT:  .LBB12_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB12_9
; AVX2-NEXT:  .LBB12_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB12_11
; AVX2-NEXT:  .LBB12_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB12_13
; AVX2-NEXT:  .LBB12_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB12_15
; AVX2-NEXT:  .LBB12_16: # %else14
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB12_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB12_4
; AVX2-NEXT:  .LBB12_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB12_6
; AVX2-NEXT:  .LBB12_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB12_8
; AVX2-NEXT:  .LBB12_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB12_10
; AVX2-NEXT:  .LBB12_9: # %cond.store7
; AVX2-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB12_12
; AVX2-NEXT:  .LBB12_11: # %cond.store9
; AVX2-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB12_14
; AVX2-NEXT:  .LBB12_13: # %cond.store11
; AVX2-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB12_16
; AVX2-NEXT:  .LBB12_15: # %cond.store13
; AVX2-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v8i32_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB12_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB12_3
; AVX512F-NEXT:  .LBB12_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB12_5
; AVX512F-NEXT:  .LBB12_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB12_7
; AVX512F-NEXT:  .LBB12_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB12_9
; AVX512F-NEXT:  .LBB12_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB12_11
; AVX512F-NEXT:  .LBB12_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB12_13
; AVX512F-NEXT:  .LBB12_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB12_15
; AVX512F-NEXT:  .LBB12_16: # %else14
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB12_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB12_4
; AVX512F-NEXT:  .LBB12_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB12_6
; AVX512F-NEXT:  .LBB12_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB12_8
; AVX512F-NEXT:  .LBB12_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB12_10
; AVX512F-NEXT:  .LBB12_9: # %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB12_12
; AVX512F-NEXT:  .LBB12_11: # %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB12_14
; AVX512F-NEXT:  .LBB12_13: # %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB12_16
; AVX512F-NEXT:  .LBB12_15: # %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v8i32_v8i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlq $56, %k0, %k0
; AVX512BW-NEXT:    kshiftrq $56, %k0, %k1
; AVX512BW-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v8i32_v8i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %ymm1, %ymm1, %k1
; AVX512BWVL-NEXT:    vpminud {{.*}}(%rip){1to8}, %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovdb %ymm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <8 x i32> %mask, zeroinitializer
  %b = icmp ult <8 x i32> %x, <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %c = select <8 x i1> %b, <8 x i32> %x, <8 x i32> <i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255, i32 255>
  %d = trunc <8 x i32> %c to <8 x i8>
  call void @llvm.masked.store.v8i8.p0v8i8(<8 x i8> %d, <8 x i8>* %p, i32 1, <8 x i1> %a)
  ret void
}

define void @truncstore_v4i32_v4i16(<4 x i32> %x, <4 x i16>* %p, <4 x i32> %mask) {
; SSE2-LABEL: truncstore_v4i32_v4i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147549183,2147549183,2147549183,2147549183]
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    movmskps %xmm2, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    jne .LBB13_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB13_3
; SSE2-NEXT:  .LBB13_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB13_5
; SSE2-NEXT:  .LBB13_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB13_7
; SSE2-NEXT:  .LBB13_8: # %else6
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB13_1: # %cond.store
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB13_4
; SSE2-NEXT:  .LBB13_3: # %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 2(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB13_6
; SSE2-NEXT:  .LBB13_5: # %cond.store3
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    movw %cx, 4(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB13_8
; SSE2-NEXT:  .LBB13_7: # %cond.store5
; SSE2-NEXT:    pextrw $3, %xmm0, %eax
; SSE2-NEXT:    movw %ax, 6(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v4i32_v4i16:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pminud {{.*}}(%rip), %xmm0
; SSE4-NEXT:    packusdw %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE4-NEXT:    movmskps %xmm2, %eax
; SSE4-NEXT:    xorl $15, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB13_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB13_3
; SSE4-NEXT:  .LBB13_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB13_5
; SSE4-NEXT:  .LBB13_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB13_7
; SSE4-NEXT:  .LBB13_8: # %else6
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB13_1: # %cond.store
; SSE4-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB13_4
; SSE4-NEXT:  .LBB13_3: # %cond.store1
; SSE4-NEXT:    pextrw $1, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB13_6
; SSE4-NEXT:  .LBB13_5: # %cond.store3
; SSE4-NEXT:    pextrw $2, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB13_8
; SSE4-NEXT:  .LBB13_7: # %cond.store5
; SSE4-NEXT:    pextrw $3, %xmm0, 6(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v4i32_v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpminud {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovmskps %xmm1, %eax
; AVX1-NEXT:    xorl $15, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB13_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB13_3
; AVX1-NEXT:  .LBB13_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB13_5
; AVX1-NEXT:  .LBB13_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB13_7
; AVX1-NEXT:  .LBB13_8: # %else6
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB13_1: # %cond.store
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB13_4
; AVX1-NEXT:  .LBB13_3: # %cond.store1
; AVX1-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB13_6
; AVX1-NEXT:  .LBB13_5: # %cond.store3
; AVX1-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB13_8
; AVX1-NEXT:  .LBB13_7: # %cond.store5
; AVX1-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v4i32_v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [65535,65535,65535,65535]
; AVX2-NEXT:    vpminud %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovmskps %xmm1, %eax
; AVX2-NEXT:    xorl $15, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB13_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB13_3
; AVX2-NEXT:  .LBB13_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB13_5
; AVX2-NEXT:  .LBB13_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB13_7
; AVX2-NEXT:  .LBB13_8: # %else6
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB13_1: # %cond.store
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB13_4
; AVX2-NEXT:  .LBB13_3: # %cond.store1
; AVX2-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB13_6
; AVX2-NEXT:  .LBB13_5: # %cond.store3
; AVX2-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB13_8
; AVX2-NEXT:  .LBB13_7: # %cond.store5
; AVX2-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v4i32_v4i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusdw %zmm0, %ymm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB13_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB13_3
; AVX512F-NEXT:  .LBB13_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB13_5
; AVX512F-NEXT:  .LBB13_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB13_7
; AVX512F-NEXT:  .LBB13_8: # %else6
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB13_1: # %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB13_4
; AVX512F-NEXT:  .LBB13_3: # %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB13_6
; AVX512F-NEXT:  .LBB13_5: # %cond.store3
; AVX512F-NEXT:    vpextrw $2, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB13_8
; AVX512F-NEXT:  .LBB13_7: # %cond.store5
; AVX512F-NEXT:    vpextrw $3, %xmm0, 6(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v4i32_v4i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftld $28, %k0, %k0
; AVX512BW-NEXT:    kshiftrd $28, %k0, %k1
; AVX512BW-NEXT:    vpmovusdw %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu16 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v4i32_v4i16:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminud {{.*}}(%rip){1to4}, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovdw %xmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <4 x i32> %mask, zeroinitializer
  %b = icmp ult <4 x i32> %x, <i32 65535, i32 65535, i32 65535, i32 65535>
  %c = select <4 x i1> %b, <4 x i32> %x, <4 x i32> <i32 65535, i32 65535, i32 65535, i32 65535>
  %d = trunc <4 x i32> %c to <4 x i16>
  call void @llvm.masked.store.v4i16.p0v4i16(<4 x i16> %d, <4 x i16>* %p, i32 1, <4 x i1> %a)
  ret void
}

define void @truncstore_v4i32_v4i8(<4 x i32> %x, <4 x i8>* %p, <4 x i32> %mask) {
; SSE2-LABEL: truncstore_v4i32_v4i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    pxor %xmm0, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483903,2147483903,2147483903,2147483903]
; SSE2-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    pandn {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm0, %xmm4
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    packuswb %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    movmskps %xmm2, %ecx
; SSE2-NEXT:    xorl $15, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    jne .LBB14_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %cl
; SSE2-NEXT:    jne .LBB14_3
; SSE2-NEXT:  .LBB14_4: # %else2
; SSE2-NEXT:    testb $4, %cl
; SSE2-NEXT:    jne .LBB14_5
; SSE2-NEXT:  .LBB14_6: # %else4
; SSE2-NEXT:    testb $8, %cl
; SSE2-NEXT:    jne .LBB14_7
; SSE2-NEXT:  .LBB14_8: # %else6
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB14_1: # %cond.store
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    testb $2, %cl
; SSE2-NEXT:    je .LBB14_4
; SSE2-NEXT:  .LBB14_3: # %cond.store1
; SSE2-NEXT:    movb %ah, 1(%rdi)
; SSE2-NEXT:    testb $4, %cl
; SSE2-NEXT:    je .LBB14_6
; SSE2-NEXT:  .LBB14_5: # %cond.store3
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %cl
; SSE2-NEXT:    je .LBB14_8
; SSE2-NEXT:  .LBB14_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    movb %al, 3(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v4i32_v4i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pminud {{.*}}(%rip), %xmm0
; SSE4-NEXT:    packusdw %xmm0, %xmm0
; SSE4-NEXT:    packuswb %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE4-NEXT:    movmskps %xmm2, %eax
; SSE4-NEXT:    xorl $15, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB14_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB14_3
; SSE4-NEXT:  .LBB14_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB14_5
; SSE4-NEXT:  .LBB14_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB14_7
; SSE4-NEXT:  .LBB14_8: # %else6
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB14_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB14_4
; SSE4-NEXT:  .LBB14_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm0, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB14_6
; SSE4-NEXT:  .LBB14_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB14_8
; SSE4-NEXT:  .LBB14_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm0, 3(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v4i32_v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpminud {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vmovmskps %xmm1, %eax
; AVX1-NEXT:    xorl $15, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB14_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB14_3
; AVX1-NEXT:  .LBB14_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB14_5
; AVX1-NEXT:  .LBB14_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB14_7
; AVX1-NEXT:  .LBB14_8: # %else6
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB14_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB14_4
; AVX1-NEXT:  .LBB14_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB14_6
; AVX1-NEXT:  .LBB14_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB14_8
; AVX1-NEXT:  .LBB14_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v4i32_v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [255,255,255,255]
; AVX2-NEXT:    vpminud %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackusdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vmovmskps %xmm1, %eax
; AVX2-NEXT:    xorl $15, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB14_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB14_3
; AVX2-NEXT:  .LBB14_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB14_5
; AVX2-NEXT:  .LBB14_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB14_7
; AVX2-NEXT:  .LBB14_8: # %else6
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB14_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB14_4
; AVX2-NEXT:  .LBB14_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB14_6
; AVX2-NEXT:  .LBB14_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB14_8
; AVX2-NEXT:  .LBB14_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v4i32_v4i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB14_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB14_3
; AVX512F-NEXT:  .LBB14_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB14_5
; AVX512F-NEXT:  .LBB14_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB14_7
; AVX512F-NEXT:  .LBB14_8: # %else6
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB14_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB14_4
; AVX512F-NEXT:  .LBB14_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB14_6
; AVX512F-NEXT:  .LBB14_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB14_8
; AVX512F-NEXT:  .LBB14_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v4i32_v4i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlq $60, %k0, %k0
; AVX512BW-NEXT:    kshiftrq $60, %k0, %k1
; AVX512BW-NEXT:    vpmovusdb %zmm0, %xmm0
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v4i32_v4i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminud {{.*}}(%rip){1to4}, %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovdb %xmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <4 x i32> %mask, zeroinitializer
  %b = icmp ult <4 x i32> %x, <i32 255, i32 255, i32 255, i32 255>
  %c = select <4 x i1> %b, <4 x i32> %x, <4 x i32> <i32 255, i32 255, i32 255, i32 255>
  %d = trunc <4 x i32> %c to <4 x i8>
  call void @llvm.masked.store.v4i8.p0v4i8(<4 x i8> %d, <4 x i8>* %p, i32 1, <4 x i1> %a)
  ret void
}

define void @truncstore_v32i16_v32i8(<32 x i16> %x, <32 x i8>* %p, <32 x i8> %mask) {
; SSE2-LABEL: truncstore_v32i16_v32i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm7, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE2-NEXT:    pxor %xmm6, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [33023,33023,33023,33023,33023,33023,33023,33023]
; SSE2-NEXT:    pminsw %xmm8, %xmm1
; SSE2-NEXT:    pxor %xmm6, %xmm1
; SSE2-NEXT:    pxor %xmm6, %xmm0
; SSE2-NEXT:    pminsw %xmm8, %xmm0
; SSE2-NEXT:    pxor %xmm6, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm7, %xmm4
; SSE2-NEXT:    pmovmskb %xmm4, %ecx
; SSE2-NEXT:    xorl $65535, %ecx # imm = 0xFFFF
; SSE2-NEXT:    pcmpeqb %xmm7, %xmm5
; SSE2-NEXT:    pmovmskb %xmm5, %eax
; SSE2-NEXT:    notl %eax
; SSE2-NEXT:    shll $16, %eax
; SSE2-NEXT:    orl %ecx, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    jne .LBB15_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB15_3
; SSE2-NEXT:  .LBB15_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB15_5
; SSE2-NEXT:  .LBB15_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB15_8
; SSE2-NEXT:  .LBB15_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 3(%rdi)
; SSE2-NEXT:  .LBB15_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    je .LBB15_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    movb %cl, 4(%rdi)
; SSE2-NEXT:  .LBB15_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB15_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    movb %ch, 5(%rdi)
; SSE2-NEXT:  .LBB15_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    pextrw $3, %xmm0, %ecx
; SSE2-NEXT:    je .LBB15_14
; SSE2-NEXT:  # %bb.13: # %cond.store11
; SSE2-NEXT:    movb %cl, 6(%rdi)
; SSE2-NEXT:  .LBB15_14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB15_16
; SSE2-NEXT:  # %bb.15: # %cond.store13
; SSE2-NEXT:    movb %ch, 7(%rdi)
; SSE2-NEXT:  .LBB15_16: # %else14
; SSE2-NEXT:    testl $256, %eax # imm = 0x100
; SSE2-NEXT:    pextrw $4, %xmm0, %ecx
; SSE2-NEXT:    je .LBB15_18
; SSE2-NEXT:  # %bb.17: # %cond.store15
; SSE2-NEXT:    movb %cl, 8(%rdi)
; SSE2-NEXT:  .LBB15_18: # %else16
; SSE2-NEXT:    testl $512, %eax # imm = 0x200
; SSE2-NEXT:    je .LBB15_20
; SSE2-NEXT:  # %bb.19: # %cond.store17
; SSE2-NEXT:    movb %ch, 9(%rdi)
; SSE2-NEXT:  .LBB15_20: # %else18
; SSE2-NEXT:    testl $1024, %eax # imm = 0x400
; SSE2-NEXT:    pextrw $5, %xmm0, %ecx
; SSE2-NEXT:    je .LBB15_22
; SSE2-NEXT:  # %bb.21: # %cond.store19
; SSE2-NEXT:    movb %cl, 10(%rdi)
; SSE2-NEXT:  .LBB15_22: # %else20
; SSE2-NEXT:    testl $2048, %eax # imm = 0x800
; SSE2-NEXT:    je .LBB15_24
; SSE2-NEXT:  # %bb.23: # %cond.store21
; SSE2-NEXT:    movb %ch, 11(%rdi)
; SSE2-NEXT:  .LBB15_24: # %else22
; SSE2-NEXT:    pxor %xmm6, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm2
; SSE2-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE2-NEXT:    pextrw $6, %xmm0, %ecx
; SSE2-NEXT:    je .LBB15_26
; SSE2-NEXT:  # %bb.25: # %cond.store23
; SSE2-NEXT:    movb %cl, 12(%rdi)
; SSE2-NEXT:  .LBB15_26: # %else24
; SSE2-NEXT:    pminsw %xmm8, %xmm3
; SSE2-NEXT:    pminsw %xmm8, %xmm2
; SSE2-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE2-NEXT:    je .LBB15_28
; SSE2-NEXT:  # %bb.27: # %cond.store25
; SSE2-NEXT:    movb %ch, 13(%rdi)
; SSE2-NEXT:  .LBB15_28: # %else26
; SSE2-NEXT:    pxor %xmm6, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm2
; SSE2-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE2-NEXT:    pextrw $7, %xmm0, %ecx
; SSE2-NEXT:    je .LBB15_30
; SSE2-NEXT:  # %bb.29: # %cond.store27
; SSE2-NEXT:    movb %cl, 14(%rdi)
; SSE2-NEXT:  .LBB15_30: # %else28
; SSE2-NEXT:    packuswb %xmm3, %xmm2
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    je .LBB15_32
; SSE2-NEXT:  # %bb.31: # %cond.store29
; SSE2-NEXT:    movb %ch, 15(%rdi)
; SSE2-NEXT:  .LBB15_32: # %else30
; SSE2-NEXT:    testl $65536, %eax # imm = 0x10000
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    jne .LBB15_33
; SSE2-NEXT:  # %bb.34: # %else32
; SSE2-NEXT:    testl $131072, %eax # imm = 0x20000
; SSE2-NEXT:    jne .LBB15_35
; SSE2-NEXT:  .LBB15_36: # %else34
; SSE2-NEXT:    testl $262144, %eax # imm = 0x40000
; SSE2-NEXT:    jne .LBB15_37
; SSE2-NEXT:  .LBB15_38: # %else36
; SSE2-NEXT:    testl $524288, %eax # imm = 0x80000
; SSE2-NEXT:    je .LBB15_40
; SSE2-NEXT:  .LBB15_39: # %cond.store37
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 19(%rdi)
; SSE2-NEXT:  .LBB15_40: # %else38
; SSE2-NEXT:    testl $1048576, %eax # imm = 0x100000
; SSE2-NEXT:    pextrw $2, %xmm2, %ecx
; SSE2-NEXT:    je .LBB15_42
; SSE2-NEXT:  # %bb.41: # %cond.store39
; SSE2-NEXT:    movb %cl, 20(%rdi)
; SSE2-NEXT:  .LBB15_42: # %else40
; SSE2-NEXT:    testl $2097152, %eax # imm = 0x200000
; SSE2-NEXT:    je .LBB15_44
; SSE2-NEXT:  # %bb.43: # %cond.store41
; SSE2-NEXT:    movb %ch, 21(%rdi)
; SSE2-NEXT:  .LBB15_44: # %else42
; SSE2-NEXT:    testl $4194304, %eax # imm = 0x400000
; SSE2-NEXT:    pextrw $3, %xmm2, %ecx
; SSE2-NEXT:    je .LBB15_46
; SSE2-NEXT:  # %bb.45: # %cond.store43
; SSE2-NEXT:    movb %cl, 22(%rdi)
; SSE2-NEXT:  .LBB15_46: # %else44
; SSE2-NEXT:    testl $8388608, %eax # imm = 0x800000
; SSE2-NEXT:    je .LBB15_48
; SSE2-NEXT:  # %bb.47: # %cond.store45
; SSE2-NEXT:    movb %ch, 23(%rdi)
; SSE2-NEXT:  .LBB15_48: # %else46
; SSE2-NEXT:    testl $16777216, %eax # imm = 0x1000000
; SSE2-NEXT:    pextrw $4, %xmm2, %ecx
; SSE2-NEXT:    je .LBB15_50
; SSE2-NEXT:  # %bb.49: # %cond.store47
; SSE2-NEXT:    movb %cl, 24(%rdi)
; SSE2-NEXT:  .LBB15_50: # %else48
; SSE2-NEXT:    testl $33554432, %eax # imm = 0x2000000
; SSE2-NEXT:    je .LBB15_52
; SSE2-NEXT:  # %bb.51: # %cond.store49
; SSE2-NEXT:    movb %ch, 25(%rdi)
; SSE2-NEXT:  .LBB15_52: # %else50
; SSE2-NEXT:    testl $67108864, %eax # imm = 0x4000000
; SSE2-NEXT:    pextrw $5, %xmm2, %ecx
; SSE2-NEXT:    je .LBB15_54
; SSE2-NEXT:  # %bb.53: # %cond.store51
; SSE2-NEXT:    movb %cl, 26(%rdi)
; SSE2-NEXT:  .LBB15_54: # %else52
; SSE2-NEXT:    testl $134217728, %eax # imm = 0x8000000
; SSE2-NEXT:    je .LBB15_56
; SSE2-NEXT:  # %bb.55: # %cond.store53
; SSE2-NEXT:    movb %ch, 27(%rdi)
; SSE2-NEXT:  .LBB15_56: # %else54
; SSE2-NEXT:    testl $268435456, %eax # imm = 0x10000000
; SSE2-NEXT:    pextrw $6, %xmm2, %ecx
; SSE2-NEXT:    je .LBB15_58
; SSE2-NEXT:  # %bb.57: # %cond.store55
; SSE2-NEXT:    movb %cl, 28(%rdi)
; SSE2-NEXT:  .LBB15_58: # %else56
; SSE2-NEXT:    testl $536870912, %eax # imm = 0x20000000
; SSE2-NEXT:    je .LBB15_60
; SSE2-NEXT:  # %bb.59: # %cond.store57
; SSE2-NEXT:    movb %ch, 29(%rdi)
; SSE2-NEXT:  .LBB15_60: # %else58
; SSE2-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; SSE2-NEXT:    pextrw $7, %xmm2, %ecx
; SSE2-NEXT:    jne .LBB15_61
; SSE2-NEXT:  # %bb.62: # %else60
; SSE2-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; SSE2-NEXT:    jne .LBB15_63
; SSE2-NEXT:  .LBB15_64: # %else62
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB15_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB15_4
; SSE2-NEXT:  .LBB15_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB15_6
; SSE2-NEXT:  .LBB15_5: # %cond.store3
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB15_7
; SSE2-NEXT:    jmp .LBB15_8
; SSE2-NEXT:  .LBB15_33: # %cond.store31
; SSE2-NEXT:    movb %cl, 16(%rdi)
; SSE2-NEXT:    testl $131072, %eax # imm = 0x20000
; SSE2-NEXT:    je .LBB15_36
; SSE2-NEXT:  .LBB15_35: # %cond.store33
; SSE2-NEXT:    movb %ch, 17(%rdi)
; SSE2-NEXT:    testl $262144, %eax # imm = 0x40000
; SSE2-NEXT:    je .LBB15_38
; SSE2-NEXT:  .LBB15_37: # %cond.store35
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 18(%rdi)
; SSE2-NEXT:    testl $524288, %eax # imm = 0x80000
; SSE2-NEXT:    jne .LBB15_39
; SSE2-NEXT:    jmp .LBB15_40
; SSE2-NEXT:  .LBB15_61: # %cond.store59
; SSE2-NEXT:    movb %cl, 30(%rdi)
; SSE2-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; SSE2-NEXT:    je .LBB15_64
; SSE2-NEXT:  .LBB15_63: # %cond.store61
; SSE2-NEXT:    movb %ch, 31(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v32i16_v32i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm7, %xmm7
; SSE4-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; SSE4-NEXT:    pminuw %xmm6, %xmm1
; SSE4-NEXT:    pminuw %xmm6, %xmm0
; SSE4-NEXT:    packuswb %xmm1, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm7, %xmm4
; SSE4-NEXT:    pmovmskb %xmm4, %ecx
; SSE4-NEXT:    xorl $65535, %ecx # imm = 0xFFFF
; SSE4-NEXT:    pcmpeqb %xmm7, %xmm5
; SSE4-NEXT:    pmovmskb %xmm5, %eax
; SSE4-NEXT:    notl %eax
; SSE4-NEXT:    shll $16, %eax
; SSE4-NEXT:    orl %ecx, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB15_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB15_3
; SSE4-NEXT:  .LBB15_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB15_5
; SSE4-NEXT:  .LBB15_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB15_7
; SSE4-NEXT:  .LBB15_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB15_9
; SSE4-NEXT:  .LBB15_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB15_11
; SSE4-NEXT:  .LBB15_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB15_13
; SSE4-NEXT:  .LBB15_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB15_15
; SSE4-NEXT:  .LBB15_16: # %else14
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    jne .LBB15_17
; SSE4-NEXT:  .LBB15_18: # %else16
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    jne .LBB15_19
; SSE4-NEXT:  .LBB15_20: # %else18
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    jne .LBB15_21
; SSE4-NEXT:  .LBB15_22: # %else20
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    jne .LBB15_23
; SSE4-NEXT:  .LBB15_24: # %else22
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    jne .LBB15_25
; SSE4-NEXT:  .LBB15_26: # %else24
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    jne .LBB15_27
; SSE4-NEXT:  .LBB15_28: # %else26
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    je .LBB15_30
; SSE4-NEXT:  .LBB15_29: # %cond.store27
; SSE4-NEXT:    pextrb $14, %xmm0, 14(%rdi)
; SSE4-NEXT:  .LBB15_30: # %else28
; SSE4-NEXT:    pminuw %xmm6, %xmm3
; SSE4-NEXT:    pminuw %xmm6, %xmm2
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    je .LBB15_32
; SSE4-NEXT:  # %bb.31: # %cond.store29
; SSE4-NEXT:    pextrb $15, %xmm0, 15(%rdi)
; SSE4-NEXT:  .LBB15_32: # %else30
; SSE4-NEXT:    packuswb %xmm3, %xmm2
; SSE4-NEXT:    testl $65536, %eax # imm = 0x10000
; SSE4-NEXT:    jne .LBB15_33
; SSE4-NEXT:  # %bb.34: # %else32
; SSE4-NEXT:    testl $131072, %eax # imm = 0x20000
; SSE4-NEXT:    jne .LBB15_35
; SSE4-NEXT:  .LBB15_36: # %else34
; SSE4-NEXT:    testl $262144, %eax # imm = 0x40000
; SSE4-NEXT:    jne .LBB15_37
; SSE4-NEXT:  .LBB15_38: # %else36
; SSE4-NEXT:    testl $524288, %eax # imm = 0x80000
; SSE4-NEXT:    jne .LBB15_39
; SSE4-NEXT:  .LBB15_40: # %else38
; SSE4-NEXT:    testl $1048576, %eax # imm = 0x100000
; SSE4-NEXT:    jne .LBB15_41
; SSE4-NEXT:  .LBB15_42: # %else40
; SSE4-NEXT:    testl $2097152, %eax # imm = 0x200000
; SSE4-NEXT:    jne .LBB15_43
; SSE4-NEXT:  .LBB15_44: # %else42
; SSE4-NEXT:    testl $4194304, %eax # imm = 0x400000
; SSE4-NEXT:    jne .LBB15_45
; SSE4-NEXT:  .LBB15_46: # %else44
; SSE4-NEXT:    testl $8388608, %eax # imm = 0x800000
; SSE4-NEXT:    jne .LBB15_47
; SSE4-NEXT:  .LBB15_48: # %else46
; SSE4-NEXT:    testl $16777216, %eax # imm = 0x1000000
; SSE4-NEXT:    jne .LBB15_49
; SSE4-NEXT:  .LBB15_50: # %else48
; SSE4-NEXT:    testl $33554432, %eax # imm = 0x2000000
; SSE4-NEXT:    jne .LBB15_51
; SSE4-NEXT:  .LBB15_52: # %else50
; SSE4-NEXT:    testl $67108864, %eax # imm = 0x4000000
; SSE4-NEXT:    jne .LBB15_53
; SSE4-NEXT:  .LBB15_54: # %else52
; SSE4-NEXT:    testl $134217728, %eax # imm = 0x8000000
; SSE4-NEXT:    jne .LBB15_55
; SSE4-NEXT:  .LBB15_56: # %else54
; SSE4-NEXT:    testl $268435456, %eax # imm = 0x10000000
; SSE4-NEXT:    jne .LBB15_57
; SSE4-NEXT:  .LBB15_58: # %else56
; SSE4-NEXT:    testl $536870912, %eax # imm = 0x20000000
; SSE4-NEXT:    jne .LBB15_59
; SSE4-NEXT:  .LBB15_60: # %else58
; SSE4-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; SSE4-NEXT:    jne .LBB15_61
; SSE4-NEXT:  .LBB15_62: # %else60
; SSE4-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; SSE4-NEXT:    jne .LBB15_63
; SSE4-NEXT:  .LBB15_64: # %else62
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB15_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB15_4
; SSE4-NEXT:  .LBB15_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm0, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB15_6
; SSE4-NEXT:  .LBB15_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB15_8
; SSE4-NEXT:  .LBB15_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm0, 3(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB15_10
; SSE4-NEXT:  .LBB15_9: # %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB15_12
; SSE4-NEXT:  .LBB15_11: # %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm0, 5(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB15_14
; SSE4-NEXT:  .LBB15_13: # %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB15_16
; SSE4-NEXT:  .LBB15_15: # %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm0, 7(%rdi)
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    je .LBB15_18
; SSE4-NEXT:  .LBB15_17: # %cond.store15
; SSE4-NEXT:    pextrb $8, %xmm0, 8(%rdi)
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    je .LBB15_20
; SSE4-NEXT:  .LBB15_19: # %cond.store17
; SSE4-NEXT:    pextrb $9, %xmm0, 9(%rdi)
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    je .LBB15_22
; SSE4-NEXT:  .LBB15_21: # %cond.store19
; SSE4-NEXT:    pextrb $10, %xmm0, 10(%rdi)
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    je .LBB15_24
; SSE4-NEXT:  .LBB15_23: # %cond.store21
; SSE4-NEXT:    pextrb $11, %xmm0, 11(%rdi)
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    je .LBB15_26
; SSE4-NEXT:  .LBB15_25: # %cond.store23
; SSE4-NEXT:    pextrb $12, %xmm0, 12(%rdi)
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    je .LBB15_28
; SSE4-NEXT:  .LBB15_27: # %cond.store25
; SSE4-NEXT:    pextrb $13, %xmm0, 13(%rdi)
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    jne .LBB15_29
; SSE4-NEXT:    jmp .LBB15_30
; SSE4-NEXT:  .LBB15_33: # %cond.store31
; SSE4-NEXT:    pextrb $0, %xmm2, 16(%rdi)
; SSE4-NEXT:    testl $131072, %eax # imm = 0x20000
; SSE4-NEXT:    je .LBB15_36
; SSE4-NEXT:  .LBB15_35: # %cond.store33
; SSE4-NEXT:    pextrb $1, %xmm2, 17(%rdi)
; SSE4-NEXT:    testl $262144, %eax # imm = 0x40000
; SSE4-NEXT:    je .LBB15_38
; SSE4-NEXT:  .LBB15_37: # %cond.store35
; SSE4-NEXT:    pextrb $2, %xmm2, 18(%rdi)
; SSE4-NEXT:    testl $524288, %eax # imm = 0x80000
; SSE4-NEXT:    je .LBB15_40
; SSE4-NEXT:  .LBB15_39: # %cond.store37
; SSE4-NEXT:    pextrb $3, %xmm2, 19(%rdi)
; SSE4-NEXT:    testl $1048576, %eax # imm = 0x100000
; SSE4-NEXT:    je .LBB15_42
; SSE4-NEXT:  .LBB15_41: # %cond.store39
; SSE4-NEXT:    pextrb $4, %xmm2, 20(%rdi)
; SSE4-NEXT:    testl $2097152, %eax # imm = 0x200000
; SSE4-NEXT:    je .LBB15_44
; SSE4-NEXT:  .LBB15_43: # %cond.store41
; SSE4-NEXT:    pextrb $5, %xmm2, 21(%rdi)
; SSE4-NEXT:    testl $4194304, %eax # imm = 0x400000
; SSE4-NEXT:    je .LBB15_46
; SSE4-NEXT:  .LBB15_45: # %cond.store43
; SSE4-NEXT:    pextrb $6, %xmm2, 22(%rdi)
; SSE4-NEXT:    testl $8388608, %eax # imm = 0x800000
; SSE4-NEXT:    je .LBB15_48
; SSE4-NEXT:  .LBB15_47: # %cond.store45
; SSE4-NEXT:    pextrb $7, %xmm2, 23(%rdi)
; SSE4-NEXT:    testl $16777216, %eax # imm = 0x1000000
; SSE4-NEXT:    je .LBB15_50
; SSE4-NEXT:  .LBB15_49: # %cond.store47
; SSE4-NEXT:    pextrb $8, %xmm2, 24(%rdi)
; SSE4-NEXT:    testl $33554432, %eax # imm = 0x2000000
; SSE4-NEXT:    je .LBB15_52
; SSE4-NEXT:  .LBB15_51: # %cond.store49
; SSE4-NEXT:    pextrb $9, %xmm2, 25(%rdi)
; SSE4-NEXT:    testl $67108864, %eax # imm = 0x4000000
; SSE4-NEXT:    je .LBB15_54
; SSE4-NEXT:  .LBB15_53: # %cond.store51
; SSE4-NEXT:    pextrb $10, %xmm2, 26(%rdi)
; SSE4-NEXT:    testl $134217728, %eax # imm = 0x8000000
; SSE4-NEXT:    je .LBB15_56
; SSE4-NEXT:  .LBB15_55: # %cond.store53
; SSE4-NEXT:    pextrb $11, %xmm2, 27(%rdi)
; SSE4-NEXT:    testl $268435456, %eax # imm = 0x10000000
; SSE4-NEXT:    je .LBB15_58
; SSE4-NEXT:  .LBB15_57: # %cond.store55
; SSE4-NEXT:    pextrb $12, %xmm2, 28(%rdi)
; SSE4-NEXT:    testl $536870912, %eax # imm = 0x20000000
; SSE4-NEXT:    je .LBB15_60
; SSE4-NEXT:  .LBB15_59: # %cond.store57
; SSE4-NEXT:    pextrb $13, %xmm2, 29(%rdi)
; SSE4-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; SSE4-NEXT:    je .LBB15_62
; SSE4-NEXT:  .LBB15_61: # %cond.store59
; SSE4-NEXT:    pextrb $14, %xmm2, 30(%rdi)
; SSE4-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; SSE4-NEXT:    je .LBB15_64
; SSE4-NEXT:  .LBB15_63: # %cond.store61
; SSE4-NEXT:    pextrb $15, %xmm2, 31(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v32i16_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpminuw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpminuw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpminuw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpminuw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm3
; AVX1-NEXT:    vpmovmskb %xmm3, %ecx
; AVX1-NEXT:    xorl $65535, %ecx # imm = 0xFFFF
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %eax
; AVX1-NEXT:    notl %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    orl %ecx, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB15_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB15_3
; AVX1-NEXT:  .LBB15_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB15_5
; AVX1-NEXT:  .LBB15_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB15_7
; AVX1-NEXT:  .LBB15_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB15_9
; AVX1-NEXT:  .LBB15_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB15_11
; AVX1-NEXT:  .LBB15_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB15_13
; AVX1-NEXT:  .LBB15_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB15_15
; AVX1-NEXT:  .LBB15_16: # %else14
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    jne .LBB15_17
; AVX1-NEXT:  .LBB15_18: # %else16
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    jne .LBB15_19
; AVX1-NEXT:  .LBB15_20: # %else18
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    jne .LBB15_21
; AVX1-NEXT:  .LBB15_22: # %else20
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    jne .LBB15_23
; AVX1-NEXT:  .LBB15_24: # %else22
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    jne .LBB15_25
; AVX1-NEXT:  .LBB15_26: # %else24
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    jne .LBB15_27
; AVX1-NEXT:  .LBB15_28: # %else26
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    jne .LBB15_29
; AVX1-NEXT:  .LBB15_30: # %else28
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    je .LBB15_32
; AVX1-NEXT:  .LBB15_31: # %cond.store29
; AVX1-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX1-NEXT:  .LBB15_32: # %else30
; AVX1-NEXT:    testl $65536, %eax # imm = 0x10000
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    jne .LBB15_33
; AVX1-NEXT:  # %bb.34: # %else32
; AVX1-NEXT:    testl $131072, %eax # imm = 0x20000
; AVX1-NEXT:    jne .LBB15_35
; AVX1-NEXT:  .LBB15_36: # %else34
; AVX1-NEXT:    testl $262144, %eax # imm = 0x40000
; AVX1-NEXT:    jne .LBB15_37
; AVX1-NEXT:  .LBB15_38: # %else36
; AVX1-NEXT:    testl $524288, %eax # imm = 0x80000
; AVX1-NEXT:    jne .LBB15_39
; AVX1-NEXT:  .LBB15_40: # %else38
; AVX1-NEXT:    testl $1048576, %eax # imm = 0x100000
; AVX1-NEXT:    jne .LBB15_41
; AVX1-NEXT:  .LBB15_42: # %else40
; AVX1-NEXT:    testl $2097152, %eax # imm = 0x200000
; AVX1-NEXT:    jne .LBB15_43
; AVX1-NEXT:  .LBB15_44: # %else42
; AVX1-NEXT:    testl $4194304, %eax # imm = 0x400000
; AVX1-NEXT:    jne .LBB15_45
; AVX1-NEXT:  .LBB15_46: # %else44
; AVX1-NEXT:    testl $8388608, %eax # imm = 0x800000
; AVX1-NEXT:    jne .LBB15_47
; AVX1-NEXT:  .LBB15_48: # %else46
; AVX1-NEXT:    testl $16777216, %eax # imm = 0x1000000
; AVX1-NEXT:    jne .LBB15_49
; AVX1-NEXT:  .LBB15_50: # %else48
; AVX1-NEXT:    testl $33554432, %eax # imm = 0x2000000
; AVX1-NEXT:    jne .LBB15_51
; AVX1-NEXT:  .LBB15_52: # %else50
; AVX1-NEXT:    testl $67108864, %eax # imm = 0x4000000
; AVX1-NEXT:    jne .LBB15_53
; AVX1-NEXT:  .LBB15_54: # %else52
; AVX1-NEXT:    testl $134217728, %eax # imm = 0x8000000
; AVX1-NEXT:    jne .LBB15_55
; AVX1-NEXT:  .LBB15_56: # %else54
; AVX1-NEXT:    testl $268435456, %eax # imm = 0x10000000
; AVX1-NEXT:    jne .LBB15_57
; AVX1-NEXT:  .LBB15_58: # %else56
; AVX1-NEXT:    testl $536870912, %eax # imm = 0x20000000
; AVX1-NEXT:    jne .LBB15_59
; AVX1-NEXT:  .LBB15_60: # %else58
; AVX1-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; AVX1-NEXT:    jne .LBB15_61
; AVX1-NEXT:  .LBB15_62: # %else60
; AVX1-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; AVX1-NEXT:    jne .LBB15_63
; AVX1-NEXT:  .LBB15_64: # %else62
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB15_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB15_4
; AVX1-NEXT:  .LBB15_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB15_6
; AVX1-NEXT:  .LBB15_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB15_8
; AVX1-NEXT:  .LBB15_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB15_10
; AVX1-NEXT:  .LBB15_9: # %cond.store7
; AVX1-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB15_12
; AVX1-NEXT:  .LBB15_11: # %cond.store9
; AVX1-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB15_14
; AVX1-NEXT:  .LBB15_13: # %cond.store11
; AVX1-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB15_16
; AVX1-NEXT:  .LBB15_15: # %cond.store13
; AVX1-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    je .LBB15_18
; AVX1-NEXT:  .LBB15_17: # %cond.store15
; AVX1-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    je .LBB15_20
; AVX1-NEXT:  .LBB15_19: # %cond.store17
; AVX1-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    je .LBB15_22
; AVX1-NEXT:  .LBB15_21: # %cond.store19
; AVX1-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    je .LBB15_24
; AVX1-NEXT:  .LBB15_23: # %cond.store21
; AVX1-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    je .LBB15_26
; AVX1-NEXT:  .LBB15_25: # %cond.store23
; AVX1-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    je .LBB15_28
; AVX1-NEXT:  .LBB15_27: # %cond.store25
; AVX1-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    je .LBB15_30
; AVX1-NEXT:  .LBB15_29: # %cond.store27
; AVX1-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    jne .LBB15_31
; AVX1-NEXT:    jmp .LBB15_32
; AVX1-NEXT:  .LBB15_33: # %cond.store31
; AVX1-NEXT:    vpextrb $0, %xmm0, 16(%rdi)
; AVX1-NEXT:    testl $131072, %eax # imm = 0x20000
; AVX1-NEXT:    je .LBB15_36
; AVX1-NEXT:  .LBB15_35: # %cond.store33
; AVX1-NEXT:    vpextrb $1, %xmm0, 17(%rdi)
; AVX1-NEXT:    testl $262144, %eax # imm = 0x40000
; AVX1-NEXT:    je .LBB15_38
; AVX1-NEXT:  .LBB15_37: # %cond.store35
; AVX1-NEXT:    vpextrb $2, %xmm0, 18(%rdi)
; AVX1-NEXT:    testl $524288, %eax # imm = 0x80000
; AVX1-NEXT:    je .LBB15_40
; AVX1-NEXT:  .LBB15_39: # %cond.store37
; AVX1-NEXT:    vpextrb $3, %xmm0, 19(%rdi)
; AVX1-NEXT:    testl $1048576, %eax # imm = 0x100000
; AVX1-NEXT:    je .LBB15_42
; AVX1-NEXT:  .LBB15_41: # %cond.store39
; AVX1-NEXT:    vpextrb $4, %xmm0, 20(%rdi)
; AVX1-NEXT:    testl $2097152, %eax # imm = 0x200000
; AVX1-NEXT:    je .LBB15_44
; AVX1-NEXT:  .LBB15_43: # %cond.store41
; AVX1-NEXT:    vpextrb $5, %xmm0, 21(%rdi)
; AVX1-NEXT:    testl $4194304, %eax # imm = 0x400000
; AVX1-NEXT:    je .LBB15_46
; AVX1-NEXT:  .LBB15_45: # %cond.store43
; AVX1-NEXT:    vpextrb $6, %xmm0, 22(%rdi)
; AVX1-NEXT:    testl $8388608, %eax # imm = 0x800000
; AVX1-NEXT:    je .LBB15_48
; AVX1-NEXT:  .LBB15_47: # %cond.store45
; AVX1-NEXT:    vpextrb $7, %xmm0, 23(%rdi)
; AVX1-NEXT:    testl $16777216, %eax # imm = 0x1000000
; AVX1-NEXT:    je .LBB15_50
; AVX1-NEXT:  .LBB15_49: # %cond.store47
; AVX1-NEXT:    vpextrb $8, %xmm0, 24(%rdi)
; AVX1-NEXT:    testl $33554432, %eax # imm = 0x2000000
; AVX1-NEXT:    je .LBB15_52
; AVX1-NEXT:  .LBB15_51: # %cond.store49
; AVX1-NEXT:    vpextrb $9, %xmm0, 25(%rdi)
; AVX1-NEXT:    testl $67108864, %eax # imm = 0x4000000
; AVX1-NEXT:    je .LBB15_54
; AVX1-NEXT:  .LBB15_53: # %cond.store51
; AVX1-NEXT:    vpextrb $10, %xmm0, 26(%rdi)
; AVX1-NEXT:    testl $134217728, %eax # imm = 0x8000000
; AVX1-NEXT:    je .LBB15_56
; AVX1-NEXT:  .LBB15_55: # %cond.store53
; AVX1-NEXT:    vpextrb $11, %xmm0, 27(%rdi)
; AVX1-NEXT:    testl $268435456, %eax # imm = 0x10000000
; AVX1-NEXT:    je .LBB15_58
; AVX1-NEXT:  .LBB15_57: # %cond.store55
; AVX1-NEXT:    vpextrb $12, %xmm0, 28(%rdi)
; AVX1-NEXT:    testl $536870912, %eax # imm = 0x20000000
; AVX1-NEXT:    je .LBB15_60
; AVX1-NEXT:  .LBB15_59: # %cond.store57
; AVX1-NEXT:    vpextrb $13, %xmm0, 29(%rdi)
; AVX1-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; AVX1-NEXT:    je .LBB15_62
; AVX1-NEXT:  .LBB15_61: # %cond.store59
; AVX1-NEXT:    vpextrb $14, %xmm0, 30(%rdi)
; AVX1-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; AVX1-NEXT:    je .LBB15_64
; AVX1-NEXT:  .LBB15_63: # %cond.store61
; AVX1-NEXT:    vpextrb $15, %xmm0, 31(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v32i16_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpminuw %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpminuw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpcmpeqb %ymm3, %ymm2, %ymm1
; AVX2-NEXT:    vpmovmskb %ymm1, %eax
; AVX2-NEXT:    notl %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB15_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB15_3
; AVX2-NEXT:  .LBB15_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB15_5
; AVX2-NEXT:  .LBB15_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB15_7
; AVX2-NEXT:  .LBB15_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB15_9
; AVX2-NEXT:  .LBB15_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB15_11
; AVX2-NEXT:  .LBB15_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB15_13
; AVX2-NEXT:  .LBB15_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB15_15
; AVX2-NEXT:  .LBB15_16: # %else14
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    jne .LBB15_17
; AVX2-NEXT:  .LBB15_18: # %else16
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    jne .LBB15_19
; AVX2-NEXT:  .LBB15_20: # %else18
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    jne .LBB15_21
; AVX2-NEXT:  .LBB15_22: # %else20
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    jne .LBB15_23
; AVX2-NEXT:  .LBB15_24: # %else22
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    jne .LBB15_25
; AVX2-NEXT:  .LBB15_26: # %else24
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    jne .LBB15_27
; AVX2-NEXT:  .LBB15_28: # %else26
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    jne .LBB15_29
; AVX2-NEXT:  .LBB15_30: # %else28
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    je .LBB15_32
; AVX2-NEXT:  .LBB15_31: # %cond.store29
; AVX2-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX2-NEXT:  .LBB15_32: # %else30
; AVX2-NEXT:    testl $65536, %eax # imm = 0x10000
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    jne .LBB15_33
; AVX2-NEXT:  # %bb.34: # %else32
; AVX2-NEXT:    testl $131072, %eax # imm = 0x20000
; AVX2-NEXT:    jne .LBB15_35
; AVX2-NEXT:  .LBB15_36: # %else34
; AVX2-NEXT:    testl $262144, %eax # imm = 0x40000
; AVX2-NEXT:    jne .LBB15_37
; AVX2-NEXT:  .LBB15_38: # %else36
; AVX2-NEXT:    testl $524288, %eax # imm = 0x80000
; AVX2-NEXT:    jne .LBB15_39
; AVX2-NEXT:  .LBB15_40: # %else38
; AVX2-NEXT:    testl $1048576, %eax # imm = 0x100000
; AVX2-NEXT:    jne .LBB15_41
; AVX2-NEXT:  .LBB15_42: # %else40
; AVX2-NEXT:    testl $2097152, %eax # imm = 0x200000
; AVX2-NEXT:    jne .LBB15_43
; AVX2-NEXT:  .LBB15_44: # %else42
; AVX2-NEXT:    testl $4194304, %eax # imm = 0x400000
; AVX2-NEXT:    jne .LBB15_45
; AVX2-NEXT:  .LBB15_46: # %else44
; AVX2-NEXT:    testl $8388608, %eax # imm = 0x800000
; AVX2-NEXT:    jne .LBB15_47
; AVX2-NEXT:  .LBB15_48: # %else46
; AVX2-NEXT:    testl $16777216, %eax # imm = 0x1000000
; AVX2-NEXT:    jne .LBB15_49
; AVX2-NEXT:  .LBB15_50: # %else48
; AVX2-NEXT:    testl $33554432, %eax # imm = 0x2000000
; AVX2-NEXT:    jne .LBB15_51
; AVX2-NEXT:  .LBB15_52: # %else50
; AVX2-NEXT:    testl $67108864, %eax # imm = 0x4000000
; AVX2-NEXT:    jne .LBB15_53
; AVX2-NEXT:  .LBB15_54: # %else52
; AVX2-NEXT:    testl $134217728, %eax # imm = 0x8000000
; AVX2-NEXT:    jne .LBB15_55
; AVX2-NEXT:  .LBB15_56: # %else54
; AVX2-NEXT:    testl $268435456, %eax # imm = 0x10000000
; AVX2-NEXT:    jne .LBB15_57
; AVX2-NEXT:  .LBB15_58: # %else56
; AVX2-NEXT:    testl $536870912, %eax # imm = 0x20000000
; AVX2-NEXT:    jne .LBB15_59
; AVX2-NEXT:  .LBB15_60: # %else58
; AVX2-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; AVX2-NEXT:    jne .LBB15_61
; AVX2-NEXT:  .LBB15_62: # %else60
; AVX2-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; AVX2-NEXT:    jne .LBB15_63
; AVX2-NEXT:  .LBB15_64: # %else62
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB15_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB15_4
; AVX2-NEXT:  .LBB15_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB15_6
; AVX2-NEXT:  .LBB15_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB15_8
; AVX2-NEXT:  .LBB15_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB15_10
; AVX2-NEXT:  .LBB15_9: # %cond.store7
; AVX2-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB15_12
; AVX2-NEXT:  .LBB15_11: # %cond.store9
; AVX2-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB15_14
; AVX2-NEXT:  .LBB15_13: # %cond.store11
; AVX2-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB15_16
; AVX2-NEXT:  .LBB15_15: # %cond.store13
; AVX2-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    je .LBB15_18
; AVX2-NEXT:  .LBB15_17: # %cond.store15
; AVX2-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    je .LBB15_20
; AVX2-NEXT:  .LBB15_19: # %cond.store17
; AVX2-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    je .LBB15_22
; AVX2-NEXT:  .LBB15_21: # %cond.store19
; AVX2-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    je .LBB15_24
; AVX2-NEXT:  .LBB15_23: # %cond.store21
; AVX2-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    je .LBB15_26
; AVX2-NEXT:  .LBB15_25: # %cond.store23
; AVX2-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    je .LBB15_28
; AVX2-NEXT:  .LBB15_27: # %cond.store25
; AVX2-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    je .LBB15_30
; AVX2-NEXT:  .LBB15_29: # %cond.store27
; AVX2-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    jne .LBB15_31
; AVX2-NEXT:    jmp .LBB15_32
; AVX2-NEXT:  .LBB15_33: # %cond.store31
; AVX2-NEXT:    vpextrb $0, %xmm0, 16(%rdi)
; AVX2-NEXT:    testl $131072, %eax # imm = 0x20000
; AVX2-NEXT:    je .LBB15_36
; AVX2-NEXT:  .LBB15_35: # %cond.store33
; AVX2-NEXT:    vpextrb $1, %xmm0, 17(%rdi)
; AVX2-NEXT:    testl $262144, %eax # imm = 0x40000
; AVX2-NEXT:    je .LBB15_38
; AVX2-NEXT:  .LBB15_37: # %cond.store35
; AVX2-NEXT:    vpextrb $2, %xmm0, 18(%rdi)
; AVX2-NEXT:    testl $524288, %eax # imm = 0x80000
; AVX2-NEXT:    je .LBB15_40
; AVX2-NEXT:  .LBB15_39: # %cond.store37
; AVX2-NEXT:    vpextrb $3, %xmm0, 19(%rdi)
; AVX2-NEXT:    testl $1048576, %eax # imm = 0x100000
; AVX2-NEXT:    je .LBB15_42
; AVX2-NEXT:  .LBB15_41: # %cond.store39
; AVX2-NEXT:    vpextrb $4, %xmm0, 20(%rdi)
; AVX2-NEXT:    testl $2097152, %eax # imm = 0x200000
; AVX2-NEXT:    je .LBB15_44
; AVX2-NEXT:  .LBB15_43: # %cond.store41
; AVX2-NEXT:    vpextrb $5, %xmm0, 21(%rdi)
; AVX2-NEXT:    testl $4194304, %eax # imm = 0x400000
; AVX2-NEXT:    je .LBB15_46
; AVX2-NEXT:  .LBB15_45: # %cond.store43
; AVX2-NEXT:    vpextrb $6, %xmm0, 22(%rdi)
; AVX2-NEXT:    testl $8388608, %eax # imm = 0x800000
; AVX2-NEXT:    je .LBB15_48
; AVX2-NEXT:  .LBB15_47: # %cond.store45
; AVX2-NEXT:    vpextrb $7, %xmm0, 23(%rdi)
; AVX2-NEXT:    testl $16777216, %eax # imm = 0x1000000
; AVX2-NEXT:    je .LBB15_50
; AVX2-NEXT:  .LBB15_49: # %cond.store47
; AVX2-NEXT:    vpextrb $8, %xmm0, 24(%rdi)
; AVX2-NEXT:    testl $33554432, %eax # imm = 0x2000000
; AVX2-NEXT:    je .LBB15_52
; AVX2-NEXT:  .LBB15_51: # %cond.store49
; AVX2-NEXT:    vpextrb $9, %xmm0, 25(%rdi)
; AVX2-NEXT:    testl $67108864, %eax # imm = 0x4000000
; AVX2-NEXT:    je .LBB15_54
; AVX2-NEXT:  .LBB15_53: # %cond.store51
; AVX2-NEXT:    vpextrb $10, %xmm0, 26(%rdi)
; AVX2-NEXT:    testl $134217728, %eax # imm = 0x8000000
; AVX2-NEXT:    je .LBB15_56
; AVX2-NEXT:  .LBB15_55: # %cond.store53
; AVX2-NEXT:    vpextrb $11, %xmm0, 27(%rdi)
; AVX2-NEXT:    testl $268435456, %eax # imm = 0x10000000
; AVX2-NEXT:    je .LBB15_58
; AVX2-NEXT:  .LBB15_57: # %cond.store55
; AVX2-NEXT:    vpextrb $12, %xmm0, 28(%rdi)
; AVX2-NEXT:    testl $536870912, %eax # imm = 0x20000000
; AVX2-NEXT:    je .LBB15_60
; AVX2-NEXT:  .LBB15_59: # %cond.store57
; AVX2-NEXT:    vpextrb $13, %xmm0, 29(%rdi)
; AVX2-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; AVX2-NEXT:    je .LBB15_62
; AVX2-NEXT:  .LBB15_61: # %cond.store59
; AVX2-NEXT:    vpextrb $14, %xmm0, 30(%rdi)
; AVX2-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; AVX2-NEXT:    je .LBB15_64
; AVX2-NEXT:  .LBB15_63: # %cond.store61
; AVX2-NEXT:    vpextrb $15, %xmm0, 31(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v32i16_v32i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpminuw %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpminuw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512F-NEXT:    vpmovdb %zmm2, %xmm2
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovmskb %ymm1, %eax
; AVX512F-NEXT:    notl %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB15_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB15_3
; AVX512F-NEXT:  .LBB15_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB15_5
; AVX512F-NEXT:  .LBB15_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB15_7
; AVX512F-NEXT:  .LBB15_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB15_9
; AVX512F-NEXT:  .LBB15_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB15_11
; AVX512F-NEXT:  .LBB15_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB15_13
; AVX512F-NEXT:  .LBB15_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB15_15
; AVX512F-NEXT:  .LBB15_16: # %else14
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    jne .LBB15_17
; AVX512F-NEXT:  .LBB15_18: # %else16
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    jne .LBB15_19
; AVX512F-NEXT:  .LBB15_20: # %else18
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    jne .LBB15_21
; AVX512F-NEXT:  .LBB15_22: # %else20
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    jne .LBB15_23
; AVX512F-NEXT:  .LBB15_24: # %else22
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    jne .LBB15_25
; AVX512F-NEXT:  .LBB15_26: # %else24
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    jne .LBB15_27
; AVX512F-NEXT:  .LBB15_28: # %else26
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    jne .LBB15_29
; AVX512F-NEXT:  .LBB15_30: # %else28
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    je .LBB15_32
; AVX512F-NEXT:  .LBB15_31: # %cond.store29
; AVX512F-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX512F-NEXT:  .LBB15_32: # %else30
; AVX512F-NEXT:    testl $65536, %eax # imm = 0x10000
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    jne .LBB15_33
; AVX512F-NEXT:  # %bb.34: # %else32
; AVX512F-NEXT:    testl $131072, %eax # imm = 0x20000
; AVX512F-NEXT:    jne .LBB15_35
; AVX512F-NEXT:  .LBB15_36: # %else34
; AVX512F-NEXT:    testl $262144, %eax # imm = 0x40000
; AVX512F-NEXT:    jne .LBB15_37
; AVX512F-NEXT:  .LBB15_38: # %else36
; AVX512F-NEXT:    testl $524288, %eax # imm = 0x80000
; AVX512F-NEXT:    jne .LBB15_39
; AVX512F-NEXT:  .LBB15_40: # %else38
; AVX512F-NEXT:    testl $1048576, %eax # imm = 0x100000
; AVX512F-NEXT:    jne .LBB15_41
; AVX512F-NEXT:  .LBB15_42: # %else40
; AVX512F-NEXT:    testl $2097152, %eax # imm = 0x200000
; AVX512F-NEXT:    jne .LBB15_43
; AVX512F-NEXT:  .LBB15_44: # %else42
; AVX512F-NEXT:    testl $4194304, %eax # imm = 0x400000
; AVX512F-NEXT:    jne .LBB15_45
; AVX512F-NEXT:  .LBB15_46: # %else44
; AVX512F-NEXT:    testl $8388608, %eax # imm = 0x800000
; AVX512F-NEXT:    jne .LBB15_47
; AVX512F-NEXT:  .LBB15_48: # %else46
; AVX512F-NEXT:    testl $16777216, %eax # imm = 0x1000000
; AVX512F-NEXT:    jne .LBB15_49
; AVX512F-NEXT:  .LBB15_50: # %else48
; AVX512F-NEXT:    testl $33554432, %eax # imm = 0x2000000
; AVX512F-NEXT:    jne .LBB15_51
; AVX512F-NEXT:  .LBB15_52: # %else50
; AVX512F-NEXT:    testl $67108864, %eax # imm = 0x4000000
; AVX512F-NEXT:    jne .LBB15_53
; AVX512F-NEXT:  .LBB15_54: # %else52
; AVX512F-NEXT:    testl $134217728, %eax # imm = 0x8000000
; AVX512F-NEXT:    jne .LBB15_55
; AVX512F-NEXT:  .LBB15_56: # %else54
; AVX512F-NEXT:    testl $268435456, %eax # imm = 0x10000000
; AVX512F-NEXT:    jne .LBB15_57
; AVX512F-NEXT:  .LBB15_58: # %else56
; AVX512F-NEXT:    testl $536870912, %eax # imm = 0x20000000
; AVX512F-NEXT:    jne .LBB15_59
; AVX512F-NEXT:  .LBB15_60: # %else58
; AVX512F-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; AVX512F-NEXT:    jne .LBB15_61
; AVX512F-NEXT:  .LBB15_62: # %else60
; AVX512F-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; AVX512F-NEXT:    jne .LBB15_63
; AVX512F-NEXT:  .LBB15_64: # %else62
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB15_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB15_4
; AVX512F-NEXT:  .LBB15_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB15_6
; AVX512F-NEXT:  .LBB15_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB15_8
; AVX512F-NEXT:  .LBB15_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB15_10
; AVX512F-NEXT:  .LBB15_9: # %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB15_12
; AVX512F-NEXT:  .LBB15_11: # %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB15_14
; AVX512F-NEXT:  .LBB15_13: # %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB15_16
; AVX512F-NEXT:  .LBB15_15: # %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    je .LBB15_18
; AVX512F-NEXT:  .LBB15_17: # %cond.store15
; AVX512F-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    je .LBB15_20
; AVX512F-NEXT:  .LBB15_19: # %cond.store17
; AVX512F-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    je .LBB15_22
; AVX512F-NEXT:  .LBB15_21: # %cond.store19
; AVX512F-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    je .LBB15_24
; AVX512F-NEXT:  .LBB15_23: # %cond.store21
; AVX512F-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    je .LBB15_26
; AVX512F-NEXT:  .LBB15_25: # %cond.store23
; AVX512F-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    je .LBB15_28
; AVX512F-NEXT:  .LBB15_27: # %cond.store25
; AVX512F-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    je .LBB15_30
; AVX512F-NEXT:  .LBB15_29: # %cond.store27
; AVX512F-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    jne .LBB15_31
; AVX512F-NEXT:    jmp .LBB15_32
; AVX512F-NEXT:  .LBB15_33: # %cond.store31
; AVX512F-NEXT:    vpextrb $0, %xmm0, 16(%rdi)
; AVX512F-NEXT:    testl $131072, %eax # imm = 0x20000
; AVX512F-NEXT:    je .LBB15_36
; AVX512F-NEXT:  .LBB15_35: # %cond.store33
; AVX512F-NEXT:    vpextrb $1, %xmm0, 17(%rdi)
; AVX512F-NEXT:    testl $262144, %eax # imm = 0x40000
; AVX512F-NEXT:    je .LBB15_38
; AVX512F-NEXT:  .LBB15_37: # %cond.store35
; AVX512F-NEXT:    vpextrb $2, %xmm0, 18(%rdi)
; AVX512F-NEXT:    testl $524288, %eax # imm = 0x80000
; AVX512F-NEXT:    je .LBB15_40
; AVX512F-NEXT:  .LBB15_39: # %cond.store37
; AVX512F-NEXT:    vpextrb $3, %xmm0, 19(%rdi)
; AVX512F-NEXT:    testl $1048576, %eax # imm = 0x100000
; AVX512F-NEXT:    je .LBB15_42
; AVX512F-NEXT:  .LBB15_41: # %cond.store39
; AVX512F-NEXT:    vpextrb $4, %xmm0, 20(%rdi)
; AVX512F-NEXT:    testl $2097152, %eax # imm = 0x200000
; AVX512F-NEXT:    je .LBB15_44
; AVX512F-NEXT:  .LBB15_43: # %cond.store41
; AVX512F-NEXT:    vpextrb $5, %xmm0, 21(%rdi)
; AVX512F-NEXT:    testl $4194304, %eax # imm = 0x400000
; AVX512F-NEXT:    je .LBB15_46
; AVX512F-NEXT:  .LBB15_45: # %cond.store43
; AVX512F-NEXT:    vpextrb $6, %xmm0, 22(%rdi)
; AVX512F-NEXT:    testl $8388608, %eax # imm = 0x800000
; AVX512F-NEXT:    je .LBB15_48
; AVX512F-NEXT:  .LBB15_47: # %cond.store45
; AVX512F-NEXT:    vpextrb $7, %xmm0, 23(%rdi)
; AVX512F-NEXT:    testl $16777216, %eax # imm = 0x1000000
; AVX512F-NEXT:    je .LBB15_50
; AVX512F-NEXT:  .LBB15_49: # %cond.store47
; AVX512F-NEXT:    vpextrb $8, %xmm0, 24(%rdi)
; AVX512F-NEXT:    testl $33554432, %eax # imm = 0x2000000
; AVX512F-NEXT:    je .LBB15_52
; AVX512F-NEXT:  .LBB15_51: # %cond.store49
; AVX512F-NEXT:    vpextrb $9, %xmm0, 25(%rdi)
; AVX512F-NEXT:    testl $67108864, %eax # imm = 0x4000000
; AVX512F-NEXT:    je .LBB15_54
; AVX512F-NEXT:  .LBB15_53: # %cond.store51
; AVX512F-NEXT:    vpextrb $10, %xmm0, 26(%rdi)
; AVX512F-NEXT:    testl $134217728, %eax # imm = 0x8000000
; AVX512F-NEXT:    je .LBB15_56
; AVX512F-NEXT:  .LBB15_55: # %cond.store53
; AVX512F-NEXT:    vpextrb $11, %xmm0, 27(%rdi)
; AVX512F-NEXT:    testl $268435456, %eax # imm = 0x10000000
; AVX512F-NEXT:    je .LBB15_58
; AVX512F-NEXT:  .LBB15_57: # %cond.store55
; AVX512F-NEXT:    vpextrb $12, %xmm0, 28(%rdi)
; AVX512F-NEXT:    testl $536870912, %eax # imm = 0x20000000
; AVX512F-NEXT:    je .LBB15_60
; AVX512F-NEXT:  .LBB15_59: # %cond.store57
; AVX512F-NEXT:    vpextrb $13, %xmm0, 29(%rdi)
; AVX512F-NEXT:    testl $1073741824, %eax # imm = 0x40000000
; AVX512F-NEXT:    je .LBB15_62
; AVX512F-NEXT:  .LBB15_61: # %cond.store59
; AVX512F-NEXT:    vpextrb $14, %xmm0, 30(%rdi)
; AVX512F-NEXT:    testl $-2147483648, %eax # imm = 0x80000000
; AVX512F-NEXT:    je .LBB15_64
; AVX512F-NEXT:  .LBB15_63: # %cond.store61
; AVX512F-NEXT:    vpextrb $15, %xmm0, 31(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v32i16_v32i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    vptestmb %zmm1, %zmm1, %k1
; AVX512BW-NEXT:    vpminuw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v32i16_v32i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmb %ymm1, %ymm1, %k1
; AVX512BWVL-NEXT:    vpminuw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BWVL-NEXT:    vpmovwb %zmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <32 x i8> %mask, zeroinitializer
  %b = icmp ult <32 x i16> %x, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %c = select <32 x i1> %b, <32 x i16> %x, <32 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %d = trunc <32 x i16> %c to <32 x i8>
  call void @llvm.masked.store.v32i8.p0v32i8(<32 x i8> %d, <32 x i8>* %p, i32 1, <32 x i1> %a)
  ret void
}

define void @truncstore_v16i16_v16i8(<16 x i16> %x, <16 x i8>* %p, <16 x i8> %mask) {
; SSE2-LABEL: truncstore_v16i16_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [33023,33023,33023,33023,33023,33023,33023,33023]
; SSE2-NEXT:    pminsw %xmm5, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    pminsw %xmm5, %xmm0
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE2-NEXT:    pmovmskb %xmm3, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    jne .LBB16_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB16_3
; SSE2-NEXT:  .LBB16_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB16_5
; SSE2-NEXT:  .LBB16_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB16_8
; SSE2-NEXT:  .LBB16_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 3(%rdi)
; SSE2-NEXT:  .LBB16_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    je .LBB16_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    movb %cl, 4(%rdi)
; SSE2-NEXT:  .LBB16_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB16_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    movb %ch, 5(%rdi)
; SSE2-NEXT:  .LBB16_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    pextrw $3, %xmm0, %ecx
; SSE2-NEXT:    je .LBB16_14
; SSE2-NEXT:  # %bb.13: # %cond.store11
; SSE2-NEXT:    movb %cl, 6(%rdi)
; SSE2-NEXT:  .LBB16_14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB16_16
; SSE2-NEXT:  # %bb.15: # %cond.store13
; SSE2-NEXT:    movb %ch, 7(%rdi)
; SSE2-NEXT:  .LBB16_16: # %else14
; SSE2-NEXT:    testl $256, %eax # imm = 0x100
; SSE2-NEXT:    pextrw $4, %xmm0, %ecx
; SSE2-NEXT:    je .LBB16_18
; SSE2-NEXT:  # %bb.17: # %cond.store15
; SSE2-NEXT:    movb %cl, 8(%rdi)
; SSE2-NEXT:  .LBB16_18: # %else16
; SSE2-NEXT:    testl $512, %eax # imm = 0x200
; SSE2-NEXT:    je .LBB16_20
; SSE2-NEXT:  # %bb.19: # %cond.store17
; SSE2-NEXT:    movb %ch, 9(%rdi)
; SSE2-NEXT:  .LBB16_20: # %else18
; SSE2-NEXT:    testl $1024, %eax # imm = 0x400
; SSE2-NEXT:    pextrw $5, %xmm0, %ecx
; SSE2-NEXT:    je .LBB16_22
; SSE2-NEXT:  # %bb.21: # %cond.store19
; SSE2-NEXT:    movb %cl, 10(%rdi)
; SSE2-NEXT:  .LBB16_22: # %else20
; SSE2-NEXT:    testl $2048, %eax # imm = 0x800
; SSE2-NEXT:    je .LBB16_24
; SSE2-NEXT:  # %bb.23: # %cond.store21
; SSE2-NEXT:    movb %ch, 11(%rdi)
; SSE2-NEXT:  .LBB16_24: # %else22
; SSE2-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE2-NEXT:    pextrw $6, %xmm0, %ecx
; SSE2-NEXT:    je .LBB16_26
; SSE2-NEXT:  # %bb.25: # %cond.store23
; SSE2-NEXT:    movb %cl, 12(%rdi)
; SSE2-NEXT:  .LBB16_26: # %else24
; SSE2-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE2-NEXT:    je .LBB16_28
; SSE2-NEXT:  # %bb.27: # %cond.store25
; SSE2-NEXT:    movb %ch, 13(%rdi)
; SSE2-NEXT:  .LBB16_28: # %else26
; SSE2-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE2-NEXT:    pextrw $7, %xmm0, %ecx
; SSE2-NEXT:    jne .LBB16_29
; SSE2-NEXT:  # %bb.30: # %else28
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    jne .LBB16_31
; SSE2-NEXT:  .LBB16_32: # %else30
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB16_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB16_4
; SSE2-NEXT:  .LBB16_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB16_6
; SSE2-NEXT:  .LBB16_5: # %cond.store3
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB16_7
; SSE2-NEXT:    jmp .LBB16_8
; SSE2-NEXT:  .LBB16_29: # %cond.store27
; SSE2-NEXT:    movb %cl, 14(%rdi)
; SSE2-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE2-NEXT:    je .LBB16_32
; SSE2-NEXT:  .LBB16_31: # %cond.store29
; SSE2-NEXT:    movb %ch, 15(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v16i16_v16i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm3, %xmm3
; SSE4-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; SSE4-NEXT:    pminuw %xmm4, %xmm1
; SSE4-NEXT:    pminuw %xmm4, %xmm0
; SSE4-NEXT:    packuswb %xmm1, %xmm0
; SSE4-NEXT:    pcmpeqb %xmm2, %xmm3
; SSE4-NEXT:    pmovmskb %xmm3, %eax
; SSE4-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB16_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB16_3
; SSE4-NEXT:  .LBB16_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB16_5
; SSE4-NEXT:  .LBB16_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB16_7
; SSE4-NEXT:  .LBB16_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB16_9
; SSE4-NEXT:  .LBB16_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB16_11
; SSE4-NEXT:  .LBB16_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB16_13
; SSE4-NEXT:  .LBB16_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB16_15
; SSE4-NEXT:  .LBB16_16: # %else14
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    jne .LBB16_17
; SSE4-NEXT:  .LBB16_18: # %else16
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    jne .LBB16_19
; SSE4-NEXT:  .LBB16_20: # %else18
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    jne .LBB16_21
; SSE4-NEXT:  .LBB16_22: # %else20
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    jne .LBB16_23
; SSE4-NEXT:  .LBB16_24: # %else22
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    jne .LBB16_25
; SSE4-NEXT:  .LBB16_26: # %else24
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    jne .LBB16_27
; SSE4-NEXT:  .LBB16_28: # %else26
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    jne .LBB16_29
; SSE4-NEXT:  .LBB16_30: # %else28
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    jne .LBB16_31
; SSE4-NEXT:  .LBB16_32: # %else30
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB16_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB16_4
; SSE4-NEXT:  .LBB16_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm0, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB16_6
; SSE4-NEXT:  .LBB16_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB16_8
; SSE4-NEXT:  .LBB16_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm0, 3(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB16_10
; SSE4-NEXT:  .LBB16_9: # %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB16_12
; SSE4-NEXT:  .LBB16_11: # %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm0, 5(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB16_14
; SSE4-NEXT:  .LBB16_13: # %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB16_16
; SSE4-NEXT:  .LBB16_15: # %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm0, 7(%rdi)
; SSE4-NEXT:    testl $256, %eax # imm = 0x100
; SSE4-NEXT:    je .LBB16_18
; SSE4-NEXT:  .LBB16_17: # %cond.store15
; SSE4-NEXT:    pextrb $8, %xmm0, 8(%rdi)
; SSE4-NEXT:    testl $512, %eax # imm = 0x200
; SSE4-NEXT:    je .LBB16_20
; SSE4-NEXT:  .LBB16_19: # %cond.store17
; SSE4-NEXT:    pextrb $9, %xmm0, 9(%rdi)
; SSE4-NEXT:    testl $1024, %eax # imm = 0x400
; SSE4-NEXT:    je .LBB16_22
; SSE4-NEXT:  .LBB16_21: # %cond.store19
; SSE4-NEXT:    pextrb $10, %xmm0, 10(%rdi)
; SSE4-NEXT:    testl $2048, %eax # imm = 0x800
; SSE4-NEXT:    je .LBB16_24
; SSE4-NEXT:  .LBB16_23: # %cond.store21
; SSE4-NEXT:    pextrb $11, %xmm0, 11(%rdi)
; SSE4-NEXT:    testl $4096, %eax # imm = 0x1000
; SSE4-NEXT:    je .LBB16_26
; SSE4-NEXT:  .LBB16_25: # %cond.store23
; SSE4-NEXT:    pextrb $12, %xmm0, 12(%rdi)
; SSE4-NEXT:    testl $8192, %eax # imm = 0x2000
; SSE4-NEXT:    je .LBB16_28
; SSE4-NEXT:  .LBB16_27: # %cond.store25
; SSE4-NEXT:    pextrb $13, %xmm0, 13(%rdi)
; SSE4-NEXT:    testl $16384, %eax # imm = 0x4000
; SSE4-NEXT:    je .LBB16_30
; SSE4-NEXT:  .LBB16_29: # %cond.store27
; SSE4-NEXT:    pextrb $14, %xmm0, 14(%rdi)
; SSE4-NEXT:    testl $32768, %eax # imm = 0x8000
; SSE4-NEXT:    je .LBB16_32
; SSE4-NEXT:  .LBB16_31: # %cond.store29
; SSE4-NEXT:    pextrb $15, %xmm0, 15(%rdi)
; SSE4-NEXT:    retq
;
; AVX1-LABEL: truncstore_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpminuw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpminuw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %eax
; AVX1-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    jne .LBB16_1
; AVX1-NEXT:  # %bb.2: # %else
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    jne .LBB16_3
; AVX1-NEXT:  .LBB16_4: # %else2
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    jne .LBB16_5
; AVX1-NEXT:  .LBB16_6: # %else4
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    jne .LBB16_7
; AVX1-NEXT:  .LBB16_8: # %else6
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    jne .LBB16_9
; AVX1-NEXT:  .LBB16_10: # %else8
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    jne .LBB16_11
; AVX1-NEXT:  .LBB16_12: # %else10
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    jne .LBB16_13
; AVX1-NEXT:  .LBB16_14: # %else12
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    jne .LBB16_15
; AVX1-NEXT:  .LBB16_16: # %else14
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    jne .LBB16_17
; AVX1-NEXT:  .LBB16_18: # %else16
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    jne .LBB16_19
; AVX1-NEXT:  .LBB16_20: # %else18
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    jne .LBB16_21
; AVX1-NEXT:  .LBB16_22: # %else20
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    jne .LBB16_23
; AVX1-NEXT:  .LBB16_24: # %else22
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    jne .LBB16_25
; AVX1-NEXT:  .LBB16_26: # %else24
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    jne .LBB16_27
; AVX1-NEXT:  .LBB16_28: # %else26
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    jne .LBB16_29
; AVX1-NEXT:  .LBB16_30: # %else28
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    jne .LBB16_31
; AVX1-NEXT:  .LBB16_32: # %else30
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
; AVX1-NEXT:  .LBB16_1: # %cond.store
; AVX1-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1-NEXT:    testb $2, %al
; AVX1-NEXT:    je .LBB16_4
; AVX1-NEXT:  .LBB16_3: # %cond.store1
; AVX1-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX1-NEXT:    testb $4, %al
; AVX1-NEXT:    je .LBB16_6
; AVX1-NEXT:  .LBB16_5: # %cond.store3
; AVX1-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX1-NEXT:    testb $8, %al
; AVX1-NEXT:    je .LBB16_8
; AVX1-NEXT:  .LBB16_7: # %cond.store5
; AVX1-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX1-NEXT:    testb $16, %al
; AVX1-NEXT:    je .LBB16_10
; AVX1-NEXT:  .LBB16_9: # %cond.store7
; AVX1-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX1-NEXT:    testb $32, %al
; AVX1-NEXT:    je .LBB16_12
; AVX1-NEXT:  .LBB16_11: # %cond.store9
; AVX1-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX1-NEXT:    testb $64, %al
; AVX1-NEXT:    je .LBB16_14
; AVX1-NEXT:  .LBB16_13: # %cond.store11
; AVX1-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX1-NEXT:    testb $-128, %al
; AVX1-NEXT:    je .LBB16_16
; AVX1-NEXT:  .LBB16_15: # %cond.store13
; AVX1-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX1-NEXT:    testl $256, %eax # imm = 0x100
; AVX1-NEXT:    je .LBB16_18
; AVX1-NEXT:  .LBB16_17: # %cond.store15
; AVX1-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX1-NEXT:    testl $512, %eax # imm = 0x200
; AVX1-NEXT:    je .LBB16_20
; AVX1-NEXT:  .LBB16_19: # %cond.store17
; AVX1-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX1-NEXT:    testl $1024, %eax # imm = 0x400
; AVX1-NEXT:    je .LBB16_22
; AVX1-NEXT:  .LBB16_21: # %cond.store19
; AVX1-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX1-NEXT:    testl $2048, %eax # imm = 0x800
; AVX1-NEXT:    je .LBB16_24
; AVX1-NEXT:  .LBB16_23: # %cond.store21
; AVX1-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX1-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX1-NEXT:    je .LBB16_26
; AVX1-NEXT:  .LBB16_25: # %cond.store23
; AVX1-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX1-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX1-NEXT:    je .LBB16_28
; AVX1-NEXT:  .LBB16_27: # %cond.store25
; AVX1-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX1-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX1-NEXT:    je .LBB16_30
; AVX1-NEXT:  .LBB16_29: # %cond.store27
; AVX1-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX1-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX1-NEXT:    je .LBB16_32
; AVX1-NEXT:  .LBB16_31: # %cond.store29
; AVX1-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: truncstore_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpminuw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpmovmskb %xmm1, %eax
; AVX2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    jne .LBB16_1
; AVX2-NEXT:  # %bb.2: # %else
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    jne .LBB16_3
; AVX2-NEXT:  .LBB16_4: # %else2
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    jne .LBB16_5
; AVX2-NEXT:  .LBB16_6: # %else4
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    jne .LBB16_7
; AVX2-NEXT:  .LBB16_8: # %else6
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    jne .LBB16_9
; AVX2-NEXT:  .LBB16_10: # %else8
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    jne .LBB16_11
; AVX2-NEXT:  .LBB16_12: # %else10
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    jne .LBB16_13
; AVX2-NEXT:  .LBB16_14: # %else12
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    jne .LBB16_15
; AVX2-NEXT:  .LBB16_16: # %else14
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    jne .LBB16_17
; AVX2-NEXT:  .LBB16_18: # %else16
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    jne .LBB16_19
; AVX2-NEXT:  .LBB16_20: # %else18
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    jne .LBB16_21
; AVX2-NEXT:  .LBB16_22: # %else20
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    jne .LBB16_23
; AVX2-NEXT:  .LBB16_24: # %else22
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    jne .LBB16_25
; AVX2-NEXT:  .LBB16_26: # %else24
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    jne .LBB16_27
; AVX2-NEXT:  .LBB16_28: # %else26
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    jne .LBB16_29
; AVX2-NEXT:  .LBB16_30: # %else28
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    jne .LBB16_31
; AVX2-NEXT:  .LBB16_32: # %else30
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
; AVX2-NEXT:  .LBB16_1: # %cond.store
; AVX2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX2-NEXT:    testb $2, %al
; AVX2-NEXT:    je .LBB16_4
; AVX2-NEXT:  .LBB16_3: # %cond.store1
; AVX2-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX2-NEXT:    testb $4, %al
; AVX2-NEXT:    je .LBB16_6
; AVX2-NEXT:  .LBB16_5: # %cond.store3
; AVX2-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX2-NEXT:    testb $8, %al
; AVX2-NEXT:    je .LBB16_8
; AVX2-NEXT:  .LBB16_7: # %cond.store5
; AVX2-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX2-NEXT:    testb $16, %al
; AVX2-NEXT:    je .LBB16_10
; AVX2-NEXT:  .LBB16_9: # %cond.store7
; AVX2-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX2-NEXT:    testb $32, %al
; AVX2-NEXT:    je .LBB16_12
; AVX2-NEXT:  .LBB16_11: # %cond.store9
; AVX2-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX2-NEXT:    testb $64, %al
; AVX2-NEXT:    je .LBB16_14
; AVX2-NEXT:  .LBB16_13: # %cond.store11
; AVX2-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX2-NEXT:    testb $-128, %al
; AVX2-NEXT:    je .LBB16_16
; AVX2-NEXT:  .LBB16_15: # %cond.store13
; AVX2-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX2-NEXT:    testl $256, %eax # imm = 0x100
; AVX2-NEXT:    je .LBB16_18
; AVX2-NEXT:  .LBB16_17: # %cond.store15
; AVX2-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX2-NEXT:    testl $512, %eax # imm = 0x200
; AVX2-NEXT:    je .LBB16_20
; AVX2-NEXT:  .LBB16_19: # %cond.store17
; AVX2-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX2-NEXT:    testl $1024, %eax # imm = 0x400
; AVX2-NEXT:    je .LBB16_22
; AVX2-NEXT:  .LBB16_21: # %cond.store19
; AVX2-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX2-NEXT:    testl $2048, %eax # imm = 0x800
; AVX2-NEXT:    je .LBB16_24
; AVX2-NEXT:  .LBB16_23: # %cond.store21
; AVX2-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX2-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX2-NEXT:    je .LBB16_26
; AVX2-NEXT:  .LBB16_25: # %cond.store23
; AVX2-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX2-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX2-NEXT:    je .LBB16_28
; AVX2-NEXT:  .LBB16_27: # %cond.store25
; AVX2-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX2-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX2-NEXT:    je .LBB16_30
; AVX2-NEXT:  .LBB16_29: # %cond.store27
; AVX2-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX2-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX2-NEXT:    je .LBB16_32
; AVX2-NEXT:  .LBB16_31: # %cond.store29
; AVX2-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpminuw {{.*}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpmovmskb %xmm1, %eax
; AVX512F-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB16_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB16_3
; AVX512F-NEXT:  .LBB16_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB16_5
; AVX512F-NEXT:  .LBB16_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB16_7
; AVX512F-NEXT:  .LBB16_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB16_9
; AVX512F-NEXT:  .LBB16_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB16_11
; AVX512F-NEXT:  .LBB16_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB16_13
; AVX512F-NEXT:  .LBB16_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB16_15
; AVX512F-NEXT:  .LBB16_16: # %else14
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    jne .LBB16_17
; AVX512F-NEXT:  .LBB16_18: # %else16
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    jne .LBB16_19
; AVX512F-NEXT:  .LBB16_20: # %else18
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    jne .LBB16_21
; AVX512F-NEXT:  .LBB16_22: # %else20
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    jne .LBB16_23
; AVX512F-NEXT:  .LBB16_24: # %else22
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    jne .LBB16_25
; AVX512F-NEXT:  .LBB16_26: # %else24
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    jne .LBB16_27
; AVX512F-NEXT:  .LBB16_28: # %else26
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    jne .LBB16_29
; AVX512F-NEXT:  .LBB16_30: # %else28
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    jne .LBB16_31
; AVX512F-NEXT:  .LBB16_32: # %else30
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB16_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB16_4
; AVX512F-NEXT:  .LBB16_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB16_6
; AVX512F-NEXT:  .LBB16_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB16_8
; AVX512F-NEXT:  .LBB16_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB16_10
; AVX512F-NEXT:  .LBB16_9: # %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB16_12
; AVX512F-NEXT:  .LBB16_11: # %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB16_14
; AVX512F-NEXT:  .LBB16_13: # %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB16_16
; AVX512F-NEXT:  .LBB16_15: # %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX512F-NEXT:    testl $256, %eax # imm = 0x100
; AVX512F-NEXT:    je .LBB16_18
; AVX512F-NEXT:  .LBB16_17: # %cond.store15
; AVX512F-NEXT:    vpextrb $8, %xmm0, 8(%rdi)
; AVX512F-NEXT:    testl $512, %eax # imm = 0x200
; AVX512F-NEXT:    je .LBB16_20
; AVX512F-NEXT:  .LBB16_19: # %cond.store17
; AVX512F-NEXT:    vpextrb $9, %xmm0, 9(%rdi)
; AVX512F-NEXT:    testl $1024, %eax # imm = 0x400
; AVX512F-NEXT:    je .LBB16_22
; AVX512F-NEXT:  .LBB16_21: # %cond.store19
; AVX512F-NEXT:    vpextrb $10, %xmm0, 10(%rdi)
; AVX512F-NEXT:    testl $2048, %eax # imm = 0x800
; AVX512F-NEXT:    je .LBB16_24
; AVX512F-NEXT:  .LBB16_23: # %cond.store21
; AVX512F-NEXT:    vpextrb $11, %xmm0, 11(%rdi)
; AVX512F-NEXT:    testl $4096, %eax # imm = 0x1000
; AVX512F-NEXT:    je .LBB16_26
; AVX512F-NEXT:  .LBB16_25: # %cond.store23
; AVX512F-NEXT:    vpextrb $12, %xmm0, 12(%rdi)
; AVX512F-NEXT:    testl $8192, %eax # imm = 0x2000
; AVX512F-NEXT:    je .LBB16_28
; AVX512F-NEXT:  .LBB16_27: # %cond.store25
; AVX512F-NEXT:    vpextrb $13, %xmm0, 13(%rdi)
; AVX512F-NEXT:    testl $16384, %eax # imm = 0x4000
; AVX512F-NEXT:    je .LBB16_30
; AVX512F-NEXT:  .LBB16_29: # %cond.store27
; AVX512F-NEXT:    vpextrb $14, %xmm0, 14(%rdi)
; AVX512F-NEXT:    testl $32768, %eax # imm = 0x8000
; AVX512F-NEXT:    je .LBB16_32
; AVX512F-NEXT:  .LBB16_31: # %cond.store29
; AVX512F-NEXT:    vpextrb $15, %xmm0, 15(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestmb %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kmovw %k0, %k1
; AVX512BW-NEXT:    vpmovuswb %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v16i16_v16i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmb %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminuw {{.*}}(%rip), %ymm0, %ymm0
; AVX512BWVL-NEXT:    vpmovwb %ymm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    vzeroupper
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <16 x i8> %mask, zeroinitializer
  %b = icmp ult <16 x i16> %x, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %c = select <16 x i1> %b, <16 x i16> %x, <16 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %d = trunc <16 x i16> %c to <16 x i8>
  call void @llvm.masked.store.v16i8.p0v16i8(<16 x i8> %d, <16 x i8>* %p, i32 1, <16 x i1> %a)
  ret void
}

define void @truncstore_v8i16_v8i8(<8 x i16> %x, <8 x i8>* %p, <8 x i16> %mask) {
; SSE2-LABEL: truncstore_v8i16_v8i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE2-NEXT:    pxor %xmm3, %xmm0
; SSE2-NEXT:    pminsw {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm0
; SSE2-NEXT:    packuswb %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm1
; SSE2-NEXT:    packsswb %xmm1, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    jne .LBB17_1
; SSE2-NEXT:  # %bb.2: # %else
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    jne .LBB17_3
; SSE2-NEXT:  .LBB17_4: # %else2
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    jne .LBB17_5
; SSE2-NEXT:  .LBB17_6: # %else4
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    je .LBB17_8
; SSE2-NEXT:  .LBB17_7: # %cond.store5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    movb %cl, 3(%rdi)
; SSE2-NEXT:  .LBB17_8: # %else6
; SSE2-NEXT:    testb $16, %al
; SSE2-NEXT:    pextrw $2, %xmm0, %ecx
; SSE2-NEXT:    je .LBB17_10
; SSE2-NEXT:  # %bb.9: # %cond.store7
; SSE2-NEXT:    movb %cl, 4(%rdi)
; SSE2-NEXT:  .LBB17_10: # %else8
; SSE2-NEXT:    testb $32, %al
; SSE2-NEXT:    je .LBB17_12
; SSE2-NEXT:  # %bb.11: # %cond.store9
; SSE2-NEXT:    movb %ch, 5(%rdi)
; SSE2-NEXT:  .LBB17_12: # %else10
; SSE2-NEXT:    testb $64, %al
; SSE2-NEXT:    pextrw $3, %xmm0, %ecx
; SSE2-NEXT:    jne .LBB17_13
; SSE2-NEXT:  # %bb.14: # %else12
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    jne .LBB17_15
; SSE2-NEXT:  .LBB17_16: # %else14
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB17_1: # %cond.store
; SSE2-NEXT:    movb %cl, (%rdi)
; SSE2-NEXT:    testb $2, %al
; SSE2-NEXT:    je .LBB17_4
; SSE2-NEXT:  .LBB17_3: # %cond.store1
; SSE2-NEXT:    movb %ch, 1(%rdi)
; SSE2-NEXT:    testb $4, %al
; SSE2-NEXT:    je .LBB17_6
; SSE2-NEXT:  .LBB17_5: # %cond.store3
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, 2(%rdi)
; SSE2-NEXT:    testb $8, %al
; SSE2-NEXT:    jne .LBB17_7
; SSE2-NEXT:    jmp .LBB17_8
; SSE2-NEXT:  .LBB17_13: # %cond.store11
; SSE2-NEXT:    movb %cl, 6(%rdi)
; SSE2-NEXT:    testb $-128, %al
; SSE2-NEXT:    je .LBB17_16
; SSE2-NEXT:  .LBB17_15: # %cond.store13
; SSE2-NEXT:    movb %ch, 7(%rdi)
; SSE2-NEXT:    retq
;
; SSE4-LABEL: truncstore_v8i16_v8i8:
; SSE4:       # %bb.0:
; SSE4-NEXT:    pxor %xmm2, %xmm2
; SSE4-NEXT:    pminuw {{.*}}(%rip), %xmm0
; SSE4-NEXT:    packuswb %xmm0, %xmm0
; SSE4-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE4-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE4-NEXT:    pxor %xmm2, %xmm1
; SSE4-NEXT:    packsswb %xmm1, %xmm1
; SSE4-NEXT:    pmovmskb %xmm1, %eax
; SSE4-NEXT:    testb $1, %al
; SSE4-NEXT:    jne .LBB17_1
; SSE4-NEXT:  # %bb.2: # %else
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    jne .LBB17_3
; SSE4-NEXT:  .LBB17_4: # %else2
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    jne .LBB17_5
; SSE4-NEXT:  .LBB17_6: # %else4
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    jne .LBB17_7
; SSE4-NEXT:  .LBB17_8: # %else6
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    jne .LBB17_9
; SSE4-NEXT:  .LBB17_10: # %else8
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    jne .LBB17_11
; SSE4-NEXT:  .LBB17_12: # %else10
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    jne .LBB17_13
; SSE4-NEXT:  .LBB17_14: # %else12
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    jne .LBB17_15
; SSE4-NEXT:  .LBB17_16: # %else14
; SSE4-NEXT:    retq
; SSE4-NEXT:  .LBB17_1: # %cond.store
; SSE4-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE4-NEXT:    testb $2, %al
; SSE4-NEXT:    je .LBB17_4
; SSE4-NEXT:  .LBB17_3: # %cond.store1
; SSE4-NEXT:    pextrb $1, %xmm0, 1(%rdi)
; SSE4-NEXT:    testb $4, %al
; SSE4-NEXT:    je .LBB17_6
; SSE4-NEXT:  .LBB17_5: # %cond.store3
; SSE4-NEXT:    pextrb $2, %xmm0, 2(%rdi)
; SSE4-NEXT:    testb $8, %al
; SSE4-NEXT:    je .LBB17_8
; SSE4-NEXT:  .LBB17_7: # %cond.store5
; SSE4-NEXT:    pextrb $3, %xmm0, 3(%rdi)
; SSE4-NEXT:    testb $16, %al
; SSE4-NEXT:    je .LBB17_10
; SSE4-NEXT:  .LBB17_9: # %cond.store7
; SSE4-NEXT:    pextrb $4, %xmm0, 4(%rdi)
; SSE4-NEXT:    testb $32, %al
; SSE4-NEXT:    je .LBB17_12
; SSE4-NEXT:  .LBB17_11: # %cond.store9
; SSE4-NEXT:    pextrb $5, %xmm0, 5(%rdi)
; SSE4-NEXT:    testb $64, %al
; SSE4-NEXT:    je .LBB17_14
; SSE4-NEXT:  .LBB17_13: # %cond.store11
; SSE4-NEXT:    pextrb $6, %xmm0, 6(%rdi)
; SSE4-NEXT:    testb $-128, %al
; SSE4-NEXT:    je .LBB17_16
; SSE4-NEXT:  .LBB17_15: # %cond.store13
; SSE4-NEXT:    pextrb $7, %xmm0, 7(%rdi)
; SSE4-NEXT:    retq
;
; AVX-LABEL: truncstore_v8i16_v8i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpminuw {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX-NEXT:    vpxor %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpacksswb %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpmovmskb %xmm1, %eax
; AVX-NEXT:    testb $1, %al
; AVX-NEXT:    jne .LBB17_1
; AVX-NEXT:  # %bb.2: # %else
; AVX-NEXT:    testb $2, %al
; AVX-NEXT:    jne .LBB17_3
; AVX-NEXT:  .LBB17_4: # %else2
; AVX-NEXT:    testb $4, %al
; AVX-NEXT:    jne .LBB17_5
; AVX-NEXT:  .LBB17_6: # %else4
; AVX-NEXT:    testb $8, %al
; AVX-NEXT:    jne .LBB17_7
; AVX-NEXT:  .LBB17_8: # %else6
; AVX-NEXT:    testb $16, %al
; AVX-NEXT:    jne .LBB17_9
; AVX-NEXT:  .LBB17_10: # %else8
; AVX-NEXT:    testb $32, %al
; AVX-NEXT:    jne .LBB17_11
; AVX-NEXT:  .LBB17_12: # %else10
; AVX-NEXT:    testb $64, %al
; AVX-NEXT:    jne .LBB17_13
; AVX-NEXT:  .LBB17_14: # %else12
; AVX-NEXT:    testb $-128, %al
; AVX-NEXT:    jne .LBB17_15
; AVX-NEXT:  .LBB17_16: # %else14
; AVX-NEXT:    retq
; AVX-NEXT:  .LBB17_1: # %cond.store
; AVX-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX-NEXT:    testb $2, %al
; AVX-NEXT:    je .LBB17_4
; AVX-NEXT:  .LBB17_3: # %cond.store1
; AVX-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX-NEXT:    testb $4, %al
; AVX-NEXT:    je .LBB17_6
; AVX-NEXT:  .LBB17_5: # %cond.store3
; AVX-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX-NEXT:    testb $8, %al
; AVX-NEXT:    je .LBB17_8
; AVX-NEXT:  .LBB17_7: # %cond.store5
; AVX-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX-NEXT:    testb $16, %al
; AVX-NEXT:    je .LBB17_10
; AVX-NEXT:  .LBB17_9: # %cond.store7
; AVX-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX-NEXT:    testb $32, %al
; AVX-NEXT:    je .LBB17_12
; AVX-NEXT:  .LBB17_11: # %cond.store9
; AVX-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX-NEXT:    testb $64, %al
; AVX-NEXT:    je .LBB17_14
; AVX-NEXT:  .LBB17_13: # %cond.store11
; AVX-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX-NEXT:    testb $-128, %al
; AVX-NEXT:    je .LBB17_16
; AVX-NEXT:  .LBB17_15: # %cond.store13
; AVX-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX-NEXT:    retq
;
; AVX512F-LABEL: truncstore_v8i16_v8i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpternlogq $15, %zmm1, %zmm1, %zmm1
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    vpminuw {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vpackuswb %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    jne .LBB17_1
; AVX512F-NEXT:  # %bb.2: # %else
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    jne .LBB17_3
; AVX512F-NEXT:  .LBB17_4: # %else2
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    jne .LBB17_5
; AVX512F-NEXT:  .LBB17_6: # %else4
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    jne .LBB17_7
; AVX512F-NEXT:  .LBB17_8: # %else6
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    jne .LBB17_9
; AVX512F-NEXT:  .LBB17_10: # %else8
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    jne .LBB17_11
; AVX512F-NEXT:  .LBB17_12: # %else10
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    jne .LBB17_13
; AVX512F-NEXT:  .LBB17_14: # %else12
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    jne .LBB17_15
; AVX512F-NEXT:  .LBB17_16: # %else14
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
; AVX512F-NEXT:  .LBB17_1: # %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    testb $2, %al
; AVX512F-NEXT:    je .LBB17_4
; AVX512F-NEXT:  .LBB17_3: # %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, 1(%rdi)
; AVX512F-NEXT:    testb $4, %al
; AVX512F-NEXT:    je .LBB17_6
; AVX512F-NEXT:  .LBB17_5: # %cond.store3
; AVX512F-NEXT:    vpextrb $2, %xmm0, 2(%rdi)
; AVX512F-NEXT:    testb $8, %al
; AVX512F-NEXT:    je .LBB17_8
; AVX512F-NEXT:  .LBB17_7: # %cond.store5
; AVX512F-NEXT:    vpextrb $3, %xmm0, 3(%rdi)
; AVX512F-NEXT:    testb $16, %al
; AVX512F-NEXT:    je .LBB17_10
; AVX512F-NEXT:  .LBB17_9: # %cond.store7
; AVX512F-NEXT:    vpextrb $4, %xmm0, 4(%rdi)
; AVX512F-NEXT:    testb $32, %al
; AVX512F-NEXT:    je .LBB17_12
; AVX512F-NEXT:  .LBB17_11: # %cond.store9
; AVX512F-NEXT:    vpextrb $5, %xmm0, 5(%rdi)
; AVX512F-NEXT:    testb $64, %al
; AVX512F-NEXT:    je .LBB17_14
; AVX512F-NEXT:  .LBB17_13: # %cond.store11
; AVX512F-NEXT:    vpextrb $6, %xmm0, 6(%rdi)
; AVX512F-NEXT:    testb $-128, %al
; AVX512F-NEXT:    je .LBB17_16
; AVX512F-NEXT:  .LBB17_15: # %cond.store13
; AVX512F-NEXT:    vpextrb $7, %xmm0, 7(%rdi)
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: truncstore_v8i16_v8i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestmw %zmm1, %zmm1, %k0
; AVX512BW-NEXT:    kshiftlq $56, %k0, %k0
; AVX512BW-NEXT:    kshiftrq $56, %k0, %k1
; AVX512BW-NEXT:    vpmovuswb %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqu8 %zmm0, (%rdi) {%k1}
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BWVL-LABEL: truncstore_v8i16_v8i8:
; AVX512BWVL:       # %bb.0:
; AVX512BWVL-NEXT:    vptestmw %xmm1, %xmm1, %k1
; AVX512BWVL-NEXT:    vpminuw {{.*}}(%rip), %xmm0, %xmm0
; AVX512BWVL-NEXT:    vpmovwb %xmm0, (%rdi) {%k1}
; AVX512BWVL-NEXT:    retq
  %a = icmp ne <8 x i16> %mask, zeroinitializer
  %b = icmp ult <8 x i16> %x, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %c = select <8 x i1> %b, <8 x i16> %x, <8 x i16> <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  %d = trunc <8 x i16> %c to <8 x i8>
  call void @llvm.masked.store.v8i8.p0v8i8(<8 x i8> %d, <8 x i8>* %p, i32 1, <8 x i1> %a)
  ret void
}

declare void @llvm.masked.store.v8i32.p0v8i32(<8 x i32>, <8 x i32>*, i32, <8 x i1>)
declare void @llvm.masked.store.v8i16.p0v8i16(<8 x i16>, <8 x i16>*, i32, <8 x i1>)
declare void @llvm.masked.store.v8i8.p0v8i8(<8 x i8>, <8 x i8>*, i32, <8 x i1>)
declare void @llvm.masked.store.v4i32.p0v4i32(<4 x i32>, <4 x i32>*, i32, <4 x i1>)
declare void @llvm.masked.store.v4i16.p0v4i16(<4 x i16>, <4 x i16>*, i32, <4 x i1>)
declare void @llvm.masked.store.v4i8.p0v4i8(<4 x i8>, <4 x i8>*, i32, <4 x i1>)
declare void @llvm.masked.store.v2i32.p0v2i32(<2 x i32>, <2 x i32>*, i32, <2 x i1>)
declare void @llvm.masked.store.v2i16.p0v2i16(<2 x i16>, <2 x i16>*, i32, <2 x i1>)
declare void @llvm.masked.store.v2i8.p0v2i8(<2 x i8>, <2 x i8>*, i32, <2 x i1>)
declare void @llvm.masked.store.v16i16.p0v16i16(<16 x i16>, <16 x i16>*, i32, <16 x i1>)
declare void @llvm.masked.store.v16i8.p0v16i8(<16 x i8>, <16 x i8>*, i32, <16 x i1>)
declare void @llvm.masked.store.v32i8.p0v32i8(<32 x i8>, <32 x i8>*, i32, <32 x i1>)
