; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main -mattr=+mve.fp -verify-machineinstrs -o - %s | FileCheck %s

declare <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32)
declare <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32)

declare { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32, i32, i32, i32, i32, <8 x i16>, <8 x i16>)
declare { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32, i32, i32, i32, i32, <4 x i32>, <4 x i32>)
declare { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32, i32, i32, i32, i32, <4 x i32>, <4 x i32>)

declare { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32, i32, i32, i32, i32, <8 x i16>, <8 x i16>, <8 x i1>)
declare { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32, i32, i32, i32, i32, <4 x i32>, <4 x i32>, <4 x i1>)
declare { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32, i32, i32, i32, i32, <4 x i32>, <4 x i32>, <4 x i1>)

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_s16(i64 %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmlaldavaq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalva.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 0, i32 0, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmlaldavaq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalva.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_u16(i64 %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmlaldavaq_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalva.u16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 1, i32 0, i32 0, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_u32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmlaldavaq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalva.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 1, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaxq_s16(i64 %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmlaldavaxq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlaldavax.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 0, i32 1, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaxq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmlaldavaxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlaldavax.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 0, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlsldavaq_s16(i64 %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmlsldavaq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldava.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 1, i32 0, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlsldavaq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmlsldavaq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldava.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 1, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlsldaxvaq_s16(i64 %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmlsldaxvaq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldavax.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 1, i32 1, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlsldavaxq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmlsldavaxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldavax.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 1, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhaq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vrmlaldavhaq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlalvha.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhaq_u32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vrmlaldavhaq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlalvha.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 1, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhaxq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vrmlaldavhaxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlaldavhax.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 0, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhaq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vrmlsldavhaq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlsldavha.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 1, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhaxq_s32(i64 %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vrmlsldavhaxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlsldavhax.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 1, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c)
  %4 = extractvalue { i32, i32 } %3, 1
  %5 = zext i32 %4 to i64
  %6 = shl i64 %5, 32
  %7 = extractvalue { i32, i32 } %3, 0
  %8 = zext i32 %7 to i64
  %9 = or i64 %6, %8
  ret i64 %9
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_p_s16(i64 %a, <8 x i16> %b, <8 x i16> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavaq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvat.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 0, i32 0, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c, <8 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavaq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvat.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_p_u16(i64 %a, <8 x i16> %b, <8 x i16> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavaq_p_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvat.u16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 1, i32 0, i32 0, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c, <8 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaq_p_u32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavaq_p_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvat.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 1, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaxq_p_s16(i64 %a, <8 x i16> %b, <8 x i16> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavaxq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlaldavaxt.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 0, i32 1, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c, <8 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlaldavaxq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavaxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlaldavaxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 0, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlsldavaq_p_s16(i64 %a, <8 x i16> %b, <8 x i16> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldavaq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavat.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 1, i32 0, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c, <8 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlsldavaq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldavaq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavat.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 1, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlsldaxvaq_p_s16(i64 %a, <8 x i16> %b, <8 x i16> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldaxvaq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavaxt.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 1, i32 1, i32 %2, i32 %1, <8 x i16> %b, <8 x i16> %c, <8 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlsldavaxq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldavaxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavaxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 1, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhaq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlaldavhaq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlalvhat.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhaq_p_u32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlaldavhaq_p_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlalvhat.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 1, i32 0, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhaxq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlaldavhaxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlaldavhaxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 0, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhaq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlsldavhaq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlsldavhat.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 1, i32 0, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhaxq_p_s32(i64 %a, <4 x i32> %b, <4 x i32> %c, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlsldavhaxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r2
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlsldavhaxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = lshr i64 %a, 32
  %1 = trunc i64 %0 to i32
  %2 = trunc i64 %a to i32
  %3 = zext i16 %p to i32
  %4 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %3)
  %5 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 1, i32 1, i32 %2, i32 %1, <4 x i32> %b, <4 x i32> %c, <4 x i1> %4)
  %6 = extractvalue { i32, i32 } %5, 1
  %7 = zext i32 %6 to i64
  %8 = shl i64 %7, 32
  %9 = extractvalue { i32, i32 } %5, 0
  %10 = zext i32 %9 to i64
  %11 = or i64 %8, %10
  ret i64 %11
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmlaldavq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalv.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 0, i32 0, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlaldavq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalv.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_u16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmlaldavq_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalv.u16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 1, i32 0, i32 0, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_u32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlaldavq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlalv.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 1, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlaldavxq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmlaldavxq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlaldavx.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 0, i32 1, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlaldavxq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlaldavxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlaldavx.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 0, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlsldavq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmlsldavq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldav.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 1, i32 0, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlsldavq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlsldavq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldav.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 1, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlsldavxvq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmlsldavxvq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldavx.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v8i16(i32 0, i32 1, i32 1, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlsldavxq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlsldavxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsldavx.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vmlldava.v4i32(i32 0, i32 1, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrmlaldavhq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlalvh.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhq_u32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrmlaldavhq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlalvh.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 1, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhxq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrmlaldavhxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlaldavhx.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 0, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrmlsldavhq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlsldavh.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 1, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhxq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrmlsldavhxq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrmlsldavhx.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.v4i32(i32 0, i32 1, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b)
  %1 = extractvalue { i32, i32 } %0, 1
  %2 = zext i32 %1 to i64
  %3 = shl i64 %2, 32
  %4 = extractvalue { i32, i32 } %0, 0
  %5 = zext i32 %4 to i64
  %6 = or i64 %3, %5
  ret i64 %6
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_p_s16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvt.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 0, i32 0, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b, <8 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_p_u16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavq_p_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvt.u16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 1, i32 0, i32 0, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b, <8 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlaldavq_p_u32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavq_p_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlalvt.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 1, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlaldavxq_p_s16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavxq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlaldavxt.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 0, i32 1, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b, <8 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlaldavxq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlaldavxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlaldavxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 0, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlsldavq_p_s16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldavq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavt.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 1, i32 0, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b, <8 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlsldavq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldavq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 1, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlsldaxvq_p_s16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldaxvq_p_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavxt.s16 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v8i16.v8i1(i32 0, i32 1, i32 1, i32 0, i32 0, <8 x i16> %a, <8 x i16> %b, <8 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vmlsldavxq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vmlsldavxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vmlsldavxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vmlldava.predicated.v4i32.v4i1(i32 0, i32 1, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlaldavhq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlalvht.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhq_p_u32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlaldavhq_p_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlalvht.u32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 1, i32 0, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vrmlaldavhxq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlaldavhxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlaldavhxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 0, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlsldavhq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlsldavht.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 1, i32 0, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}

define arm_aapcs_vfpcc i64 @test_vrmlsldavhxq_p_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrmlsldavhxq_p_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrmlsldavhxt.s32 r0, r1, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call { i32, i32 } @llvm.arm.mve.vrmlldavha.predicated.v4i32.v4i1(i32 0, i32 1, i32 1, i32 0, i32 0, <4 x i32> %a, <4 x i32> %b, <4 x i1> %1)
  %3 = extractvalue { i32, i32 } %2, 1
  %4 = zext i32 %3 to i64
  %5 = shl i64 %4, 32
  %6 = extractvalue { i32, i32 } %2, 0
  %7 = zext i32 %6 to i64
  %8 = or i64 %5, %7
  ret i64 %8
}
