/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.refactor;

import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.lisaac.ldt.refactor.RenamePrototypeRefactor;

class RenamePrototypeInputPage
extends UserInputWizardPage {
    Text fNameField;
    String prototypeToRename;

    public RenamePrototypeInputPage(String prototypeToRename) {
        super("RenamePrototypeInputPage");
        this.prototypeToRename = prototypeToRename;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("&New name:");
        this.fNameField = this.createNameField(result);
        Button referenceButton = new Button(result, 32);
        referenceButton.setText("&Update references");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 2;
        referenceButton.setLayoutData((Object)data);
        this.fNameField.setText(this.prototypeToRename);
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RenamePrototypeInputPage.this.handleInputChanged();
            }
        });
        referenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RenamePrototypeRefactor refactoring = (RenamePrototypeRefactor)RenamePrototypeInputPage.this.getRefactoring();
                refactoring.setUpdateReferences(referenceButton.getSelection());
            }
        });
        referenceButton.setSelection(true);
        this.fNameField.setFocus();
        this.fNameField.selectAll();
        this.handleInputChanged();
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    void handleInputChanged() {
        RefactoringStatus status = new RefactoringStatus();
        RenamePrototypeRefactor refactoring = (RenamePrototypeRefactor)this.getRefactoring();
        status.merge(refactoring.setNewPrototypeName(this.fNameField.getText()));
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }
}

