/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.lisaac.ldt.editors.AbstractLisaacEditor;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.refactor.ChangeHeaderRefactor;
import org.lisaac.ldt.refactor.ChangeHeaderWizard;

public class ChangeHeader
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow = null;
    private LisaacModel model;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (this.fWindow != null && this.model != null) {
            ChangeHeaderRefactor refactoring = new ChangeHeaderRefactor(this.model);
            String name = "Change Project Headers";
            this.run(new ChangeHeaderWizard(refactoring, name), this.fWindow.getShell(), name);
        }
    }

    public void run(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IResource res;
        this.model = null;
        if (selection instanceof ITextSelection) {
            IWorkbenchPart part;
            if (this.fWindow != null && (part = this.fWindow.getPartService().getActivePart()) instanceof AbstractLisaacEditor) {
                IProject project = ((AbstractLisaacEditor)part).getProject();
                this.model = LisaacModel.getModel(project);
            }
        } else if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IResource && (res = (IResource)((IStructuredSelection)selection).getFirstElement()).getProject() != null) {
            this.model = LisaacModel.getModel(res.getProject());
        }
        action.setEnabled(this.model != null);
    }
}

