/* $RCSfile$
 * $Author$
 * $Date$
 * $Revision$
 *
 * Copyright (C) 2011  The Jmol Development Team
 *
 * Contact: jmol-developers@lists.sf.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *  02110-1301, USA.
 */

package org.jmol.constant;

public enum EnumStereoMode {
  NONE("OFF", false),
  DOUBLE("", false),
  REDCYAN("REDCYAN", true),
  REDBLUE("REDBLUE", true),
  REDGREEN("REDGREEN", true),
  CUSTOM("", true)
  ;

  private String name;
  private boolean isBiColor;
  
  private EnumStereoMode(String name, boolean isBiColor) {
    this.name = name;
    this.isBiColor = isBiColor;
  }

  public String getName() {
    return name;
  }
  
  public boolean isBiColor() {
    return isBiColor;
  }
  public final static int DEFAULT_STEREO_DEGREES = -5;


  public static EnumStereoMode getStereoMode(String id) {
    for (EnumStereoMode item : values())
      if (item.name.equalsIgnoreCase(id))
        return item;
    return null;
  }
}
