/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.doccheck;

import com.sun.tools.doclets.doccheck.DocCheckConstants;
import com.sun.tools.doclets.doccheck.Form;
import com.sun.tools.doclets.util.HtmlTagWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class ErrorTracker
implements DocCheckConstants {
    String name;
    String typeName;
    Form[] form = new Form[5];
    int[] itemErrs = new int[5];
    int[] subErrs = new int[5];
    int[] errorCount = new int[5];
    boolean[][] error = new boolean[5][30];
    String[] htmlError = new String[5];
    List sub = new LinkedList();
    int subCount = 0;
    ErrorTracker owner;
    static int noCmtErr = 0;

    void incrNoCmtErr() {
        ++noCmtErr;
    }

    ErrorTracker(String aName, String aTypeName) {
        this.name = aName;
        this.typeName = aTypeName;
    }

    void addSub(ErrorTracker et) {
        this.sub.add(et);
        int i = 0;
        while (i < 5) {
            int n = i;
            this.errorCount[n] = this.errorCount[n] + et.errorCount[i];
            int n2 = i;
            this.subErrs[n2] = this.subErrs[n2] + et.itemErrs[i];
            ++i;
        }
    }

    boolean hasError() {
        int i = 0;
        while (i < 5) {
            if (this.errorCount[i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean hasError(int level) {
        return this.errorCount[level] != 0;
    }

    boolean hasForm(int level) {
        return this.form[level] != null;
    }

    int missingCommentErrors() {
        int missing = this.errorCount[0] + this.errorCount[1];
        return missing;
    }

    protected int minorErrors() {
        int minor = this.errorCount[2] + this.errorCount[3] + this.errorCount[4];
        return minor;
    }

    protected int minorItemErrors() {
        int minor = this.itemErrs[2] + this.itemErrs[3] + this.itemErrs[4];
        return minor;
    }

    protected int itemsWithMinorErrors() {
        int itemCount = 0;
        ListIterator pkgs = this.subIterator();
        while (pkgs.hasNext()) {
            ErrorTracker pkg = (ErrorTracker)pkgs.next();
            itemCount += pkg.itemsWithMinorErrors();
        }
        return itemCount;
    }

    boolean hasMessage(int level) {
        int i = 0;
        while (i < 30) {
            if (this.error[level][i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    ListIterator subIterator() {
        return this.sub.listIterator();
    }

    void formStart(int level) {
        if (this.form[level] == null) {
            this.form[level] = new Form();
        }
        this.form[level].start();
    }

    void formEnd(int level) {
        if (this.form[level] == null) {
            this.form[level] = new Form();
        }
        this.form[level].end();
    }

    void formLine(int level, String s) {
        if (this.form[level] == null) {
            this.form[level] = new Form();
        }
        this.form[level].addLine(s);
    }

    void formBadLine(int level, String s) {
        this.formLine(level, Form.badText(s));
    }

    void formTag(int level, String tag, int tagType) {
        if (this.form[level] == null) {
            this.form[level] = new Form();
        }
        this.form[level].addTag(tag, tagType);
    }

    void formBadTag(int level, String tag, int tagType) {
        if (this.form[level] == null) {
            this.form[level] = new Form();
        }
        tag = Form.badText(tag);
        this.form[level].addTag(tag, tagType);
    }

    void formPrint(int level, HtmlTagWriter h) {
        boolean trace = false;
        if (trace) {
            System.out.println(this.name + ": Printing form");
        }
        if (this.form[level] == null) {
            if (trace) {
                System.out.println("--form dne");
            }
            return;
        }
        this.form[level].print(h);
    }

    void addErr(int level, int errID) {
        if (errID == 8 && this.error[level][errID]) {
            return;
        }
        this.error[level][errID] = true;
        if (errID == 4) {
            return;
        }
        if (errID == 5) {
            return;
        }
        if (errID == 11) {
            return;
        }
        if (errID == 12) {
            return;
        }
        if (errID == 13) {
            return;
        }
        if (errID == 3) {
            return;
        }
        if (this.error[level][0] && errID == 14) {
            return;
        }
        int n = level;
        this.errorCount[n] = this.errorCount[n] + 1;
        int n2 = level;
        this.itemErrs[n2] = this.itemErrs[n2] + 1;
    }

    void addHtmlErrLine(int level, String s) {
        if (this.htmlError[level] == null) {
            this.htmlError[level] = s;
        } else {
            int n = level;
            this.htmlError[n] = this.htmlError[n] + "<br>" + s;
        }
    }

    void printLinkedRow(String filelink, HtmlTagWriter h) {
        h.tr();
        h.td();
        h.println("<a href=\"" + filelink + "\">" + this.name + "</a>");
        h.tdEnd();
        int i = 0;
        while (i < 5) {
            this.printCount(this.errorCount[i], filelink + "#err" + i, h);
            ++i;
        }
        h.trEnd();
    }

    public static long percent0(int num, int denom) {
        if (denom == 0) {
            return -1L;
        }
        double t = num;
        return Math.round((t /= (double)denom) * 100.0);
    }

    public static String percentString0(int num, int denom) {
        if (denom == 0) {
            return "-1";
        }
        if (num == 0) {
            return "--";
        }
        double t = num;
        long n = Math.round((t /= (double)denom) * 100.0);
        if (n == 0L) {
            return "<1%";
        }
        return n + "%";
    }

    public static double percent1(int num, int denom) {
        if (denom == 0) {
            return -1.0;
        }
        double t1 = num;
        long t2 = Math.round((t1 /= (double)denom) * 1000.0);
        t1 = t2;
        return t1 /= 10.0;
    }

    void printCount(int n, String link, HtmlTagWriter h) {
        if (n == 0) {
            h.dat(0);
        } else {
            h.tdAlign("Right");
            h.link(link, "" + n);
            h.tdEnd();
        }
    }

    void printErrorMessages(int level, HtmlTagWriter h) {
    }

    void printTagErrors(int level, HtmlTagWriter h) {
        if (this.error[level][14]) {
            h.li();
            h.println("Missing tag.");
            this.error[level][14] = false;
        }
        if (this.error[level][16]) {
            h.li();
            h.println("Tag missing text.");
            this.error[level][16] = false;
        }
        if (this.error[level][15]) {
            h.li();
            h.println("Invalid tag.");
            this.error[level][15] = false;
        }
        if (this.error[level][17]) {
            h.li();
            h.println("Extraneous tag.");
            this.error[level][17] = false;
        }
        if (this.error[level][18]) {
            h.li();
            h.println("Multiple @version tags.");
            this.error[level][18] = false;
        }
        if (this.error[level][19]) {
            h.li();
            h.println("Missing @return tag.");
            this.error[level][19] = false;
        }
        if (this.error[level][20]) {
            h.li();
            h.println("Invalid @return tag.");
            this.error[level][20] = false;
        }
        if (this.error[level][21]) {
            h.li();
            h.println("Missing text in @return tag.");
            this.error[level][21] = false;
        }
        if (this.error[level][22]) {
            h.li();
            h.println("Extraneous @return tag.");
            this.error[level][22] = false;
        }
        if (this.error[level][23]) {
            h.li();
            h.println("Missing @throws tag.");
            this.error[level][23] = false;
        }
        if (this.error[level][24]) {
            h.li();
            h.println("Invalid @throws/@exception tag.");
            this.error[level][24] = false;
        }
        if (this.error[level][25]) {
            h.li();
            h.println("Missing text in @throws/@exception tag.");
            this.error[level][25] = false;
        }
        if (this.error[level][26]) {
            h.li();
            h.println("Extraneous @throws/@exception tag.");
            this.error[level][26] = false;
        }
        if (this.error[level][28]) {
            h.li();
            h.println("Invalid @see tag.");
            this.error[level][28] = false;
        }
        if (this.error[level][27]) {
            h.li();
            h.println("Missing @see tag.");
            this.error[level][27] = false;
        }
        if (this.error[level][29]) {
            h.li();
            h.println("Missing text in @see tag.");
            this.error[level][29] = false;
        }
    }

    void printHtmlErrors(int level, HtmlTagWriter h) {
        if (this.error[level][4]) {
            h.li();
            h.println("Html Error in First Sentence");
            this.error[level][4] = false;
            this.error[level][8] = false;
        }
        if (this.error[level][5]) {
            h.li();
            h.println("Html Error in Body of Comment");
            this.error[level][5] = false;
            this.error[level][8] = false;
        }
        if (this.error[level][6]) {
            h.br();
            h.println("--Missing a period");
            this.error[level][6] = false;
        }
        if (this.error[level][7]) {
            h.br();
            h.println("--First sentence contains a list");
            this.error[level][7] = false;
        }
        if (this.error[level][8]) {
            h.br();
            h.println("--HTML error");
            this.error[level][8] = false;
        }
        if (this.htmlError[level] != null && this.htmlError[level] != "") {
            h.br();
            h.print(this.htmlError[level]);
        }
    }

    void printMajorErrsRow(HtmlTagWriter h) {
        h.tr();
        this.printColFilename(h);
        this.printCol2(this.missingCommentErrors(), h);
        h.trEnd();
    }

    void printMinorErrsRow(HtmlTagWriter h) {
        h.tr();
        this.printColFilename(h);
        this.printCol2(this.itemsWithMinorErrors(), h);
        h.trEnd();
    }

    void printMajorErrsCols(HtmlTagWriter h) {
        this.printCol2(this.missingCommentErrors(), h);
    }

    void printMinorErrsCols(HtmlTagWriter h) {
        this.printCol2(this.itemsWithMinorErrors(), h);
    }

    protected String filepath() {
        return "";
    }

    protected int itemCount() {
        int itemCount = 0;
        ListIterator pkgs = this.subIterator();
        while (pkgs.hasNext()) {
            ErrorTracker pkg = (ErrorTracker)pkgs.next();
            itemCount += pkg.itemCount();
        }
        return itemCount;
    }

    void printCol2(int n, HtmlTagWriter h) {
        int itemCount = this.itemCount();
        h.dat(n);
        h.dat(ErrorTracker.percentString0(n, itemCount));
    }

    void printColFilename(HtmlTagWriter h) {
        String filepath = this.filepath();
        if (filepath.equals("")) {
            h.td();
            h.print(this.name);
            h.tdEnd();
        } else {
            h.td();
            h.link(filepath, this.name);
            h.tdEnd();
        }
    }
}

