/*
 * Copyright © <2010>, Intel Corporation.
 *
 * This program is licensed under the terms and conditions of the
 * Eclipse Public License (EPL), version 1.0.  The full text of the EPL is at
 * http://www.opensource.org/licenses/eclipse-1.0.php.
 *
 */
//////////////////////////////////////////////////////////////////////////////////////////
//	Module name: TransposeNV12_16x16.asm
//	
//	Transpose a 16x16 NV12 MB.  The output is also in NV12
//
//----------------------------------------------------------------------------------------
//  Symbols need to be defined before including this module
//
//	Source region is :ub
//	SRC_YB:			SRC_YB Base=rxx ElementSize=1 SrcRegion=REGION(16,1) Type=ub	// 8 GRFs
//	SRC_UW:			SRC_UW Base=rxx ElementSize=2 SrcRegion=REGION(8,1) Type=uw	// 4 GRFs
//
//  Temp buffer:
//	BUF_B:			BUF_B Base=rxx ElementSize=1 SrcRegion=REGION(16,1) Type=ub		// 8 GRFs
//	BUF_W:			BUF_W Base=rxx ElementSize=2 SrcRegion=REGION(8,1) Type=uw		// 4 GRFs
//
//////////////////////////////////////////////////////////////////////////////////////////

#if defined(_DEBUG) 
	mov		(1)		EntrySignatureC:w			0xDDDA:w
#endif


// Transpose Y (16x16 bytes)

// The first step
mov (16)	BUF_B(0,0)<1>		SRC_YB(0,0)<16;4,1>
mov (16)	BUF_B(0,16)<1>		SRC_YB(2,0)<16;4,1>
mov (16)	BUF_B(1,0)<1>		SRC_YB(4,0)<16;4,1>
mov (16)	BUF_B(1,16)<1>		SRC_YB(6,0)<16;4,1>

mov (16)	BUF_B(2,0)<1>		SRC_YB(0,4)<16;4,1>
mov (16)	BUF_B(2,16)<1>		SRC_YB(2,4)<16;4,1>
mov (16)	BUF_B(3,0)<1>		SRC_YB(4,4)<16;4,1>
mov (16)	BUF_B(3,16)<1>		SRC_YB(6,4)<16;4,1>

mov (16)	BUF_B(4,0)<1>		SRC_YB(0,8)<16;4,1>
mov (16)	BUF_B(4,16)<1>		SRC_YB(2,8)<16;4,1>
mov (16)	BUF_B(5,0)<1>		SRC_YB(4,8)<16;4,1>
mov (16)	BUF_B(5,16)<1>		SRC_YB(6,8)<16;4,1>

mov (16)	BUF_B(6,0)<1>		SRC_YB(0,12)<16;4,1>
mov (16)	BUF_B(6,16)<1>		SRC_YB(2,12)<16;4,1>
mov (16)	BUF_B(7,0)<1>		SRC_YB(4,12)<16;4,1>
mov (16)	BUF_B(7,16)<1>		SRC_YB(6,12)<16;4,1>

// The second step
mov (16)	SRC_YB(0,0)<1>		BUF_B(0,0)<32;8,4>
mov (16)	SRC_YB(0,16)<1>		BUF_B(0,1)<32;8,4>
mov (16)	SRC_YB(1,0)<1>		BUF_B(0,2)<32;8,4>
mov (16)	SRC_YB(1,16)<1>		BUF_B(0,3)<32;8,4>

mov (16)	SRC_YB(2,0)<1>		BUF_B(2,0)<32;8,4>
mov (16)	SRC_YB(2,16)<1>		BUF_B(2,1)<32;8,4>
mov (16)	SRC_YB(3,0)<1>		BUF_B(2,2)<32;8,4>
mov (16)	SRC_YB(3,16)<1>		BUF_B(2,3)<32;8,4>

mov (16)	SRC_YB(4,0)<1>		BUF_B(4,0)<32;8,4>
mov (16)	SRC_YB(4,16)<1>		BUF_B(4,1)<32;8,4>
mov (16)	SRC_YB(5,0)<1>		BUF_B(4,2)<32;8,4>
mov (16)	SRC_YB(5,16)<1>		BUF_B(4,3)<32;8,4>

mov (16)	SRC_YB(6,0)<1>		BUF_B(6,0)<32;8,4>
mov (16)	SRC_YB(6,16)<1>		BUF_B(6,1)<32;8,4>
mov (16)	SRC_YB(7,0)<1>		BUF_B(6,2)<32;8,4>
mov (16)	SRC_YB(7,16)<1>		BUF_B(6,3)<32;8,4>

// Y is transposed.


//////////////////////////////////////////////////////////////////////////////////////////////////////////

// Src U and V are mixed in NV12 format. U on even bytes, V on odd bytes.
// Transpose by treating UV pair as a word.


// Src U 8x8 and V 8x8 are mixed. (each pix is specified as yx)
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|17 17 16 16 15 15 14 14 13 13 12 12 11 11 10 10 07 07 06 06 05 05 04 04 03 03 02 02 01 01 00 00|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|37 37 36 36 35 35 34 34 33 33 32 32 31 31 30 30 27 27 26 26 25 25 24 24 23 23 22 22 21 21 20 20|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|57 57 56 56 55 55 54 54 53 53 52 52 51 51 50 50 47 47 46 46 45 45 44 44 43 43 42 42 41 41 40 40|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|77 77 76 76 75 75 74 74 73 73 72 72 71 71 70 70 67 67 66 66 65 65 64 64 63 63 62 62 61 61 60 60|
//	+-----------------------+-----------------------+-----------------------+-----------------------+

//  First step 		(16)	<1>:w <==== <8;4,1>:w
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|33 33 32 32 31 31 30 30 23 23 22 22 21 21 20 20 13 13 12 12 11 11 10 10 03 03 02 02 01 01 00 00|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|73 73 72 72 71 71 70 70 63 63 62 62 61 61 60 60 53 53 52 52 51 51 50 50 43 43 42 42 41 41 40 40|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|37 37 36 36 35 35 34 34 27 27 26 26 25 25 24 24 17 17 16 16 15 15 14 14 07 07 06 06 05 05 04 04|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|77 77 76 76 75 75 74 74 67 67 66 66 65 65 64 64 57 57 56 56 55 55 54 54 47 47 46 46 45 45 44 44|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//
// Transpose UV (8x8 words), The first step
mov (16)	BUF_W(0,0)<1>		SRC_UW(0,0)<8;4,1>
mov (16)	BUF_W(1,0)<1>		SRC_UW(2,0)<8;4,1>
mov (16)	BUF_W(2,0)<1>		SRC_UW(0,4)<8;4,1>
mov (16)	BUF_W(3,0)<1>		SRC_UW(2,4)<8;4,1>


//	Second step		(16)	<1>:w <=== <16;4,4>:w
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|71 71 61 61 51 51 41 41 31 31 21 21 11 11 01 01 70 70 60 60 50 50 40 40 30 30 20 20 10 10 00 00|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|73 73 63 63 53 53 43 43 33 33 23 23 13 13 03 03 72 72 62 62 52 52 42 42 32 32 22 22 12 12 02 02|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|75 75 65 65 55 55 45 45 35 35 25 25 15 15 05 05 74 74 64 64 54 54 44 44 34 34 24 24 14 14 04 04|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//	|77 77 67 67 57 57 47 47 37 37 27 27 17 17 07 07 76 76 66 66 56 56 46 46 36 36 26 26 16 16 06 06|
//	+-----------------------+-----------------------+-----------------------+-----------------------+
//
// Transpose UV (8x8 words), The second step
mov (8)		SRC_UW(0,0)<1>		BUF_W(0,0)<16;4,4>
mov (8)		SRC_UW(0,8)<1>		BUF_W(0,1)<16;4,4>
mov (8)		SRC_UW(1,0)<1>		BUF_W(0,2)<16;4,4>
mov (8)		SRC_UW(1,8)<1>		BUF_W(0,3)<16;4,4>
mov (8)		SRC_UW(2,0)<1>		BUF_W(2,0)<16;4,4>
mov (8)		SRC_UW(2,8)<1>		BUF_W(2,1)<16;4,4>
mov (8)		SRC_UW(3,0)<1>		BUF_W(2,2)<16;4,4>
mov (8)		SRC_UW(3,8)<1>		BUF_W(2,3)<16;4,4>

// U and V are now transposed and separated.
