#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

from irgenerator.util.sysinfo import SystemInfo
from irgenerator.core.plugcentral import IPlugin, AbstractPlugin

#if not _: # only for test purposes
#    _ = lambda x: x

__version__ = (1,0)

class HelloPlugin(IPlugin, AbstractPlugin):
    description = _("""This is an example plugin, don't use it for support purposes!""")
    enabled = False
    def __init__(self, active_obj=None, hwconfig=None):
        IPlugin.__init__(self)
        AbstractPlugin.__init__(self, active_obj, hwconfig)
        self.report = '\n'.join([
                    "Vendor: %(vendor)s",
                    "Model: %(model)s",
                    "CPU: %(cpu)s",
                    "RAM: %(memory)s",
                    "VGA: %(vga)s",
                    "Release: %(release)s",
                    "Website: %(website)s"])
    def get_report(self):
        return self.report
    def run(self):
        self.obj.activity_check = 1
        self.report = self.report % {'vendor':self.hwconfig.vendor, 'model':self.hwconfig.model,
                                 'memory':self.hwconfig.memory, 'cpu':self.hwconfig.cpu,
                                 'release':self.hwconfig.release,'vga':self.hwconfig.vga,
                                 'website':self.hwconfig.website}
        self.obj.activity_check = -1
        self.obj.report_is_ready()
