/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementByTagNameVisitor implements INodeVisitor {

    private final String tagName;
    private NodeListImpl elementList;
    
    public NodeListImpl getElementList() {
        return elementList;
    }
    
    public ElementByTagNameVisitor(String tagName) {
    
        this.tagName = tagName;
        elementList = new NodeListImpl();
    }
    

    public void accept(Node node) {

        if (node == null || node instanceof Element == false) {
            return;
        }

        Element element = (Element) node;
        String otherTagName = element.getTagName();
    
        if (tagName != null && otherTagName != null) {
            if (tagName.equals(otherTagName)) {
                elementList.add((NodeImpl) element);
            }
        }
    }

	@Override
	public void openTag(Node node) {
		// 
	}

	@Override
	public void closeTag(Node node) {
		// 
	} 

}
