/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgNum;
import com.garmin.fit.SubField;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Mesg {
    protected String name;
    protected int num;
    protected int localNum;
    protected ArrayList<Field> fields;
    protected long systemTimeOffset;

    public Mesg(Mesg mesg) {
        this.fields = new ArrayList();
        if (mesg == null) {
            this.name = "unknown";
            this.num = MesgNum.INVALID;
            this.systemTimeOffset = 0L;
            return;
        }
        this.name = mesg.name;
        this.num = mesg.num;
        this.localNum = mesg.localNum;
        this.systemTimeOffset = mesg.systemTimeOffset;
        for (Field field : mesg.fields) {
            if (field.getNumValues() <= 0) continue;
            this.fields.add(new Field(field));
        }
    }

    protected Mesg(String string, int n) {
        this.name = new String(string);
        this.num = n;
        this.localNum = 0;
        this.fields = new ArrayList();
        this.systemTimeOffset = 0L;
    }

    public void write(OutputStream outputStream) {
        this.write(outputStream, null);
    }

    public void write(OutputStream outputStream, MesgDefinition mesgDefinition) {
        try {
            new DataOutputStream(outputStream).writeByte(this.localNum & 0xF);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (mesgDefinition == null) {
            mesgDefinition = new MesgDefinition(this);
        }
        for (FieldDefinition fieldDefinition : mesgDefinition.fields) {
            Field field = this.getField(fieldDefinition.num);
            if (field == null) {
                field = Factory.createField(this.num, fieldDefinition.num);
            }
            field.write(outputStream, fieldDefinition);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getNum() {
        return this.num;
    }

    public boolean hasField(int n) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != n) continue;
            return true;
        }
        return false;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void setField(Field field) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != field.num) continue;
            this.fields.set(i, field);
            return;
        }
        this.fields.add(field);
    }

    public void setFields(Mesg mesg) {
        if (mesg.num != this.num) {
            return;
        }
        for (Field field : mesg.fields) {
            this.setField(field);
        }
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public Field getField(int n) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != n) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public Field getField(String string) {
        return this.getField(string, true);
    }

    public Field getField(String string, boolean bl) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).name.equals(string)) {
                return this.fields.get(i);
            }
            for (int j = 0; j < this.fields.get((int)i).subFields.size(); ++j) {
                if (!this.fields.get((int)i).subFields.get((int)j).name.equals(string) || bl && !this.fields.get((int)i).subFields.get(j).canMesgSupport(this)) continue;
                return this.fields.get(i);
            }
        }
        return null;
    }

    public int GetActiveSubFieldIndex(int n) {
        Field field = Factory.createField(this.num, n);
        if (field == null) {
            return 65535;
        }
        for (int i = 0; i < field.subFields.size(); ++i) {
            if (!field.subFields.get(i).canMesgSupport(this)) continue;
            return i;
        }
        return 65535;
    }

    public String GetActiveSubFieldName(int n) {
        Field field = Factory.createField(this.num, n);
        if (field == null) {
            return Fit.SUBFIELD_NAME_MAIN_FIELD;
        }
        for (int i = 0; i < field.subFields.size(); ++i) {
            if (!field.subFields.get(i).canMesgSupport(this)) continue;
            return field.subFields.get(i).getName();
        }
        return Fit.SUBFIELD_NAME_MAIN_FIELD;
    }

    public int getNumFieldValues(int n) {
        return this.getNumFieldValues(n, 65534);
    }

    public int getNumFieldValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return 0;
        }
        if (n2 == 65534) {
            return field.getNumValues();
        }
        SubField subField = field.getSubField(n2);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getNumValues();
        }
        return 0;
    }

    public int getNumFieldValues(int n, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return 0;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getNumValues();
        }
        return 0;
    }

    public int getNumFieldValues(String string) {
        Field field = this.getField(string, false);
        if (field == null) {
            return 0;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getNumValues();
        }
        return 0;
    }

    public Object getFieldValue(int n) {
        return this.getFieldValue(n, 0, 65534);
    }

    public Object getFieldValue(int n, int n2) {
        return this.getFieldValue(n, n2, 65534);
    }

    public Object getFieldValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getValue(n2, n3);
        }
        return null;
    }

    public Object getFieldValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getValue(n2, string);
        }
        return null;
    }

    public Object getFieldValue(String string) {
        return this.getFieldValue(string, 0);
    }

    public Object getFieldValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getValue(n, string);
        }
        return null;
    }

    public boolean getIsFieldAccumulated(int n) {
        Field field = this.getField(n);
        if (field != null) {
            return field.getIsAccumulated();
        }
        return false;
    }

    public void setFieldValue(int n, Object object) {
        this.setFieldValue(n, 0, object, 65535);
    }

    public void setFieldValue(int n, int n2, Object object) {
        this.setFieldValue(n, n2, object, 65535);
    }

    public void setFieldValue(int n, int n2, Object object, int n3) {
        Field field;
        if (n3 == 65534) {
            n3 = this.GetActiveSubFieldIndex(n);
        }
        if ((field = this.getField(n)) == null) {
            field = Factory.createField(this.num, n);
            this.addField(field);
        }
        field.setValue(n2, object, n3);
    }

    public void setFieldValue(int n, int n2, Object object, String string) {
        Field field = this.getField(n);
        if (field == null) {
            field = Factory.createField(this.num, n);
            this.addField(field);
        }
        field.setValue(n2, object, string);
    }

    public void setFieldValue(String string, Object object) {
        this.setFieldValue(string, 0, object);
    }

    public void setFieldValue(String string, int n, Object object) {
        Field field = this.getField(string, false);
        if (field == null) {
            field = Factory.createField(this.num, string);
            this.addField(field);
        }
        field.setValue(n, object, string);
    }

    public Long getFieldBitsValue(int n, int n2, int n3, boolean bl) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getBitsValue(n2, n3, bl);
    }

    public Long getFieldBitsValue(String string, int n, int n2, boolean bl) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getBitsValue(n, n2, bl);
        }
        return null;
    }

    public Byte getFieldByteValue(int n) {
        return this.getFieldByteValue(n, 0, 65534);
    }

    public Byte getFieldByteValue(int n, int n2) {
        return this.getFieldByteValue(n, n2, 65534);
    }

    public Byte getFieldByteValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getByteValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValue(n2, n3);
        }
        return null;
    }

    public Byte getFieldByteValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValue(n2, string);
        }
        return null;
    }

    public Byte getFieldByteValue(String string) {
        return this.getFieldByteValue(string, 0);
    }

    public Byte getFieldByteValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getByteValue(n, string);
        }
        return null;
    }

    public Short getFieldShortValue(int n) {
        return this.getFieldShortValue(n, 0, 65534);
    }

    public Short getFieldShortValue(int n, int n2) {
        return this.getFieldShortValue(n, n2, 65534);
    }

    public Short getFieldShortValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getShortValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValue(n2, n3);
        }
        return null;
    }

    public Short getFieldShortValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValue(n2, string);
        }
        return null;
    }

    public Short getFieldShortValue(String string) {
        return this.getFieldShortValue(string, 0);
    }

    public Short getFieldShortValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getShortValue(n, string);
        }
        return null;
    }

    public Integer getFieldIntegerValue(int n) {
        return this.getFieldIntegerValue(n, 0, 65534);
    }

    public Integer getFieldIntegerValue(int n, int n2) {
        return this.getFieldIntegerValue(n, n2, 65534);
    }

    public Integer getFieldIntegerValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getIntegerValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValue(n2, n3);
        }
        return null;
    }

    public Integer getFieldIntegerValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValue(n2, string);
        }
        return null;
    }

    public Integer getFieldIntegerValue(String string) {
        return this.getFieldIntegerValue(string, 0);
    }

    public Integer getFieldIntegerValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getIntegerValue(n, string);
        }
        return null;
    }

    public Long getFieldLongValue(int n) {
        return this.getFieldLongValue(n, 0, 65534);
    }

    public Long getFieldLongValue(int n, int n2) {
        return this.getFieldLongValue(n, n2, 65534);
    }

    public Long getFieldLongValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getLongValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValue(n2, n3);
        }
        return null;
    }

    public Long getFieldLongValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValue(n2, string);
        }
        return null;
    }

    public Long getFieldLongValue(String string) {
        return this.getFieldLongValue(string, 0);
    }

    public Long getFieldLongValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getLongValue(n, string);
        }
        return null;
    }

    public Float getFieldFloatValue(int n) {
        return this.getFieldFloatValue(n, 0, 65534);
    }

    public Float getFieldFloatValue(int n, int n2) {
        return this.getFieldFloatValue(n, n2, 65534);
    }

    public Float getFieldFloatValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getFloatValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValue(n2, n3);
        }
        return null;
    }

    public Float getFieldFloatValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValue(n2, string);
        }
        return null;
    }

    public Float getFieldFloatValue(String string) {
        return this.getFieldFloatValue(string, 0);
    }

    public Float getFieldFloatValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getFloatValue(n, string);
        }
        return null;
    }

    public Double getFieldDoubleValue(int n) {
        return this.getFieldDoubleValue(n, 0, 65534);
    }

    public Double getFieldDoubleValue(int n, int n2) {
        return this.getFieldDoubleValue(n, n2, 65534);
    }

    public Double getFieldDoubleValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getDoubleValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValue(n2, n3);
        }
        return null;
    }

    public Double getFieldDoubleValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValue(n2, string);
        }
        return null;
    }

    public Double getFieldDoubleValue(String string) {
        return this.getFieldDoubleValue(string, 0);
    }

    public Double getFieldDoubleValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getDoubleValue(n, string);
        }
        return null;
    }

    public String getFieldStringValue(int n) {
        return this.getFieldStringValue(n, 0, 65534);
    }

    public String getFieldStringValue(int n, int n2) {
        return this.getFieldStringValue(n, n2, 65534);
    }

    public String getFieldStringValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getStringValue(n2, this.GetActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValue(n2, n3);
        }
        return null;
    }

    public String getFieldStringValue(int n, int n2, String string) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValue(n2, string);
        }
        return null;
    }

    public String getFieldStringValue(String string) {
        return this.getFieldStringValue(string, 0);
    }

    public String getFieldStringValue(String string, int n) {
        Field field = this.getField(string, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string);
        if (subField == null || subField.canMesgSupport(this)) {
            return field.getStringValue(n, string);
        }
        return null;
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public DateTime timestampToDateTime(Long l) {
        if (l == null) {
            return null;
        }
        DateTime dateTime = new DateTime(l);
        dateTime.convertSystemTimeToUTC(this.systemTimeOffset);
        return dateTime;
    }

    public void setLocalNum(int n) {
        if (n >= 16) {
            throw new FitRuntimeException("Invalid local message number " + n + ".  Local message number must be < " + 16 + ".");
        }
        this.localNum = n;
    }

    public int getLocalNum() {
        return this.localNum;
    }
}

