// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#include <stdio.h>
#include <string.h>

#include "defines.h"
#include "structs.h"

void
readRc (FILE * rcFp, char *filename, struct optionsInfo *options)
{
  char *strPtr;
  int nameLen;
  char rcLine[MAX_RC_LEN];

  if ((strPtr = strrchr (filename, '/')) == NULL)
    strPtr = filename;
  else
    strPtr++;

  if ((nameLen = strlen (strPtr)) > 0)
    {
      fseek (rcFp, 0, SEEK_SET);

      while (fgets (rcLine, MAX_RC_LEN, rcFp) != NULL)
	{
	  if (!strncmp (strPtr, rcLine, nameLen))
	    {
#ifndef USE_X
	      //fprintf (stderr, "rc: %s\n", rcLine);
#endif

	      if (strstr (rcLine, "nobpm") != NULL)
		options->bpmTempos = 0;
	      if (strstr (rcLine, "ntsc") != NULL)
		options->ntsc = 1;
	      if (strstr (rcLine, "nospeed0") != NULL)
		options->tolerant = 1;
	      if (strstr (rcLine, "extend") != NULL)
		options->extendOct = 1;
	      if (strstr (rcLine, "50hz") != NULL)
		options->use_50hz = 1;
	    }
	}
    }
}
